/*
 * Decompiled with CFR 0.152.
 */
package sra.smalltalk;

import sra.smalltalk.SmalltalkException;
import sra.smalltalk.StObject;

public class StReadStream
extends StObject {
    protected String source = null;
    protected int position;
    protected int length;

    public StReadStream() {
        this("");
    }

    public StReadStream(String aString) {
        this.length = aString.length();
        char[] charArray = new char[this.length + 1];
        System.arraycopy(aString.toCharArray(), 0, charArray, 0, this.length);
        charArray[this.length] = '\u0000';
        this.source = new String(charArray);
        this.position = 0;
    }

    public boolean atEnd() {
        return this.position >= this.length;
    }

    public String contents() {
        return new String(this.source);
    }

    public char next() {
        return this.source.charAt(this.position++);
    }

    public String nextAvailable_(int anInteger) {
        int to = Math.min(this.length, this.position() + anInteger);
        int size = to - this.position();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < size) {
            buffer.append(this.next());
            ++i;
        }
        return buffer.toString();
    }

    public char peek() {
        if (this.atEnd()) {
            return '\u0000';
        }
        return this.source.charAt(this.position);
    }

    public boolean peekFor_(char ch) {
        if (this.atEnd()) {
            return false;
        }
        char nextChar = this.next();
        if (ch == nextChar) {
            return true;
        }
        this.skip_(-1);
        return false;
    }

    public final int position() {
        return this.position;
    }

    public void position_(int newPosition) {
        if (newPosition < 0 || newPosition > this.source.length()) {
            throw new SmalltalkException("positionOutOfBoundsError: " + newPosition);
        }
        this.position = newPosition;
    }

    public void skip_(int offset) {
        this.position_(this.position + offset);
    }

    public String toString() {
        return super.toString();
    }

    public String upToEnd() {
        return this.source.substring(this.position, this.length);
    }
}

