/*
 * Decompiled with CFR 0.152.
 */
package sra.smalltalk;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import sra.smalltalk.DependentEvent;
import sra.smalltalk.DependentListener;
import sra.smalltalk.StApplicationModel;
import sra.smalltalk.StButtonGroup;
import sra.smalltalk.StCheckBoxMenuItem;
import sra.smalltalk.StMenu;
import sra.smalltalk.StMenuItem;
import sra.smalltalk.StMenuModel;
import sra.smalltalk.StRadioButtonMenuItem;
import sra.smalltalk.StSymbol;
import sra.smalltalk.StView;

public class StMenuViewForSwing
implements DependentListener,
ActionListener,
ItemListener {
    private transient boolean isBroadcasting = false;
    protected StMenu stRootMenu;
    protected JComponent uiRootMenu;
    protected Vector stMenus;
    protected Vector uiMenus;
    protected Hashtable groups;

    public static final StSymbol $(String aString) {
        return StSymbol.Intern_(aString);
    }

    public StMenuViewForSwing(JMenuBar menuBar) {
        this.uiRootMenu = menuBar;
    }

    public StMenuViewForSwing(JPopupMenu popupMenu) {
        this.uiRootMenu = popupMenu;
    }

    public void actionPerformed(ActionEvent ev) {
        StMenuItem anItem = this.getMenu((JMenuItem)ev.getSource());
        anItem.action();
    }

    protected void addMenu(StMenuItem stMenu, JMenuItem uiMenu) {
        this.stMenus.addElement(stMenu);
        this.uiMenus.addElement(uiMenu);
    }

    protected void clearMenuTable() {
        this.stMenus = new Vector();
        this.uiMenus = new Vector();
        this.groups = new Hashtable();
    }

    public static final JFrame CreateJFrame(StApplicationModel app, StView view) {
        JFrame aFrame = new JFrame(app.windowTitle());
        aFrame.getContentPane().add((JComponent)((Object)view));
        aFrame.pack();
        StMenuModel menuModel = app.menuModel();
        if (menuModel != null) {
            JMenuBar aMenuBar = new JMenuBar();
            StMenuViewForSwing aMenuView = new StMenuViewForSwing(aMenuBar);
            aMenuView.setModel(menuModel);
            aFrame.setJMenuBar(aMenuBar);
        }
        if (!app.windowResizable()) {
            aFrame.setResizable(false);
        }
        aFrame.pack();
        aFrame.setDefaultCloseOperation(0);
        app.builder().addFrame_(aFrame);
        return aFrame;
    }

    public static final JPopupMenu CreateJPopupMenu(StMenu menu) {
        JPopupMenu popupMenu = new JPopupMenu();
        StMenuViewForSwing aMenuView = new StMenuViewForSwing(popupMenu);
        aMenuView.setModel(menu);
        return popupMenu;
    }

    protected ButtonGroup getGroup(StButtonGroup stGroup) {
        ButtonGroup uiGroup = (ButtonGroup)this.groups.get(stGroup);
        if (uiGroup == null) {
            uiGroup = new ButtonGroup();
            this.groups.put(stGroup, uiGroup);
        }
        return uiGroup;
    }

    protected StMenuItem getMenu(JMenuItem uiMenu) {
        int i = this.uiMenus.indexOf(uiMenu);
        return (StMenuItem)this.stMenus.elementAt(i);
    }

    protected JMenuItem getMenu(StMenuItem stMenu) {
        int i = this.stMenus.indexOf(stMenu);
        return (JMenuItem)this.uiMenus.elementAt(i);
    }

    public StMenu getModel() {
        return this.stRootMenu;
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.isBroadcasting) {
            return;
        }
        StMenuItem menuItem = this.getMenu((JMenuItem)e.getSource());
        boolean selected = e.getStateChange() == 1;
        new ActionEvent(e.getSource(), e.getID(), menuItem.getActionCommand());
        if (menuItem instanceof StRadioButtonMenuItem) {
            StRadioButtonMenuItem anItem = (StRadioButtonMenuItem)menuItem;
            anItem.selected_(selected);
        } else {
            StCheckBoxMenuItem anItem = (StCheckBoxMenuItem)menuItem;
            anItem.selected_(selected);
        }
    }

    protected void makeSubMenu(StMenu stMenu, JMenu uiMenu) {
        int i = 0;
        while (i < stMenu.getItems().size()) {
            JMenuItem uiSubMenu;
            JMenuItem uiSubMenu2;
            StMenuItem stSubMenu = stMenu.getItem(i);
            if (stSubMenu == null) {
                uiMenu.addSeparator();
            } else if (stSubMenu instanceof StMenu) {
                uiSubMenu2 = new JMenu(stSubMenu.label);
                uiMenu.add(uiSubMenu2);
                this.addMenu(stSubMenu, uiSubMenu2);
                this.makeSubMenu((StMenu)stSubMenu, (JMenu)uiSubMenu2);
            } else if (stSubMenu instanceof StRadioButtonMenuItem) {
                boolean isSelected = ((StRadioButtonMenuItem)stSubMenu).isSelected();
                uiSubMenu = new JRadioButtonMenuItem(stSubMenu.label, isSelected);
                uiSubMenu.setEnabled(stSubMenu.isEnabled());
                StButtonGroup stGroup = ((StRadioButtonMenuItem)stSubMenu).getGroup();
                this.getGroup(stGroup).add(uiSubMenu);
                uiSubMenu.setActionCommand(stSubMenu.getActionCommand());
                uiSubMenu.addItemListener(this);
                uiSubMenu.addActionListener(this);
                uiMenu.add(uiSubMenu);
                this.addMenu(stSubMenu, uiSubMenu);
            } else if (stSubMenu instanceof StCheckBoxMenuItem) {
                boolean isSelected = ((StCheckBoxMenuItem)stSubMenu).isSelected();
                uiSubMenu = new JCheckBoxMenuItem(stSubMenu.label, isSelected);
                uiSubMenu.setEnabled(stSubMenu.isEnabled());
                uiSubMenu.setActionCommand(stSubMenu.getActionCommand());
                uiSubMenu.addItemListener(this);
                uiSubMenu.addActionListener(this);
                uiMenu.add(uiSubMenu);
                this.addMenu(stSubMenu, uiSubMenu);
            } else {
                uiSubMenu2 = new JMenuItem(stSubMenu.label);
                uiSubMenu2.setEnabled(stSubMenu.isEnabled());
                uiSubMenu2.setActionCommand(stSubMenu.getActionCommand());
                uiSubMenu2.addActionListener(this);
                uiMenu.add(uiSubMenu2);
                this.addMenu(stSubMenu, uiSubMenu2);
            }
            ++i;
        }
    }

    protected void rebuildComponent() {
        this.clearMenuTable();
        if (this.uiRootMenu instanceof JPopupMenu) {
            JPopupMenu uiMenu = (JPopupMenu)this.uiRootMenu;
            int i = 0;
            while (i < this.getModel().getItems().size()) {
                JMenuItem uiSubMenu;
                JMenuItem uiSubMenu2;
                StMenuItem stSubMenu = this.getModel().getItem(i);
                if (stSubMenu == null) {
                    uiMenu.addSeparator();
                } else if (stSubMenu instanceof StMenu) {
                    uiSubMenu2 = new JMenu(stSubMenu.label);
                    uiMenu.add(uiSubMenu2);
                    this.addMenu(stSubMenu, uiSubMenu2);
                    this.makeSubMenu((StMenu)stSubMenu, (JMenu)uiSubMenu2);
                } else if (stSubMenu instanceof StRadioButtonMenuItem) {
                    boolean isSelected = ((StRadioButtonMenuItem)stSubMenu).isSelected();
                    uiSubMenu = new JRadioButtonMenuItem(stSubMenu.label, isSelected);
                    StButtonGroup stGroup = ((StRadioButtonMenuItem)stSubMenu).getGroup();
                    this.getGroup(stGroup).add(uiSubMenu);
                    uiSubMenu.setActionCommand(stSubMenu.getActionCommand());
                    uiSubMenu.addItemListener(this);
                    uiSubMenu.addActionListener(this);
                    uiMenu.add(uiSubMenu);
                    this.addMenu(stSubMenu, uiSubMenu);
                } else if (stSubMenu instanceof StCheckBoxMenuItem) {
                    boolean isSelected = ((StCheckBoxMenuItem)stSubMenu).isSelected();
                    uiSubMenu = new JCheckBoxMenuItem(stSubMenu.label, isSelected);
                    uiSubMenu.setActionCommand(stSubMenu.getActionCommand());
                    uiSubMenu.addItemListener(this);
                    uiSubMenu.addActionListener(this);
                    uiMenu.add(uiSubMenu);
                    this.addMenu(stSubMenu, uiSubMenu);
                } else {
                    uiSubMenu2 = new JMenuItem(stSubMenu.label);
                    uiSubMenu2.setActionCommand(stSubMenu.getActionCommand());
                    uiSubMenu2.addActionListener(this);
                    uiMenu.add(uiSubMenu2);
                    this.addMenu(stSubMenu, uiSubMenu2);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.getModel().getItems().size()) {
                StMenu stMenu = (StMenu)this.getModel().getItem(i);
                JMenu uiMenu = new JMenu(stMenu.label);
                ((JMenuBar)this.uiRootMenu).add(uiMenu);
                this.addMenu(stMenu, uiMenu);
                this.makeSubMenu(stMenu, uiMenu);
                ++i;
            }
        }
    }

    public void setModel(StMenu aModel) {
        this.stRootMenu = aModel;
        ((StMenuModel)this.stRootMenu.getRoot()).addDependentListener(this);
        this.rebuildComponent();
    }

    public void update_(DependentEvent evt) {
        StMenuItem stMenu = (StMenuItem)evt.getParameter();
        JMenuItem uiMenu = this.getMenu(stMenu);
        StSymbol aspect = evt.getAspect();
        if (aspect == StMenuViewForSwing.$("selected")) {
            this.isBroadcasting = true;
            uiMenu.setSelected(true);
            this.isBroadcasting = false;
        } else if (aspect == StMenuViewForSwing.$("deselected")) {
            this.isBroadcasting = true;
            uiMenu.setSelected(false);
            this.isBroadcasting = false;
        } else if (aspect == StMenuViewForSwing.$("enabled")) {
            uiMenu.setEnabled(true);
        } else if (aspect == StMenuViewForSwing.$("disable")) {
            uiMenu.setEnabled(false);
        }
    }
}

