/*
 * Decompiled with CFR 0.152.
 */
package sra.smalltalk;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import sra.smalltalk.DependentEvent;
import sra.smalltalk.DependentListener;
import sra.smalltalk.StApplicationModel;
import sra.smalltalk.StCheckBoxMenuItem;
import sra.smalltalk.StMenu;
import sra.smalltalk.StMenuItem;
import sra.smalltalk.StMenuModel;
import sra.smalltalk.StRadioButtonMenuItem;
import sra.smalltalk.StSymbol;
import sra.smalltalk.StView;

public class StMenuViewForAwt
implements DependentListener,
ActionListener,
ItemListener {
    private transient boolean isBroadcasting = false;
    protected StMenu stRootMenu;
    protected MenuComponent uiRootMenu;
    protected Vector stMenus;
    protected Vector uiMenus;

    public static final StSymbol $(String aString) {
        return StSymbol.Intern_(aString);
    }

    public StMenuViewForAwt(MenuBar menuBar) {
        this.uiRootMenu = menuBar;
    }

    public StMenuViewForAwt(PopupMenu popupMenu) {
        this.uiRootMenu = popupMenu;
    }

    public void actionPerformed(ActionEvent ev) {
        StMenuItem anItem = this.getMenu((MenuItem)ev.getSource());
        anItem.action();
    }

    protected void addMenu(StMenuItem stMenu, MenuItem uiMenu) {
        this.stMenus.addElement(stMenu);
        this.uiMenus.addElement(uiMenu);
    }

    protected void clearMenuTable() {
        this.stMenus = new Vector();
        this.uiMenus = new Vector();
    }

    public static final Frame CreateFrame(StApplicationModel app, StView view) {
        Frame aFrame = new Frame(app.windowTitle());
        aFrame.add((Component)((Object)view));
        aFrame.pack();
        StMenuModel menuModel = app.menuModel();
        if (menuModel != null) {
            MenuBar aMenuBar = new MenuBar();
            StMenuViewForAwt aMenuView = new StMenuViewForAwt(aMenuBar);
            aMenuView.setModel(menuModel);
            aFrame.setMenuBar(aMenuBar);
        }
        if (!app.windowResizable()) {
            aFrame.setResizable(false);
        }
        aFrame.pack();
        app.builder().addFrame_(aFrame);
        return aFrame;
    }

    public static final PopupMenu CreatePopupMenu(StMenu menu) {
        PopupMenu popupMenu = new PopupMenu();
        StMenuViewForAwt aMenuView = new StMenuViewForAwt(popupMenu);
        aMenuView.setModel(menu);
        return popupMenu;
    }

    protected StMenuItem getMenu(MenuItem uiMenu) {
        int i = this.uiMenus.indexOf(uiMenu);
        return (StMenuItem)this.stMenus.elementAt(i);
    }

    protected MenuItem getMenu(StMenuItem stMenu) {
        int i = this.stMenus.indexOf(stMenu);
        return (MenuItem)this.uiMenus.elementAt(i);
    }

    public StMenu getModel() {
        return this.stRootMenu;
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.isBroadcasting) {
            return;
        }
        StMenuItem menuItem = this.getMenu((MenuItem)e.getSource());
        boolean selected = e.getStateChange() == 1;
        new ActionEvent(e.getSource(), e.getID(), menuItem.getActionCommand());
        if (menuItem instanceof StRadioButtonMenuItem) {
            if (selected) {
                StRadioButtonMenuItem anItem = (StRadioButtonMenuItem)menuItem;
                anItem.setSelected(selected);
                anItem.action();
            } else {
                ((CheckboxMenuItem)e.getSource()).setState(true);
            }
        } else {
            StCheckBoxMenuItem anItem = (StCheckBoxMenuItem)menuItem;
            anItem.setSelected(selected);
            anItem.action();
        }
    }

    protected void makeSubMenu(StMenu stMenu, Menu awtMenu) {
        int i = 0;
        while (i < stMenu.getItems().size()) {
            CheckboxMenuItem awtSubMenu;
            MenuItem awtSubMenu2;
            StMenuItem stSubMenu = stMenu.getItem(i);
            if (stSubMenu == null) {
                awtMenu.addSeparator();
            } else if (stSubMenu instanceof StMenu) {
                awtSubMenu2 = new Menu(stSubMenu.label);
                awtMenu.add(awtSubMenu2);
                this.addMenu(stSubMenu, awtSubMenu2);
                this.makeSubMenu((StMenu)stSubMenu, (Menu)awtSubMenu2);
            } else if (stSubMenu instanceof StRadioButtonMenuItem) {
                boolean isSelected = ((StRadioButtonMenuItem)stSubMenu).isSelected();
                awtSubMenu = new CheckboxMenuItem(stSubMenu.label, isSelected);
                awtSubMenu.setEnabled(stSubMenu.isEnabled());
                awtSubMenu.setActionCommand(stSubMenu.getActionCommand());
                awtSubMenu.addItemListener(this);
                awtMenu.add(awtSubMenu);
                this.addMenu(stSubMenu, awtSubMenu);
            } else if (stSubMenu instanceof StCheckBoxMenuItem) {
                boolean isSelected = ((StCheckBoxMenuItem)stSubMenu).isSelected();
                awtSubMenu = new CheckboxMenuItem(stSubMenu.label, isSelected);
                awtSubMenu.setEnabled(stSubMenu.isEnabled());
                awtSubMenu.setActionCommand(stSubMenu.getActionCommand());
                awtSubMenu.addItemListener(this);
                awtMenu.add(awtSubMenu);
                this.addMenu(stSubMenu, awtSubMenu);
            } else {
                awtSubMenu2 = new MenuItem(stSubMenu.label);
                awtSubMenu2.setEnabled(stSubMenu.isEnabled());
                awtSubMenu2.setActionCommand(stSubMenu.getActionCommand());
                awtSubMenu2.addActionListener(this);
                awtMenu.add(awtSubMenu2);
                this.addMenu(stSubMenu, awtSubMenu2);
            }
            ++i;
        }
    }

    protected void rebuildComponent() {
        this.clearMenuTable();
        if (this.uiRootMenu instanceof PopupMenu) {
            this.makeSubMenu(this.getModel(), (PopupMenu)this.uiRootMenu);
        } else {
            int i = 0;
            while (i < this.getModel().getItems().size()) {
                StMenu stMenu = (StMenu)this.getModel().getItem(i);
                Menu awtMenu = new Menu(stMenu.label);
                ((MenuBar)this.uiRootMenu).add(awtMenu);
                this.addMenu(stMenu, awtMenu);
                this.makeSubMenu(stMenu, awtMenu);
                ++i;
            }
        }
    }

    public void setModel(StMenu aModel) {
        this.stRootMenu = aModel;
        ((StMenuModel)this.stRootMenu.getRoot()).addDependentListener(this);
        this.rebuildComponent();
    }

    public void update_(DependentEvent evt) {
        StMenuItem stMenu = (StMenuItem)evt.getParameter();
        MenuItem awtMenu = this.getMenu(stMenu);
        StSymbol aspect = evt.getAspect();
        if (aspect == StMenuViewForAwt.$("selected")) {
            this.isBroadcasting = true;
            ((CheckboxMenuItem)awtMenu).setState(true);
            this.isBroadcasting = false;
        } else if (aspect == StMenuViewForAwt.$("deselected")) {
            this.isBroadcasting = true;
            ((CheckboxMenuItem)awtMenu).setState(false);
            this.isBroadcasting = false;
        } else if (aspect == StMenuViewForAwt.$("enabled")) {
            awtMenu.setEnabled(true);
        } else if (aspect == StMenuViewForAwt.$("disable")) {
            awtMenu.setEnabled(false);
        }
    }
}

