/*
 * Decompiled with CFR 0.152.
 */
package sra.smalltalk;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import sra.smalltalk.StMenu;
import sra.smalltalk.StMenuModel;
import sra.smalltalk.StSymbol;

public class StMenuItem {
    private Vector actionlisteners;
    protected String label;
    protected String actionCommand;
    protected boolean enabled = true;
    protected StMenu parent;

    public static final StSymbol $(String aString) {
        return StSymbol.Intern_(aString);
    }

    public StMenuItem(String aLabel) {
        this.label = aLabel;
    }

    public void action() {
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    public synchronized void addActionListener(ActionListener l) {
        if (this.actionlisteners == null) {
            this.actionlisteners = new Vector();
        }
        this.actionlisteners.addElement(l);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Vector copy;
        if (this.actionlisteners == null) {
            return;
        }
        Vector vector = this.actionlisteners;
        synchronized (vector) {
            copy = (Vector)this.actionlisteners.clone();
        }
        int i = 0;
        while (i < copy.size()) {
            ActionListener l = (ActionListener)copy.elementAt(i);
            l.actionPerformed(event);
            ++i;
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected StMenu getParent() {
        return this.parent;
    }

    protected StMenuItem getRoot() {
        StMenuItem current = this;
        StMenu parent = this.getParent();
        while (parent != null) {
            current = parent;
            parent = current.getParent();
        }
        return current;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void removeActionListener(ActionListener l) {
        this.actionlisteners.removeElement(l);
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public void setEnabled(boolean aBoolean) {
        if (this.enabled != aBoolean) {
            this.enabled = aBoolean;
            StSymbol aspect = this.enabled ? StMenuItem.$("enabled") : StMenuItem.$("disable");
            StMenuItem root = this.getRoot();
            if (root instanceof StMenuModel) {
                ((StMenuModel)root).changed_with_(aspect, this);
            }
        }
    }

    protected void setParent(StMenu aMenu) {
        this.parent = aMenu;
    }
}

