/*
 * Decompiled with CFR 0.152.
 */
package sra.smalltalk;

import java.io.IOException;
import java.io.Writer;
import sra.smalltalk.StBlockClosure;
import sra.smalltalk.StObject;

public class StInterval
extends StObject {
    private double start;
    private double stop;
    private double step = 1.0;

    public StInterval() {
    }

    public StInterval(double startNumber, double stopNumber) {
        this.setFrom_to_by_(startNumber, stopNumber, 1.0);
    }

    public StInterval(double startNumber, double stopNumber, double stepNumber) {
        this.setFrom_to_by_(startNumber, stopNumber, stepNumber);
    }

    public double at_(int index) {
        if (index >= 1 && index <= this.size() - 1) {
            double value = this.start;
            int i = 0;
            while (i < index) {
                value += this.step;
                ++i;
            }
            return value;
        }
        throw new IndexOutOfBoundsException();
    }

    public double[] collect_(StBlockClosure aBlock) {
        double[] result = new double[this.size()];
        double nextValue = this.start;
        int i = 0;
        while (i < result.length) {
            result[i] = (Double)aBlock.value_(new Double(nextValue));
            nextValue += this.step;
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public void do_(StBlockClosure aBlock) {
        block2: {
            value = this.start;
            if (!(this.step < 0.0)) ** GOTO lbl12
            while (this.stop <= value) {
                aBlock.value_(new Double(value));
                value += this.step;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                aBlock.value_(new Double(value));
                value += this.step;
lbl12:
                // 2 sources

                ** while (this.stop >= value)
            }
        }
    }

    public boolean equals(Object other) {
        if (other.getClass() == this.getClass()) {
            StInterval aStInterval = (StInterval)other;
            return this.start == aStInterval.start && this.step == aStInterval.increment() && this.size() == aStInterval.size();
        }
        return false;
    }

    public double first() {
        return this.start;
    }

    public static StInterval From_to_(double startNumber, double stopNumber) {
        StInterval interval = new StInterval();
        interval.setFrom_to_by_(startNumber, stopNumber, 1.0);
        return interval;
    }

    public static StInterval From_to_by_(double startNumber, double stopNumber, double stepNumber) {
        StInterval interval = new StInterval();
        interval.setFrom_to_by_(startNumber, stopNumber, stepNumber);
        return interval;
    }

    public int hashCode() {
        long bitsStart = Double.doubleToLongBits(this.start);
        int startHash = (int)(bitsStart ^ bitsStart >> 32);
        long bitsStop = Double.doubleToLongBits(this.stop);
        int stopHash = (int)(bitsStop ^ bitsStop >> 32);
        return (startHash >> 2 | stopHash) >> 1 | this.size();
    }

    public double increment() {
        return this.step;
    }

    public double last() {
        return this.stop - (this.stop - this.start) % this.step;
    }

    public void printOn_(Writer aWriter) throws IOException {
        aWriter.write("(" + this.start + " to: " + this.stop);
        if (this.step != 1.0) {
            aWriter.write(" by: " + this.step);
        }
        aWriter.write(")");
    }

    /*
     * Unable to fully structure code
     */
    public void reverseDo_(StBlockClosure aBlock) {
        block2: {
            value = this.stop;
            if (!(this.step < 0.0)) ** GOTO lbl12
            while (this.start >= value) {
                aBlock.value_(new Double(value));
                value -= this.step;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                aBlock.value_(new Double(value));
                value -= this.step;
lbl12:
                // 2 sources

                ** while (this.start <= value)
            }
        }
    }

    private StInterval setFrom_to_by_(double startNumber, double stopNumber, double stepNumber) {
        this.start = startNumber;
        this.stop = stopNumber;
        this.step = stepNumber;
        return this;
    }

    public int size() {
        int size = 0;
        if (this.step < 0.0) {
            if (!(this.start < this.stop)) {
                size = (int)((this.stop - this.start) / this.step) + 1;
            }
        } else if (!(this.stop < this.start)) {
            size = (int)((this.stop - this.start) / this.step) + 1;
        }
        return size;
    }

    public double start() {
        return this.start;
    }

    public double start_(double startValue) {
        this.start = startValue;
        return this.start;
    }

    public double step() {
        return this.step;
    }

    public double step_(double stepValue) {
        this.step = stepValue;
        return this.step;
    }

    public double stop() {
        return this.stop;
    }

    public double stop_(double stopValue) {
        this.stop = stopValue;
        return this.stop;
    }

    public void storeOn_(Writer aWriter) throws IOException {
        this.printOn_(aWriter);
    }
}

