/*
 * Decompiled with CFR 0.152.
 */
package sra.smalltalk;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Hashtable;
import sra.smalltalk.StByteArray;
import sra.smalltalk.StColorValue;
import sra.smalltalk.StObject;

public class StImage
extends StObject
implements Serializable {
    private Image image;
    private int width;
    private int height;
    private int[] bits;
    public static final int WriteZeros = 0;
    public static final int And = 1;
    public static final int Over = 3;
    public static final int Erase = 4;
    public static final int Reverse = 6;
    public static final int Under = 7;
    public static final int ReverseUnder = 13;
    public static final int WriteOnes = 15;
    public static final int Paint = 16;

    public StImage(int width, int height) {
        int size = width * height;
        int[] newBits = new int[size];
        int index = 0;
        while (index < size) {
            newBits[index] = -1;
            ++index;
        }
        this.width_(width);
        this.height_(height);
        this.bits_(newBits);
    }

    public StImage(int width, int height, int[] bits) {
        this.width_(width);
        this.height_(height);
        this.bits_(bits);
    }

    public StImage(Image image) {
        this.image = image;
        Canvas medium = new Canvas();
        int width = image.getWidth(medium);
        int height = image.getHeight(medium);
        this.width_(width);
        this.height_(height);
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        this.bits_(pixels);
    }

    private int _atIndex_(int index) {
        return this.bits[index];
    }

    private void _atIndex_put_(int index, int pixelValue) {
        this.bits[index] = pixelValue;
        this.image = null;
    }

    public int _combinationedColorFrom_to_in_(int sourceColor, int destinationColor, int combinationRule) {
        if (combinationRule == 0) {
            return -1;
        }
        if (combinationRule == 1) {
            return sourceColor & destinationColor;
        }
        if (combinationRule == 3) {
            return sourceColor;
        }
        if (combinationRule == 7) {
            return sourceColor | destinationColor;
        }
        if (combinationRule == 15) {
            return -16777216;
        }
        return sourceColor;
    }

    public StImage _convertToPalette_RenderedByErrorDiffusion(IndexColorModel aPalette) {
        StImage newImage = new StImage(this.width(), this.height(), (int[])this.bits().clone());
        Hashtable<Integer, Integer> colorDictionary = new Hashtable<Integer, Integer>();
        int y = 0;
        while (y < this.height()) {
            int x = 0;
            while (x < newImage.width()) {
                int i = y * newImage.width() + x;
                Integer pixel = new Integer(newImage.bits()[i]);
                Color currentColor = new Color(pixel);
                if (colorDictionary.containsKey(pixel)) {
                    newImage.bits()[i] = (Integer)colorDictionary.get(pixel);
                } else {
                    int fit = StColorValue._MaxDistanceSquared() + 1;
                    int fitRGB = -16777216;
                    int j = 0;
                    while (j < aPalette.getMapSize()) {
                        int pixelRGB = aPalette.getRGB(j);
                        Color newColor = new Color(pixelRGB);
                        Integer d = StColorValue._DistanceSquaredFrom_ifLessThan_(newColor, currentColor, fit);
                        if (d != null) {
                            fit = d;
                            fitRGB = pixelRGB;
                        }
                        ++j;
                    }
                    colorDictionary.put(pixel, new Integer(fitRGB));
                    newImage.bits()[i] = fitRGB;
                }
                Color actualColor = new Color(newImage.bits()[i]);
                float redError = (float)(currentColor.getRed() - actualColor.getRed()) / 16.0f;
                float greenError = (float)(currentColor.getGreen() - actualColor.getGreen()) / 16.0f;
                float blueError = (float)(currentColor.getBlue() - actualColor.getBlue()) / 16.0f;
                if (x < newImage.width() - 1) {
                    Color rightColor = new Color(newImage.atX_y_(x + 1, y));
                    rightColor = new Color(Math.min(255, Math.max(0, rightColor.getRed() + (int)(redError * 7.0f))), Math.min(255, Math.max(0, rightColor.getGreen() + (int)(greenError * 7.0f))), Math.min(255, Math.max(0, rightColor.getBlue() + (int)(blueError * 7.0f))));
                    newImage.bits()[i + 1] = rightColor.getRGB();
                }
                if (y < newImage.height() - 1) {
                    if (x > 0) {
                        Color leftDownColor = new Color(newImage.atX_y_(x - 1, y + 1));
                        leftDownColor = new Color(Math.min(255, Math.max(0, leftDownColor.getRed() + (int)(redError * 3.0f))), Math.min(255, Math.max(0, leftDownColor.getGreen() + (int)(greenError * 3.0f))), Math.min(255, Math.max(0, leftDownColor.getBlue() + (int)(blueError * 3.0f))));
                        newImage.atX_y_put_(x - 1, y + 1, leftDownColor.getRGB());
                    }
                    Color centerDownColor = new Color(newImage.atX_y_(x, y + 1));
                    centerDownColor = new Color(Math.min(255, Math.max(0, centerDownColor.getRed() + (int)(redError * 5.0f))), Math.min(255, Math.max(0, centerDownColor.getGreen() + (int)(greenError * 5.0f))), Math.min(255, Math.max(0, centerDownColor.getBlue() + (int)(blueError * 5.0f))));
                    newImage.atX_y_put_(x, y + 1, centerDownColor.getRGB());
                    if (x < newImage.width() - 1) {
                        Color rightDownColor = new Color(newImage.atX_y_(x + 1, y + 1));
                        rightDownColor = new Color(Math.min(255, Math.max(0, rightDownColor.getRed() + (int)redError)), Math.min(255, Math.max(0, rightDownColor.getGreen() + (int)greenError)), Math.min(255, Math.max(0, rightDownColor.getBlue() + (int)blueError)));
                        newImage.atX_y_put_(x + 1, y + 1, rightDownColor.getRGB());
                    }
                }
                ++x;
            }
            ++y;
        }
        return newImage;
    }

    public StImage _convertToPalette_RenderedByNearistPaint(IndexColorModel aPalette) {
        StImage newImage = new StImage(this.width(), this.height());
        Hashtable<Integer, Integer> colorDictionary = new Hashtable<Integer, Integer>();
        int i = 0;
        while (i < this.bits().length) {
            Integer pixel = new Integer(this.bits()[i]);
            if (colorDictionary.containsKey(pixel)) {
                newImage.bits()[i] = (Integer)colorDictionary.get(pixel);
            } else {
                int fit = StColorValue._MaxDistanceSquared() + 1;
                int fitRGB = -16777216;
                Color oldColor = new Color(pixel);
                int j = 0;
                while (j < aPalette.getMapSize()) {
                    int pixelRGB = aPalette.getRGB(j);
                    Color newColor = new Color(pixelRGB);
                    Integer d = StColorValue._DistanceSquaredFrom_ifLessThan_(newColor, oldColor, fit);
                    if (d != null) {
                        fit = d;
                        fitRGB = pixelRGB;
                    }
                    ++j;
                }
                colorDictionary.put(pixel, new Integer(fitRGB));
                newImage.bits()[i] = fitRGB;
            }
            ++i;
        }
        return newImage;
    }

    public void _display() {
        StImage.Display_(this);
    }

    private Image _makeImage() {
        int width = this.width();
        int height = this.height();
        int[] pixels = new int[width * height];
        int i = 0;
        while (i < width * height) {
            pixels[i] = this.bits[i];
            ++i;
        }
        int offset = 0;
        int scansize = width;
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, offset, scansize);
        this.image = Toolkit.getDefaultToolkit().createImage(source);
        return this.image;
    }

    public int atPoint_(Point point) {
        int index = point.y * this.width() + point.x;
        return this.bits[index];
    }

    public void atPoint_put_(Point point, int pixelValue) {
        int index = point.y * this.width() + point.x;
        this._atIndex_put_(index, pixelValue);
    }

    public int atX_y_(int x, int y) {
        int index = y * this.width() + x;
        return this._atIndex_(index);
    }

    public void atX_y_put_(int x, int y, int pixelValue) {
        int index = y * this.width() + x;
        this._atIndex_put_(index, pixelValue);
    }

    public int[] bits() {
        return this.bits;
    }

    public void bits_(int[] bits) {
        this.bits = bits;
    }

    public Rectangle bounds() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public StImage convertToPalette_(IndexColorModel aPalette) {
        return this._convertToPalette_RenderedByNearistPaint(aPalette);
    }

    public StImage copy_from_in_rule_(Rectangle destRectangle, Point sourcePt, StImage sourceImage, int combinationRule) {
        int width = destRectangle.width;
        int height = destRectangle.height;
        int destOriginX = destRectangle.x;
        int destOriginY = destRectangle.y;
        int destCornerX = destRectangle.x + width - 1;
        int destCornerY = destRectangle.y + height - 1;
        int sourceOriginX = sourcePt.x;
        int sourceOriginY = sourcePt.y;
        int sourceCornerX = sourcePt.x + width - 1;
        int sourceCornerY = sourcePt.y + height - 1;
        if (!this.bounds().contains(destRectangle.getLocation())) {
            return null;
        }
        if (!this.bounds().contains(destCornerX, destCornerY)) {
            return null;
        }
        if (!sourceImage.bounds().contains(sourcePt)) {
            return null;
        }
        if (!sourceImage.bounds().contains(sourceCornerX, sourceCornerY)) {
            return null;
        }
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                Point sourcePoint = new Point(x + sourceOriginX, y + sourceOriginY);
                Point destinationPoint = new Point(x + destOriginX, y + destOriginY);
                int newPaint = this._combinationedColorFrom_to_in_(sourceImage.atPoint_(sourcePoint), this.atPoint_(destinationPoint), combinationRule);
                this.atPoint_put_(destinationPoint, newPaint);
                ++x;
            }
            ++y;
        }
        return this;
    }

    public StImage copyEmpty_(Point newExtent) {
        return new StImage(newExtent.x, newExtent.y);
    }

    public static void Display_(StImage anImage) {
        Frame aFrame = new Frame();
        aFrame.setTitle("Display");
        ((Component)aFrame).setLocation(100, 100);
        aFrame.setLayout(new BorderLayout());
        aFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
            }
        });
        StImage _image = anImage;
        Canvas newCanvas = new Canvas(_image){
            /* synthetic */ StImage val$_image;

            public void paint(Graphics g) {
                this.val$_image.displayOn_(g);
            }
            {
                this.val$_image = val$_image;
            }
        };
        newCanvas.setBounds(0, 0, anImage.width(), anImage.height());
        aFrame.add(newCanvas);
        aFrame.pack();
        aFrame.show();
    }

    public void displayOn_(Graphics aGraphics) {
        this.displayOn_at_(aGraphics, new Point(0, 0));
    }

    public void displayOn_at_(Graphics aGraphics, Point aPoint) {
        Graphics graphics = aGraphics.create();
        try {
            Canvas medium = new Canvas();
            MediaTracker mt = new MediaTracker(medium);
            mt.addImage(this.image(), 0);
            graphics.drawImage(this.image(), aPoint.x, aPoint.y, medium);
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            graphics.dispose();
            throw throwable;
        }
        Object var4_8 = null;
        graphics.dispose();
    }

    public Point extent() {
        return new Point(this.width, this.height);
    }

    public int height() {
        return this.height;
    }

    public void height_(int height) {
        this.height = height;
    }

    public Image image() {
        if (this.image != null) {
            return this.image;
        }
        this.image = this._makeImage();
        return this.image;
    }

    public int[] packedRowAt_(int rowIndex) {
        int width = this.width();
        int[] bits = this.bits();
        int[] rowBytes = new int[width];
        int index = 0;
        while (index < width) {
            rowBytes[index] = bits[width * rowIndex + index];
            ++index;
        }
        return rowBytes;
    }

    public void packedRowAt_into_(int rowIndex, int[] anArray) {
        int width = this.width();
        int[] bits = this.bits();
        int index = 0;
        while (index < width) {
            bits[width * rowIndex + index] = anArray[index];
            ++index;
        }
    }

    public Point scaledExtent_(double scaleX, double scaleY) {
        Double x = new Double((double)this.width * 1.0 / scaleX);
        Double y = new Double((double)this.height * 1.0 / scaleY);
        return new Point(x.intValue(), y.intValue());
    }

    public void storeOn_(Writer aWriter) throws IOException {
        aWriter.write("(Image extent: ");
        aWriter.write(String.valueOf(this.width));
        aWriter.write(64);
        aWriter.write(String.valueOf(this.height));
        aWriter.write(" depth: ");
        aWriter.write("24");
        aWriter.write(" bitPerPixel: ");
        aWriter.write("24");
        aWriter.write(" palette: ");
        aWriter.write("(FixedPalette redShift: 16 redMask: 255 greenShift: 8 greenMask: 255 blueShift: 0 blueMask: 255)");
        aWriter.write(" usingBits: ");
        new StByteArray(this.bits).storeOn_(aWriter);
        aWriter.write(41);
    }

    public StImage tile_from_in_rule_(Rectangle destRectangle, Point sourcePt, StImage sourceImage, int combinationRule) {
        int width = destRectangle.width;
        int height = destRectangle.height;
        int sourceWidth = sourceImage.width();
        int sourceHeight = sourceImage.height();
        int destOriginX = destRectangle.x;
        int destOriginY = destRectangle.y;
        int destCornerX = destRectangle.x + width - 1;
        int destCornerY = destRectangle.y + height - 1;
        int sourceOriginX = sourcePt.x;
        int sourceOriginY = sourcePt.y;
        int cfr_ignored_0 = sourcePt.x + width - 1;
        int cfr_ignored_1 = sourcePt.y + height - 1;
        if (!this.bounds().contains(destRectangle.getLocation())) {
            return null;
        }
        if (!this.bounds().contains(destCornerX, destCornerY)) {
            return null;
        }
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                Point sourcePoint = new Point((x + sourceOriginX) % sourceWidth, (y + sourceOriginY) % sourceHeight);
                Point destinationPoint = new Point(x + destOriginX, y + destOriginY);
                int newPaint = this._combinationedColorFrom_to_in_(sourceImage.atPoint_(sourcePoint), this.atPoint_(destinationPoint), combinationRule);
                this.atPoint_put_(destinationPoint, newPaint);
                ++x;
            }
            ++y;
        }
        return this;
    }

    public Color valueAtPoint_(Point point) {
        int pixelValue = this.atPoint_(point);
        ColorModel colorModel = ColorModel.getRGBdefault();
        int red = colorModel.getRed(pixelValue);
        int green = colorModel.getGreen(pixelValue);
        int blue = colorModel.getBlue(pixelValue);
        return new Color(red, green, blue);
    }

    public void valueAtPoint_put_(Point point, Color color) {
        this.atPoint_put_(point, color.getRGB());
    }

    public int width() {
        return this.width;
    }

    public void width_(int width) {
        this.width = width;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.image = null;
        out.defaultWriteObject();
    }
}

