/*
 * Decompiled with CFR 0.152.
 */
package sra.smalltalk;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import sra.smalltalk.SystemResourceSupport;

public class StDialog
implements ActionListener {
    protected Dialog dialog;
    protected boolean accepted;
    protected String value;
    protected TextField textField;
    protected static String lastDirectory = null;

    public StDialog() {
        this(SystemResourceSupport.getFrame());
    }

    public StDialog(Frame aFrame) {
        this.dialog = new Dialog(aFrame, "", true);
    }

    protected Button _closeCancelButton() {
        Button yesButton = new Button("Cancel");
        yesButton.addActionListener(this);
        return yesButton;
    }

    protected Button _closeOKButton() {
        Button yesButton = new Button("OK");
        yesButton.addActionListener(this);
        return yesButton;
    }

    protected static Point _getCenterPoint() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point(dimension.width / 2, dimension.height / 2);
    }

    protected Panel _okCancelButtons() {
        Button yesButton = new Button("OK");
        yesButton.addActionListener(this);
        Button noButton = new Button("Cancel");
        noButton.addActionListener(this);
        Panel panel = new Panel();
        panel.add("West", yesButton);
        panel.add("East", noButton);
        return panel;
    }

    protected void _showDialog(Point point) {
        this.dialog.pack();
        Rectangle bounds = this.dialog.getBounds();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int originX = Math.max(0, Math.min(point.x - bounds.width / 2, screenSize.width - bounds.width));
        int originY = Math.max(0, Math.min(point.y - bounds.height / 2, screenSize.height - bounds.height));
        ((Component)this.dialog).setBounds(originX, originY, bounds.width, bounds.height);
        this.dialog.show();
    }

    protected Panel _yesNoButtons() {
        Button yesButton = new Button("Yes");
        yesButton.addActionListener(this);
        Button noButton = new Button("No");
        noButton.addActionListener(this);
        Panel panel = new Panel();
        panel.add("West", yesButton);
        panel.add("East", noButton);
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        String buttonLabel = e.getActionCommand();
        if (buttonLabel.equals("Yes") || buttonLabel.equals("OK")) {
            this.accepted = true;
            this.value = this.textField != null ? this.textField.getText() : null;
        } else if (buttonLabel.equals("No") || buttonLabel.equals("Cancel")) {
            this.accepted = false;
        }
        this.dialog.dispose();
    }

    public static boolean Confirm_(String messageString) {
        return StDialog.Confirm_(messageString, StDialog._getCenterPoint());
    }

    public static boolean Confirm_(String messageString, Point point) {
        return StDialog.Confirm_(messageString, true, point);
    }

    public static boolean Confirm_(String messageString, boolean initialAnswer) {
        return StDialog.Confirm_(messageString, initialAnswer, StDialog._getCenterPoint());
    }

    public boolean confirm_(String messageString, boolean initialAnswer, Point point) {
        this.dialog.add("Center", new Label(messageString, 1));
        this.dialog.add("South", this._yesNoButtons());
        this._showDialog(point);
        return this.accepted;
    }

    public static boolean Confirm_(String messageString, boolean initialAnswer, Point point) {
        StDialog aDialog = new StDialog();
        return aDialog.confirm_(messageString, initialAnswer, point);
    }

    public static File OpenFileDialog() {
        return StDialog.OpenFileDialog_default_("", null);
    }

    public static File OpenFileDialog_(String messageString) {
        return StDialog.OpenFileDialog_default_(messageString, null);
    }

    public static File OpenFileDialog_default_(String messageString, String defaultFilename) {
        FileDialog fileDialog = new FileDialog(SystemResourceSupport.getFrame(), messageString);
        if (lastDirectory != null) {
            fileDialog.setDirectory(lastDirectory);
        }
        if (defaultFilename != null | defaultFilename == "") {
            fileDialog.setFile(defaultFilename);
        }
        fileDialog.show();
        String directory = fileDialog.getDirectory();
        String filename = fileDialog.getFile();
        if (directory == null || filename == null) {
            return null;
        }
        lastDirectory = directory;
        return new File(directory, filename);
    }

    public static String Request_(String messageString) {
        return StDialog.Request_(messageString, StDialog._getCenterPoint());
    }

    public static String Request_(String messageString, Point point) {
        return StDialog.Request_(messageString, "", point);
    }

    public static String Request_(String messageString, String initialAnswer) {
        return StDialog.Request_(messageString, initialAnswer, StDialog._getCenterPoint());
    }

    public String request_(String messageString, String initialAnswer, Point point) {
        this.dialog.setLayout(new GridLayout(3, 1));
        this.textField = new TextField(20);
        ((TextComponent)this.textField).setText(initialAnswer);
        this.dialog.add(new Label(messageString, 1));
        this.dialog.add(this.textField);
        this.dialog.add(this._okCancelButtons());
        this._showDialog(point);
        return this.value;
    }

    public static String Request_(String messageString, String initialAnswer, Point point) {
        StDialog aDialog = new StDialog();
        return aDialog.request_(messageString, initialAnswer, point);
    }

    public static File SaveFileDialog() {
        return StDialog.SaveFileDialog_default_("", null);
    }

    public static File SaveFileDialog_(String messageString) {
        return StDialog.SaveFileDialog_default_(messageString, null);
    }

    public static File SaveFileDialog_default_(String messageString, String defaultFilename) {
        FileDialog fileDialog = new FileDialog(SystemResourceSupport.getFrame(), "", 1);
        if (lastDirectory != null) {
            fileDialog.setDirectory(lastDirectory);
        }
        if (defaultFilename != null | defaultFilename == "") {
            fileDialog.setFile(defaultFilename);
        }
        fileDialog.show();
        String directory = fileDialog.getDirectory();
        String filename = fileDialog.getFile();
        if (directory == null || filename == null) {
            return null;
        }
        lastDirectory = directory;
        return new File(directory, filename);
    }

    public static void Warn_(String messageString) {
        StDialog.Warn_(messageString, StDialog._getCenterPoint());
    }

    public void warn_(String messageString, Point point) {
        this.dialog.add("Center", new Label(messageString, 1));
        this.dialog.add("South", this._closeOKButton());
        this._showDialog(point);
    }

    public static void Warn_(String messageString, Point point) {
        StDialog aDialog = new StDialog();
        aDialog.warn_(messageString, point);
    }
}

