/*
 * Decompiled with CFR 0.152.
 */
package sra.smalltalk;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.util.Vector;
import sra.smalltalk.StObject;
import sra.smalltalk.StSymbol;

public class StColorValue
extends StObject {
    protected int red;
    protected int green;
    protected int blue;
    public static final Color Black = Color.black;
    public static final Color Blue = Color.blue;
    public static final Color Brown = new Color(127, 63, 63);
    public static final Color Chartreuse = new Color(127, 255, 0);
    public static final Color Cyan = new Color(0, 255, 255);
    public static final Color DarkCyan = new Color(0, 127, 127);
    public static final Color DarkGray = new Color(95, 95, 95);
    public static final Color DarkGreen = new Color(0, 127, 0);
    public static final Color DarkMagenta = new Color(127, 0, 127);
    public static final Color DarkRed = new Color(127, 0, 0);
    public static final Color Gray = new Color(127, 127, 127);
    public static final Color Green = new Color(0, 255, 0);
    public static final Color LightGray = new Color(170, 170, 170);
    public static final Color LightCyan = new Color(127, 255, 255);
    public static final Color LightYellow = new Color(255, 255, 127);
    public static final Color Magenta = new Color(255, 0, 255);
    public static final Color Navy = new Color(0, 0, 127);
    public static final Color Olive = new Color(127, 127, 0);
    public static final Color Orange = new Color(255, 127, 0);
    public static final Color Orchid = new Color(255, 127, 255);
    public static final Color PaleGreen = new Color(127, 255, 127);
    public static final Color Pink = new Color(255, 191, 191);
    public static final Color Purple = new Color(159, 31, 223);
    public static final Color Red = Color.red;
    public static final Color RoyalBlue = new Color(127, 127, 255);
    public static final Color Salmon = new Color(255, 127, 127);
    public static final Color SpringGreen = new Color(0, 255, 127);
    public static final Color VeryDarkGray = new Color(63, 63, 63);
    public static final Color VeryLightGray = new Color(212, 212, 212);
    public static final Color White = Color.white;
    public static final Color Yellow = new Color(255, 255, 0);
    public static int _MaxDistanceSquared = -1;
    public static int _MaxValue = 255;
    public static int _MaxLuminanceValue = _MaxValue * 1000;
    public static double _LuminanceScaleValue = 1.0f / (float)_MaxLuminanceValue;

    public static double _DistanceFrom(Color color1, Color color2) {
        return Math.sqrt(StColorValue._DistanceSquaredFrom(color1, color2));
    }

    public static int _DistanceSquaredFrom(Color color1, Color color2) {
        int rdiff = color1.getRed() - color2.getRed();
        int gdiff = color1.getGreen() - color2.getGreen();
        int bdiff = color1.getBlue() - color2.getBlue();
        return rdiff * rdiff + gdiff + gdiff + bdiff * bdiff;
    }

    public static Integer _DistanceSquaredFrom_ifLessThan_(Color color1, Color color2, int dist) {
        int rdiff = color1.getRed() - color2.getRed();
        int diff = rdiff * rdiff;
        if (diff >= dist) {
            return null;
        }
        int gdiff = color1.getGreen() - color2.getGreen();
        if ((diff += gdiff * gdiff) >= dist) {
            return null;
        }
        int bdiff = color1.getBlue() - color2.getBlue();
        if ((diff += bdiff * bdiff) >= dist) {
            return null;
        }
        return new Integer(diff);
    }

    public static int _GetAlpha(Color color) {
        ColorModel rgbColorModel = ColorModel.getRGBdefault();
        return rgbColorModel.getAlpha(color.getRGB());
    }

    public static float _GetBrightness(Color color) {
        float[] values = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), values);
        return values[2];
    }

    public static Color _GetColorByName_(String colorName) {
        if (colorName.compareTo("black") == 0) {
            return Black;
        }
        if (colorName.compareTo("blue") == 0) {
            return Blue;
        }
        if (colorName.compareTo("brown") == 0) {
            return Brown;
        }
        if (colorName.compareTo("chartreuse") == 0) {
            return Chartreuse;
        }
        if (colorName.compareTo("cyan") == 0) {
            return Cyan;
        }
        if (colorName.compareTo("darkCyan") == 0) {
            return DarkCyan;
        }
        if (colorName.compareTo("darkGray") == 0) {
            return DarkGray;
        }
        if (colorName.compareTo("darkGreen") == 0) {
            return DarkGreen;
        }
        if (colorName.compareTo("darkMagenta") == 0) {
            return DarkMagenta;
        }
        if (colorName.compareTo("darkRed") == 0) {
            return DarkRed;
        }
        if (colorName.compareTo("gray") == 0) {
            return Gray;
        }
        if (colorName.compareTo("green") == 0) {
            return Green;
        }
        if (colorName.compareTo("lightGray") == 0) {
            return LightGray;
        }
        if (colorName.compareTo("lightCyan") == 0) {
            return LightCyan;
        }
        if (colorName.compareTo("lightYellow") == 0) {
            return LightYellow;
        }
        if (colorName.compareTo("magenta") == 0) {
            return Magenta;
        }
        if (colorName.compareTo("navy") == 0) {
            return Navy;
        }
        if (colorName.compareTo("olive") == 0) {
            return Olive;
        }
        if (colorName.compareTo("orange") == 0) {
            return Orange;
        }
        if (colorName.compareTo("orchid") == 0) {
            return Orchid;
        }
        if (colorName.compareTo("paleGreen") == 0) {
            return PaleGreen;
        }
        if (colorName.compareTo("pink") == 0) {
            return Pink;
        }
        if (colorName.compareTo("purple") == 0) {
            return Purple;
        }
        if (colorName.compareTo("red") == 0) {
            return Red;
        }
        if (colorName.compareTo("royalBlue") == 0) {
            return RoyalBlue;
        }
        if (colorName.compareTo("salmon") == 0) {
            return Salmon;
        }
        if (colorName.compareTo("springGreen") == 0) {
            return SpringGreen;
        }
        if (colorName.compareTo("veryDarkGray") == 0) {
            return VeryDarkGray;
        }
        if (colorName.compareTo("veryLightGray") == 0) {
            return VeryLightGray;
        }
        if (colorName.compareTo("white") == 0) {
            return White;
        }
        if (colorName.compareTo("yellow") == 0) {
            return Yellow;
        }
        return null;
    }

    public static float _GetHue(Color color) {
        float[] values = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), values);
        return values[0];
    }

    public static double _GetLuminance(Color color) {
        return _LuminanceScaleValue * (double)StColorValue._ScaledLuminance_(color);
    }

    public static float _GetSaturation(Color color) {
        float[] values = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), values);
        return values[1];
    }

    public static boolean _IsGray(Color color) {
        return color.getRed() == color.getGreen() && color.getGreen() == color.getBlue() && (color.getRGB() >> 24 & 0xFF) != 0;
    }

    public static int _MaxDistanceSquared() {
        if (_MaxDistanceSquared == -1) {
            _MaxDistanceSquared = StColorValue._DistanceSquaredFrom(Color.black, Color.white);
        }
        return _MaxDistanceSquared;
    }

    public static Color _NewColor(float red, float green, float blue, float alpha) {
        return StColorValue._NewColor(red * 255.0f, green * 255.0f, blue * 255.0f, alpha * 255.0f);
    }

    public static Color _NewColor(int red, int green, int blue, int alpha) {
        int pixel = alpha << 24 | red << 16 | green << 8 | blue << 0;
        return new Color(pixel);
    }

    public static int _ScaledLuminance_(Color color) {
        return 299 * color.getRed() + 587 * color.getGreen() + 114 * color.getBlue();
    }

    public static Color Brightness_(double b) {
        int sb = Math.round((float)(b * 255.0));
        if (sb >= 0 && sb <= 255) {
            return new Color(sb, sb, sb);
        }
        return Color.black;
    }

    public static Vector ConstantNames() {
        Vector<StSymbol> colorNames = new Vector<StSymbol>();
        colorNames.addElement(StObject.$("black"));
        colorNames.addElement(StObject.$("blue"));
        colorNames.addElement(StObject.$("brown"));
        colorNames.addElement(StObject.$("chartreuse"));
        colorNames.addElement(StObject.$("cyan"));
        colorNames.addElement(StObject.$("darkCyan"));
        colorNames.addElement(StObject.$("darkGray"));
        colorNames.addElement(StObject.$("darkGreen"));
        colorNames.addElement(StObject.$("darkMagenta"));
        colorNames.addElement(StObject.$("darkRed"));
        colorNames.addElement(StObject.$("olive"));
        colorNames.addElement(StObject.$("gray"));
        colorNames.addElement(StObject.$("green"));
        colorNames.addElement(StObject.$("lightYellow"));
        colorNames.addElement(StObject.$("lightGray"));
        colorNames.addElement(StObject.$("magenta"));
        colorNames.addElement(StObject.$("navy"));
        colorNames.addElement(StObject.$("orange"));
        colorNames.addElement(StObject.$("orchid"));
        colorNames.addElement(StObject.$("paleGreen"));
        colorNames.addElement(StObject.$("pink"));
        colorNames.addElement(StObject.$("purple"));
        colorNames.addElement(StObject.$("red"));
        colorNames.addElement(StObject.$("royalBlue"));
        colorNames.addElement(StObject.$("salmon"));
        colorNames.addElement(StObject.$("lightCyan"));
        colorNames.addElement(StObject.$("springGreen"));
        colorNames.addElement(StObject.$("veryDarkGray"));
        colorNames.addElement(StObject.$("veryLightGray"));
        colorNames.addElement(StObject.$("white"));
        colorNames.addElement(StObject.$("yellow"));
        return colorNames;
    }

    public static Color Cyan_Magenta_Yellow_(double cyan, double magenta, double yellow) {
        return new Color((float)(1.0 - cyan), (float)(1.0 - magenta), (float)(1.0 - yellow));
    }

    public static Color ScaledRed_ScaledGreen_ScaledBlue_(int r, int g, int b) {
        int scaledRed = Math.min(Math.max(r / 32, 0), 255);
        int scaledGreen = Math.min(Math.max(g / 32, 0), 255);
        int scaledBlue = Math.min(Math.max(b / 32, 0), 255);
        return new Color(scaledRed, scaledGreen, scaledBlue);
    }
}

