/*
 * Decompiled with CFR 0.152.
 */
package sra.smalltalk;

import java.io.IOException;
import java.io.Writer;
import sra.smalltalk.StObject;

public class StByteArray
extends StObject {
    protected byte[] byteArray = null;

    public StByteArray() {
        this(0);
    }

    public StByteArray(byte[] bytes) {
        this.byteArray = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            this.byteArray[i] = bytes[i];
            ++i;
        }
    }

    public StByteArray(int[] ints) {
        this.byteArray = new byte[ints.length];
        int i = 0;
        while (i < ints.length) {
            this.byteArray[i] = (byte)ints[i];
            ++i;
        }
    }

    public StByteArray(int size) {
        this.byteArray = new byte[size];
        int i = 0;
        while (i < size) {
            this.byteArray[i] = 0;
            ++i;
        }
    }

    public byte[] _asBytes() {
        byte[] newArray = new byte[this.byteArray.length];
        int i = 0;
        while (i < this.byteArray.length) {
            newArray[i] = this.byteArray[i];
            ++i;
        }
        return newArray;
    }

    public int[] _asInts() {
        int[] ints = new int[this.byteArray.length];
        int i = 0;
        while (i < this.byteArray.length) {
            ints[i] = this.byteArray[i] & 0xFF;
            ++i;
        }
        return ints;
    }

    public String asPackedString() {
        int size = this.size();
        StByteArray result = new StByteArray((size + 2) / 3 * 4);
        if (size > 300) {
            this.slowEncodeFrom_into_startingAt_(1, result, 1);
        } else {
            this.slowEncodeFrom_into_startingAt_(1, result, 1);
        }
        return new String(result._asBytes());
    }

    public byte at_(int index) {
        return this.byteArray[index - 1];
    }

    public void at_put_(int index, byte value) {
        this.byteArray[index - 1] = value;
    }

    public static StByteArray FromPackedString_(String packedString) {
        int size = packedString.length();
        if (size == 0) {
            return new StByteArray();
        }
        char last = packedString.charAt(size - 1);
        int resultSize = Math.round((float)size / 4.0f) * 3;
        if (last >= '`') {
            resultSize = resultSize - 3 + last - 96;
        }
        StByteArray result = new StByteArray(resultSize);
        if (size > 400) {
            StByteArray.SlowDecodeFromFrom_Starting_Into_(1, packedString, 1, result);
        } else {
            StByteArray.SlowDecodeFromFrom_Starting_Into_(1, packedString, 1, result);
        }
        return result;
    }

    public final int size() {
        return this.byteArray.length;
    }

    private static void SlowDecodeFromFrom_Starting_Into_(int start, String source, int index, StByteArray dest) {
        int to = start;
        int from = index;
        int stop = dest.size();
        while (to <= stop) {
            int w = (source.charAt(from - 1) & 0x3F) << 18;
            w += (source.charAt(from) & 0x3F) << 12;
            w += (source.charAt(from + 1) & 0x3F) << 6;
            dest.at_put_(to, (byte)((w += source.charAt((from += 4) + 2) & 0x3F) >> 16));
            if (to < stop) {
                dest.at_put_(to + 1, (byte)(w >> 8 & 0xFF));
                if (to + 1 < stop) {
                    dest.at_put_(to + 2, (byte)(w & 0xFF));
                }
            }
            to += 3;
        }
    }

    private void slowEncodeFrom_into_startingAt_(int start, StByteArray dest, int index) {
        int from = start;
        int to = index;
        int stop = this.size();
        while (from <= stop) {
            int w = this.at_(from) << 16;
            if (from < stop) {
                w += this.at_(from + 1) << 8;
                if (from + 1 < stop) {
                    w += this.at_(from + 2);
                }
            }
            from += 3;
            dest.at_put_(to, (byte)(((w ^= 0x820820) >> 18) + 32));
            dest.at_put_(to + 1, (byte)((w >> 12 & 0x3F) + 32));
            dest.at_put_(to + 2, (byte)((w >> 6 & 0x3F) + 32));
            dest.at_put_(to + 3, (byte)((w & 0x3F) + 32));
            to += 4;
        }
        if (stop % 3 != 0) {
            dest.at_put_(to - 1, (byte)(stop % 3 + 96));
        }
    }

    public void storeOn_(Writer aWriter) throws IOException {
        aWriter.write("(ByteArray fromPackedString: '");
        aWriter.write(this.asPackedString());
        aWriter.write("')");
    }
}

