/*
 * Decompiled with CFR 0.152.
 */
package sra.smalltalk;

import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import sra.smalltalk.SmalltalkException;
import sra.smalltalk.StButtonGroup;
import sra.smalltalk.StCheckBoxMenuItem;
import sra.smalltalk.StMenuItem;
import sra.smalltalk.StMenuModel;
import sra.smalltalk.StMenuViewForAwt;
import sra.smalltalk.StModel;
import sra.smalltalk.StRadioButtonMenuItem;
import sra.smalltalk.StUIBuilder;
import sra.smalltalk.StView;

public abstract class StApplicationModel
extends StModel
implements ActionListener,
ItemListener {
    public static final int VIEW_AWT = 0;
    public static final int VIEW_SWING = 1;
    public static final int VIEW_SWING_ONLY = 2;
    protected static int DefaultViewMode;
    protected StUIBuilder builder = new StUIBuilder(this);
    static Class class$sra$smalltalk$StApplicationModel;
    static Class class$sra$smalltalk$StView;

    public static Panel _PanelWithBorder() {
        Panel aPanel = new Panel(){

            public Insets getInsets() {
                return new Insets(4, 4, 4, 4);
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                Dimension size = this.getSize();
                graphics.setColor(Color.black);
                graphics.fillRect(1, 1, size.width - 4, 1);
                graphics.setColor(Color.gray);
                graphics.fillRect(2, 2, size.width - 4, 1);
                graphics.setColor(Color.lightGray);
                graphics.fillRect(1, size.height - 3, size.width - 4, 1);
                graphics.setColor(Color.black);
                graphics.fillRect(1, 1, 1, size.height - 4);
                graphics.setColor(Color.gray);
                graphics.fillRect(2, 2, 1, size.height - 4);
                graphics.setColor(Color.lightGray);
                graphics.fillRect(size.width - 3, 1, 1, size.height - 4);
            }
        };
        return aPanel;
    }

    public void actionPerformed(ActionEvent ev) {
        this.perform_(ev.getActionCommand());
    }

    public final StUIBuilder builder() {
        return this.builder;
    }

    protected StCheckBoxMenuItem createCheckBoxMenuItem(String displayString, String commandString) {
        StCheckBoxMenuItem item = new StCheckBoxMenuItem(displayString);
        item.setActionCommand(commandString);
        item.addActionListener(this);
        return item;
    }

    protected StMenuItem createMenuItem(String displayString, String commandString) {
        StMenuItem item = new StMenuItem(displayString);
        item.setActionCommand(commandString);
        item.addActionListener(this);
        return item;
    }

    protected StRadioButtonMenuItem createRadioButtonMenuItem(String displayString, String commandString, StButtonGroup radioGroup) {
        StRadioButtonMenuItem item = new StRadioButtonMenuItem(displayString);
        item.setActionCommand(commandString);
        item.addActionListener(this);
        radioGroup.add(item);
        return item;
    }

    protected static final StView CreateView(String className) {
        try {
            return (StView)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new SmalltalkException(e);
        }
    }

    public abstract StView defaultView();

    public static final int GetDefaultViewMode() {
        return DefaultViewMode;
    }

    public static final boolean IsSwingInstalled() {
        try {
            Class.forName("javax.swing.JComponent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public void itemStateChanged(ItemEvent ev) {
        String command = ev.getSource() instanceof StCheckBoxMenuItem ? ((StCheckBoxMenuItem)ev.getSource()).getActionCommand() : ((CheckboxMenuItem)ev.getSource()).getActionCommand();
        this.perform_(command);
    }

    public StMenuModel menuModel() {
        return null;
    }

    public Frame open() {
        return this.openView_(this.defaultView());
    }

    public Frame openView_(StView aView) {
        Frame aFrame;
        aView.model_(this);
        boolean viewmode = false;
        try {
            Class<?> aClass = Class.forName("javax.swing.JComponent");
            if (aClass.isInstance(aView)) {
                viewmode = true;
            }
        }
        catch (Exception exception) {}
        if (!viewmode) {
            aFrame = StMenuViewForAwt.CreateFrame(this, aView);
        } else {
            Class[] classArray = new Class[2];
            Class<?> clazz = class$sra$smalltalk$StApplicationModel;
            if (clazz == null) {
                try {
                    clazz = class$sra$smalltalk$StApplicationModel = Class.forName("sra.smalltalk.StApplicationModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$sra$smalltalk$StView;
            if (clazz2 == null) {
                try {
                    clazz2 = class$sra$smalltalk$StView = Class.forName("sra.smalltalk.StView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class[] parameterTypes = classArray;
            try {
                Class<?> aClass = Class.forName("sra.smalltalk.StMenuViewForSwing");
                Method aMethod = aClass.getMethod("CreateJFrame", parameterTypes);
                aFrame = (Frame)aMethod.invoke(aClass, this, aView);
            }
            catch (Exception e) {
                throw new SmalltalkException(e);
            }
        }
        aFrame.show();
        return aFrame;
    }

    protected boolean requestForWindowClose() {
        return true;
    }

    public static final boolean SetDefaultViewMode(int mode) {
        if (mode != 0 && !StApplicationModel.IsSwingInstalled()) {
            return false;
        }
        DefaultViewMode = mode;
        return true;
    }

    public void windowClosing(WindowEvent e) {
        this.builder().removeFrame_((Frame)e.getWindow());
        ((Component)e.getWindow()).setVisible(false);
        Thread.yield();
        e.getWindow().dispose();
    }

    protected boolean windowResizable() {
        return true;
    }

    protected String windowTitle() {
        return this.toString();
    }
}

