/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.spot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.interfaces.spot.IsrSpotController;
import sra.isr.interfaces.spot.IsrSpotModel;
import sra.isr.interfaces.spot.IsrSpotView;
import sra.smalltalk.DependentEvent;
import sra.smalltalk.StImage;
import sra.smalltalk.StModel;
import sra.smalltalk.StViewJPanel;

public class IsrSpotViewSwing
extends StViewJPanel
implements IsrSpotView {
    protected IsrSpotController controller;

    protected void buildComponent() {
        ((JComponent)((Object)this)).setPreferredSize(new Dimension(this.plateArea().width + 22, this.plateArea().height + 22));
        this.controller = this.defaultController();
        this.controller.view_(this);
    }

    protected IsrSpotController defaultController() {
        return new IsrSpotController();
    }

    protected StModel defaultModel() {
        return new IsrSpotModel();
    }

    public void displayOn_(Graphics aGraphics) {
        this.displayPlateOn_(aGraphics);
        this.displayXYOn_(aGraphics);
    }

    public void displayPlateOn_(Graphics aGraphics) {
        if (!((Component)((Object)this)).isShowing()) {
            return;
        }
        Rectangle box = this.plateArea();
        aGraphics.clipRect(box.x - 1, box.y - 1, box.width + 2, box.height + 2);
        this.plate().displayOn_at_(aGraphics, box.getLocation());
        aGraphics.setColor(Color.black);
        aGraphics.drawRect(box.x - 1, box.y - 1, box.width + 1, box.height + 1);
    }

    public void displayXYOn_(Graphics aGraphics) {
        if (!((Component)((Object)this)).isShowing()) {
            return;
        }
        Rectangle box = this.plateArea();
        aGraphics.clipRect(box.x - 1, box.y - 1, box.width + 2, box.height + 2);
        Point point = new Point((int)(this.xy().x() * (double)(box.width - 1)), (int)(this.xy().y() * (double)(box.height - 1)));
        Point globalPoint = new Point(point);
        globalPoint.translate(box.x, box.y);
        aGraphics.setColor(Color.white);
        int i = 0;
        while (i < 360) {
            aGraphics.drawArc(globalPoint.x - 4, globalPoint.y - 4, 8, 8, i, 15);
            if (aGraphics.getColor() == Color.white) {
                aGraphics.setColor(Color.black);
            } else {
                aGraphics.setColor(Color.white);
            }
            i += 15;
        }
    }

    public IsrSpotModel getModel() {
        return (IsrSpotModel)this.model();
    }

    public StImage plate() {
        return this.getModel().plate();
    }

    public Rectangle plateArea() {
        Rectangle imageRect = this.plate().bounds();
        imageRect.translate(10, 10);
        return imageRect;
    }

    public void setModel(IsrSpotModel aModel) {
        this.model_((StModel)aModel);
    }

    public void update_(DependentEvent evt) {
        block3: {
            if (!((Component)((Object)this)).isShowing()) {
                return;
            }
            if (evt.getAspect() != StViewJPanel.$((String)"xy")) break block3;
            Graphics gc = ((JComponent)((Object)this)).getGraphics();
            try {
                this.displayPlateOn_(gc);
                this.displayXYOn_(gc);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                gc.dispose();
                throw throwable;
            }
            Object var3_5 = null;
            gc.dispose();
        }
    }

    public Isr2dPoint xy() {
        return this.getModel().xy();
    }
}

