/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.spot;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.interfaces.spot.IsrSpotModel;
import sra.isr.interfaces.spot.IsrSpotView;
import sra.smalltalk.StController;
import sra.smalltalk.StView;

public class IsrSpotController
extends StController
implements MouseListener,
MouseMotionListener {
    protected void buildListener(StView newView) {
        Component aView = (Component)newView;
        aView.addMouseListener(this);
        aView.addMouseMotionListener(this);
    }

    protected IsrSpotModel getModel() {
        return (IsrSpotModel)this.model();
    }

    protected IsrSpotView getView() {
        return (IsrSpotView)this.view();
    }

    public void mouseDragged(MouseEvent event) {
        if (this.isMenuButtonPressed_(event)) {
            return;
        }
        IsrSpotView view = this.getView();
        if (view.plateArea().contains(event.getPoint())) {
            this.mousePressed(event);
        }
    }

    public void mouseMoved(MouseEvent event) {
        IsrSpotView view = this.getView();
        if (view.plateArea().contains(event.getPoint())) {
            ((Component)((Object)view)).setCursor(Cursor.getPredefinedCursor(1));
        } else {
            ((Component)((Object)view)).setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mousePressed(MouseEvent event) {
        if (this.isMenuButtonPressed_(event)) {
            return;
        }
        Point point = event.getPoint();
        IsrSpotView view = this.getView();
        if (view.plateArea().contains(point)) {
            double x = (double)(point.x - view.plateArea().getLocation().x) / ((double)view.plateArea().width - 1.0);
            double y = (double)(point.y - view.plateArea().getLocation().y) / ((double)view.plateArea().height - 1.0);
            Isr2dPoint pointXy = new Isr2dPoint(x, y);
            ((IsrSpotModel)this.model()).xy_(pointXy);
        }
    }
}

