/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.nineColors;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.image.support.IsrImageProcessor;
import sra.isr.interfaces.nineColors.Isr9ColorsView;
import sra.isr.interfaces.nineColors.Isr9ColorsViewAwt;
import sra.smalltalk.StApplicationModel;
import sra.smalltalk.StAssociation;
import sra.smalltalk.StColorValue;
import sra.smalltalk.StDialog;
import sra.smalltalk.StImage;
import sra.smalltalk.StMenu;
import sra.smalltalk.StMenuItem;
import sra.smalltalk.StMenuModel;
import sra.smalltalk.StModel;
import sra.smalltalk.StObject;
import sra.smalltalk.StView;

public class Isr9ColorsModel
extends StApplicationModel {
    protected Color[] colors;
    protected StImage plate;
    private boolean accepted = false;

    private Rectangle[] _nineAreas_(Rectangle bounds) {
        Point size = new Point(bounds.width / 3, bounds.height / 3);
        Point[] array = new Point[]{new Point(size.x * 0, size.y * 0), new Point(size.x * 1, size.y * 1), new Point(size.x * 2, size.y * 2), new Point(size.x * 3, size.y * 3)};
        int index = 0;
        while (index < 4) {
            array[index] = new Point(Math.min(array[index].x, bounds.width), Math.min(array[index].y, bounds.height));
            ++index;
        }
        Rectangle[] collection = new Rectangle[9];
        int j = 0;
        while (j < array.length - 1) {
            int i = 0;
            while (i < array.length - 1) {
                Point origin = new Point(array[i].x, array[j].y);
                Point corner = new Point(array[i + 1].x, array[j + 1].y);
                Rectangle box = new Rectangle(origin.x, origin.y, corner.x - origin.x, corner.y - origin.y);
                box.translate(bounds.x, bounds.y);
                collection[j * 3 + i] = box;
                ++i;
            }
            ++j;
        }
        return collection;
    }

    private Color[] _nineColors_(StImage anImage) {
        Color[] collection = new Color[9];
        Rectangle[] areas = this._nineAreas_(anImage.bounds());
        int index = 0;
        while (index < areas.length) {
            StAssociation assoc;
            Rectangle area = areas[index];
            StImage image = new StImage(area.width, area.height);
            image = image.copy_from_in_rule_(image.bounds(), area.getLocation(), anImage, 3);
            Object[] histogram = IsrImageProcessor.ColorHistogram_(image);
            double max = 0.0;
            Color color = null;
            int i = 0;
            while (i < histogram.length) {
                boolean isGray;
                assoc = (StAssociation)histogram[i];
                Color key = (Color)assoc.key();
                boolean bl = isGray = key.getRed() == key.getGreen() && key.getGreen() == key.getBlue();
                if ((Double)assoc.value() > max && !isGray) {
                    color = key;
                    max = (Double)assoc.value();
                }
                ++i;
            }
            if (color == null) {
                max = 0.0;
                color = null;
                i = 0;
                while (i < histogram.length) {
                    assoc = (StAssociation)histogram[i];
                    if ((Double)assoc.value() > max) {
                        color = (Color)assoc.key();
                        max = (Double)assoc.value();
                    }
                    ++i;
                }
            }
            if (color == null) {
                color = Color.white;
            }
            collection[index] = color;
            ++index;
        }
        return collection;
    }

    public Panel _okCancelButtons(Dialog target) {
        Panel panel = new Panel();
        Isr9ColorsModel this_ = this;
        panel.add("West", new Button(target, this_, "OK"){
            /* synthetic */ Dialog val$target;
            /* synthetic */ Isr9ColorsModel val$this_;

            public boolean action(Event ev, Object what) {
                this.val$this_.accept();
                this.val$target.dispose();
                return true;
            }
            {
                this.val$target = val$target;
                this.val$this_ = val$this_;
            }
        });
        panel.add("East", new Button(target, this_, "Cancel"){
            /* synthetic */ Dialog val$target;
            /* synthetic */ Isr9ColorsModel val$this_;

            public boolean action(Event ev, Object what) {
                this.val$this_.cancel();
                this.val$target.dispose();
                return true;
            }
            {
                this.val$target = val$target;
                this.val$this_ = val$this_;
            }
        });
        return panel;
    }

    public void accept() {
        this.accepted = true;
    }

    public Rectangle areaAt_(int index) {
        if (index == 0) {
            return new Rectangle(0, 0, 33, 33);
        }
        if (index == 1) {
            return new Rectangle(34, 0, 33, 33);
        }
        if (index == 2) {
            return new Rectangle(68, 0, 33, 33);
        }
        if (index == 3) {
            return new Rectangle(0, 34, 33, 33);
        }
        if (index == 4) {
            return new Rectangle(34, 34, 33, 33);
        }
        if (index == 5) {
            return new Rectangle(68, 34, 33, 33);
        }
        if (index == 6) {
            return new Rectangle(0, 68, 33, 33);
        }
        if (index == 7) {
            return new Rectangle(34, 68, 33, 33);
        }
        if (index == 8) {
            return new Rectangle(68, 68, 33, 33);
        }
        return null;
    }

    public Color at_(int index) {
        return this.colors()[index];
    }

    public void at_put_(int index, Color color) {
        this.colors()[index] = color;
        this.plate = null;
        this.changed_(StObject.$((String)"colors"));
    }

    public void cancel() {
    }

    public Color[] colors() {
        if (this.colors == null) {
            this.colors = new Color[9];
        }
        return this.colors;
    }

    public static Isr9ColorsModel Colors_(Color[] colorValues) {
        Color[] colors = new Color[9];
        int index = 0;
        while (index <= 8) {
            colors[index] = colorValues[index];
            ++index;
        }
        Isr9ColorsModel model = new Isr9ColorsModel();
        model.colors_(colors);
        return model;
    }

    public void colors_(Color[] anArray) {
        this.colors = anArray;
        this.plate = null;
        this.changed_(StObject.$((String)"colors"));
    }

    public StView colorsView() {
        StView view = this.defaultView();
        view.model_((StModel)this);
        return view;
    }

    protected StMenuModel defaultMenu() {
        StMenuModel rootMenu = new StMenuModel();
        StMenu editMenu = new StMenu("NineColorsMenu");
        editMenu.add(this.createMenuItem("clear", "doClear"));
        editMenu.addSeparator();
        editMenu.add(this.createMenuItem("colors", "doColors"));
        rootMenu.add((StMenuItem)editMenu);
        return rootMenu;
    }

    public StView defaultView() {
        if (StApplicationModel.GetDefaultViewMode() == 0) {
            return new Isr9ColorsViewAwt();
        }
        return StApplicationModel.CreateView((String)"sra.isr.interfaces.nineColors.Isr9ColorsViewSwing");
    }

    public void doClear() {
        this.colors_(new Color[9]);
    }

    public void doColors() {
        int index = 0;
        while (index <= 8) {
            Color color = this.colors()[index];
            String colorString = color == null ? "null" : color.toString();
            System.out.println(String.valueOf(Integer.toString(index)) + ": " + colorString);
            ++index;
        }
    }

    public void doScissors() {
        StDialog.Warn_((String)"ShouldNotImpliment");
    }

    public int indexAt_(Isr2dPoint normalizedPoint) {
        Point point = new Point((int)(normalizedPoint.x() * (double)(this.plate().width() - 1)), (int)(normalizedPoint.y() * (double)(this.plate().height() - 1)));
        int index = 0;
        while (index <= 8) {
            Rectangle area = this.areaAt_(index);
            if (area.contains(point)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public StImage plate() {
        if (this.plate != null) {
            return this.plate;
        }
        StImage plate = IsrImageProcessor.Fill_color_(new StImage(101, 101), Color.black);
        int index = 0;
        while (index <= 8) {
            StImage image;
            Color color = this.at_(index);
            if (color == null) {
                image = Isr9ColorsModel.Tile();
            } else {
                image = new StImage(1, 1);
                int value = color.getRGB();
                image.atX_y_put_(0, 0, value);
            }
            plate = plate.tile_from_in_rule_(this.areaAt_(index), new Point(0, 0), image, 3);
            ++index;
        }
        return plate;
    }

    public void printOn_(Writer aWriter) throws IOException {
        super.printOn_(aWriter);
        aWriter.write(" on: ");
        aWriter.write(this.colors().toString());
    }

    public static Color[] Request_(Color[] anArray) {
        Isr9ColorsModel colorsModel = new Isr9ColorsModel();
        colorsModel.colors_(anArray);
        Color[] selection = null;
        Frame parent = new Frame();
        Isr9ColorsView view = (Isr9ColorsView)colorsModel.colorsView();
        Dialog dialog = new Dialog(parent, "9 Colors", true);
        dialog.setResizable(false);
        dialog.add("Center", (Component)((Object)view));
        dialog.add("South", colorsModel._okCancelButtons(dialog));
        dialog.pack();
        try {
            Thread.sleep(0L);
        }
        catch (Exception exception) {}
        colorsModel.changed();
        dialog.show();
        if (colorsModel.accepted) {
            selection = colorsModel.colors();
        }
        return selection;
    }

    public static StImage Tile() {
        StImage image = new StImage(4, 4);
        int iw = StColorValue.Brightness_((double)0.9).getRGB();
        int ib = StColorValue.Brightness_((double)0.45).getRGB();
        image.atX_y_put_(0, 0, iw);
        image.atX_y_put_(1, 0, iw);
        image.atX_y_put_(2, 0, ib);
        image.atX_y_put_(3, 0, ib);
        image.atX_y_put_(0, 1, iw);
        image.atX_y_put_(1, 1, iw);
        image.atX_y_put_(2, 1, ib);
        image.atX_y_put_(3, 1, ib);
        image.atX_y_put_(0, 2, ib);
        image.atX_y_put_(1, 2, ib);
        image.atX_y_put_(2, 2, iw);
        image.atX_y_put_(3, 2, iw);
        image.atX_y_put_(0, 3, ib);
        image.atX_y_put_(1, 3, ib);
        image.atX_y_put_(2, 3, iw);
        image.atX_y_put_(3, 3, iw);
        return image;
    }

    protected String windowTitle() {
        return "9 Colors";
    }
}

