/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.nineColors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.interfaces.colors.IsrColorChoiceSBH;
import sra.isr.interfaces.nineColors.Isr9ColorsModel;
import sra.isr.interfaces.nineColors.Isr9ColorsView;
import sra.smalltalk.StController;
import sra.smalltalk.StView;

public class Isr9ColorsController
extends StController
implements MouseListener,
MouseMotionListener {
    protected void buildListener(StView newView) {
        Component aView = (Component)newView;
        aView.addMouseListener(this);
        aView.addMouseMotionListener(this);
    }

    protected Isr9ColorsModel getModel() {
        return (Isr9ColorsModel)this.model();
    }

    protected Isr9ColorsView getView() {
        return (Isr9ColorsView)this.view();
    }

    public void mouseMoved(MouseEvent event) {
        Isr9ColorsView view = this.getView();
        if (view.plateArea().contains(event.getPoint())) {
            ((Component)((Object)view)).setCursor(Cursor.getPredefinedCursor(1));
        } else {
            ((Component)((Object)view)).setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mousePressed(MouseEvent event) {
        Isr9ColorsView view = this.getView();
        Point point = event.getPoint();
        if (event.isMetaDown()) {
            view.showPopupMenu(point);
            return;
        }
        Isr9ColorsModel colorsModel = this.getModel();
        if (view.plateArea().contains(point)) {
            double x = (double)(point.x - view.plateArea().getLocation().x) / ((double)view.plateArea().width - 1.0);
            double y = (double)(point.y - view.plateArea().getLocation().y) / ((double)view.plateArea().height - 1.0);
            Isr2dPoint pointXy = new Isr2dPoint(x, y);
            int index = colorsModel.indexAt_(pointXy);
            if (index == -1) {
                return;
            }
            Color color = null;
            if (event.isShiftDown() ? (color = IsrColorChoiceSBH.Request()) == null : (color = (color = colorsModel.at_(index)) == null ? IsrColorChoiceSBH.Request() : IsrColorChoiceSBH.Request_(color)) == null) {
                return;
            }
            colorsModel.at_put_(index, color);
            event.consume();
        }
    }
}

