/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.gauge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.util.Enumeration;
import java.util.Vector;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.interfaces.gauge.IsrGaugeController;
import sra.isr.interfaces.gauge.IsrGaugeModel;
import sra.isr.interfaces.gauge.IsrGaugeView;
import sra.smalltalk.DependentEvent;
import sra.smalltalk.StAssociation;
import sra.smalltalk.StColorValue;
import sra.smalltalk.StModel;
import sra.smalltalk.StSymbol;
import sra.smalltalk.StViewCanvas;
import sra.smalltalk.SystemResourceSupport;

public class IsrGaugeViewAwt
extends StViewCanvas
implements IsrGaugeView {
    protected IsrGaugeController controller;
    protected StSymbol getSelector;
    protected StSymbol putSelector;
    protected double minValue;
    protected double maxValue;
    protected int divideValue;
    protected double roundValue;
    protected Vector scalesLayout;
    protected static Color _ForegroundColor = StColorValue.Black;
    protected static Color _SelectionForegroundColor = SystemColor.controlLtHighlight;
    protected static Color _SelectionBackgroundColor = SystemColor.textHighlight;

    protected void buildComponent() {
        ((Component)((Object)this)).setSize(100, 180);
        this.controller = this.defaultController();
        this.controller.view_(this);
    }

    protected IsrGaugeController defaultController() {
        return new IsrGaugeController();
    }

    public Rectangle defaultMargin() {
        return new Rectangle(10, 10, 10, 10);
    }

    protected StModel defaultModel() {
        return new IsrGaugeModel();
    }

    public void displayBorderOn_(Graphics aGraphics) {
        if (!((Component)((Object)this)).isShowing()) {
            return;
        }
        Rectangle border = this.gaugeBorder();
        aGraphics.setColor(StColorValue.Brightness_((double)0.75));
        aGraphics.drawLine(border.x, border.y + border.height, border.x + border.width, border.y + border.height);
        aGraphics.setColor(StColorValue.Brightness_((double)0.75));
        aGraphics.drawLine(border.x + border.width, border.y, border.x + border.width, border.y + border.height);
        aGraphics.setColor(StColorValue.Brightness_((double)0.25));
        aGraphics.drawLine(border.x, border.y, border.x + border.width, border.y);
        aGraphics.setColor(StColorValue.Brightness_((double)0.25));
        aGraphics.drawLine(border.x, border.y, border.x, border.y + border.height);
    }

    public void displayOn_(Graphics aGraphics) {
        this.displayBorderOn_(aGraphics);
        this.displayScalesOn_(aGraphics);
        this.displayValueOn_(aGraphics);
    }

    public void displayScalesOn_(Graphics aGraphics) {
        if (!((Component)((Object)this)).isShowing()) {
            return;
        }
        Rectangle bounds = new Rectangle(0, 0, ((Component)((Object)this)).getBounds().width, ((Component)((Object)this)).getBounds().height);
        Rectangle margin = this.defaultMargin();
        Rectangle box = new Rectangle(bounds.x + margin.x, bounds.y + margin.y, bounds.width - margin.width - margin.x, bounds.height - margin.height - margin.y);
        Point extent = this.gaugeScalesExtent();
        FontMetrics fontMetrics = SystemResourceSupport.getFontMetrics((Font)SystemResourceSupport.getFont());
        Enumeration enumeration = this.gaugeScales().elements();
        while (enumeration.hasMoreElements()) {
            StAssociation assoc = (StAssociation)enumeration.nextElement();
            String label = assoc.key().toString();
            double location = (Double)assoc.value();
            int labelWidth = fontMetrics.stringWidth(label);
            int labelHeight = fontMetrics.getAscent();
            int labelHeightFromBoxY = box.height - (int)((double)box.height * location);
            Point point = new Point(box.x + (extent.x - labelWidth), labelHeightFromBoxY + box.y);
            Point stringCenterHeightPoint = new Point(point.x, point.y + labelHeight / 2);
            aGraphics.setColor(_ForegroundColor);
            aGraphics.drawString(label, stringCenterHeightPoint.x, stringCenterHeightPoint.y);
            Point lineFromPoint = new Point(box.x + extent.x, labelHeightFromBoxY + box.y);
            aGraphics.setColor(_ForegroundColor);
            aGraphics.drawLine(lineFromPoint.x + 3, lineFromPoint.y, lineFromPoint.x + 7, lineFromPoint.y);
        }
    }

    public void displayValueOn_(Graphics aGraphics) {
        if (!((Component)((Object)this)).isShowing()) {
            return;
        }
        double value = (this.getValue() - this.minValue) / (this.maxValue - this.minValue);
        Rectangle border = this.gaugeBorder();
        border = new Rectangle(border.x + 1, border.y + 1, border.width - 1, border.height - 1);
        Rectangle back = new Rectangle(border.x, border.y, border.width, border.height - (int)((double)border.height * value));
        Rectangle fore = new Rectangle(back.x, back.y + back.height, border.width, border.height);
        aGraphics.setColor(_SelectionForegroundColor);
        Rectangle intersection = back.intersection(border);
        aGraphics.fillRect(intersection.x, intersection.y, intersection.width, intersection.height);
        aGraphics.setColor(_SelectionBackgroundColor);
        intersection = fore.intersection(border);
        aGraphics.fillRect(intersection.x, intersection.y, intersection.width, intersection.height);
    }

    public Rectangle gaugeBorder() {
        Rectangle border = new Rectangle(0, 0, ((Component)((Object)this)).getBounds().width, ((Component)((Object)this)).getBounds().height);
        Rectangle margin = this.defaultMargin();
        Rectangle box = new Rectangle(border.x + margin.x, border.y + margin.y, border.width - margin.x - margin.width, border.height - margin.y - margin.height);
        int x = box.x + this.gaugeScalesExtent().x + 13;
        return new Rectangle(x, box.y, box.width - this.gaugeScalesExtent().x - 13, box.height);
    }

    public Vector gaugeScales() {
        return (Vector)this.scalesLayout().firstElement();
    }

    public Point gaugeScalesExtent() {
        return (Point)this.scalesLayout().lastElement();
    }

    public IsrGaugeModel getModel() {
        return (IsrGaugeModel)this.model();
    }

    public double getValue() {
        return (Double)this.model().perform_(this.getSelector.toString());
    }

    public static IsrGaugeViewAwt On_get_put_valuesMinMaxDivideRound_(IsrGaugeModel aModel, StSymbol getSymbol, StSymbol putSymbol, double[] anArray) {
        IsrGaugeViewAwt view = new IsrGaugeViewAwt();
        view.on_get_put_valuesMinMaxDivideRound_(aModel, getSymbol, putSymbol, anArray);
        return view;
    }

    public void on_get_put_valuesMinMaxDivideRound_(IsrGaugeModel aModel, StSymbol getSymbol, StSymbol putSymbol, double[] anArray) {
        double min = anArray[0];
        double max = anArray[1];
        double div = anArray[2];
        double rnd = anArray[3];
        this.model_((StModel)aModel);
        this.getSelector = getSymbol;
        this.putSelector = putSymbol;
        this.minValue = Math.min(min, max);
        this.maxValue = Math.max(max, min);
        this.divideValue = Math.max((int)Math.rint(div), 1);
        this.roundValue = Math.min(max - min, Math.max(rnd, 0.0));
        this.scalesLayout();
    }

    public void putValue_(double aNumber) {
        if (this.roundValue == 0.0) {
            this.getModel().value_(aNumber);
        } else {
            this.getModel().value_(Math.rint(aNumber / this.roundValue) * this.roundValue);
        }
    }

    private Vector scalesLayout() {
        if (this.scalesLayout == null) {
            Point point;
            Vector<StAssociation> labels = new Vector<StAssociation>();
            labels.addElement(new StAssociation((Object)new Double(this.minValue), (Object)new Double(0.0)));
            Font font = SystemResourceSupport.getFont();
            Point extent = SystemResourceSupport._getStringExtentFor_((String)Double.toString(this.minValue), (Font)font);
            int i = 1;
            while (i <= this.divideValue - 1) {
                double value = (this.maxValue - this.minValue) * (double)i / (double)this.divideValue;
                double location = 1.0 * (double)i / (double)this.divideValue;
                labels.addElement(new StAssociation((Object)new Double(value), (Object)new Double(location)));
                point = SystemResourceSupport._getStringExtentFor_((String)Double.toString(value), (Font)font);
                extent = new Point(Math.max(extent.x, point.x), Math.max(extent.y, point.y));
                ++i;
            }
            labels.addElement(new StAssociation((Object)new Double(this.maxValue), (Object)new Double(1.0)));
            point = SystemResourceSupport._getStringExtentFor_((String)Double.toString(this.maxValue), (Font)font);
            extent = new Point(Math.max(extent.x, point.x), Math.max(extent.y, point.y));
            this.scalesLayout = new Vector(2);
            this.scalesLayout.addElement(labels);
            this.scalesLayout.addElement(extent);
        }
        return this.scalesLayout;
    }

    public void setModel(IsrGaugeModel aModel) {
        this.model_((StModel)aModel);
    }

    public void setValue_(Point cursorPoint) {
        Rectangle box = this.gaugeBorder();
        Isr2dPoint point = new Isr2dPoint((double)(cursorPoint.x - box.x) / (double)box.width, (double)(cursorPoint.y - box.y) / (double)box.height);
        double value = 1.0 - point.y();
        value = value * (this.maxValue - this.minValue) + this.minValue;
        this.putValue_(value);
    }

    public void update_(DependentEvent evt) {
        block3: {
            if (!((Component)((Object)this)).isShowing()) {
                return;
            }
            if (evt.getAspect() != this.getSelector) break block3;
            Graphics gc = ((Component)((Object)this)).getGraphics();
            try {
                this.displayValueOn_(gc);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                gc.dispose();
                throw throwable;
            }
            Object var3_5 = null;
            gc.dispose();
        }
    }
}

