/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.freehand;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import sra.isr.interfaces.freehand.IsrFreehandModel;
import sra.isr.interfaces.freehand.IsrFreehandView;
import sra.smalltalk.StController;
import sra.smalltalk.StView;

public class IsrFreehandController
extends StController
implements MouseListener,
MouseMotionListener {
    protected Point previousPoint = new Point(0, 0);
    protected Point currentPoint = new Point(0, 0);

    protected void buildListener(StView newView) {
        Component aView = (Component)newView;
        aView.addMouseListener(this);
        aView.addMouseMotionListener(this);
    }

    protected final IsrFreehandModel getModel() {
        return (IsrFreehandModel)this.model();
    }

    protected IsrFreehandView getView() {
        return (IsrFreehandView)this.view();
    }

    public void mouseDragged(MouseEvent event) {
        if (this.isMenuButtonPressed_(event)) {
            return;
        }
        IsrFreehandView view = this.getView();
        IsrFreehandModel model = this.getModel();
        Rectangle box = view.plateArea();
        this.currentPoint = event.getPoint();
        this.currentPoint.translate(0 - box.x, 0 - box.y);
        Graphics gc = model.currentPixmap().getGraphics();
        model.gstate_(gc);
        int lineWidth = model.lineWidth();
        if (this.previousPoint != null) {
            int width = -(lineWidth / 2);
            while (width < -(lineWidth / 2) + lineWidth) {
                gc.drawLine(this.previousPoint.x + width, this.previousPoint.y, this.currentPoint.x + width, this.currentPoint.y);
                gc.drawLine(this.previousPoint.x, this.previousPoint.y + width, this.currentPoint.x, this.currentPoint.y + width);
                ++width;
            }
        }
        if (box.contains(event.getPoint())) {
            gc.fillOval(this.currentPoint.x - lineWidth / 2, this.currentPoint.y - lineWidth / 2, lineWidth, lineWidth);
        }
        model.setImage(model.currentPixmap());
        this.previousPoint = this.currentPoint;
        gc.dispose();
    }

    public void mouseMoved(MouseEvent event) {
        IsrFreehandView view = this.getView();
        if (view.plateArea().contains(event.getPoint())) {
            ((Component)((Object)view)).setCursor(this.getModel().cursor());
        } else {
            ((Component)((Object)view)).setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mousePressed(MouseEvent event) {
        if (this.isMenuButtonPressed_(event)) {
            return;
        }
        IsrFreehandView view = this.getView();
        IsrFreehandModel model = this.getModel();
        Rectangle box = view.plateArea();
        if (box.contains(event.getPoint())) {
            this.currentPoint = event.getPoint();
            this.currentPoint.translate(0 - box.x, 0 - box.y);
            Graphics gc = model.currentPixmap().getGraphics();
            model.gstate_(gc);
            int lineWidth = model.lineWidth();
            gc.fillOval(this.currentPoint.x - lineWidth / 2, this.currentPoint.y - lineWidth / 2, lineWidth, lineWidth);
            this.previousPoint = this.currentPoint;
            model.setImage(model.currentPixmap());
            gc.dispose();
        } else {
            this.previousPoint = null;
        }
    }
}

