/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JComponent;
import sra.isr.interfaces.display.IsrDisplayModel;
import sra.isr.interfaces.display.IsrDisplayView;
import sra.smalltalk.DependentEvent;
import sra.smalltalk.StModel;
import sra.smalltalk.StViewJPanel;
import sra.smalltalk.SystemResourceSupport;

public class IsrDisplayViewSwing
extends StViewJPanel
implements IsrDisplayView {
    protected boolean resizable;

    protected Dimension _getPreferredSizeOf(Object anObject) {
        if (anObject instanceof Image) {
            Image anImage = (Image)anObject;
            return new Dimension(anImage.getWidth(null), anImage.getHeight(null));
        }
        String aString = anObject instanceof String ? (String)anObject : anObject.toString();
        Point extent = SystemResourceSupport._getStringExtentFor_((String)aString, null);
        return new Dimension(extent.x, extent.y);
    }

    public void adjustSize() {
        Dimension size = this._getPreferredSizeOf(this.getModel().visual());
        ((JComponent)((Object)this)).setPreferredSize(size);
        ((Component)((Object)this)).setSize(size);
    }

    protected StModel defaultModel() {
        return new IsrDisplayModel();
    }

    public void displayOn_(Graphics aGraphics) {
        Object displayObject = this.getModel().visual();
        if (displayObject instanceof Image) {
            Image anImage = (Image)displayObject;
            if (this.isResizable()) {
                aGraphics.drawImage(anImage, 0, 0, ((Component)((Object)this)).getSize().width, ((Component)((Object)this)).getSize().height, null);
            } else {
                int x = (((Component)((Object)this)).getSize().width - anImage.getWidth(null)) / 2;
                int y = (((Component)((Object)this)).getSize().height - anImage.getHeight(null)) / 2;
                aGraphics.drawImage(anImage, x, y, null);
            }
        } else {
            String aString = displayObject instanceof String ? (String)displayObject : displayObject.toString();
            FontMetrics fontMetrics = aGraphics.getFontMetrics();
            int x = (((Component)((Object)this)).getSize().width - fontMetrics.stringWidth(aString)) / 2;
            int y = (((Component)((Object)this)).getSize().height + fontMetrics.getAscent()) / 2;
            aGraphics.setColor(Color.black);
            aGraphics.drawString(aString, x, y);
        }
    }

    public IsrDisplayModel getModel() {
        return (IsrDisplayModel)this.model();
    }

    public Object getVisual() {
        return this.getModel().visual();
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setModel(IsrDisplayModel aModel) {
        this.model_((StModel)aModel);
    }

    public void setResizable(boolean newValue) {
        boolean oldValue = this.resizable;
        this.resizable = newValue;
        ((Component)((Object)this)).repaint();
        ((Component)((Object)this)).firePropertyChange("resizable", new Boolean(oldValue), new Boolean(newValue));
    }

    public void setVisual(Object anObject) {
        this.getModel().visual_(anObject);
    }

    public void update_(DependentEvent evt) {
        if (evt.getAspect() == StViewJPanel.$((String)"visual")) {
            ((Component)((Object)this)).repaint();
            ((Component)((Object)this)).firePropertyChange("visual", null, this.getVisual());
        } else {
            super.update_(evt);
        }
    }
}

