/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.colors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import sra.isr.interfaces.colors.IsrColorChoiceController;
import sra.isr.interfaces.colors.IsrColorChoiceHSB;
import sra.isr.interfaces.colors.IsrColorChoiceModel;
import sra.isr.interfaces.colors.IsrColorChoiceView;
import sra.smalltalk.DependentEvent;
import sra.smalltalk.StModel;
import sra.smalltalk.StViewJPanel;

public class IsrColorChoiceViewSwing
extends StViewJPanel
implements IsrColorChoiceView {
    protected IsrColorChoiceController controller;
    protected static final Color _VeryLightGrayColor = new Color(212, 212, 212);

    public Rectangle barArea() {
        int originX = this.plateArea().x + this.plateArea().width + 16;
        int originY = this.plateArea().y;
        IsrColorChoiceModel cfr_ignored_0 = (IsrColorChoiceModel)this.model();
        Rectangle area = IsrColorChoiceModel._barArea();
        Rectangle box = new Rectangle(originX, originY, area.width, area.height);
        return box;
    }

    private double brightness() {
        int roundedValue = (int)(((IsrColorChoiceModel)this.model()).brightness() / this.round());
        return (double)roundedValue * this.round();
    }

    public Rectangle brightnessArea() {
        int originX = this.saturationArea().x;
        int originY = this.saturationArea().y + this.saturationArea().height + 3;
        Rectangle box = new Rectangle(originX, originY, 56, 18);
        return box;
    }

    public String brightnessString() {
        double value = this.brightness();
        String string = "" + value;
        if (string.length() < 4) {
            int i = string.length();
            while (i < 4) {
                string = string.concat("0");
                ++i;
            }
            return string;
        }
        return string.substring(0, 4);
    }

    protected void buildComponent() {
        ((JComponent)((Object)this)).setPreferredSize(new Dimension(230, 125));
        this.controller = this.defaultController();
        this.controller.view_(this);
    }

    private Rectangle colorArea() {
        int originX = this.barArea().x + this.barArea().width + 16;
        int originY = this.barArea().y;
        Rectangle box = new Rectangle(originX, originY, 56, 30);
        return box;
    }

    protected IsrColorChoiceController defaultController() {
        return new IsrColorChoiceController();
    }

    protected StModel defaultModel() {
        return new IsrColorChoiceHSB();
    }

    private void displayBarOn_(Graphics aGraphics) {
        Graphics graphics = aGraphics.create();
        Rectangle box = this.barArea();
        this.getModel().bar().displayOn_at_(graphics, box.getLocation());
        graphics.setColor(Color.black);
        graphics.drawRect(box.x, box.y, box.width, box.height);
    }

    private void displayBrightnessOn_(Graphics aGraphics) {
        Graphics graphics = aGraphics.create();
        Rectangle box = this.brightnessArea();
        String text = "B:".concat(this.brightnessString());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int width = fontMetrics.stringWidth(text);
        int height = fontMetrics.getHeight();
        Point stringOrigin = new Point((box.width - width) / 2 + box.x, box.height - height / 2 + box.y);
        graphics.clipRect(box.x, box.y, box.width + 1, box.height + 1);
        graphics.setColor(_VeryLightGrayColor);
        graphics.fillRect(box.x, box.y, box.width, box.height);
        graphics.setColor(Color.black);
        graphics.drawString(text, stringOrigin.x, stringOrigin.y);
        graphics.drawRect(box.x, box.y, box.width, box.height);
    }

    private void displayColorOn_(Graphics aGraphics) {
        Graphics graphics = aGraphics.create();
        Rectangle box = this.colorArea();
        graphics.setColor(this.getModel().color());
        graphics.fillRect(box.x, box.y, box.width, box.height);
        graphics.setColor(Color.black);
        graphics.drawRect(box.x, box.y, box.width, box.height);
    }

    private void displayHueOn_(Graphics aGraphics) {
        Graphics graphics = aGraphics.create();
        Rectangle box = this.hueArea();
        String text = "H:".concat(this.hueString());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int width = fontMetrics.stringWidth(text);
        int height = fontMetrics.getHeight();
        Point stringOrigin = new Point((box.width - width) / 2 + box.x, box.height - height / 2 + box.y);
        graphics.clipRect(box.x, box.y, box.width + 1, box.height + 1);
        graphics.setColor(_VeryLightGrayColor);
        graphics.fillRect(box.x, box.y, box.width, box.height);
        graphics.setColor(Color.black);
        graphics.drawString(text, stringOrigin.x, stringOrigin.y);
        graphics.drawRect(box.x, box.y, box.width, box.height);
    }

    public void displayOn_(Graphics aGraphics) {
        if (!((Component)((Object)this)).isShowing()) {
            return;
        }
        this.displayPlateOn_(aGraphics);
        this.displayXYOn_(aGraphics);
        this.displayBarOn_(aGraphics);
        this.displayZOn_(aGraphics);
        this.displayColorOn_(aGraphics);
        this.displayHueOn_(aGraphics);
        this.displaySaturationOn_(aGraphics);
        this.displayBrightnessOn_(aGraphics);
    }

    private void displayPlateOn_(Graphics aGraphics) {
        Graphics graphics = aGraphics.create();
        Rectangle box = this.plateArea();
        this.getModel().plate().displayOn_at_(graphics, box.getLocation());
        graphics.setColor(Color.black);
        graphics.drawRect(box.x, box.y, box.width, box.height);
    }

    private void displaySaturationOn_(Graphics aGraphics) {
        Graphics graphics = aGraphics.create();
        Rectangle box = this.saturationArea();
        String text = "S:".concat(this.saturationString());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int width = fontMetrics.stringWidth(text);
        int height = fontMetrics.getHeight();
        Point stringOrigin = new Point((box.width - width) / 2 + box.x, box.height - height / 2 + box.y);
        graphics.clipRect(box.x, box.y, box.width + 1, box.height + 1);
        graphics.setColor(_VeryLightGrayColor);
        graphics.fillRect(box.x, box.y, box.width, box.height);
        graphics.setColor(Color.black);
        graphics.drawString(text, stringOrigin.x, stringOrigin.y);
        graphics.drawRect(box.x, box.y, box.width, box.height);
    }

    private void displayXYOn_(Graphics aGraphics) {
        Graphics graphics = aGraphics.create();
        Rectangle box = this.plateArea();
        graphics.clipRect(box.x, box.y, box.width, box.height);
        int x = (int)(this.getModel().xy().x() * (double)(box.width - 1) + (double)box.x);
        int y = (int)(this.getModel().xy().y() * (double)(box.height - 1) + (double)box.y);
        Color white = Color.white;
        Color black = Color.black;
        graphics.setColor(white);
        int angle = 0;
        while (angle < 360) {
            graphics.drawArc(x - 4, y - 4, 8, 8, angle, 15);
            if (black.equals(graphics.getColor())) {
                graphics.setColor(white);
            } else {
                graphics.setColor(black);
            }
            angle += 15;
        }
    }

    private void displayZOn_(Graphics aGraphics) {
        Graphics graphics = aGraphics.create();
        Rectangle box = this.barArea();
        Rectangle boxL = new Rectangle(box.x - 4, box.y - 3, 4, box.height + 7);
        Rectangle boxR = new Rectangle(box.x + box.width + 1, box.y - 3, 4, box.height + 7);
        graphics.setColor(((Component)((Object)this)).getBackground());
        graphics.fillRect(boxL.x, boxL.y, boxL.width, boxL.height);
        graphics.fillRect(boxR.x, boxR.y, boxR.width, boxR.height);
        Point[] points = new Point[]{new Point(0, 0), new Point(3, -3), new Point(3, 3), new Point(0, 0)};
        int height = (int)(this.getModel().z() * (double)(box.height - 1));
        Point offsetR = new Point(box.x + box.width + 1, height + box.y);
        Point offsetL = new Point(box.x - 1, height + box.y);
        int[] xLs = new int[4];
        int[] yLs = new int[4];
        int[] xRs = new int[4];
        int[] yRs = new int[4];
        int i = 0;
        while (i < 4) {
            xRs[i] = offsetR.x + points[i].x;
            yRs[i] = offsetR.y + points[i].y;
            xLs[i] = offsetL.x - points[i].x;
            yLs[i] = offsetL.y + points[i].y;
            ++i;
        }
        graphics.setColor(Color.black);
        graphics.drawPolyline(xRs, yRs, 4);
        graphics.drawPolyline(xLs, yLs, 4);
    }

    public IsrColorChoiceModel getModel() {
        return (IsrColorChoiceModel)this.model();
    }

    private double hue() {
        int roundedValue = (int)(((IsrColorChoiceModel)this.model()).hue() / this.round());
        return (double)roundedValue * this.round();
    }

    public Rectangle hueArea() {
        int originX = this.colorArea().x;
        int originY = this.colorArea().y + this.colorArea().height + 10;
        Rectangle box = new Rectangle(originX, originY, 56, 18);
        return box;
    }

    public String hueString() {
        double value = this.hue();
        String string = "" + value;
        if (string.length() < 4) {
            int i = string.length();
            while (i < 4) {
                string = string.concat("0");
                ++i;
            }
            return string;
        }
        return string.substring(0, 4);
    }

    public Rectangle plateArea() {
        IsrColorChoiceModel cfr_ignored_0 = (IsrColorChoiceModel)this.model();
        Rectangle area = IsrColorChoiceModel._plateArea();
        Rectangle box = new Rectangle(10, 10, area.width, area.height);
        return box;
    }

    private double round() {
        return 0.01;
    }

    private double saturation() {
        int roundedValue = (int)(((IsrColorChoiceModel)this.model()).saturation() / this.round());
        return (double)roundedValue * this.round();
    }

    public Rectangle saturationArea() {
        int originX = this.hueArea().x;
        int originY = this.hueArea().y + this.hueArea().height + 3;
        Rectangle box = new Rectangle(originX, originY, 56, 18);
        return box;
    }

    public String saturationString() {
        double value = this.saturation();
        String string = "" + value;
        if (string.length() < 4) {
            int i = string.length();
            while (i < 4) {
                string = string.concat("0");
                ++i;
            }
            return string;
        }
        return string.substring(0, 4);
    }

    public void setModel(IsrColorChoiceModel aModel) {
        this.model_((StModel)aModel);
    }

    public void update_(DependentEvent evt) {
        Graphics gc;
        if (!((Component)((Object)this)).isShowing()) {
            return;
        }
        if (evt.getAspect() == StViewJPanel.$((String)"xy")) {
            gc = ((JComponent)((Object)this)).getGraphics();
            this.displayPlateOn_(gc);
            this.displayXYOn_(gc);
            this.displayBarOn_(gc);
            this.displayColorOn_(gc);
            this.displayHueOn_(gc);
            this.displaySaturationOn_(gc);
            this.displayBrightnessOn_(gc);
            gc.dispose();
        }
        if (evt.getAspect() == StViewJPanel.$((String)"z")) {
            gc = ((JComponent)((Object)this)).getGraphics();
            this.displayPlateOn_(gc);
            this.displayXYOn_(gc);
            this.displayBarOn_(gc);
            this.displayZOn_(gc);
            this.displayColorOn_(gc);
            this.displayHueOn_(gc);
            this.displaySaturationOn_(gc);
            this.displayBrightnessOn_(gc);
            gc.dispose();
        }
        if (evt.getAspect() == StViewJPanel.$((String)"color")) {
            gc = ((JComponent)((Object)this)).getGraphics();
            this.displayOn_(gc);
            gc.dispose();
        }
    }
}

