/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.colors;

import java.awt.Color;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.interfaces.colors.IsrColorChoiceModel;
import sra.smalltalk.StColorValue;
import sra.smalltalk.StImage;
import sra.smalltalk.StObject;

public class IsrColorChoiceSBH
extends IsrColorChoiceModel {
    private static StImage[] plates = IsrColorChoiceSBH._InitializePlates();
    private static StImage[] bars = IsrColorChoiceSBH._InitializeBars();

    static StImage[] _InitializeBars() {
        int gap = IsrColorChoiceModel._Gap();
        int interval = IsrColorChoiceModel._Intervals();
        int ySize = interval / gap;
        int zSize = interval / gap;
        int width = IsrColorChoiceModel._barArea().width;
        StImage[] images = new StImage[zSize];
        int z = 0;
        while (z < zSize) {
            int[] pixels = new int[interval * width];
            int y = 0;
            while (y < ySize) {
                double hue = (double)y * 1.0 / (double)ySize;
                double saturation = 1.0;
                double brightness = 1.0;
                Color color = Color.getHSBColor((float)hue, (float)saturation, (float)brightness);
                int dy = 0;
                while (dy < gap) {
                    int dx = 0;
                    while (dx < width) {
                        pixels[(y * gap + dy) * width + dx] = color.getRGB();
                        ++dx;
                    }
                    ++dy;
                }
                ++y;
            }
            images[z] = new StImage(width, interval, pixels);
            ++z;
        }
        return images;
    }

    static StImage[] _InitializePlates() {
        int gap = IsrColorChoiceModel._Gap();
        int interval = IsrColorChoiceModel._Intervals();
        int size = interval / gap;
        StImage[] images = new StImage[size];
        int z = 0;
        while (z < size) {
            int[] pixels = new int[interval * interval];
            int y = 0;
            while (y < size) {
                int x = 0;
                while (x < size) {
                    double hue = (double)z * 1.0 / (double)size;
                    double saturation = (double)x * 1.0 / (double)size;
                    double brightness = 1.0 - (double)y * 1.0 / (double)size;
                    Color color = Color.getHSBColor((float)hue, (float)saturation, (float)brightness);
                    int dy = 0;
                    while (dy < gap) {
                        int dx = 0;
                        while (dx < gap) {
                            pixels[(y * gap + dy) * interval + x * gap + dx] = color.getRGB();
                            ++dx;
                        }
                        ++dy;
                    }
                    ++x;
                }
                ++y;
            }
            images[z] = new StImage(interval, interval, pixels);
            ++z;
        }
        return images;
    }

    public StImage[] bars() {
        StImage[] images = bars;
        return images;
    }

    public double brightness() {
        double value = 1.0 - this.xy().y();
        return value;
    }

    public void brightness_(double value) {
        this.xy_(new Isr2dPoint(this.xy().x(), 1.0 - value));
    }

    public void color_(Color color) {
        this.z_(StColorValue._GetHue((Color)color));
        this.xy_(new Isr2dPoint(StColorValue._GetSaturation((Color)color), 1.0f - StColorValue._GetBrightness((Color)color)));
        this.changed_(StObject.$((String)"color"));
    }

    public double hue() {
        double value = this.z();
        return value;
    }

    public void hue_(double value) {
        this.z_(value);
    }

    public StImage[] plates() {
        StImage[] images = plates;
        return images;
    }

    public static Color Request() {
        return IsrColorChoiceSBH.Request_(Color.white);
    }

    public static Color Request_(Color colorValue) {
        return IsrColorChoiceModel._Request_(colorValue, new IsrColorChoiceSBH());
    }

    public double saturation() {
        double value = this.xy().x();
        return value;
    }

    public void saturation_(double value) {
        this.xy_(new Isr2dPoint(value, this.xy().y()));
    }
}

