/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.colors;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.interfaces.colors.IsrColorChoiceModel;
import sra.isr.interfaces.colors.IsrColorChoiceView;
import sra.smalltalk.StController;
import sra.smalltalk.StDialog;
import sra.smalltalk.StView;

public class IsrColorChoiceController
extends StController
implements MouseListener,
MouseMotionListener {
    protected void buildListener(StView newView) {
        Component aView = (Component)newView;
        aView.addMouseListener(this);
        aView.addMouseMotionListener(this);
    }

    public void mouseDragged(MouseEvent event) {
        Point point = event.getPoint();
        IsrColorChoiceView view = (IsrColorChoiceView)this.view();
        if (view.plateArea().contains(point) || view.barArea().contains(point)) {
            this.mousePressed(event);
        }
    }

    public void mouseMoved(MouseEvent event) {
        Point point = event.getPoint();
        IsrColorChoiceView view = (IsrColorChoiceView)this.view();
        if (view.plateArea().contains(point) || view.barArea().contains(point) || view.hueArea().contains(point) || view.saturationArea().contains(point) || view.brightnessArea().contains(point)) {
            ((Component)((Object)view)).setCursor(Cursor.getPredefinedCursor(1));
        } else {
            ((Component)((Object)view)).setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mousePressed(MouseEvent event) {
        double resultValue;
        String result;
        if (this.isMenuButtonPressed_(event)) {
            return;
        }
        Point point = event.getPoint();
        IsrColorChoiceView view = (IsrColorChoiceView)this.view();
        Point globalOrigin = event.getComponent().getParent().getLocation();
        if (view.plateArea().contains(point)) {
            double x = (double)(point.x - view.plateArea().getLocation().x) / ((double)view.plateArea().width - 1.0);
            double y = (double)(point.y - view.plateArea().getLocation().y) / ((double)view.plateArea().height - 1.0);
            Isr2dPoint jPoint = new Isr2dPoint(x, y);
            ((IsrColorChoiceModel)this.model()).xy_(jPoint);
        }
        if (view.barArea().contains(point)) {
            double z = (double)(point.y - view.barArea().getLocation().y) / ((double)view.barArea().height - 1.0);
            ((IsrColorChoiceModel)this.model()).z_(z);
        }
        if (view.hueArea().contains(point) && (result = StDialog.Request_((String)"hue?", (String)view.hueString(), (Point)new Point(globalOrigin.x + point.x, globalOrigin.y + point.y))) != null && (resultValue = new Double(result).doubleValue()) >= 0.0 && resultValue <= 1.0) {
            ((IsrColorChoiceModel)this.model()).hue_(resultValue);
        }
        if (view.saturationArea().contains(point) && (result = StDialog.Request_((String)"saturation?", (String)view.saturationString(), (Point)new Point(globalOrigin.x + point.x, globalOrigin.y + point.y))) != null && (resultValue = new Double(result).doubleValue()) >= 0.0 && resultValue <= 1.0) {
            ((IsrColorChoiceModel)this.model()).saturation_(resultValue);
        }
        if (view.brightnessArea().contains(point) && (result = StDialog.Request_((String)"brightness?", (String)view.brightnessString(), (Point)new Point(globalOrigin.x + point.x, globalOrigin.y + point.y))) != null && (resultValue = new Double(result).doubleValue()) >= 0.0 && resultValue <= 1.0) {
            ((IsrColorChoiceModel)this.model()).brightness_(resultValue);
        }
    }
}

