/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import sra.isr.interfaces.button.IsrButtonModel;
import sra.isr.interfaces.button.IsrButtonView;
import sra.smalltalk.StBlockClosure;
import sra.smalltalk.StController;
import sra.smalltalk.StView;

public class IsrButtonController
extends StController
implements MouseListener,
Runnable {
    protected transient boolean mousePress;
    protected transient boolean mouseEnter;
    protected transient Thread repeatThread;

    protected void buildListener(StView newView) {
        Component aView = (Component)newView;
        aView.addMouseListener(this);
    }

    protected IsrButtonModel getModel() {
        return (IsrButtonModel)this.model();
    }

    protected IsrButtonView getView() {
        return (IsrButtonView)this.view();
    }

    public void mouseEntered(MouseEvent e) {
        IsrButtonView view = this.getView();
        this.mouseEnter = true;
        if (this.mousePress) {
            Graphics gc = ((Component)((Object)view)).getGraphics();
            view.displayTrueOn_(gc);
            gc.setColor(Color.black);
            Dimension size = ((Component)((Object)view)).getSize();
            gc.drawRect(0, 0, size.width - 1, size.height - 1);
            gc.dispose();
        }
    }

    public void mouseExited(MouseEvent e) {
        IsrButtonView view = this.getView();
        this.mouseEnter = false;
        if (this.mousePress) {
            Graphics gc = ((Component)((Object)view)).getGraphics();
            if (this.getModel().value()) {
                view.displayTrueOn_(gc);
            } else {
                view.displayFalseOn_(gc);
            }
            gc.dispose();
        }
    }

    public void mousePressed(MouseEvent e) {
        IsrButtonView view = this.getView();
        this.mousePress = true;
        this.mouseEnter = true;
        Graphics gc = ((Component)((Object)view)).getGraphics();
        view.displayTrueOn_(gc);
        gc.setColor(Color.black);
        Dimension size = ((Component)((Object)view)).getSize();
        gc.drawRect(0, 0, size.width - 1, size.height - 1);
        gc.dispose();
        if (this.getModel().repeatAction()) {
            this.repeatThread = new Thread(this);
            this.repeatThread.start();
        }
    }

    public void mouseReleased(MouseEvent e) {
        IsrButtonView view = this.getView();
        IsrButtonModel model = this.getModel();
        if (this.mousePress) {
            Graphics gc = ((Component)((Object)view)).getGraphics();
            if (model.value()) {
                view.displayTrueOn_(gc);
            } else {
                view.displayFalseOn_(gc);
            }
            gc.dispose();
            this.mousePress = false;
        }
        if (this.repeatThread != null) {
            this.repeatThread = null;
        }
        if (this.mouseEnter) {
            StBlockClosure action = model.action();
            if (action != null) {
                switch (action.numArgs()) {
                    case 0: {
                        action.value();
                        break;
                    }
                    case 1: {
                        action.value_((Object)model);
                        break;
                    }
                    case 2: {
                        action.value_value_((Object)model, (Object)e);
                    }
                }
            }
            this.mouseEnter = false;
        }
    }

    public void run() {
        IsrButtonModel model = this.getModel();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        StBlockClosure action = model.action();
        while (this.mousePress) {
            switch (action.numArgs()) {
                case 0: {
                    action.value();
                    break;
                }
                case 1: {
                    action.value_((Object)model);
                    break;
                }
                case 2: {
                    action.value_value_((Object)model, null);
                }
            }
            Thread.yield();
        }
    }
}

