/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.interfaces.area;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.interfaces.area.IsrAreaModel;
import sra.isr.interfaces.area.IsrAreaView;
import sra.smalltalk.StController;
import sra.smalltalk.StView;

public class IsrAreaController
extends StController
implements MouseListener,
MouseMotionListener {
    protected void buildListener(StView newView) {
        Component aView = (Component)newView;
        aView.addMouseListener(this);
        aView.addMouseMotionListener(this);
    }

    protected IsrAreaModel getModel() {
        return (IsrAreaModel)this.model();
    }

    protected IsrAreaView getView() {
        return (IsrAreaView)this.view();
    }

    public void mouseDragged(MouseEvent event) {
        if (this.isMenuButtonPressed_(event)) {
            return;
        }
        IsrAreaView view = this.getView();
        if (view.plateArea().contains(event.getPoint())) {
            this.mousePressed(event);
        }
    }

    public void mouseMoved(MouseEvent event) {
        IsrAreaView view = this.getView();
        if (view.plateArea().contains(event.getPoint())) {
            ((Component)((Object)view)).setCursor(Cursor.getPredefinedCursor(1));
        } else {
            ((Component)((Object)view)).setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mousePressed(MouseEvent event) {
        if (this.isMenuButtonPressed_(event)) {
            return;
        }
        Point point = event.getPoint();
        IsrAreaView view = this.getView();
        if (view.plateArea().contains(point)) {
            double x = (double)(point.x - view.plateArea().getLocation().x) / ((double)view.plateArea().width - 1.0);
            double y = (double)(point.y - view.plateArea().getLocation().y) / ((double)view.plateArea().height - 1.0);
            Isr2dPoint pointXy = new Isr2dPoint(x, y);
            ((IsrAreaModel)this.model()).xy_(pointXy);
        }
    }
}

