/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.image.support;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.image.support.IsrImageProcessor;
import sra.isr.interfaces.colors.IsrColorChoiceHBS;
import sra.isr.interfaces.colors.IsrColorChoiceSBH;
import sra.isr.interfaces.cursors.IsrCursors;
import sra.isr.system.support.IsrSystem;
import sra.isr.system.support.IsrTestExamples;
import sra.smalltalk.StAssociation;
import sra.smalltalk.StByteArray;
import sra.smalltalk.StImage;
import sra.smalltalk.SystemResourceSupport;

public class IsrImageProcessorTestExamples
extends IsrTestExamples {
    protected static Image _ImageSmalltalkBalloon() {
        int width = 128;
        int height = 128;
        int[] pixels = IsrImageProcessorTestExamples._ImageSmalltalkBaloon_bits();
        MemoryImageSource source = new MemoryImageSource(width, height, IsrImageProcessorTestExamples._ImageSmalltalkBaloon_colorModel(), pixels, 0, width);
        return new StImage(Toolkit.getDefaultToolkit().createImage(source)).image();
    }

    protected static int[] _ImageSmalltalkBaloon_bits() {
        String packedString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a";
        return StByteArray.FromPackedString_((String)packedString)._asInts();
    }

    protected static ColorModel _ImageSmalltalkBaloon_colorModel() {
        Color[] colors = new Color[]{new Color(255, 255, 255), new Color(255, 255, 204), new Color(255, 255, 153), new Color(255, 255, 102), new Color(255, 255, 51), new Color(255, 255, 0), new Color(255, 204, 255), new Color(255, 204, 204), new Color(255, 204, 153), new Color(255, 204, 102), new Color(255, 204, 51), new Color(255, 204, 0), new Color(255, 153, 255), new Color(255, 153, 204), new Color(255, 153, 153), new Color(255, 153, 102), new Color(255, 153, 51), new Color(255, 153, 0), new Color(255, 102, 255), new Color(255, 102, 204), new Color(255, 102, 153), new Color(255, 102, 102), new Color(255, 102, 51), new Color(255, 102, 0), new Color(255, 51, 255), new Color(255, 51, 204), new Color(255, 51, 153), new Color(255, 51, 102), new Color(255, 51, 51), new Color(255, 51, 0), new Color(255, 0, 255), new Color(255, 0, 204), new Color(255, 0, 153), new Color(255, 0, 102), new Color(255, 0, 51), new Color(255, 0, 0), new Color(204, 255, 255), new Color(204, 255, 204), new Color(204, 255, 153), new Color(204, 255, 102), new Color(204, 255, 51), new Color(204, 255, 0), new Color(204, 204, 255), new Color(204, 204, 204), new Color(204, 204, 153), new Color(204, 204, 102), new Color(204, 204, 51), new Color(204, 204, 0), new Color(204, 153, 255), new Color(204, 153, 204), new Color(204, 153, 153), new Color(204, 153, 102), new Color(204, 153, 51), new Color(204, 153, 0), new Color(204, 102, 255), new Color(204, 102, 204), new Color(204, 102, 153), new Color(204, 102, 102), new Color(204, 102, 51), new Color(204, 102, 0), new Color(204, 51, 255), new Color(204, 51, 204), new Color(204, 51, 153), new Color(204, 51, 102), new Color(204, 51, 51), new Color(204, 51, 0), new Color(204, 0, 255), new Color(204, 0, 204), new Color(204, 0, 153), new Color(204, 0, 102), new Color(204, 0, 51), new Color(204, 0, 0), new Color(153, 255, 255), new Color(153, 255, 204), new Color(153, 255, 153), new Color(153, 255, 102), new Color(153, 255, 51), new Color(153, 255, 0), new Color(153, 204, 255), new Color(153, 204, 204), new Color(153, 204, 153), new Color(153, 204, 102), new Color(153, 204, 51), new Color(153, 204, 0), new Color(153, 153, 255), new Color(153, 153, 204), new Color(153, 153, 153), new Color(153, 153, 102), new Color(153, 153, 51), new Color(153, 153, 0), new Color(153, 102, 255), new Color(153, 102, 204), new Color(153, 102, 153), new Color(153, 102, 102), new Color(153, 102, 51), new Color(153, 102, 0), new Color(153, 51, 255), new Color(153, 51, 204), new Color(153, 51, 153), new Color(153, 51, 102), new Color(153, 51, 51), new Color(153, 51, 0), new Color(153, 0, 255), new Color(153, 0, 204), new Color(153, 0, 153), new Color(153, 0, 102), new Color(153, 0, 51), new Color(153, 0, 0), new Color(102, 255, 255), new Color(102, 255, 204), new Color(102, 255, 153), new Color(102, 255, 102), new Color(102, 255, 51), new Color(102, 255, 0), new Color(102, 204, 255), new Color(102, 204, 204), new Color(102, 204, 153), new Color(102, 204, 102), new Color(102, 204, 51), new Color(102, 204, 0), new Color(102, 153, 255), new Color(102, 153, 204), new Color(102, 153, 153), new Color(102, 153, 102), new Color(102, 153, 51), new Color(102, 153, 0), new Color(102, 102, 255), new Color(102, 102, 204), new Color(102, 102, 153), new Color(102, 102, 102), new Color(102, 102, 51), new Color(102, 102, 0), new Color(102, 51, 255), new Color(102, 51, 204), new Color(102, 51, 153), new Color(102, 51, 102), new Color(102, 51, 51), new Color(102, 51, 0), new Color(102, 0, 255), new Color(102, 0, 204), new Color(102, 0, 153), new Color(102, 0, 102), new Color(102, 0, 51), new Color(102, 0, 0), new Color(51, 255, 255), new Color(51, 255, 204), new Color(51, 255, 153), new Color(51, 255, 102), new Color(51, 255, 51), new Color(51, 255, 0), new Color(51, 204, 255), new Color(51, 204, 204), new Color(51, 204, 153), new Color(51, 204, 102), new Color(51, 204, 51), new Color(51, 204, 0), new Color(51, 153, 255), new Color(51, 153, 204), new Color(51, 153, 153), new Color(51, 153, 102), new Color(51, 153, 51), new Color(51, 153, 0), new Color(51, 102, 255), new Color(51, 102, 204), new Color(51, 102, 153), new Color(51, 102, 102), new Color(51, 102, 51), new Color(51, 102, 0), new Color(51, 51, 255), new Color(51, 51, 204), new Color(51, 51, 153), new Color(51, 51, 102), new Color(51, 51, 51), new Color(51, 51, 0), new Color(51, 0, 255), new Color(51, 0, 204), new Color(51, 0, 153), new Color(51, 0, 102), new Color(51, 0, 51), new Color(51, 0, 0), new Color(0, 255, 255), new Color(0, 255, 204), new Color(0, 255, 153), new Color(0, 255, 102), new Color(0, 255, 51), new Color(0, 255, 0), new Color(0, 204, 255), new Color(0, 204, 204), new Color(0, 204, 153), new Color(0, 204, 102), new Color(0, 204, 51), new Color(0, 204, 0), new Color(0, 153, 255), new Color(0, 153, 204), new Color(0, 153, 153), new Color(0, 153, 102), new Color(0, 153, 51), new Color(0, 153, 0), new Color(0, 102, 255), new Color(0, 102, 204), new Color(0, 102, 153), new Color(0, 102, 102), new Color(0, 102, 51), new Color(0, 102, 0), new Color(0, 51, 255), new Color(0, 51, 204), new Color(0, 51, 153), new Color(0, 51, 102), new Color(0, 51, 51), new Color(0, 51, 0), new Color(0, 0, 255), new Color(0, 0, 204), new Color(0, 0, 153), new Color(0, 0, 102), new Color(0, 0, 51), new Color(238, 0, 0), new Color(221, 0, 0), new Color(187, 0, 0), new Color(170, 0, 0), new Color(136, 0, 0), new Color(119, 0, 0), new Color(85, 0, 0), new Color(68, 0, 0), new Color(34, 0, 0), new Color(17, 0, 0), new Color(0, 238, 0), new Color(0, 221, 0), new Color(0, 187, 0), new Color(0, 170, 0), new Color(0, 136, 0), new Color(0, 119, 0), new Color(0, 85, 0), new Color(0, 68, 0), new Color(0, 34, 0), new Color(0, 17, 0), new Color(0, 0, 238), new Color(0, 0, 221), new Color(0, 0, 187), new Color(0, 0, 170), new Color(0, 0, 136), new Color(0, 0, 119), new Color(0, 0, 85), new Color(0, 0, 68), new Color(0, 0, 34), new Color(0, 0, 17), new Color(238, 238, 238), new Color(221, 221, 221), new Color(187, 187, 187), new Color(170, 170, 170), new Color(136, 136, 136), new Color(119, 119, 119), new Color(85, 85, 85), new Color(68, 68, 68), new Color(34, 34, 34), new Color(17, 17, 17), new Color(0, 0, 0)};
        byte[] rPalette = new byte[256];
        byte[] gPalette = new byte[256];
        byte[] bPalette = new byte[256];
        int index = 0;
        while (index < 256) {
            rPalette[index] = (byte)colors[index].getRed();
            gPalette[index] = (byte)colors[index].getGreen();
            bPalette[index] = (byte)colors[index].getBlue();
            ++index;
        }
        return new IndexColorModel(8, 256, rPalette, gPalette, bPalette);
    }

    protected static StImage _TestImage() {
        int width = 50;
        int height = 50;
        int index = 0;
        StImage anImage = new StImage(width * 3, height * 3);
        Color[] colors = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.white, Color.yellow, Color.cyan, Color.magenta, Color.gray};
        int y = 0;
        while (y < 3) {
            int x = 0;
            while (x < 3) {
                StImage pattern = new StImage(16, 16);
                int value = colors[index].getRGB();
                int x2 = 0;
                while (x2 < pattern.width()) {
                    int y2 = 0;
                    while (y2 < pattern.height()) {
                        pattern.atX_y_put_(x2, y2, value);
                        ++y2;
                    }
                    ++x2;
                }
                anImage.tile_from_in_rule_(new Rectangle(width * x + 1, height * y + 1, width - 2, height - 2), new Point(0, 0), pattern, 3);
                ++index;
                ++x;
            }
            ++y;
        }
        return anImage;
    }

    public static boolean Example01() {
        StImage source = new IsrColorChoiceSBH().plate();
        StImage destination = (StImage)new IsrColorChoiceHBS().plate().copy();
        Rectangle area = new Rectangle(25, 25, 55, 55);
        destination.copy_from_in_rule_(area, new Point(0, 0), source, 3);
        destination._display();
        return true;
    }

    public static boolean Example02() {
        StImage destination = new StImage(IsrImageProcessorTestExamples._ImageSmalltalkBalloon());
        StImage source = new StImage(IsrCursors.StopCursor());
        Rectangle area = new Rectangle(10, 10, 30, 30);
        destination.tile_from_in_rule_(area, new Point(0, 0), source, 3);
        destination._display();
        return true;
    }

    public static boolean Example03() {
        StImage source = new IsrColorChoiceSBH().plate();
        StImage result = IsrImageProcessor.Scale_factor_(source, new Isr2dPoint(2.5, 2.0));
        result._display();
        return true;
    }

    public static boolean Example04() {
        StImage source = new StImage(IsrSystem.LogoImage());
        StImage result = IsrImageProcessor.Scale_factor_(source, new Isr2dPoint(2.5, 2.0));
        result._display();
        return true;
    }

    public static boolean Example05() {
        StImage destination = new StImage(512, 512);
        int index = 0;
        while (index < 66) {
            Rectangle area = new Rectangle(index % 8 * 24, index / 8 * 24, 16, 16);
            destination.copy_from_in_rule_(area, new Point(0, 0), new StImage(IsrImageProcessor.MaskAt_(index)), 3);
            ++index;
        }
        destination._display();
        return true;
    }

    public static boolean Example06() {
        System.out.print(IsrImageProcessor.Stipple_(0.5));
        return true;
    }

    public static boolean Example07() {
        StImage anImage = IsrImageProcessorTestExamples._TestImage();
        IsrImageProcessor.Fill_rectangle_color_(anImage, new Rectangle(20, 20, 60, 60), Color.pink);
        anImage._display();
        anImage = IsrImageProcessorTestExamples._TestImage();
        IsrImageProcessor.Fill_seed_color_(anImage, new Point(75, 75), Color.pink);
        anImage._display();
        return true;
    }

    public static boolean Example08() {
        StImage anImage = new StImage(IsrImageProcessorTestExamples._ImageSmalltalkBalloon());
        Object[] histogram = IsrImageProcessor.ColorHistogram_(anImage);
        StImage image = new StImage(401, histogram.length * 4);
        int i = 0;
        while (i < histogram.length) {
            int width = (int)((Double)((StAssociation)histogram[i]).value() * 400.0);
            if (width == 0) {
                width = 1;
            }
            Rectangle box = new Rectangle(1, i * 4, width, 3);
            Color color = (Color)((StAssociation)histogram[i]).key();
            image = IsrImageProcessor.Fill_rectangle_color_(image, box, color);
            ++i;
        }
        image._display();
        return true;
    }

    public static boolean Example09() {
        StImage anImage = new StImage(IsrImageProcessorTestExamples._ImageSmalltalkBalloon());
        IsrImageProcessor.Icon_size_(anImage, 64)._display();
        ((StImage)IsrImageProcessor.Icon2_size_(anImage, 64).firstElement())._display();
        ((StImage)IsrImageProcessor.Icon3_size_(anImage, 64).firstElement())._display();
        return true;
    }

    public static boolean Example10() {
        StImage anImage = new StImage(IsrImageProcessorTestExamples._ImageSmalltalkBalloon());
        Object[] xspectrum = IsrImageProcessor.XSpectrum_(anImage);
        StImage image = new StImage(xspectrum.length, 100);
        int i = 0;
        while (i < xspectrum.length) {
            int x = (Integer)((StAssociation)xspectrum[i]).key();
            int value = (int)((Double)((StAssociation)xspectrum[i]).value() * 100.0);
            if (value == 0) {
                value = 1;
            }
            Rectangle box = new Rectangle(x, 0, 1, value);
            image = IsrImageProcessor.Fill_rectangle_color_(image, box, Color.black);
            ++i;
        }
        image._display();
        return true;
    }

    public static boolean Example11() {
        StImage anImage = new StImage(IsrImageProcessorTestExamples._ImageSmalltalkBalloon());
        Object[] yspectrum = IsrImageProcessor.YSpectrum_(anImage);
        StImage image = new StImage(100, yspectrum.length);
        int i = 0;
        while (i < yspectrum.length) {
            int x = (Integer)((StAssociation)yspectrum[i]).key();
            int value = (int)((Double)((StAssociation)yspectrum[i]).value() * 100.0);
            if (value == 0) {
                value = 1;
            }
            Rectangle box = new Rectangle(0, x, value, 1);
            image = IsrImageProcessor.Fill_rectangle_color_(image, box, Color.black);
            ++i;
        }
        image._display();
        return true;
    }

    public static boolean Example12() {
        IsrImageProcessor.ColorPalette256Image_(new Point(8, 8))._display();
        IsrImageProcessor.GrayPalette256Image_(new Point(8, 8))._display();
        return true;
    }

    public static boolean Example13() {
        StImage anImage = IsrImageProcessorTestExamples._TestImage();
        anImage = IsrImageProcessor.Shape_color_(anImage, Color.green);
        anImage._display();
        return true;
    }

    public static boolean Example14() {
        Graphics gc = null;
        StImage anImage = new StImage(IsrSystem.LogoImage());
        StAssociation[] collection = IsrImageProcessor.BorderFollowing_(anImage);
        Image newImage = SystemResourceSupport.createImage((int)(anImage.width() + 2), (int)(anImage.height() + 2));
        try {
            gc = newImage.getGraphics();
            int i = 0;
            while (i < collection.length) {
                StAssociation assoc = collection[i];
                Point[] points = (Point[])assoc.value();
                int[] xPoints = new int[points.length];
                int[] yPoints = new int[points.length];
                int j = 0;
                while (j < points.length) {
                    xPoints[j] = points[j].x;
                    yPoints[j] = points[j].y;
                    ++j;
                }
                gc.drawPolyline(xPoints, yPoints, xPoints.length);
                ++i;
            }
            new StImage(newImage)._display();
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            gc.dispose();
            newImage.flush();
            throw throwable;
        }
        Object var4_12 = null;
        gc.dispose();
        newImage.flush();
        return true;
    }

    public static boolean Example15() {
        Graphics gc = null;
        StImage anImage = new StImage(IsrSystem.LogoImage());
        Object[] collection = IsrImageProcessor.TraceBorder_(anImage);
        Image newImage = SystemResourceSupport.createImage((int)(anImage.width() + 2), (int)(anImage.height() + 2));
        try {
            gc = newImage.getGraphics();
            int i = 0;
            while (i < collection.length) {
                Point[] points = (Point[])collection[i];
                int[] xPoints = new int[points.length];
                int[] yPoints = new int[points.length];
                int j = 0;
                while (j < points.length) {
                    xPoints[j] = points[j].x;
                    yPoints[j] = points[j].y;
                    ++j;
                }
                gc.drawPolyline(xPoints, yPoints, xPoints.length);
                ++i;
            }
            new StImage(newImage)._display();
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            gc.dispose();
            newImage.flush();
            throw throwable;
        }
        Object var4_11 = null;
        gc.dispose();
        newImage.flush();
        return true;
    }

    public static boolean Example16() {
        StImage anImage = new StImage(IsrSystem.LogoImage());
        anImage = IsrImageProcessor.MakeThin_(anImage);
        anImage._display();
        return true;
    }

    public static boolean Example17() {
        StImage anImage = new StImage(IsrImageProcessorTestExamples._ImageSmalltalkBalloon());
        anImage._display();
        StImage newImage = anImage._convertToPalette_RenderedByNearistPaint(IsrImageProcessor.GrayPalette256());
        newImage._display();
        newImage = anImage._convertToPalette_RenderedByErrorDiffusion(IsrImageProcessor.GrayPalette256());
        newImage._display();
        return true;
    }

    public static void main(String[] args) {
        new IsrImageProcessorTestExamples();
    }
}

