/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.image.support;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.image.streams.IsrBmpImageStream;
import sra.smalltalk.SmalltalkException;
import sra.smalltalk.StAssociation;
import sra.smalltalk.StBlockClosure;
import sra.smalltalk.StColorValue;
import sra.smalltalk.StDialog;
import sra.smalltalk.StImage;
import sra.smalltalk.StInterval;
import sra.smalltalk.StSortedCollection;

public class IsrImageProcessor {
    private static int[] Stipples = IsrImageProcessor._InitializeStipples();
    private static StImage[] Masks = IsrImageProcessor._InitializeMasks();
    private static IndexColorModel ColorPalette256;
    private static IndexColorModel GrayPalette256;
    private static IndexColorModel _WhiteBlackPalette;
    private static IndexColorModel _BlackWhitePalette;
    private static Point[] EightPoints;
    private static Point[] FourPoints;

    public static final IndexColorModel _BlackWhitePalette() {
        if (_BlackWhitePalette == null) {
            byte[] palette = new byte[]{0, -1};
            _BlackWhitePalette = new IndexColorModel(1, 2, palette, palette, palette);
        }
        return _BlackWhitePalette;
    }

    private static StImage[] _InitializeMasks() {
        int[] map = new int[]{1, 33, 9, 41, 3, 35, 11, 43, 59, 17, 49, 25, 57, 19, 51, 27, 13, 45, 5, 37, 15, 47, 7, 39, 55, 29, 61, 21, 53, 31, 63, 23, 4, 36, 12, 44, 2, 34, 10, 42, 58, 20, 52, 28, 60, 18, 50, 26, 16, 48, 8, 40, 14, 46, 6, 38, 54, 32, 64, 24, 56, 30, 62, 22};
        int pixelValue = Color.black.getRGB();
        StImage[] masks = new StImage[65];
        int index = 0;
        while (index < 65) {
            StImage mask = new StImage(16, 16);
            if (index != 0) {
                int count = 0;
                int eachIndex = 0;
                while (eachIndex < map.length) {
                    int each = map[eachIndex];
                    if (each <= index) {
                        int x = count % 8;
                        int y = count / 8;
                        mask.atX_y_put_(x, y, pixelValue);
                        mask.atX_y_put_(x + 8, y, pixelValue);
                        mask.atX_y_put_(x, y + 8, pixelValue);
                        mask.atX_y_put_(x + 8, y + 8, pixelValue);
                    }
                    ++count;
                    ++eachIndex;
                }
            }
            masks[index] = mask;
            ++index;
        }
        return masks;
    }

    private static int[] _InitializeStipples() {
        int[] stipples = new int[]{Integer.parseInt("0000", 16), Integer.parseInt("8080", 16), Integer.parseInt("8888", 16), Integer.parseInt("A8A8", 16), Integer.parseInt("AAAA", 16), Integer.parseInt("EAEA", 16), Integer.parseInt("EEEE", 16), Integer.parseInt("FEFE", 16), Integer.parseInt("FFFF", 16)};
        return stipples;
    }

    public static StImage _MakeImage_Shape_(StImage figure, StImage shape) {
        if (figure.extent().equals(shape.extent())) {
            ColorModel colorModel = ColorModel.getRGBdefault();
            int width = figure.width();
            int height = figure.height();
            int[] pixels = new int[width * height];
            int i = 0;
            while (i < width * height) {
                int figurePixelValue = figure.bits()[i];
                int shapePixelValue = shape.bits()[i];
                int red = colorModel.getRed(figurePixelValue);
                int green = colorModel.getGreen(figurePixelValue);
                int blue = colorModel.getBlue(figurePixelValue);
                int alpha = colorModel.getAlpha(shapePixelValue);
                pixels[i] = figurePixelValue != 0xFFFFFF ? alpha << 24 | red << 16 | green << 8 | blue << 0 : (shapePixelValue != 0xFFFFFF ? shapePixelValue : 0xFFFFFF);
                ++i;
            }
            return new StImage(width, height, pixels);
        }
        return null;
    }

    public static final IndexColorModel _WhiteBlackPalette() {
        if (_WhiteBlackPalette == null) {
            byte[] palette = new byte[]{-1, 0};
            _WhiteBlackPalette = new IndexColorModel(1, 2, palette, palette, palette);
        }
        return _WhiteBlackPalette;
    }

    public static StAssociation[] BorderFollowing_(StImage anImage) {
        StImage temp = anImage.convertToPalette_(IsrImageProcessor._WhiteBlackPalette());
        StImage image = new StImage(temp.width() + 2, temp.height() + 2);
        image.copy_from_in_rule_(new Rectangle(1, 1, temp.width(), temp.height()), new Point(0, 0), temp, 3);
        Vector<StAssociation> borders = new Vector<StAssociation>();
        int colorBlackValue = Color.black.getRGB();
        int colorWhiteValue = Color.white.getRGB();
        int i = 0;
        while (i < image.width()) {
            int j = 0;
            while (j < image.height()) {
                Point[] collection;
                int direction;
                int b4;
                int b3;
                int b2;
                int b1;
                if (image.atX_y_(i, j) == colorBlackValue && ((b1 = image.atX_y_(i, j + 1)) | (b2 = image.atX_y_(i - 1, j)) | (b3 = image.atX_y_(i, j - 1)) | (b4 = image.atX_y_(i + 1, j))) == colorWhiteValue && (direction = b4 == colorWhiteValue ? 6 : (b3 == colorWhiteValue ? 4 : (b2 == colorWhiteValue ? 2 : (b1 == colorWhiteValue ? 0 : -1)))) > 0 && (collection = IsrImageProcessor.BorderFollowingPoint_direction_image_(new Point(i, j), direction, image)).length > 0) {
                    borders.addElement(new StAssociation((Object)new Integer(direction), (Object)collection));
                }
                ++j;
            }
            ++i;
        }
        Object[] answer = new StAssociation[borders.size()];
        borders.copyInto(answer);
        return answer;
    }

    public static Point[] BorderFollowingPoint_direction_image_(Point point, int ds, StImage image) {
        int[] array1 = new int[]{0, -1, -1, -1, 0, 1, 1, 1};
        int[] array2 = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
        int colorGrayValue = Color.gray.getRGB();
        int colorWhiteValue = Color.white.getRGB();
        Vector<Point> border = new Vector<Point>();
        int i = point.x;
        int iw = point.x;
        int is = point.x;
        int j = point.y;
        int jw = point.y;
        int js = point.y;
        int d = ds;
        int n = d + 4 & 7;
        d = -1;
        int nb = -1;
        int nc = 0;
        nc = nc + image.atX_y_(i - 1, j - 1) + 1;
        nc = nc + image.atX_y_(i - 1, j) + 1;
        nc = nc + image.atX_y_(i - 1, j + 1) + 1;
        nc = nc + image.atX_y_(i, j - 1) + 1;
        nc = nc + image.atX_y_(i, j + 1) + 1;
        nc = nc + image.atX_y_(i + 1, j - 1) + 1;
        nc = nc + image.atX_y_(i + 1, j) + 1;
        if ((nc = nc + image.atX_y_(i + 1, j + 1) + 1) < 0) {
            boolean loop1 = true;
            while (loop1) {
                i = iw;
                j = jw;
                image.atX_y_put_(iw, jw, colorGrayValue);
                Point p = new Point(iw - 1, jw - 1);
                border.addElement(p);
                n = n + 4 & 7;
                boolean loop2 = true;
                while (loop2) {
                    iw = i + array1[n = n + 1 & 7];
                    jw = j + array2[n];
                    boolean bl = loop2 = image.atX_y_(iw, jw) == colorWhiteValue;
                }
                if (d < 0) {
                    if (nb < 0) {
                        nb = n;
                    } else {
                        d = nb;
                    }
                }
                boolean bl = loop1 = i != is | j != js | n != d;
            }
        } else {
            image.atX_y_put_(i, j, colorGrayValue);
        }
        Object[] answer = new Point[border.size()];
        border.copyInto(answer);
        return answer;
    }

    public static Object[] ColorHistogram_(StImage anImage) {
        Hashtable<Integer, Integer> dictionary = new Hashtable<Integer, Integer>();
        int y = 0;
        while (y < anImage.height()) {
            int x = 0;
            while (x < anImage.width()) {
                Integer index = new Integer(anImage.atX_y_(x, y) & 0xFFFFFF);
                if (dictionary.containsKey(index)) {
                    dictionary.put(index, new Integer(1 + (Integer)dictionary.get(index)));
                } else {
                    dictionary.put(index, new Integer(1));
                }
                ++x;
            }
            ++y;
        }
        StBlockClosure sortBlock = new StBlockClosure(){

            public Object value_value_(Object x, Object y) {
                Color cx = (Color)((StAssociation)x).key();
                double dx = StColorValue._DistanceFrom((Color)cx, (Color)Color.black);
                Color cy = (Color)((StAssociation)y).key();
                double dy = StColorValue._DistanceFrom((Color)cy, (Color)Color.black);
                if (cx == cy) {
                    return new Boolean(cx.getRed() < cy.getRed() && cx.getGreen() < cy.getGreen() && cx.getBlue() < cy.getBlue());
                }
                return new Boolean(dx < dy);
            }
        };
        StSortedCollection histogram = new StSortedCollection(sortBlock);
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Integer assocKey = (Integer)enumeration.nextElement();
            Integer assocValue = (Integer)dictionary.get(assocKey);
            Color color = new Color(assocKey);
            double value = assocValue.doubleValue() / (double)(anImage.width() * anImage.height());
            StAssociation pair = new StAssociation((Object)color, (Object)new Double(value));
            histogram.add_((Object)pair);
        }
        return histogram._asArray();
    }

    public static final IndexColorModel ColorPalette256() {
        if (ColorPalette256 == null) {
            Color[] colors = new Color[]{new Color(0, 0, 0), new Color(16, 16, 16), new Color(33, 33, 33), new Color(67, 67, 67), new Color(84, 84, 84), new Color(118, 118, 118), new Color(136, 136, 136), new Color(170, 170, 170), new Color(187, 187, 187), new Color(221, 221, 221), new Color(238, 238, 238), new Color(0, 0, 16), new Color(0, 0, 33), new Color(0, 0, 67), new Color(0, 0, 84), new Color(0, 0, 118), new Color(0, 0, 136), new Color(0, 0, 170), new Color(0, 0, 187), new Color(0, 0, 221), new Color(0, 0, 238), new Color(0, 16, 0), new Color(0, 33, 0), new Color(0, 67, 0), new Color(0, 84, 0), new Color(0, 118, 0), new Color(0, 136, 0), new Color(0, 170, 0), new Color(0, 187, 0), new Color(0, 221, 0), new Color(0, 238, 0), new Color(16, 0, 0), new Color(33, 0, 0), new Color(67, 0, 0), new Color(84, 0, 0), new Color(118, 0, 0), new Color(136, 0, 0), new Color(170, 0, 0), new Color(187, 0, 0), new Color(221, 0, 0), new Color(238, 0, 0), new Color(0, 0, 50), new Color(0, 0, 101), new Color(0, 0, 153), new Color(0, 0, 204), new Color(0, 0, 255), new Color(0, 50, 0), new Color(0, 50, 50), new Color(0, 50, 101), new Color(0, 50, 153), new Color(0, 50, 204), new Color(0, 50, 255), new Color(0, 101, 0), new Color(0, 101, 50), new Color(0, 101, 101), new Color(0, 101, 153), new Color(0, 101, 204), new Color(0, 101, 255), new Color(0, 153, 0), new Color(0, 153, 50), new Color(0, 153, 101), new Color(0, 153, 153), new Color(0, 153, 204), new Color(0, 153, 255), new Color(0, 204, 0), new Color(0, 204, 50), new Color(0, 204, 101), new Color(0, 204, 153), new Color(0, 204, 204), new Color(0, 204, 255), new Color(0, 255, 0), new Color(0, 255, 50), new Color(0, 255, 101), new Color(0, 255, 153), new Color(0, 255, 204), new Color(0, 255, 255), new Color(50, 0, 0), new Color(50, 0, 50), new Color(50, 0, 101), new Color(50, 0, 153), new Color(50, 0, 204), new Color(50, 0, 255), new Color(50, 50, 0), new Color(50, 50, 50), new Color(50, 50, 101), new Color(50, 50, 153), new Color(50, 50, 204), new Color(50, 50, 255), new Color(50, 101, 0), new Color(50, 101, 50), new Color(50, 101, 101), new Color(50, 101, 153), new Color(50, 101, 204), new Color(50, 101, 255), new Color(50, 153, 0), new Color(50, 153, 50), new Color(50, 153, 101), new Color(50, 153, 153), new Color(50, 153, 204), new Color(50, 153, 255), new Color(50, 204, 0), new Color(50, 204, 50), new Color(50, 204, 101), new Color(50, 204, 153), new Color(50, 204, 204), new Color(50, 204, 255), new Color(50, 255, 0), new Color(50, 255, 50), new Color(50, 255, 101), new Color(50, 255, 153), new Color(50, 255, 204), new Color(50, 255, 255), new Color(101, 0, 0), new Color(101, 0, 50), new Color(101, 0, 101), new Color(101, 0, 153), new Color(101, 0, 204), new Color(101, 0, 255), new Color(101, 50, 0), new Color(101, 50, 50), new Color(101, 50, 101), new Color(101, 50, 153), new Color(101, 50, 204), new Color(101, 50, 255), new Color(101, 101, 0), new Color(101, 101, 50), new Color(101, 101, 101), new Color(101, 101, 153), new Color(101, 101, 204), new Color(101, 101, 255), new Color(101, 153, 0), new Color(101, 153, 50), new Color(101, 153, 101), new Color(101, 153, 153), new Color(101, 153, 204), new Color(101, 153, 255), new Color(101, 204, 0), new Color(101, 204, 50), new Color(101, 204, 101), new Color(101, 204, 153), new Color(101, 204, 204), new Color(101, 204, 255), new Color(101, 255, 0), new Color(101, 255, 50), new Color(101, 255, 101), new Color(101, 255, 153), new Color(101, 255, 204), new Color(101, 255, 255), new Color(153, 0, 0), new Color(153, 0, 50), new Color(153, 0, 101), new Color(153, 0, 153), new Color(153, 0, 204), new Color(153, 0, 255), new Color(153, 50, 0), new Color(153, 50, 50), new Color(153, 50, 101), new Color(153, 50, 153), new Color(153, 50, 204), new Color(153, 50, 255), new Color(153, 101, 0), new Color(153, 101, 50), new Color(153, 101, 101), new Color(153, 101, 153), new Color(153, 101, 204), new Color(153, 101, 255), new Color(153, 153, 0), new Color(153, 153, 50), new Color(153, 153, 101), new Color(153, 153, 153), new Color(153, 153, 204), new Color(153, 153, 255), new Color(153, 204, 0), new Color(153, 204, 50), new Color(153, 204, 101), new Color(153, 204, 153), new Color(153, 204, 204), new Color(153, 204, 255), new Color(153, 255, 0), new Color(153, 255, 50), new Color(153, 255, 101), new Color(153, 255, 153), new Color(153, 255, 204), new Color(153, 255, 255), new Color(204, 0, 0), new Color(204, 0, 50), new Color(204, 0, 101), new Color(204, 0, 153), new Color(204, 0, 204), new Color(204, 0, 255), new Color(204, 50, 0), new Color(204, 50, 50), new Color(204, 50, 101), new Color(204, 50, 153), new Color(204, 50, 204), new Color(204, 50, 255), new Color(204, 101, 0), new Color(204, 101, 50), new Color(204, 101, 101), new Color(204, 101, 153), new Color(204, 101, 204), new Color(204, 101, 255), new Color(204, 153, 0), new Color(204, 153, 50), new Color(204, 153, 101), new Color(204, 153, 153), new Color(204, 153, 204), new Color(204, 153, 255), new Color(204, 204, 0), new Color(204, 204, 50), new Color(204, 204, 101), new Color(204, 204, 153), new Color(204, 204, 204), new Color(204, 204, 255), new Color(204, 255, 0), new Color(204, 255, 50), new Color(204, 255, 101), new Color(204, 255, 153), new Color(204, 255, 204), new Color(204, 255, 255), new Color(255, 0, 0), new Color(255, 0, 50), new Color(255, 0, 101), new Color(255, 0, 153), new Color(255, 0, 204), new Color(255, 0, 255), new Color(255, 50, 0), new Color(255, 50, 50), new Color(255, 50, 101), new Color(255, 50, 153), new Color(255, 50, 204), new Color(255, 50, 255), new Color(255, 101, 0), new Color(255, 101, 50), new Color(255, 101, 101), new Color(255, 101, 153), new Color(255, 101, 204), new Color(255, 101, 255), new Color(255, 153, 0), new Color(255, 153, 50), new Color(255, 153, 101), new Color(255, 153, 153), new Color(255, 153, 204), new Color(255, 153, 255), new Color(255, 204, 0), new Color(255, 204, 50), new Color(255, 204, 101), new Color(255, 204, 153), new Color(255, 204, 204), new Color(255, 204, 255), new Color(255, 255, 0), new Color(255, 255, 50), new Color(255, 255, 101), new Color(255, 255, 153), new Color(255, 255, 204), new Color(255, 255, 255)};
            byte[] rPalette = new byte[256];
            byte[] gPalette = new byte[256];
            byte[] bPalette = new byte[256];
            int index = 0;
            while (index < 256) {
                rPalette[index] = (byte)colors[index].getRed();
                gPalette[index] = (byte)colors[index].getGreen();
                bPalette[index] = (byte)colors[index].getBlue();
                ++index;
            }
            ColorPalette256 = new IndexColorModel(8, 256, rPalette, gPalette, bPalette);
        }
        return ColorPalette256;
    }

    public static StImage ColorPalette256Image_(Point cellSize) {
        StImage anImage = new StImage(cellSize.x * 32, cellSize.y * 8);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        IndexColorModel colorModel = IsrImageProcessor.ColorPalette256();
        int index = 0;
        int width = cellSize.x;
        int height = cellSize.y;
        int offset = 0;
        int scansize = width;
        int y = 0;
        while (y < 8) {
            int x = 0;
            while (x < 32) {
                int[] pixels = new int[width * height];
                int i = 0;
                while (i < pixels.length) {
                    pixels[i] = index;
                    ++i;
                }
                MemoryImageSource source = new MemoryImageSource(width, height, (ColorModel)colorModel, pixels, offset, scansize);
                Image cellImage = toolkit.createImage(source);
                anImage.copy_from_in_rule_(new Rectangle(x * width, y * height, width, height), new Point(0, 0), new StImage(cellImage), 3);
                cellImage.flush();
                ++index;
                ++x;
            }
            ++y;
        }
        return anImage;
    }

    private static StImage ComputeImage_shrinkExtent_(StImage anImage, Point aPoint) {
        StInterval[] xIntervals = IsrImageProcessor.ComputeIntervals_divisionSize_(anImage.width(), aPoint.x);
        StInterval[] yIntervals = IsrImageProcessor.ComputeIntervals_divisionSize_(anImage.height(), aPoint.y);
        StImage shrunkenImage = new StImage(aPoint.x, aPoint.y);
        int yValue = 0;
        ColorModel colorModel = ColorModel.getRGBdefault();
        int i = 0;
        while (i < yIntervals.length) {
            StInterval yInterval = yIntervals[i];
            int xValue = 0;
            int j = 0;
            while (j < xIntervals.length) {
                StInterval xInterval = xIntervals[j];
                int redValue = 0;
                int greenValue = 0;
                int blueValue = 0;
                int countValue = 0;
                int y = (int)yInterval.start();
                while (y <= (int)yInterval.stop()) {
                    int x = (int)xInterval.start();
                    while (x <= (int)xInterval.stop()) {
                        int pixelValue = anImage.atX_y_(x, y) & 0xFFFFFF;
                        redValue += colorModel.getRed(pixelValue);
                        greenValue += colorModel.getGreen(pixelValue);
                        blueValue += colorModel.getBlue(pixelValue);
                        ++countValue;
                        x += (int)xInterval.step();
                    }
                    y += (int)yInterval.step();
                }
                Color colorValue = countValue > 0 ? new Color(Math.max(0, Math.min(Math.round((float)redValue / (float)countValue), 255)), Math.max(0, Math.min(Math.round((float)greenValue / (float)countValue), 255)), Math.max(0, Math.min(Math.round((float)blueValue / (float)countValue), 255))) : new Color(0, 0, 0);
                shrunkenImage.valueAtPoint_put_(new Point(xValue, yValue), colorValue);
                ++xValue;
                ++j;
            }
            ++yValue;
            ++i;
        }
        return shrunkenImage;
    }

    private static StInterval[] ComputeIntervals_divisionSize_(int anInteger, int divisionSize) {
        if (anInteger < divisionSize) {
            throw SmalltalkException.Error((String)(String.valueOf(Integer.toString(anInteger)) + " is smaller than " + Integer.toString(divisionSize)));
        }
        double stepValue = (double)anInteger / (double)divisionSize;
        int[] collection = new int[divisionSize + 1];
        int index = 0;
        double i = 0.0;
        while (i <= (double)anInteger) {
            collection[index] = Math.round((float)i);
            ++index;
            i += stepValue;
        }
        int[] startCollection = new int[collection.length - 1];
        int[] endCollection = new int[collection.length - 1];
        int j = 0;
        while (j < collection.length - 1) {
            startCollection[j] = collection[j];
            ++j;
        }
        int k = 0;
        while (k < collection.length - 1) {
            endCollection[k] = collection[k + 1] - 1;
            ++k;
        }
        StInterval[] array = new StInterval[startCollection.length];
        int l = 0;
        while (l < startCollection.length) {
            StInterval interval;
            array[l] = interval = new StInterval((double)startCollection[l], (double)endCollection[l], 1.0);
            ++l;
        }
        return array;
    }

    public static final Point[] EightPoints() {
        if (EightPoints == null) {
            Point[] points = new Point[]{new Point(-1, -1), new Point(0, -1), new Point(1, -1), new Point(1, 0), new Point(1, 1), new Point(0, 1), new Point(-1, 1), new Point(-1, 0)};
            EightPoints = points;
        }
        return EightPoints;
    }

    public static StImage Fill_(StImage anImage) {
        return IsrImageProcessor.Fill_rectangle_color_(anImage, anImage.bounds(), Color.black);
    }

    public static StImage Fill_color_(StImage anImage, Color colorValue) {
        return IsrImageProcessor.Fill_rectangle_color_(anImage, anImage.bounds(), colorValue);
    }

    public static StImage Fill_rectangle_(StImage anImage, Rectangle aRectangle) {
        return IsrImageProcessor.Fill_rectangle_color_(anImage, aRectangle, Color.black);
    }

    public static StImage Fill_rectangle_color_(StImage anImage, Rectangle aRectangle, Color colorValue) {
        StImage pattern = new StImage(16, 16);
        int value = colorValue.getRGB();
        int x = 0;
        while (x < pattern.width()) {
            int y = 0;
            while (y < pattern.height()) {
                pattern.atX_y_put_(x, y, value);
                ++y;
            }
            ++x;
        }
        return anImage.tile_from_in_rule_(aRectangle, new Point(0, 0), pattern, 3);
    }

    public static StImage Fill_seed_(StImage anImage, Point aPoint) {
        return IsrImageProcessor.Fill_seed_color_(anImage, aPoint, Color.black);
    }

    public static StImage Fill_seed_color_(StImage anImage, Point aPoint, Color colorValue) {
        int colorIndex = colorValue.getRGB();
        if (colorIndex == anImage.atPoint_(aPoint)) {
            return anImage;
        }
        int whiteIndex = Color.white.getRGB();
        int width = anImage.width();
        int height = anImage.height();
        Vector<Integer> x0Stack = new Vector<Integer>();
        x0Stack.addElement(new Integer(IsrImageProcessor.LastOn_before_after_index_(anImage, aPoint, -1, whiteIndex) + 1));
        Vector<Integer> x1Stack = new Vector<Integer>();
        x1Stack.addElement(new Integer(IsrImageProcessor.FirstOn_after_before_index_(anImage, aPoint, width, whiteIndex) - 1));
        Vector<Integer> yStack = new Vector<Integer>();
        yStack.addElement(new Integer(aPoint.y));
        Vector<Integer> directionStack = new Vector<Integer>();
        directionStack.addElement(new Integer(0));
        while (yStack.size() > 0) {
            int d;
            int xEnd;
            int xStart;
            int x0 = (Integer)x0Stack.lastElement();
            x0Stack.removeElementAt(x0Stack.size() - 1);
            int x1 = (Integer)x1Stack.lastElement();
            x1Stack.removeElementAt(x1Stack.size() - 1);
            int y = (Integer)yStack.lastElement();
            yStack.removeElementAt(yStack.size() - 1);
            int direction = (Integer)directionStack.lastElement();
            directionStack.removeElementAt(directionStack.size() - 1);
            int xLimit = Math.min(x1, width - 1);
            Point point = new Point(x0, y);
            while (point.x <= xLimit) {
                anImage.atPoint_put_(point, colorIndex);
                point = new Point(point.x + 1, point.y);
            }
            if (direction != 1 && y > 0) {
                xStart = whiteIndex == anImage.atPoint_(new Point(x0, y - 1)) ? IsrImageProcessor.LastOn_before_after_index_(anImage, new Point(x0, y - 1), -1, whiteIndex) + 1 : IsrImageProcessor.FirstOff_after_before_index_(anImage, new Point(x0, y - 1), x1 + 1, whiteIndex);
                while (xStart <= x1) {
                    xEnd = IsrImageProcessor.FirstOn_after_before_index_(anImage, new Point(xStart, y - 1), width, whiteIndex) - 1;
                    x0Stack.addElement(new Integer(xStart));
                    x1Stack.addElement(new Integer(xEnd));
                    yStack.addElement(new Integer(y - 1));
                    d = x0 - 1 > xStart || x1 + 1 < xEnd ? 0 : 2;
                    directionStack.addElement(new Integer(d));
                    xStart = xEnd >= x1 ? xEnd + 1 : IsrImageProcessor.FirstOff_after_before_index_(anImage, new Point(xEnd + 1, y - 1), x1 + 1, whiteIndex);
                }
            }
            if (direction == 2 || y >= height - 1) continue;
            xStart = whiteIndex == anImage.atPoint_(new Point(x0, y + 1)) ? IsrImageProcessor.LastOn_before_after_index_(anImage, new Point(x0, y + 1), -1, whiteIndex) + 1 : IsrImageProcessor.FirstOff_after_before_index_(anImage, new Point(x0, y + 1), x1 + 1, whiteIndex);
            while (xStart <= x1) {
                xEnd = IsrImageProcessor.FirstOn_after_before_index_(anImage, new Point(xStart, y + 1), width, whiteIndex) - 1;
                x0Stack.addElement(new Integer(xStart));
                x1Stack.addElement(new Integer(xEnd));
                yStack.addElement(new Integer(y + 1));
                d = x0 - 1 > xStart || x1 + 1 < xEnd ? 0 : 1;
                directionStack.addElement(new Integer(d));
                xStart = xEnd > x1 ? xEnd : IsrImageProcessor.FirstOff_after_before_index_(anImage, new Point(xEnd + 1, y + 1), x1 + 1, whiteIndex);
            }
        }
        return anImage;
    }

    private static int FirstOff_after_before_index_(StImage anImage, Point aPoint, int max, int paletteIndex) {
        int y;
        if (aPoint.x >= max) {
            return max;
        }
        Rectangle b = anImage.bounds();
        int x = Math.min(Math.max(aPoint.x, 0), b.width - 1);
        if (paletteIndex != anImage.atX_y_(x, y = Math.min(Math.max(aPoint.y, 0), b.height - 1))) {
            ++x;
            while (x < max && paletteIndex != anImage.atX_y_(x, y)) {
                ++x;
            }
        }
        return Math.min(x, max);
    }

    private static int FirstOn_after_before_index_(StImage anImage, Point aPoint, int max, int paletteIndex) {
        int y;
        Rectangle b = anImage.bounds();
        int x = Math.min(Math.max(aPoint.x, 0), b.width - 1);
        if (paletteIndex == anImage.atX_y_(x, y = Math.min(Math.max(aPoint.y, 0), b.height - 1))) {
            ++x;
            while (x < max && paletteIndex == anImage.atX_y_(x, y)) {
                ++x;
            }
        }
        return Math.min(x, max);
    }

    public static void FlushPalettes() {
        ColorPalette256 = null;
        GrayPalette256 = null;
        _WhiteBlackPalette = null;
        _BlackWhitePalette = null;
    }

    public static void FlushPoints() {
        EightPoints = null;
        FourPoints = null;
    }

    public static final Point[] FourPoints() {
        if (FourPoints == null) {
            Point[] points = new Point[]{new Point(0, -1), new Point(1, 0), new Point(0, 1), new Point(-1, 0)};
            FourPoints = points;
        }
        return FourPoints;
    }

    public static final IndexColorModel GrayPalette256() {
        if (GrayPalette256 == null) {
            Color[] colors = new Color[]{new Color(0, 0, 0), new Color(0, 0, 0), new Color(1, 1, 1), new Color(2, 2, 2), new Color(3, 3, 3), new Color(5, 5, 5), new Color(6, 6, 6), new Color(7, 7, 7), new Color(8, 8, 8), new Color(8, 8, 8), new Color(9, 9, 9), new Color(10, 10, 10), new Color(11, 11, 11), new Color(13, 13, 13), new Color(14, 14, 14), new Color(15, 15, 15), new Color(16, 16, 16), new Color(16, 16, 16), new Color(17, 17, 17), new Color(18, 18, 18), new Color(19, 19, 19), new Color(21, 21, 21), new Color(22, 22, 22), new Color(23, 23, 23), new Color(24, 24, 24), new Color(24, 24, 24), new Color(25, 25, 25), new Color(26, 26, 26), new Color(27, 27, 27), new Color(29, 29, 29), new Color(30, 30, 30), new Color(31, 31, 31), new Color(32, 32, 32), new Color(32, 32, 32), new Color(33, 33, 33), new Color(34, 34, 34), new Color(35, 35, 35), new Color(36, 36, 36), new Color(38, 38, 38), new Color(39, 39, 39), new Color(40, 40, 40), new Color(41, 41, 41), new Color(41, 41, 41), new Color(42, 42, 42), new Color(43, 43, 43), new Color(44, 44, 44), new Color(46, 46, 46), new Color(47, 47, 47), new Color(48, 48, 48), new Color(49, 49, 49), new Color(49, 49, 49), new Color(50, 50, 50), new Color(51, 51, 51), new Color(52, 52, 52), new Color(54, 54, 54), new Color(55, 55, 55), new Color(56, 56, 56), new Color(57, 57, 57), new Color(57, 57, 57), new Color(58, 58, 58), new Color(59, 59, 59), new Color(60, 60, 60), new Color(62, 62, 62), new Color(63, 63, 63), new Color(64, 64, 64), new Color(65, 65, 65), new Color(65, 65, 65), new Color(66, 66, 66), new Color(67, 67, 67), new Color(68, 68, 68), new Color(70, 70, 70), new Color(71, 71, 71), new Color(72, 72, 72), new Color(73, 73, 73), new Color(74, 74, 74), new Color(74, 74, 74), new Color(75, 75, 75), new Color(76, 76, 76), new Color(77, 77, 77), new Color(79, 79, 79), new Color(80, 80, 80), new Color(81, 81, 81), new Color(82, 82, 82), new Color(82, 82, 82), new Color(83, 83, 83), new Color(84, 84, 84), new Color(85, 85, 85), new Color(87, 87, 87), new Color(88, 88, 88), new Color(89, 89, 89), new Color(90, 90, 90), new Color(90, 90, 90), new Color(91, 91, 91), new Color(92, 92, 92), new Color(93, 93, 93), new Color(95, 95, 95), new Color(96, 96, 96), new Color(97, 97, 97), new Color(98, 98, 98), new Color(98, 98, 98), new Color(99, 99, 99), new Color(100, 100, 100), new Color(101, 101, 101), new Color(103, 103, 103), new Color(104, 104, 104), new Color(105, 105, 105), new Color(106, 106, 106), new Color(106, 106, 106), new Color(107, 107, 107), new Color(108, 108, 108), new Color(109, 109, 109), new Color(110, 110, 110), new Color(112, 112, 112), new Color(113, 113, 113), new Color(114, 114, 114), new Color(115, 115, 115), new Color(115, 115, 115), new Color(116, 116, 116), new Color(117, 117, 117), new Color(118, 118, 118), new Color(120, 120, 120), new Color(121, 121, 121), new Color(122, 122, 122), new Color(123, 123, 123), new Color(123, 123, 123), new Color(124, 124, 124), new Color(125, 125, 125), new Color(126, 126, 126), new Color(128, 128, 128), new Color(129, 129, 129), new Color(130, 130, 130), new Color(131, 131, 131), new Color(131, 131, 131), new Color(132, 132, 132), new Color(133, 133, 133), new Color(134, 134, 134), new Color(136, 136, 136), new Color(137, 137, 137), new Color(138, 138, 138), new Color(139, 139, 139), new Color(139, 139, 139), new Color(140, 140, 140), new Color(141, 141, 141), new Color(142, 142, 142), new Color(144, 144, 144), new Color(145, 145, 145), new Color(146, 146, 146), new Color(147, 147, 147), new Color(148, 148, 148), new Color(148, 148, 148), new Color(149, 149, 149), new Color(150, 150, 150), new Color(151, 151, 151), new Color(153, 153, 153), new Color(154, 154, 154), new Color(155, 155, 155), new Color(156, 156, 156), new Color(156, 156, 156), new Color(157, 157, 157), new Color(158, 158, 158), new Color(159, 159, 159), new Color(161, 161, 161), new Color(162, 162, 162), new Color(163, 163, 163), new Color(164, 164, 164), new Color(164, 164, 164), new Color(165, 165, 165), new Color(166, 166, 166), new Color(167, 167, 167), new Color(169, 169, 169), new Color(170, 170, 170), new Color(171, 171, 171), new Color(172, 172, 172), new Color(172, 172, 172), new Color(173, 173, 173), new Color(174, 174, 174), new Color(175, 175, 175), new Color(177, 177, 177), new Color(178, 178, 178), new Color(179, 179, 179), new Color(180, 180, 180), new Color(180, 180, 180), new Color(181, 181, 181), new Color(182, 182, 182), new Color(183, 183, 183), new Color(184, 184, 184), new Color(186, 186, 186), new Color(187, 187, 187), new Color(188, 188, 188), new Color(189, 189, 189), new Color(189, 189, 189), new Color(190, 190, 190), new Color(191, 191, 191), new Color(192, 192, 192), new Color(194, 194, 194), new Color(195, 195, 195), new Color(196, 196, 196), new Color(197, 197, 197), new Color(197, 197, 197), new Color(198, 198, 198), new Color(199, 199, 199), new Color(200, 200, 200), new Color(202, 202, 202), new Color(203, 203, 203), new Color(204, 204, 204), new Color(205, 205, 205), new Color(205, 205, 205), new Color(206, 206, 206), new Color(207, 207, 207), new Color(208, 208, 208), new Color(210, 210, 210), new Color(211, 211, 211), new Color(212, 212, 212), new Color(213, 213, 213), new Color(213, 213, 213), new Color(214, 214, 214), new Color(215, 215, 215), new Color(216, 216, 216), new Color(218, 218, 218), new Color(219, 219, 219), new Color(220, 220, 220), new Color(221, 221, 221), new Color(222, 222, 222), new Color(222, 222, 222), new Color(223, 223, 223), new Color(224, 224, 224), new Color(225, 225, 225), new Color(227, 227, 227), new Color(228, 228, 228), new Color(229, 229, 229), new Color(230, 230, 230), new Color(230, 230, 230), new Color(231, 231, 231), new Color(232, 232, 232), new Color(233, 233, 233), new Color(235, 235, 235), new Color(236, 236, 236), new Color(237, 237, 237), new Color(238, 238, 238), new Color(238, 238, 238), new Color(239, 239, 239), new Color(240, 240, 240), new Color(241, 241, 241), new Color(243, 243, 243), new Color(244, 244, 244), new Color(245, 245, 245), new Color(246, 246, 246), new Color(246, 246, 246), new Color(247, 247, 247), new Color(248, 248, 248), new Color(249, 249, 249), new Color(251, 251, 251), new Color(252, 252, 252), new Color(253, 253, 253), new Color(254, 254, 254), new Color(255, 255, 255)};
            byte[] rPalette = new byte[256];
            byte[] gPalette = new byte[256];
            byte[] bPalette = new byte[256];
            int index = 0;
            while (index < 256) {
                rPalette[index] = (byte)colors[index].getRed();
                gPalette[index] = (byte)colors[index].getGreen();
                bPalette[index] = (byte)colors[index].getBlue();
                ++index;
            }
            GrayPalette256 = new IndexColorModel(8, 256, rPalette, gPalette, bPalette);
        }
        return GrayPalette256;
    }

    public static StImage GrayPalette256Image_(Point cellSize) {
        StImage anImage = new StImage(cellSize.x * 32, cellSize.y * 8);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        IndexColorModel colorModel = IsrImageProcessor.GrayPalette256();
        int index = 0;
        int width = cellSize.x;
        int height = cellSize.y;
        int offset = 0;
        int scansize = width;
        int y = 0;
        while (y < 8) {
            int x = 0;
            while (x < 32) {
                int[] pixels = new int[width * height];
                int i = 0;
                while (i < pixels.length) {
                    pixels[i] = index;
                    ++i;
                }
                MemoryImageSource source = new MemoryImageSource(width, height, (ColorModel)colorModel, pixels, offset, scansize);
                Image cellImage = toolkit.createImage(source);
                anImage.copy_from_in_rule_(new Rectangle(x * width, y * height, width, height), new Point(0, 0), new StImage(cellImage), 3);
                cellImage.flush();
                ++index;
                ++x;
            }
            ++y;
        }
        return anImage;
    }

    public static Image Halftone_(double halftoneScale) {
        double scale = halftoneScale;
        scale = Math.max(scale, 0.0);
        scale = Math.min(scale, 1.0);
        int index = new Double((double)Masks.length * scale).intValue() + 1;
        return IsrImageProcessor.MaskAt_(index);
    }

    public static StImage Icon_size_(StImage anImage, int sizeInteger) {
        return (StImage)IsrImageProcessor.Icon2_size_(anImage, sizeInteger).firstElement();
    }

    public static Vector Icon2_size_(StImage anImage, int sizeInteger) {
        double factor = (double)sizeInteger / (double)Math.max(anImage.width(), anImage.height());
        StImage image = IsrImageProcessor.Scale_factor_(anImage, new Isr2dPoint(factor, factor));
        int maxSize = Math.max(image.width(), image.height());
        Point extent = new Point(maxSize, maxSize);
        Rectangle area = image.bounds();
        area.translate((int)((double)extent.x / 2.0 - (double)image.bounds().width / 2.0), (int)((double)extent.y / 2.0 - (double)image.bounds().height / 2.0));
        int[] bits = new int[maxSize * maxSize];
        int i = 0;
        while (i < maxSize * maxSize) {
            bits[i] = 0xFFFFFF;
            ++i;
        }
        StImage figure = new StImage(extent.x, extent.y, (int[])bits.clone());
        figure.copy_from_in_rule_(area, new Point(0, 0), image, 3);
        StImage shape = new StImage(extent.x, extent.y, (int[])bits.clone());
        shape = IsrImageProcessor.Fill_rectangle_color_(shape, area, Color.black);
        StImage opaque = IsrImageProcessor._MakeImage_Shape_(figure, shape);
        Vector<Object> array = new Vector<Object>();
        array.addElement(opaque);
        array.addElement(area);
        return array;
    }

    public static Vector Icon3_size_(StImage anImage, int sizeInteger) {
        StImage image = null;
        Point extent = null;
        double factor = (double)sizeInteger / (double)Math.max(anImage.width(), anImage.height());
        try {
            extent = new Point(Math.round((float)(factor * (double)anImage.width())), Math.round((float)(factor * (double)anImage.height())));
            image = IsrImageProcessor.ComputeImage_shrinkExtent_(anImage, extent);
        }
        catch (Exception exception) {
            image = IsrImageProcessor.Scale_factor_(anImage, new Isr2dPoint(factor, factor));
        }
        int maxSize = Math.max(image.width(), image.height());
        extent = new Point(maxSize, maxSize);
        Rectangle area = image.bounds();
        area.translate((int)((double)extent.x / 2.0 - (double)image.bounds().width / 2.0), (int)((double)extent.y / 2.0 - (double)image.bounds().height / 2.0));
        int[] bits = new int[maxSize * maxSize];
        int i = 0;
        while (i < maxSize * maxSize) {
            bits[i] = 0xFFFFFF;
            ++i;
        }
        StImage figure = new StImage(extent.x, extent.y, (int[])bits.clone());
        figure.copy_from_in_rule_(area, new Point(0, 0), image, 3);
        StImage shape = new StImage(extent.x, extent.y, (int[])bits.clone());
        shape = IsrImageProcessor.Fill_rectangle_color_(shape, area, Color.black);
        StImage opaque = IsrImageProcessor._MakeImage_Shape_(figure, shape);
        Vector<Object> array = new Vector<Object>();
        array.addElement(opaque);
        array.addElement(area);
        return array;
    }

    public static Image ImageFromFile_(String filename) {
        if (filename.toLowerCase().endsWith(".gif")) {
            System.err.println("It is not allowed to load GIF image.");
            return null;
        }
        StImage anImage = null;
        if (filename.toLowerCase().endsWith(".bmp")) {
            try {
                FileInputStream file = new FileInputStream(filename);
                IsrBmpImageStream stream = IsrBmpImageStream.On_(file);
                anImage = stream.nextImage();
                file.close();
            }
            catch (Exception exception) {
                System.err.println("could not load image.");
                return null;
            }
        }
        Frame frame = new Frame();
        Toolkit toolKit = frame.getToolkit();
        Image image = toolKit.getImage(filename);
        MediaTracker mt = new MediaTracker(frame);
        mt.addImage(image, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("image load interrupted.");
            return null;
        }
        int status = mt.statusAll(false);
        if ((status & 2) != 0 || (status & 4) != 0) {
            System.err.println("could not load image.");
            return null;
        }
        anImage = new StImage(image);
        image.flush();
        return anImage.image();
    }

    public static Image ImageFromFileDialog() {
        File file = StDialog.OpenFileDialog_((String)"Select a image file");
        if (file == null) {
            return null;
        }
        return IsrImageProcessor.ImageFromFile_(file.getPath());
    }

    private static int LastOn_before_after_index_(StImage anImage, Point aPoint, int min, int paletteIndex) {
        Rectangle b = anImage.bounds();
        int x = Math.min(Math.max(aPoint.x, 0), b.width - 1);
        int y = Math.min(Math.max(aPoint.y, 0), b.height - 1);
        while (x > min && paletteIndex == anImage.atX_y_(x, y)) {
            --x;
        }
        return x;
    }

    public static StImage MakeThin_(StImage anImage) {
        int colorWhiteValue0 = Color.white.getRGB();
        int colorBlackValue1 = Color.black.getRGB();
        int colorGrayValue3 = Color.gray.getRGB();
        int colorGrayValue5 = Color.darkGray.getRGB();
        int colorGrayValue7 = Color.lightGray.getRGB();
        StImage image = anImage.convertToPalette_(IsrImageProcessor._WhiteBlackPalette());
        StImage map = new StImage(image.width(), image.height());
        int z = 0;
        while (z < map.bits().length) {
            map.bits()[z] = image.bits()[z];
            ++z;
        }
        int i1 = map.width() - 1;
        int j1 = map.height() - 1;
        boolean loop = true;
        while (loop) {
            int x = 1;
            while (x < i1) {
                int y = 1;
                while (y < j1) {
                    if (map.atX_y_(x, y) == colorBlackValue1) {
                        if (map.atX_y_(x - 1, y) == colorWhiteValue0) {
                            map.atX_y_put_(x, y, colorGrayValue3);
                        } else if (map.atX_y_(x, y - 1) == colorWhiteValue0) {
                            map.atX_y_put_(x, y, colorGrayValue5);
                        } else if (map.atX_y_(x + 1, y) == colorWhiteValue0) {
                            map.atX_y_put_(x, y, colorGrayValue3);
                        } else if (map.atX_y_(x, y + 1) == colorWhiteValue0) {
                            map.atX_y_put_(x, y, colorGrayValue5);
                        }
                    }
                    ++y;
                }
                ++x;
            }
            int jsw = 0;
            int delta = 1;
            while (delta >= -1) {
                int data;
                int jj2;
                int jj1;
                int ii2;
                int ii1;
                if (delta == 1) {
                    ii1 = 1;
                    ii2 = i1;
                    jj1 = 1;
                    jj2 = j1;
                    data = colorGrayValue3;
                } else {
                    ii1 = i1 - 1;
                    ii2 = 0;
                    jj1 = j1 - 1;
                    jj2 = 0;
                    data = colorGrayValue5;
                }
                int i = ii1;
                while (i != ii2) {
                    int im = i - 1;
                    int ip = i + 1;
                    int j = jj1;
                    while (j != jj2) {
                        int jm = j - 1;
                        int jp = j + 1;
                        if (map.atX_y_(i, j) == data) {
                            int a8;
                            jsw = 1;
                            int a1 = map.atX_y_(i, jp) == colorWhiteValue0 ? 1 : 0;
                            int a2 = map.atX_y_(im, jp) == colorWhiteValue0 ? 1 : 0;
                            int a3 = map.atX_y_(im, j) == colorWhiteValue0 ? 1 : 0;
                            int a4 = map.atX_y_(im, jm) == colorWhiteValue0 ? 1 : 0;
                            int a5 = map.atX_y_(i, jm) == colorWhiteValue0 ? 1 : 0;
                            int a6 = map.atX_y_(ip, jm) == colorWhiteValue0 ? 1 : 0;
                            int a7 = map.atX_y_(ip, j) == colorWhiteValue0 ? 1 : 0;
                            int ns = a1 + a3 + a5 + a7;
                            if (ns + a2 + a4 + a6 + (a8 = map.atX_y_(ip, jp) == colorWhiteValue0 ? 1 : 0) <= 6) {
                                int k = ns - (a1 & a2 & a3) - (a3 & a4 & a5) - (a5 & a6 & a7) - (a7 & a8 & a1);
                                if (k == 1) {
                                    map.atX_y_put_(i, j, colorWhiteValue0);
                                    image.atX_y_put_(i, j, colorWhiteValue0);
                                } else {
                                    map.atX_y_put_(i, j, colorGrayValue7);
                                }
                            } else {
                                map.atX_y_put_(i, j, colorGrayValue7);
                            }
                        }
                        j += delta;
                    }
                    i += delta;
                }
                delta -= 2;
            }
            boolean bl = loop = jsw > 0;
        }
        return image;
    }

    public static Image MaskAt_(int indexInteger) {
        int index = indexInteger;
        index = Math.max(index, 1);
        index = Math.min(index, Masks.length);
        return Masks[index - 1].image();
    }

    public static StImage Scale_factor_(StImage anImage, Isr2dPoint scaleFactor) {
        Isr2dPoint scale = new Isr2dPoint(1.0 / scaleFactor.x(), 1.0 / scaleFactor.y());
        StImage image = anImage.copyEmpty_(anImage.scaledExtent_(scale.x(), scale.y()));
        StImage wide = anImage.copyEmpty_(new Point(anImage.width(), new Double((double)anImage.height() * 1.0 / scale.y()).intValue()));
        int y = 0;
        while (y < wide.height()) {
            int[] row = anImage.packedRowAt_(new Double((double)y * scale.y()).intValue());
            wide.packedRowAt_into_(y, row);
            ++y;
        }
        int x = 0;
        while (x < image.width()) {
            image.copy_from_in_rule_(new Rectangle(x, 0, 1, wide.height()), new Point(new Double((double)x * scale.x()).intValue(), 0), wide, 3);
            ++x;
        }
        return image;
    }

    public static StImage Shape_(StImage anImage) {
        return IsrImageProcessor.Shape_color_(anImage, Color.black);
    }

    public static StImage Shape_color_(StImage anImage, Color colorValue) {
        StImage copyImage = new StImage(anImage.width(), anImage.height());
        int i = 0;
        while (i < copyImage.bits().length) {
            copyImage.bits()[i] = anImage.bits()[i];
            ++i;
        }
        StImage expandImage = new StImage(copyImage.width() + 2, copyImage.height() + 2);
        expandImage.copy_from_in_rule_(new Rectangle(1, 1, copyImage.width(), copyImage.height()), new Point(0, 0), copyImage, 3);
        IsrImageProcessor.Fill_seed_color_(expandImage, new Point(0, 0), colorValue);
        int width = copyImage.width();
        int height = copyImage.height();
        int index = colorValue.getRGB();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                Point point = new Point(x, y);
                if (index != copyImage.atPoint_(point) && index != expandImage.atPoint_(new Point(x + 1, y + 1))) {
                    copyImage.atPoint_put_(point, index);
                }
                ++x;
            }
            ++y;
        }
        return copyImage;
    }

    public static float Similarity_with_(StImage image1, StImage image2) {
        if (image1.bits().length <= 0) {
            return 0.0f;
        }
        StImage destination = image1.convertToPalette_(IsrImageProcessor._WhiteBlackPalette());
        StImage source = image2.convertToPalette_(IsrImageProcessor._WhiteBlackPalette());
        destination.copy_from_in_rule_(destination.bounds(), new Point(0, 0), source, 6);
        Color.white.getRGB();
        int color1 = Color.black.getRGB();
        int count = 0;
        int y = 0;
        while (y < destination.height()) {
            int x = 0;
            while (x < destination.width()) {
                int v = destination.atX_y_(x, y);
                if (v == color1) {
                    ++count;
                }
                ++x;
            }
            ++y;
        }
        float similarity = 1.0f - (float)count / (float)destination.bits().length;
        similarity = Math.max(0.0f, Math.min(similarity, 1.0f));
        return similarity;
    }

    public static int Stipple_(double stippleScale) {
        double scale = stippleScale;
        scale = Math.max(scale, 0.0);
        scale = Math.min(scale, 1.0);
        int index = new Double((double)(Stipples.length - 1) * scale).intValue() + 1;
        return IsrImageProcessor.StippleAt_(index);
    }

    public static int StippleAt_(int indexInteger) {
        int index = indexInteger;
        index = Math.max(index, 1);
        index = Math.min(index, Stipples.length);
        return Stipples[index - 1];
    }

    public static Object[] TraceBorder_(StImage anImage) {
        StAssociation[] collection = IsrImageProcessor.BorderFollowing_(anImage);
        Object[] array = new Object[collection.length];
        int i = 0;
        while (i < collection.length) {
            array[i] = collection[i].value();
            ++i;
        }
        return array;
    }

    public static Object[] XSpectrum_(StImage anImage) {
        double value;
        Hashtable<Integer, Double> dictionary = new Hashtable<Integer, Double>();
        int x = 0;
        while (x < anImage.width()) {
            Integer key = new Integer(x);
            value = 0.0;
            int y = 0;
            while (y < anImage.height()) {
                Color color = anImage.valueAtPoint_(new Point(x, y));
                value += 1.0 - (double)StColorValue._GetBrightness((Color)color);
                ++y;
            }
            if (dictionary.containsKey(key)) {
                value += ((Double)dictionary.get(key)).doubleValue();
            }
            dictionary.put(key, new Double(value));
            ++x;
        }
        StBlockClosure sortBlock = new StBlockClosure(){

            public Object value_value_(Object obj1, Object obj2) {
                int obj2Number;
                int obj1Number = ((Number)((StAssociation)obj1).key()).intValue();
                return new Boolean(obj1Number <= (obj2Number = ((Number)((StAssociation)obj2).key()).intValue()));
            }
        };
        StSortedCollection spectrum = new StSortedCollection(sortBlock);
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Integer assocKey = (Integer)enumeration.nextElement();
            Double assocValue = (Double)dictionary.get(assocKey);
            value = assocValue / (double)anImage.height();
            StAssociation pair = new StAssociation((Object)assocKey, (Object)new Double(value));
            spectrum.add_((Object)pair);
        }
        return spectrum._asArray();
    }

    public static Object[] YSpectrum_(StImage anImage) {
        double value;
        Hashtable<Integer, Double> dictionary = new Hashtable<Integer, Double>();
        int y = 0;
        while (y < anImage.height()) {
            Integer key = new Integer(y);
            value = 0.0;
            int x = 0;
            while (x < anImage.width()) {
                Color color = anImage.valueAtPoint_(new Point(x, y));
                value += 1.0 - (double)StColorValue._GetBrightness((Color)color);
                ++x;
            }
            if (dictionary.containsKey(key)) {
                value += ((Double)dictionary.get(key)).doubleValue();
            }
            dictionary.put(key, new Double(value));
            ++y;
        }
        StBlockClosure sortBlock = new StBlockClosure(){

            public Object value_value_(Object obj1, Object obj2) {
                int obj2Number;
                int obj1Number = ((Number)((StAssociation)obj1).key()).intValue();
                return new Boolean(obj1Number <= (obj2Number = ((Number)((StAssociation)obj2).key()).intValue()));
            }
        };
        StSortedCollection spectrum = new StSortedCollection(sortBlock);
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Integer assocKey = (Integer)enumeration.nextElement();
            Double assocValue = (Double)dictionary.get(assocKey);
            value = assocValue / (double)anImage.width();
            StAssociation pair = new StAssociation((Object)assocKey, (Object)new Double(value));
            spectrum.add_((Object)pair);
        }
        return spectrum._asArray();
    }
}

