/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.image.streams;

import java.awt.Color;
import java.io.InputStream;
import sra.isr.image.streams.IsrImageStream;
import sra.smalltalk.StImage;

public class IsrBmpImageStream
extends IsrImageStream {
    private StImage imageObject;
    private int bfType;
    private long bfSize;
    private int bfReserved1;
    private int bfReserved2;
    private long bfOffBits;
    private long biSize;
    private long biWidth;
    private long biHeight;
    private int biPlanes;
    private int biBitCount;
    private long biCompression;
    private long biSizeImage;
    private long biXPelsPerMeter;
    private long biYPelsPerMeter;
    private long biClrUsed;
    private long biClrImportant;
    private int[] imagePalette;

    public StImage nextImage() {
        boolean check = this.readBitmapFileHeader();
        if (check) {
            this.readBitmapInfoHeader();
            this.readImagePalette();
            boolean check2 = this.readImageData();
            if (check2) {
                return this.imageObject;
            }
            return null;
        }
        return null;
    }

    public long nextLSBLong() {
        int byte1 = this.next();
        int byte2 = this.next();
        int byte3 = this.next();
        int byte4 = this.next();
        return (byte4 << 24) + (byte3 << 16) + (byte2 << 8) + byte1;
    }

    public int nextLSBWord() {
        int byte1 = this.next();
        int byte2 = this.next();
        return (byte2 << 8) + byte1;
    }

    public static IsrBmpImageStream On_(InputStream stream) {
        IsrBmpImageStream imageStream = new IsrBmpImageStream();
        imageStream.on_(stream);
        return imageStream;
    }

    private boolean readBitmapFileHeader() {
        int checker = 16973;
        this.bfType = this.nextWord();
        if (checker != this.bfType) {
            return false;
        }
        this.bfSize = this.nextLSBLong();
        this.bfReserved1 = this.nextLSBWord();
        this.bfReserved2 = this.nextLSBWord();
        this.bfOffBits = this.nextLSBLong();
        return true;
    }

    private void readBitmapInfoHeader() {
        this.biSize = this.nextLSBLong();
        this.biWidth = this.nextLSBLong();
        this.biHeight = this.nextLSBLong();
        this.biPlanes = this.nextLSBWord();
        this.biBitCount = this.nextLSBWord();
        this.biCompression = this.nextLSBLong();
        this.biSizeImage = this.nextLSBLong();
        this.biXPelsPerMeter = this.nextLSBLong();
        this.biYPelsPerMeter = this.nextLSBLong();
        this.biClrUsed = this.nextLSBLong();
        this.biClrImportant = this.nextLSBLong();
    }

    private StImage readDepth1Data() {
        System.out.print("1bit BMP detect");
        return null;
    }

    private StImage readDepth24Data() {
        while ((long)this.position < this.bfOffBits) {
            this.next();
        }
        int width = (int)this.biWidth;
        int height = (int)this.biHeight;
        StImage image = new StImage(width, height);
        int cfr_ignored_0 = width * height;
        int y = height - 1;
        while (y > -1) {
            int count = 0;
            int x = 0;
            while (x < width) {
                int rgb = (this.next() << 0) + (this.next() << 8) + (this.next() << 16);
                image.atX_y_put_(x, y, new Color(rgb).getRGB());
                count += 3;
                ++x;
            }
            while (count % 4 != 0) {
                this.next();
                ++count;
            }
            --y;
        }
        return image;
    }

    private StImage readDepth8Data() {
        int[] palette = this.imagePalette;
        int width = (int)this.biWidth;
        int height = (int)this.biHeight;
        StImage image = new StImage(width, height);
        int cfr_ignored_0 = width * height;
        int y = height - 1;
        while (y > -1) {
            int count = 0;
            int x = 0;
            while (x < width) {
                int index = this.next();
                image.atX_y_put_(x, y, palette[index]);
                ++count;
                ++x;
            }
            while (count % 4 != 0) {
                this.next();
                ++count;
            }
            --y;
        }
        return image;
    }

    private void readDepth8Palette() {
        long size = 1 << this.biBitCount;
        if (this.biClrUsed != 0L) {
            size = this.biClrUsed;
        }
        int[] colors = new int[(int)size];
        int index = 0;
        while ((long)index < size) {
            int rgb = this.next() + (this.next() << 8) + (this.next() << 16);
            this.next();
            colors[index] = 0xFF000000 | rgb;
            ++index;
        }
        this.imagePalette = colors;
    }

    private boolean readImageData() {
        if (this.biCompression != 0L) {
            return false;
        }
        int bit = this.biBitCount;
        this.imageObject = null;
        if (bit == 24) {
            this.imageObject = this.readDepth24Data();
        }
        if (bit == 8) {
            this.imageObject = this.readDepth8Data();
        }
        if (bit == 1) {
            this.imageObject = this.readDepth1Data();
        }
        return this.imageObject != null;
    }

    private void readImagePalette() {
        this.imagePalette = null;
        if (this.biBitCount == 8) {
            this.readDepth8Palette();
        }
    }
}

