/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.image.searcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.image.browser.IsrImageBrowser;
import sra.isr.image.objects.IsrImageAuxiliary;
import sra.isr.image.objects.IsrImageFolder;
import sra.isr.image.objects.IsrImageObject;
import sra.isr.image.searcher.IsrImageSearcherViewAwt;
import sra.isr.image.support.IsrImageProcessor;
import sra.isr.interfaces.area.IsrAreaModel;
import sra.isr.interfaces.button.IsrButtonModel;
import sra.isr.interfaces.colors.IsrColorChoiceSBH;
import sra.isr.interfaces.freehand.IsrFreehandModel;
import sra.isr.interfaces.gauge.IsrGaugeModel;
import sra.isr.interfaces.nineColors.Isr9ColorsModel;
import sra.isr.interfaces.progress.IsrProgress;
import sra.isr.interfaces.spot.IsrSpotModel;
import sra.smalltalk.StApplicationModel;
import sra.smalltalk.StAssociation;
import sra.smalltalk.StBlockClosure;
import sra.smalltalk.StColorValue;
import sra.smalltalk.StDialog;
import sra.smalltalk.StImage;
import sra.smalltalk.StMenu;
import sra.smalltalk.StMenuItem;
import sra.smalltalk.StMenuModel;
import sra.smalltalk.StMenuViewForAwt;
import sra.smalltalk.StSortedCollection;
import sra.smalltalk.StView;
import sra.smalltalk.SystemResourceSupport;

public class IsrImageSearcher
extends StApplicationModel {
    protected IsrImageFolder imageFolder;
    protected IsrAreaModel iconAreaModel;
    protected IsrButtonModel iconAreaSwitch;
    protected Isr9ColorsModel nineColorsModel;
    protected IsrButtonModel nineColorsSwitch;
    protected IsrColorChoiceSBH typicalColorModel;
    protected IsrButtonModel typicalColorSwitch;
    protected IsrGaugeModel averageGrayModel;
    protected IsrButtonModel averageGraySwitch;
    protected IsrSpotModel centerSpectraModel;
    protected IsrButtonModel centerSpectraSwitch;
    protected IsrFreehandModel freehandImageModel;
    protected IsrButtonModel freehandImageSwitch;
    protected IsrGaugeModel cutOffModel;
    protected IsrImageBrowser imageBrowser;
    private static Image OffImage;
    private static Image OnImage;
    protected PopupMenu menu;

    private Image _averageGrayButtonImage() {
        String imageString = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000011100100010011100010100011100011110011100000000101000100010110100001010110000111001011000011100001110000000001010001010001001100000001010010010001000000010100010001101101000101100100000010110010010001001000100000111100101001111100100000111101111001111100000001010001000100100100010100010001111010001001000000111110000100010010100100000010000100010100000100000000000101000100010010010001010001001000101000100100000010000000010001000100010001001000010001011110010001000000010100110001001001000101000100100010100010010001001000100000111100010000111000100000111101000100111000000001001101000100100100010100010001111010001000111000011100000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        String maskString = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000001110000000000000000000000000000000000001111111101111111101111101111101111111111100000011111011101111111100111111110011111111111001111100111110000111111110111111111111110111111111111111111000001111101110111111111011111111101111111111111111111111111100011111111111111111111111011111111111111111100000111110111011111111101111111110111111111111111111111111110011111111111111111111111011111111111111111110000011111011101111111110111111111111111111111111101111111111001111111111111111111111001111111111111111111000001111111110111111111011111011111111111101111110111111111100111111111111111111111100111111111111111111100000111111111011111111101111101111111111110111111111111111110011111110111011111111110011111111111111111110000011111111101111111110111110111111111111011111111111111111000111111011100111110111000111111111111111110000001111111110111111111011111011101111111101110111110011111000000000000000000000000000000000011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        return this._DecodeImageString_maskString_fore_back_width_height_(imageString, maskString, this.foreColor(), this.backColor(), 106, 16);
    }

    private Image _centerSpectraButtonImage() {
        String imageString = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000010000000000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000111000011100010110001110001110001010000000111001111000111000011100011100101000111000010001001000100110010001000100010011000000010001010001010001001000100010001100000001000100000011111001000100010001111100100000000010000100010111110010000000100010000011110001000000100000010001000100010000001000000000011001000101000000100000001000100001000100010001001000100100010001000100010010000000010001010001010001001000100010001000010001000011100001110001000100001000111000100000000011100111100011100001110000010010000011110000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        String maskString = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000000000011100000000000000000000000000000000000011100000000000000000000000000000000000000000000111000000000000000111110011111011111101111101111101111100000111111111110111110011111011111111110111110011111111111111111111111111111111111111000011111111111111111111111111111111111101111110111111111111111111111111111111111111110000111111111111111111111111111111111111011111101110111111111111111110111011111111111000001111111110111111111111011101110111101111111011101111111111111011101110111111111100000011111111101111111111110111011101110011111110111111111111111110111011111111111111000000111111111111111111111111110111111100111111101111111111111111101110111111111111110000001111111111111111111111111101111111001111111001111100111110111011100111011111011100000001111111111101111100111110001111110001111110000000000000000000000000000000000000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        return this._DecodeImageString_maskString_fore_back_width_height_(imageString, maskString, this.foreColor(), this.backColor(), 86, 16);
    }

    private Image _cutOffButtonImage() {
        String imageString = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000100000000000000000010000000000000001000100000000000000000001000000000000000100010000011100010001001110000000111000111011100010001001000100010000000100010001000100001000000100010001000000010001000100010000100000010001000100000001000100010001000010001001001100010000000100010001000100000111000011010000100000001110000100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        String maskString = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111011100000000000000001110000000000000111111110000000000000000111000000000000011111111001111101110111111110000011111011111111101111111111011111111000011111111111111110111111111101111111100001111111111111111011101111110111011100000111011101110111001110111111111101110000011101110111011100111111111111110111100001111111011101110011111111111111011110000111111101110111000111110011111100111000001111100111011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        return this._DecodeImageString_maskString_fore_back_width_height_(imageString, maskString, this.foreColor2(), this.backColor2(), 40, 16);
    }

    private Image _DecodeImageString_maskString_fore_back_width_height_(String imageString, String maskString, Color foreColor, Color backColor, int x, int y) {
        int[] imagePixels = new int[x * y];
        int i = 0;
        while (i < x * y) {
            int imagePixel = Integer.parseInt(imageString.substring(i, i + 1), 2);
            int maskPixel = Integer.parseInt(maskString.substring(i, i + 1), 2);
            int pixel = imagePixel != 0 ? foreColor.getRGB() : (maskPixel != 0 ? backColor.getRGB() : 0);
            imagePixels[i] = pixel;
            ++i;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(x, y, imagePixels, 0, x));
        return image;
    }

    private Image _freehandImageButtonImage() {
        String imageString = "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000100000000000000000000000100000010000000000000000000000000000000001000000000000000000000100000000000000000000000100000000000000000000000000000000000000001000000000000000000000100000000000000000000000100000000000000000000000000000000000000011101010001110000111000101100001110010110000111100000010010110100001110001111001110000001001100010001001000100110010000001011001001000100000010011011010000001010010010001000001001000011111001111100100010001111010001001000100000010010010010001111011110011111000001001000010000001000000100010010001010001001000100000010010010010010001010000010000000001001000010001001000100100010010001010001001000100000010010010010010001011110010001000001001000001110000111000100010001111010001000111100000010010010010001111010001001110000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        String maskString = "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000001110000000000000000000001110000111000000000000000000000000000000011110000000000000000001110000000000000000000001110000111000000000000000000000000000000011110000000000000000001110000000000000000000001110000111000000000000000000000000000000111111111011111001111101111110011111111111001111110000111111111110011111011111111111000111111111111111111111111111111011111111111111111110000111111111111011111111111111111100111111111111111111111111111111011111111111111111110000111111111111011111111111111111100011111110111111111111111111111111111111111111101110000111111111111111111111111111111100011111100111111111111111110111111111111011111101110000111111111111111111111111111111100011111100111111111111111110111111111111011111111110000111111111111111111111111111111100011111100111111111111111110111111111111011111111110000111111111111111111111111111111100011111100011111001111101110111011111111011101111110000111111111111011111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        return this._DecodeImageString_maskString_fore_back_width_height_(imageString, maskString, this.foreColor(), this.backColor(), 87, 16);
    }

    private Image _iconAreaButtonImage() {
        String imageString = "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000010000000000000000000000000000000000000000000000000000000100000000000000000010000001001011010000111000111100111000000001110001000101110001110001011000111000001001101101000000101001001000100000010001000101000100010001001100100010000001001001001000111101111001111100000011111000010000100011111001000100010000001001001001001000101000001000000000010000000010000100010000001000100010000001001001001001000101111001000100000010001000101000100010001001000100010000001001001001000111101000100111000000001110001000100010001110001000100001000000000000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        String maskString = "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000001110000000000000000111000011100000000000000000000000000000000000000000000001110000000000000000111000011111111111001111101111111111100000011111011101111111011111011111101111100011111111111101111111111111111110000111111111111111111111111111111111111100011111111111101111111111111111110000111111111111111111111111111111111111100011111111111111111111111111111110000111111101111101110111111111111110111000011111111111111111111111111111110000111111101111101110111111111101110111000011111111111111111111111111111110000111111111111111111111111111101110111100011111111111111111111111111111110000111111111111111111111111111101110111100011111111111101111111111111111100000011111011101110111011111011101110011100000000000000000000001111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        return this._DecodeImageString_maskString_fore_back_width_height_(imageString, maskString, this.foreColor(), this.backColor(), 75, 16);
    }

    private Image _imageSearchButtonImage() {
        String imageString = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000001000000000000000000000000000000000000000100000000011100011100001110010100011100010110000010001010001000000101100010001001100100000100001111100011110100001000000100010000001100100000010001010000100000010001000010001010001001000101000010001001000100000111000111000011110100000111000100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        String maskString = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000111000000000000000000000000000000000000011100000001111101111100111111111101111101111110001111111111111011111111111111111111111100111111111111101111111111111111111111110011111111111111111111111011101111111111001111111111111111111111001110111111011100111111111111111111111100111111111101110011111111111111111111110011111111110111000111110111110011111111000111110111011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        return this._DecodeImageString_maskString_fore_back_width_height_(imageString, maskString, this.foreColor2(), this.backColor2(), 40, 16);
    }

    private Image _menuButtonImage() {
        String imageString = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000000000000000000000000001000000000000000000000000000000000000000100000000000000000000000000000000000000010010110100001110001111001110000111000001001101101000000101001001000100100010000100100100100011110111100111110001000000010010010010010001010000010000000011000001001001001001000101111001000100100010001110100100100011110100010011100001110000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        String maskString = "0000000000000000000000000000000000000000000000000000000000000000000000000000000011111000000000000000000000000000000000001111100000000000000000000000000000000000111110000000000000000000000000000000000001111111111100111110111111111110011111000111111111111011111111111111111111111110011111111111101111111111111111111111111001111111111111111111111111111111111111100111111111111111111111111111111111111110111111111111111111111111111111111111111011111111111111111111111111111111111111101111111111111011111111111111111001111100000000000000000000001111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        return this._DecodeImageString_maskString_fore_back_width_height_(imageString, maskString, this.foreColor2(), this.backColor2(), 40, 16);
    }

    private Image _nineColorsButtonImage() {
        String imageString = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000010000000000000000000001011000010101100001110000000011100001110000100111000101000111000011001000101100100100010000001000100100010001010001001100010001000100010001010001001111100000010000001000100010100010010000010000001000100010100010010000000000100000010001000101000100100000011000010001000101000100100010000001000100100010001010001001000010001000100010001010001000111000000001110000111000010011100010000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        String maskString = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000111000000000000000000000000000111000000000000000000000000000000001110000000000000000000000000001110000000000000000000000000000000011100000000000000000001111110011111111001111100000011111001111100111111110111110111110011111110111111111111111100001111111111111101111111111111111111110111111101111111111111111000011111111111111011111111111111111111101111111011111111111111110000111011111101110111110111111101111111011101110111110111111111100001110111111011101111101111110011111110111011101111101111111111000011111111111111011111111111100111111101110111011111011111111110000111111111111110111111111111001111111011101110111110111011111000000111110011111001111111101110001111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        return this._DecodeImageString_maskString_fore_back_width_height_(imageString, maskString, this.foreColor(), this.backColor(), 65, 16);
    }

    private Image _typicalColorButtonImage() {
        String imageString = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000100000000000000000000100000000000000001000000000000000000000000000000001000000000000000000001000000000000000010000000000000000000000000000000010000000000000000000010000000000000001110010001011110001001110000111000100000011100001110000100111000101000001000100010100010010100010000001001000001000100100010001010001001100000010000101001000100101000000011110010000010000001000100010100010010000000100001010010001001010000001000100100000100000010001000101000100100000001000001000100010010100010010001001000001000100100010001010001001000000001000010001111000100111000011110010000001110000111000010011100010000000000001000010000000000000000000000000000000000000000000000000000000000000000100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        String maskString = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000111000000000000000000111000000000000001110000000000000011100000000000001110000000000000000001110000000000000011100000000000000111000000000000011100000000000000000011100000000000001111111101111111101111111100111110111000011111001111100111111110111110011111111011111111111111111101111111110001111111111111101111111111111100111111111111111111111111111011111111100011111111111111011111111111111000111011111111101111111101111111111111000111011111101110111110111111100001110011111111011111111011111111111110001110111111011101111101111110000011110111111111111111111111111111111100011111111111111011111111111100000111101111011111111111111111111111111000111111111111110111111111111000000111111110111111011111111001111111110000111110011111001111111101110000000001111001110000000000000000000000000000000000000000000000000000000000000011100011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        return this._DecodeImageString_maskString_fore_back_width_height_(imageString, maskString, this.foreColor(), this.backColor(), 71, 16);
    }

    public boolean allSwitchOff() {
        return !this.typicalColorSwitch().value() && !this.averageGraySwitch().value() && !this.nineColorsSwitch().value() && !this.iconAreaSwitch().value() && !this.centerSpectraSwitch().value() && !this.freehandImageSwitch().value();
    }

    private Object assert_do_ensure_(StBlockClosure asserBlock, StBlockClosure doBlock, StBlockClosure ensureBlock) {
        return null;
    }

    public Color averageGray() {
        return StColorValue.Brightness_((double)Math.max(0.0, Math.min(this.averageGrayModel().value() / 100.0, 1.0)));
    }

    public IsrButtonModel averageGrayButton() {
        IsrImageSearcher self = this;
        StBlockClosure block = new StBlockClosure(self){
            /* synthetic */ IsrImageSearcher val$self;

            public Object value_(Object o) {
                this.val$self.averageGrayButtonAction();
                return null;
            }
            {
                this.val$self = val$self;
            }
        };
        return IsrButtonModel.Value_visual_action_(false, this._averageGrayButtonImage(), block);
    }

    public void averageGrayButtonAction() {
        IsrGaugeModel model = this.averageGrayModel();
        Frame[] frames = model.builder().frames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                frames[i].toFront();
            } else {
                frames[i].show();
            }
            ++i;
        }
        if (frames.length == 0) {
            Frame window = model.open();
            window.setTitle("Luminance");
        }
    }

    public IsrGaugeModel averageGrayModel() {
        if (this.averageGrayModel == null) {
            double[] array = new double[]{0.0, 100.0, 10.0, 1.0};
            this.averageGrayModel = IsrGaugeModel.Value_range_(0.0, array);
        }
        return this.averageGrayModel;
    }

    public IsrButtonModel averageGraySwitch() {
        if (this.averageGraySwitch == null) {
            IsrImageSearcher self = this;
            StBlockClosure block = new StBlockClosure(self){
                /* synthetic */ IsrImageSearcher val$self;

                public Object value_(Object o) {
                    this.val$self.averageGraySwitchAction();
                    return null;
                }
                {
                    this.val$self = val$self;
                }
            };
            this.averageGraySwitch = IsrButtonModel.Value_visual_action_(false, this.offImage(), block);
        }
        return this.averageGraySwitch;
    }

    public void averageGraySwitchAction() {
        IsrButtonModel averageGraySwitch;
        averageGraySwitch.value_(!(averageGraySwitch = this.averageGraySwitch()).value());
        if (averageGraySwitch.value()) {
            averageGraySwitch.visual_(this.onImage());
        } else {
            averageGraySwitch.visual_(this.offImage());
        }
    }

    protected Color backColor() {
        return Color.getHSBColor(0.0f, 0.0f, 0.9f);
    }

    protected Color backColor2() {
        return Color.getHSBColor(0.0f, 0.0f, 0.95f);
    }

    public Isr2dPoint centerSpectra() {
        return this.centerSpectraModel().xy();
    }

    public IsrButtonModel centerSpectraButton() {
        IsrImageSearcher self = this;
        StBlockClosure block = new StBlockClosure(self){
            /* synthetic */ IsrImageSearcher val$self;

            public Object value_(Object o) {
                this.val$self.centerSpectraButtonAction();
                return null;
            }
            {
                this.val$self = val$self;
            }
        };
        return IsrButtonModel.Value_visual_action_(false, this._centerSpectraButtonImage(), block);
    }

    public void centerSpectraButtonAction() {
        IsrSpotModel model = this.centerSpectraModel();
        Frame[] frames = model.builder().frames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                frames[i].toFront();
            } else {
                frames[i].show();
            }
            ++i;
        }
        if (frames.length == 0) {
            Frame window = model.open();
            window.setTitle("Center");
        }
    }

    public IsrSpotModel centerSpectraModel() {
        if (this.centerSpectraModel == null) {
            this.centerSpectraModel = IsrSpotModel.Xy_(new Isr2dPoint(0.5, 0.5));
        }
        return this.centerSpectraModel;
    }

    public IsrButtonModel centerSpectraSwitch() {
        if (this.centerSpectraSwitch == null) {
            IsrImageSearcher self = this;
            StBlockClosure block = new StBlockClosure(self){
                /* synthetic */ IsrImageSearcher val$self;

                public Object value_(Object o) {
                    this.val$self.centerSpectraSwitchAction();
                    return null;
                }
                {
                    this.val$self = val$self;
                }
            };
            this.centerSpectraSwitch = IsrButtonModel.Value_visual_action_(false, this.offImage(), block);
        }
        return this.centerSpectraSwitch;
    }

    public void centerSpectraSwitchAction() {
        IsrButtonModel centerSpectraSwitch;
        centerSpectraSwitch.value_(!(centerSpectraSwitch = this.centerSpectraSwitch()).value());
        if (centerSpectraSwitch.value()) {
            centerSpectraSwitch.visual_(this.onImage());
        } else {
            centerSpectraSwitch.visual_(this.offImage());
        }
    }

    public double cutOff() {
        return Math.max(0.0, Math.min(this.cutOffModel().value(), 1.0));
    }

    public IsrButtonModel cutOffButton() {
        IsrImageSearcher self = this;
        StBlockClosure block = new StBlockClosure(self){
            /* synthetic */ IsrImageSearcher val$self;

            public Object value_(Object o) {
                this.val$self.cutOffButtonAction();
                return null;
            }
            {
                this.val$self = val$self;
            }
        };
        return IsrButtonModel.Value_visual_action_(false, this._cutOffButtonImage(), block);
    }

    public void cutOffButtonAction() {
        IsrGaugeModel model = this.cutOffModel();
        Frame[] frames = model.builder().frames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                frames[i].toFront();
            } else {
                frames[i].show();
            }
            ++i;
        }
        if (frames.length == 0) {
            Frame window = model.open();
            window.setTitle("Cut");
        }
    }

    public IsrGaugeModel cutOffModel() {
        if (this.cutOffModel == null) {
            double[] array = new double[]{0.0, 1.0, 10.0, 0.01};
            this.cutOffModel = IsrGaugeModel.Value_range_(0.0, array);
        }
        return this.cutOffModel;
    }

    public StView defaultView() {
        if (StApplicationModel.GetDefaultViewMode() == 0) {
            return new IsrImageSearcherViewAwt();
        }
        return StApplicationModel.CreateView((String)"sra.isr.image.searcher.IsrImageSearcherViewSwing");
    }

    public static IsrImageSearcher DirectoryName_(String aString) {
        return IsrImageSearcher.ImageFolder_(IsrImageFolder.DirectoryName_(aString));
    }

    public static void FlushImages() {
        OnImage = null;
        OffImage = null;
    }

    protected Color foreColor() {
        return Color.blue;
    }

    protected Color foreColor2() {
        return StColorValue.Brown;
    }

    public StImage freehandImage() {
        return this.freehandImageModel().getImage();
    }

    public IsrButtonModel freehandImageButton() {
        IsrImageSearcher self = this;
        StBlockClosure block = new StBlockClosure(self){
            /* synthetic */ IsrImageSearcher val$self;

            public Object value_(Object o) {
                this.val$self.freehandImageButtonAction();
                return null;
            }
            {
                this.val$self = val$self;
            }
        };
        return IsrButtonModel.Value_visual_action_(false, this._freehandImageButtonImage(), block);
    }

    public void freehandImageButtonAction() {
        IsrFreehandModel model = this.freehandImageModel();
        Frame[] frames = model.builder().frames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                frames[i].toFront();
            } else {
                frames[i].show();
            }
            ++i;
        }
        if (frames.length == 0) {
            Frame window = model.open();
            window.setTitle("Freehand");
        }
    }

    public IsrFreehandModel freehandImageModel() {
        if (this.freehandImageModel == null) {
            this.freehandImageModel = new IsrFreehandModel();
        }
        return this.freehandImageModel;
    }

    public IsrButtonModel freehandImageSwitch() {
        if (this.freehandImageSwitch == null) {
            IsrImageSearcher self = this;
            StBlockClosure block = new StBlockClosure(self){
                /* synthetic */ IsrImageSearcher val$self;

                public Object value_(Object o) {
                    this.val$self.freehandImageSwitchAction();
                    return null;
                }
                {
                    this.val$self = val$self;
                }
            };
            this.freehandImageSwitch = IsrButtonModel.Value_visual_action_(false, this.offImage(), block);
        }
        return this.freehandImageSwitch;
    }

    public void freehandImageSwitchAction() {
        IsrButtonModel freehandImageSwitch;
        freehandImageSwitch.value_(!(freehandImageSwitch = this.freehandImageSwitch()).value());
        if (freehandImageSwitch.value()) {
            freehandImageSwitch.visual_(this.onImage());
        } else {
            freehandImageSwitch.visual_(this.offImage());
        }
    }

    public static IsrImageSearcher FromUser() {
        IsrImageFolder imageFolder = IsrImageFolder.FromUser();
        if (imageFolder == null) {
            return null;
        }
        IsrImageSearcher imageSearcher = IsrImageSearcher.ImageFolder_(imageFolder);
        return imageSearcher;
    }

    public Rectangle iconArea() {
        return new Rectangle(0, 0, (int)Math.round(this.iconAreaModel().xy().x() * 100.0), (int)Math.round(this.iconAreaModel().xy().y() * 100.0));
    }

    public IsrButtonModel iconAreaButton() {
        IsrImageSearcher self = this;
        StBlockClosure block = new StBlockClosure(self){
            /* synthetic */ IsrImageSearcher val$self;

            public Object value_(Object o) {
                this.val$self.iconAreaButtonAction();
                return null;
            }
            {
                this.val$self = val$self;
            }
        };
        return IsrButtonModel.Value_visual_action_(false, this._iconAreaButtonImage(), block);
    }

    public void iconAreaButtonAction() {
        IsrAreaModel model = this.iconAreaModel();
        Frame[] frames = model.builder().frames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                frames[i].toFront();
            } else {
                frames[i].show();
            }
            ++i;
        }
        if (frames.length == 0) {
            Frame window = model.open();
            window.setTitle("Extent");
        }
    }

    public IsrAreaModel iconAreaModel() {
        if (this.iconAreaModel == null) {
            this.iconAreaModel = IsrAreaModel.Xy_(new Isr2dPoint(0.5, 0.5));
        }
        return this.iconAreaModel;
    }

    public IsrButtonModel iconAreaSwitch() {
        if (this.iconAreaSwitch == null) {
            IsrImageSearcher self = this;
            StBlockClosure block = new StBlockClosure(self){
                /* synthetic */ IsrImageSearcher val$self;

                public Object value_(Object o) {
                    this.val$self.iconAreaSwitchAction();
                    return null;
                }
                {
                    this.val$self = val$self;
                }
            };
            this.iconAreaSwitch = IsrButtonModel.Value_visual_action_(false, this.offImage(), block);
        }
        return this.iconAreaSwitch;
    }

    public void iconAreaSwitchAction() {
        IsrButtonModel iconAreaSwitch;
        iconAreaSwitch.value_(!(iconAreaSwitch = this.iconAreaSwitch()).value());
        if (iconAreaSwitch.value()) {
            iconAreaSwitch.visual_(this.onImage());
        } else {
            iconAreaSwitch.visual_(this.offImage());
        }
    }

    public IsrImageBrowser imageBrowser() {
        if (this.imageBrowser == null) {
            this.imageBrowser = IsrImageBrowser.ImageObjects_(new IsrImageObject[0]);
            this.imageBrowser.slaveFlag_(true);
        }
        return this.imageBrowser;
    }

    public IsrImageFolder imageFolder() {
        return this.imageFolder;
    }

    public static IsrImageSearcher ImageFolder_(IsrImageFolder imageFolder) {
        IsrImageSearcher model = new IsrImageSearcher();
        model.imageFolder_(imageFolder);
        return model;
    }

    public void imageFolder_(IsrImageFolder anImageFolder) {
        this.imageFolder = anImageFolder;
        this.imageObjects();
    }

    public IsrImageObject[] imageObjects() {
        return this.imageFolder().imageObjects();
    }

    public IsrButtonModel imageSearchButton() {
        IsrImageSearcher self = this;
        StBlockClosure block = new StBlockClosure(self){
            /* synthetic */ IsrImageSearcher val$self;

            public Object value_(Object o) {
                this.val$self.imageSearchButtonAction();
                return null;
            }
            {
                this.val$self = val$self;
            }
        };
        return IsrButtonModel.Value_visual_action_(false, this._imageSearchButtonImage(), block);
    }

    public void imageSearchButtonAction() {
        this.search();
    }

    private StImage label_fore_back_(String aString, Color foreColor, Color backColor) {
        int i;
        Point[] points;
        StImage figure = null;
        StImage shape = null;
        Image pixmap = null;
        Graphics gc = null;
        String text = aString;
        FontMetrics fontMetrics = SystemResourceSupport.getFontMetrics((Font)SystemResourceSupport.getFont());
        int width = fontMetrics.stringWidth(text);
        int base = fontMetrics.getAscent();
        int height = base + fontMetrics.getDescent();
        pixmap = SystemResourceSupport.createImage((int)(width + 2), (int)(height + 2));
        try {
            gc = pixmap.getGraphics();
            gc.setColor(backColor);
            points = IsrImageProcessor.EightPoints();
            i = 0;
            while (i < points.length) {
                gc.drawString(text, 1 + points[i].x, 1 + points[i].y + base);
                ++i;
            }
            gc.setColor(foreColor);
            gc.drawString(text, 1, 1 + base);
            figure = new StImage(pixmap);
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            gc.dispose();
            pixmap.flush();
            throw throwable;
        }
        Object var15_19 = null;
        gc.dispose();
        pixmap.flush();
        pixmap = SystemResourceSupport.createImage((int)(width + 2), (int)(height + 2));
        try {
            gc = pixmap.getGraphics();
            gc.setColor(Color.black);
            points = IsrImageProcessor.EightPoints();
            i = 0;
            while (i < points.length) {
                gc.drawString(text, 1 + points[i].x, 1 + points[i].y + base);
                ++i;
            }
            gc.drawString(text, 1, 1 + base);
            shape = new StImage(pixmap);
        }
        catch (Throwable throwable) {
            var15_19 = null;
            gc.dispose();
            pixmap.flush();
            throw throwable;
        }
        var15_19 = null;
        gc.dispose();
        pixmap.flush();
        shape = shape.convertToPalette_(IsrImageProcessor._WhiteBlackPalette());
        int white = Color.white.getRGB();
        int coverage = 0xFFFFFF;
        int j = 0;
        while (j < shape.bits().length) {
            if (shape.bits()[j] == white) {
                shape.bits()[j] = coverage;
            }
            ++j;
        }
        StImage iconImage = IsrImageProcessor._MakeImage_Shape_(figure, shape);
        return iconImage;
    }

    protected PopupMenu menu() {
        StMenuModel rootMenu = new StMenuModel();
        StMenu searcherMenu = new StMenu("Menu");
        searcherMenu.add(this.createMenuItem("open", "openImageSearcher"));
        searcherMenu.addSeparator();
        searcherMenu.add(this.createMenuItem("cut off", "setCutOff"));
        searcherMenu.add(this.createMenuItem("search", "searchImages"));
        searcherMenu.addSeparator();
        searcherMenu.add(this.createMenuItem("update", "updateImageSearcher"));
        rootMenu.add((StMenuItem)searcherMenu);
        StMenu menu = (StMenu)rootMenu.getItem("Menu");
        PopupMenu popupMenu = StMenuViewForAwt.CreatePopupMenu((StMenu)menu);
        return popupMenu;
    }

    public IsrButtonModel menuButton() {
        Image buttonImage = null;
        IsrImageSearcher self = this;
        StBlockClosure block = new StBlockClosure(self){
            /* synthetic */ IsrImageSearcher val$self;

            public Object value_value_(Object o1, Object o2) {
                IsrButtonModel cfr_ignored_0 = (IsrButtonModel)((Object)o1);
                MouseEvent event = (MouseEvent)o2;
                this.val$self.menuButtonAction(event);
                return null;
            }
            {
                this.val$self = val$self;
            }
        };
        if (this.imageFolder() == null || this.imageFolder().directoryName() == null) {
            buttonImage = this._menuButtonImage();
        } else {
            String text;
            String aString = this.imageFolder().directoryName();
            int charCount = 24;
            if (aString.length() > charCount) {
                int half = charCount / 2;
                text = aString.substring(0, half - 1);
                text = String.valueOf(text) + "...";
                text = String.valueOf(text) + aString.substring(aString.length() - half + 2, aString.length());
            } else {
                text = aString;
            }
            buttonImage = this.label_fore_back_(text, this.foreColor2(), this.backColor2()).image();
        }
        return IsrButtonModel.Value_visual_action_(false, buttonImage, block);
    }

    public void menuButtonAction(MouseEvent event) {
        Point point = event.getPoint();
        Component component = event.getComponent();
        if (this.menu == null) {
            this.menu = this.menu();
            component.add(this.menu);
        }
        this.menu.show(component, point.x, point.y);
    }

    public Color[] nineColors() {
        return this.nineColorsModel().colors();
    }

    public IsrButtonModel nineColorsButton() {
        IsrImageSearcher self = this;
        StBlockClosure block = new StBlockClosure(self){
            /* synthetic */ IsrImageSearcher val$self;

            public Object value_(Object o) {
                this.val$self.nineColorsButtonAction();
                return null;
            }
            {
                this.val$self = val$self;
            }
        };
        return IsrButtonModel.Value_visual_action_(false, this._nineColorsButtonImage(), block);
    }

    public void nineColorsButtonAction() {
        Isr9ColorsModel model = this.nineColorsModel();
        Frame[] frames = model.builder().frames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                frames[i].toFront();
            } else {
                frames[i].show();
            }
            ++i;
        }
        if (frames.length == 0) {
            Frame window = model.open();
            window.setTitle("9 Colors");
        }
    }

    public Isr9ColorsModel nineColorsModel() {
        if (this.nineColorsModel == null) {
            this.nineColorsModel = Isr9ColorsModel.Colors_(new Color[9]);
        }
        return this.nineColorsModel;
    }

    public IsrButtonModel nineColorsSwitch() {
        if (this.nineColorsSwitch == null) {
            IsrImageSearcher self = this;
            StBlockClosure block = new StBlockClosure(self){
                /* synthetic */ IsrImageSearcher val$self;

                public Object value_(Object o) {
                    this.val$self.nineColorsSwitchAction();
                    return null;
                }
                {
                    this.val$self = val$self;
                }
            };
            this.nineColorsSwitch = IsrButtonModel.Value_visual_action_(false, this.offImage(), block);
        }
        return this.nineColorsSwitch;
    }

    public void nineColorsSwitchAction() {
        IsrButtonModel nineColorsSwitch;
        nineColorsSwitch.value_(!(nineColorsSwitch = this.nineColorsSwitch()).value());
        if (nineColorsSwitch.value()) {
            nineColorsSwitch.visual_(this.onImage());
        } else {
            nineColorsSwitch.visual_(this.offImage());
        }
    }

    protected Image offImage() {
        if (OffImage == null) {
            String imageString = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
            String maskString = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
            OffImage = this._DecodeImageString_maskString_fore_back_width_height_(imageString, maskString, this.foreColor(), this.backColor(), 8, 16);
        }
        return OffImage;
    }

    protected Image onImage() {
        if (OnImage == null) {
            String imageString = "00000000000000000000000000000000000000000000000001000100001010000001000000010000001010000100010000000000000000000000000000000000";
            String maskString = "00000000000000000000000000000000000000001110111011111110111111100111110001111100111111101111111011101110000000000000000000000000";
            OnImage = this._DecodeImageString_maskString_fore_back_width_height_(imageString, maskString, this.foreColor(), this.backColor(), 8, 16);
        }
        return OnImage;
    }

    public void openImageBrowser_(IsrImageObject[] imageObjects) {
        IsrImageBrowser browser = this.imageBrowser();
        browser.imageObjects_(imageObjects);
        Frame[] frames = browser.builder().frames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                frames[i].toFront();
            } else {
                frames[i].show();
            }
            ++i;
        }
        if (frames.length == 0) {
            browser.open();
        }
    }

    public IsrImageSearcher openImageSearcher() {
        IsrImageSearcher imageSearcher = IsrImageSearcher.FromUser();
        if (imageSearcher == null) {
            return null;
        }
        imageSearcher.open();
        return imageSearcher;
    }

    public void openNewImageBrowser_(IsrImageObject[] imageObjects) {
        IsrImageBrowser browser = IsrImageBrowser.ImageObjects_(imageObjects);
        browser.open();
    }

    public void search() {
        if (this.allSwitchOff()) {
            this.openImageBrowser_(this.imageObjects());
            return;
        }
        IsrImageObject[] imageObjects = this.searchAux();
        this.openImageBrowser_(imageObjects);
    }

    public IsrImageObject[] searchAux() {
        Float[] similarities;
        float[] collection = new float[this.imageObjects().length];
        int i = 0;
        while (i < collection.length) {
            collection[i] = 0.0f;
            ++i;
        }
        int count = 0;
        if (this.typicalColorSwitch().value()) {
            similarities = this.similaritiesTypicalColor_(this.typicalColor());
            if (similarities == null) {
                return null;
            }
            i = 0;
            while (i < collection.length) {
                collection[i] = collection[i] + similarities[i].floatValue();
                ++i;
            }
            ++count;
        }
        if (this.averageGraySwitch().value()) {
            similarities = this.similaritiesAverageGray_(this.averageGray());
            if (similarities == null) {
                return null;
            }
            i = 0;
            while (i < collection.length) {
                collection[i] = collection[i] + similarities[i].floatValue();
                ++i;
            }
            ++count;
        }
        if (this.nineColorsSwitch().value()) {
            similarities = this.similaritiesNineColors_(this.nineColors());
            if (similarities == null) {
                return null;
            }
            i = 0;
            while (i < collection.length) {
                collection[i] = collection[i] + similarities[i].floatValue();
                ++i;
            }
            ++count;
        }
        if (this.iconAreaSwitch().value()) {
            similarities = this.similaritiesIconArea_(this.iconArea());
            if (similarities == null) {
                return null;
            }
            i = 0;
            while (i < collection.length) {
                collection[i] = collection[i] + similarities[i].floatValue();
                ++i;
            }
            ++count;
        }
        if (this.centerSpectraSwitch().value()) {
            similarities = this.similaritiesCenterSpectra_(this.centerSpectra());
            if (similarities == null) {
                return null;
            }
            i = 0;
            while (i < collection.length) {
                collection[i] = collection[i] + similarities[i].floatValue();
                ++i;
            }
            ++count;
        }
        if (this.freehandImageSwitch().value()) {
            similarities = this.similaritiesFreehandImage_(this.freehandImage());
            if (similarities == null) {
                return null;
            }
            i = 0;
            while (i < collection.length) {
                collection[i] = collection[i] + similarities[i].floatValue();
                ++i;
            }
            ++count;
        }
        StBlockClosure sortBlock = new StBlockClosure(){

            public Object value_value_(Object assoc1, Object assoc2) {
                return new Boolean(((Float)((StAssociation)assoc1).key()).floatValue() >= ((Float)((StAssociation)assoc2).key()).floatValue());
            }
        };
        StSortedCollection similarityCollection = new StSortedCollection(sortBlock);
        int index = 0;
        while (index < collection.length) {
            similarityCollection.add_((Object)new StAssociation((Object)new Float(collection[index] / (float)count), (Object)new Integer(index)));
            ++index;
        }
        Object[] sortCollection = similarityCollection._asArray();
        Vector<IsrImageObject> imageObjectVector = new Vector<IsrImageObject>(this.imageObjects().length);
        float cutoff = (float)this.cutOff();
        i = 0;
        while (i < sortCollection.length) {
            StAssociation assoc = (StAssociation)sortCollection[i];
            index = i;
            float similarity = ((Float)assoc.key()).floatValue();
            IsrImageObject object = this.imageObjects()[(Integer)assoc.value()];
            if (similarity >= cutoff) {
                imageObjectVector.addElement(object);
                if (imageObjectVector.size() < 10) {
                    if (imageObjectVector.size() < 2) {
                        System.out.println();
                    }
                    System.out.print(String.valueOf(String.valueOf(index)) + ": ");
                    System.out.print((double)((int)((double)similarity / 0.01)) * 0.01);
                    if (imageObjectVector.size() % 3 == 0) {
                        System.out.println();
                    } else {
                        System.out.print("  ");
                    }
                    System.out.flush();
                }
            }
            ++i;
        }
        Object[] results = new IsrImageObject[imageObjectVector.size()];
        imageObjectVector.copyInto(results);
        return results;
    }

    public void searchImages() {
        this.imageSearchButtonAction();
    }

    public void setCutOff() {
        this.cutOffButtonAction();
    }

    public Float[] similaritiesAverageGray_(Color grayValue) {
        int size = this.imageObjects().length;
        IsrImageSearcher self = this;
        Vector collection = new Vector(size);
        Color gray = grayValue;
        IsrProgress aProgress = new IsrProgress();
        aProgress.do_(new StBlockClosure(size, self, collection, gray){
            /* synthetic */ int val$size;
            /* synthetic */ IsrImageSearcher val$self;
            /* synthetic */ Vector val$collection;
            /* synthetic */ Color val$gray;

            public Object value_(Object anObject) {
                IsrProgress progress = (IsrProgress)((Object)anObject);
                int count = 1;
                progress.message_("average luminance ... ");
                int i = 0;
                while (i < this.val$self.imageObjects().length) {
                    IsrImageObject each = this.val$self.imageObjects()[i];
                    float value = (float)count / (float)this.val$size;
                    progress.value_(value);
                    float similarity = this.val$self.similarityAverageGray_with_(each, this.val$gray);
                    this.val$collection.addElement(new Float(similarity));
                    ++count;
                    ++i;
                }
                return null;
            }
            {
                this.val$size = val$size;
                this.val$self = val$self;
                this.val$collection = val$collection;
                this.val$gray = val$gray;
            }
        });
        Float[] results = new Float[collection.size()];
        collection.copyInto(results);
        return results;
    }

    public Float[] similaritiesCenterSpectra_(Isr2dPoint aPoint) {
        int size = this.imageObjects().length;
        IsrImageSearcher self = this;
        Vector collection = new Vector(size);
        Isr2dPoint point = aPoint;
        IsrProgress aProgress = new IsrProgress();
        aProgress.do_(new StBlockClosure(size, self, collection, point){
            /* synthetic */ int val$size;
            /* synthetic */ IsrImageSearcher val$self;
            /* synthetic */ Vector val$collection;
            /* synthetic */ Isr2dPoint val$point;

            public Object value_(Object anObject) {
                IsrProgress progress = (IsrProgress)((Object)anObject);
                int count = 1;
                progress.message_("center spectra ... ");
                int i = 0;
                while (i < this.val$self.imageObjects().length) {
                    IsrImageObject each = this.val$self.imageObjects()[i];
                    float value = (float)count / (float)this.val$size;
                    progress.value_(value);
                    float similarity = this.val$self.similarityCenterSpectra_with_(each, this.val$point);
                    this.val$collection.addElement(new Float(similarity));
                    ++count;
                    ++i;
                }
                return null;
            }
            {
                this.val$size = val$size;
                this.val$self = val$self;
                this.val$collection = val$collection;
                this.val$point = val$point;
            }
        });
        Float[] results = new Float[collection.size()];
        collection.copyInto(results);
        return results;
    }

    public Float[] similaritiesFreehandImage_(StImage anImage) {
        int size = this.imageObjects().length;
        IsrImageSearcher self = this;
        Vector collection = new Vector(size);
        StImage image = anImage;
        IsrProgress aProgress = new IsrProgress();
        aProgress.do_(new StBlockClosure(size, self, collection, image){
            /* synthetic */ int val$size;
            /* synthetic */ IsrImageSearcher val$self;
            /* synthetic */ Vector val$collection;
            /* synthetic */ StImage val$image;

            public Object value_(Object anObject) {
                IsrProgress progress = (IsrProgress)((Object)anObject);
                int count = 1;
                progress.message_("freehand image ... ");
                IsrImageAuxiliary imageAux = IsrImageAuxiliary.OriginalImage_(this.val$image);
                Color typicalColor = imageAux.typicalColor();
                Color[] nineColors = imageAux.nineColors();
                StImage xSpectrum = imageAux.xSpectrum();
                StImage ySpectrum = imageAux.ySpectrum();
                StImage renderingImage = imageAux.renderingImage();
                StImage binaryImage = imageAux.binaryImage();
                int i = 0;
                while (i < this.val$self.imageObjects().length) {
                    IsrImageObject each = this.val$self.imageObjects()[i];
                    float value = (float)count / (float)this.val$size;
                    progress.value_(value);
                    float similarity = this.val$self.similarityFreehandImage_typicalColor_nineColor_xSpectrum_ySpectrum_renderingImage_binaryImage_(each, typicalColor, nineColors, xSpectrum, ySpectrum, renderingImage, binaryImage);
                    this.val$collection.addElement(new Float(similarity));
                    ++count;
                    ++i;
                }
                return null;
            }
            {
                this.val$size = val$size;
                this.val$self = val$self;
                this.val$collection = val$collection;
                this.val$image = val$image;
            }
        });
        Float[] results = new Float[collection.size()];
        collection.copyInto(results);
        return results;
    }

    public Float[] similaritiesIconArea_(Rectangle aRectangle) {
        int size = this.imageObjects().length;
        IsrImageSearcher self = this;
        Vector collection = new Vector(size);
        Rectangle rectangle = aRectangle;
        IsrProgress aProgress = new IsrProgress();
        aProgress.do_(new StBlockClosure(size, self, collection, rectangle){
            /* synthetic */ int val$size;
            /* synthetic */ IsrImageSearcher val$self;
            /* synthetic */ Vector val$collection;
            /* synthetic */ Rectangle val$rectangle;

            public Object value_(Object anObject) {
                IsrProgress progress = (IsrProgress)((Object)anObject);
                int count = 1;
                progress.message_("image area ... ");
                StImage image = new StImage(this.val$rectangle.width, this.val$rectangle.height);
                Vector array = IsrImageProcessor.Icon3_size_(image, IsrImageObject.DefaultSize());
                Rectangle box = (Rectangle)array.lastElement();
                int i = 0;
                while (i < this.val$self.imageObjects().length) {
                    IsrImageObject each = this.val$self.imageObjects()[i];
                    float value = (float)count / (float)this.val$size;
                    progress.value_(value);
                    float similarity = this.val$self.similarityIconArea_with_(each, box);
                    this.val$collection.addElement(new Float(similarity));
                    ++count;
                    ++i;
                }
                return null;
            }
            {
                this.val$size = val$size;
                this.val$self = val$self;
                this.val$collection = val$collection;
                this.val$rectangle = val$rectangle;
            }
        });
        Float[] results = new Float[collection.size()];
        collection.copyInto(results);
        return results;
    }

    public Float[] similaritiesNineColors_(Color[] nineColors) {
        int size = this.imageObjects().length;
        IsrImageSearcher self = this;
        Vector collection = new Vector(size);
        Color[] colors = nineColors;
        IsrProgress aProgress = new IsrProgress();
        aProgress.do_(new StBlockClosure(size, self, collection, colors){
            /* synthetic */ int val$size;
            /* synthetic */ IsrImageSearcher val$self;
            /* synthetic */ Vector val$collection;
            /* synthetic */ Color[] val$colors;

            public Object value_(Object anObject) {
                IsrProgress progress = (IsrProgress)((Object)anObject);
                int count = 1;
                progress.message_("nine colors ... ");
                int i = 0;
                while (i < this.val$self.imageObjects().length) {
                    IsrImageObject each = this.val$self.imageObjects()[i];
                    float value = (float)count / (float)this.val$size;
                    progress.value_(value);
                    float similarity = this.val$self.similarityNineColors_with_(each, this.val$colors);
                    this.val$collection.addElement(new Float(similarity));
                    ++count;
                    ++i;
                }
                return null;
            }
            {
                this.val$size = val$size;
                this.val$self = val$self;
                this.val$collection = val$collection;
                this.val$colors = val$colors;
            }
        });
        Float[] results = new Float[collection.size()];
        collection.copyInto(results);
        return results;
    }

    public Float[] similaritiesTypicalColor_(Color colorValue) {
        int size = this.imageObjects().length;
        IsrImageSearcher self = this;
        Vector collection = new Vector(size);
        Color color = colorValue;
        IsrProgress aProgress = new IsrProgress();
        aProgress.do_(new StBlockClosure(size, self, collection, color){
            /* synthetic */ int val$size;
            /* synthetic */ IsrImageSearcher val$self;
            /* synthetic */ Vector val$collection;
            /* synthetic */ Color val$color;

            public Object value_(Object anObject) {
                IsrProgress progress = (IsrProgress)((Object)anObject);
                int count = 1;
                progress.message_("typical color ... ");
                int i = 0;
                while (i < this.val$self.imageObjects().length) {
                    IsrImageObject each = this.val$self.imageObjects()[i];
                    float value = (float)count / (float)this.val$size;
                    progress.value_(value);
                    float similarity = this.val$self.similarityTypicalColor_with_(each, this.val$color);
                    this.val$collection.addElement(new Float(similarity));
                    ++count;
                    ++i;
                }
                return null;
            }
            {
                this.val$size = val$size;
                this.val$self = val$self;
                this.val$collection = val$collection;
                this.val$color = val$color;
            }
        });
        Float[] results = new Float[collection.size()];
        collection.copyInto(results);
        return results;
    }

    public float similarityAverageGray_with_(IsrImageObject imageObject, Color grayValue) {
        double luminance1 = StColorValue._GetLuminance((Color)grayValue);
        double luminance2 = StColorValue._GetLuminance((Color)imageObject.averageGray());
        double luminance = Math.max(luminance1, luminance2) - Math.min(luminance1, luminance2);
        float similarity = 1.0f - (float)luminance;
        similarity = Math.max(0.0f, Math.min(similarity, 1.0f));
        return similarity;
    }

    public float similarityCenterSpectra_with_(IsrImageObject imageObject, Isr2dPoint aPoint) {
        Isr2dPoint point = imageObject.centerSpectra();
        double x = Math.max(aPoint.x(), point.x()) - Math.min(aPoint.x(), point.x());
        double y = Math.max(aPoint.y(), point.y()) - Math.min(aPoint.y(), point.y());
        float similarity = 1.0f - (float)(x + y);
        similarity = Math.max(0.0f, Math.min(similarity, 1.0f));
        return similarity;
    }

    public float similarityFreehandImage_typicalColor_nineColor_xSpectrum_ySpectrum_renderingImage_binaryImage_(IsrImageObject imageObject, Color typicalColor, Color[] nineColors, Object[] xSpectrum, Object[] ySpectrum, StImage renderingImage, StImage binaryImage) {
        double luminance1 = StColorValue._GetLuminance((Color)typicalColor);
        double luminance2 = StColorValue._GetLuminance((Color)imageObject.averageGray());
        double luminance = Math.max(luminance1, luminance2) - Math.min(luminance1, luminance2);
        float similarity = 1.0f - (float)luminance;
        similarity = Math.max(0.0f, Math.min(similarity, 1.0f));
        return similarity;
    }

    public float similarityFreehandImage_typicalColor_nineColor_xSpectrum_ySpectrum_renderingImage_binaryImage_(IsrImageObject imageObject, Color typicalColor, Color[] nineColors, StImage xSpectrum, StImage ySpectrum, StImage renderingImage, StImage binaryImage) {
        float sum = 0.0f;
        int count = 0;
        float similarity = this.similarityTypicalColor_with_(imageObject, typicalColor);
        sum += similarity;
        ++count;
        similarity = this.similarityNineColors_with_(imageObject, nineColors);
        sum += similarity;
        ++count;
        similarity = IsrImageProcessor.Similarity_with_(imageObject.xSpectrum(), xSpectrum);
        sum += similarity;
        ++count;
        similarity = IsrImageProcessor.Similarity_with_(imageObject.ySpectrum(), ySpectrum);
        sum += similarity;
        ++count;
        similarity = IsrImageProcessor.Similarity_with_(imageObject.renderingImage(), renderingImage);
        sum += similarity;
        ++count;
        similarity = IsrImageProcessor.Similarity_with_(imageObject.binaryImage(), binaryImage);
        sum += similarity;
        similarity = sum / (float)(++count);
        similarity = Math.max(0.0f, Math.min(similarity, 1.0f));
        return similarity;
    }

    public float similarityIconArea_with_(IsrImageObject imageObject, Rectangle iconArea) {
        Rectangle area = imageObject.iconArea();
        double w = (double)Math.min(iconArea.width, area.width) / (double)Math.max(iconArea.width, area.width);
        double h = (double)Math.min(iconArea.height, area.height) / (double)Math.max(iconArea.height, area.height);
        float similarity = (float)((w + h) / 2.0);
        similarity = Math.max(0.0f, Math.min(similarity, 1.0f));
        return similarity;
    }

    public float similarityNineColors_with_(IsrImageObject imageObject, Color[] nineColors) {
        Vector<Integer> indexes = new Vector<Integer>();
        Vector<Color> colors1 = new Vector<Color>();
        int index = 0;
        while (index < nineColors.length) {
            if (nineColors[index] != null) {
                indexes.addElement(new Integer(index));
                colors1.addElement(nineColors[index]);
            }
            ++index;
        }
        if (indexes.size() == 0) {
            return -0.0f;
        }
        Vector<Color> colors2 = new Vector<Color>(colors1.size());
        Enumeration enumeration = indexes.elements();
        while (enumeration.hasMoreElements()) {
            index = (Integer)enumeration.nextElement();
            colors2.addElement(imageObject.nineColors()[index]);
        }
        float sum = 0.0f;
        index = 0;
        while (index < colors2.size()) {
            Color c1 = (Color)colors1.elementAt(index);
            Color c2 = (Color)colors2.elementAt(index);
            float r = (float)(Math.max(c1.getRed(), c2.getRed()) - Math.min(c1.getRed(), c2.getRed())) / 255.0f;
            float g = (float)(Math.max(c1.getGreen(), c2.getGreen()) - Math.min(c1.getGreen(), c2.getGreen())) / 255.0f;
            float b = (float)(Math.max(c1.getBlue(), c2.getBlue()) - Math.min(c1.getBlue(), c2.getBlue())) / 255.0f;
            sum += (r + g + b) / 3.0f;
            ++index;
        }
        float similarity = 1.0f - sum / (float)indexes.size();
        similarity = Math.max(0.0f, Math.min(similarity, 1.0f));
        return similarity;
    }

    public float similarityTypicalColor_with_(IsrImageObject imageObject, Color colorValue) {
        Color color = imageObject.typicalColor();
        float r = (float)(Math.max(colorValue.getRed(), color.getRed()) - Math.min(colorValue.getRed(), color.getRed())) / 255.0f;
        float g = (float)(Math.max(colorValue.getGreen(), color.getGreen()) - Math.min(colorValue.getGreen(), color.getGreen())) / 255.0f;
        float b = (float)(Math.max(colorValue.getBlue(), color.getBlue()) - Math.min(colorValue.getBlue(), color.getBlue())) / 255.0f;
        float similarity = 1.0f - (r + g + b) / 3.0f;
        similarity = Math.max(0.0f, Math.min(similarity, 1.0f));
        return similarity;
    }

    public Color typicalColor() {
        return this.typicalColorModel().color();
    }

    public IsrButtonModel typicalColorButton() {
        IsrImageSearcher self = this;
        StBlockClosure block = new StBlockClosure(self){
            /* synthetic */ IsrImageSearcher val$self;

            public Object value_(Object o) {
                this.val$self.typicalColorButtonAction();
                return null;
            }
            {
                this.val$self = val$self;
            }
        };
        return IsrButtonModel.Value_visual_action_(false, this._typicalColorButtonImage(), block);
    }

    public void typicalColorButtonAction() {
        IsrColorChoiceSBH model = this.typicalColorModel();
        Frame[] frames = model.builder().frames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                frames[i].toFront();
            } else {
                frames[i].show();
            }
            ++i;
        }
        if (frames.length == 0) {
            Frame window = model.open();
            window.setTitle("Color");
        }
    }

    public IsrColorChoiceSBH typicalColorModel() {
        if (this.typicalColorModel == null) {
            this.typicalColorModel = new IsrColorChoiceSBH();
        }
        return this.typicalColorModel;
    }

    public IsrButtonModel typicalColorSwitch() {
        if (this.typicalColorSwitch == null) {
            IsrImageSearcher self = this;
            StBlockClosure block = new StBlockClosure(self){
                /* synthetic */ IsrImageSearcher val$self;

                public Object value_(Object o) {
                    this.val$self.typicalColorSwitchAction();
                    return null;
                }
                {
                    this.val$self = val$self;
                }
            };
            this.typicalColorSwitch = IsrButtonModel.Value_visual_action_(false, this.offImage(), block);
        }
        return this.typicalColorSwitch;
    }

    public void typicalColorSwitchAction() {
        IsrButtonModel typicalColorSwitch;
        typicalColorSwitch.value_(!(typicalColorSwitch = this.typicalColorSwitch()).value());
        if (typicalColorSwitch.value()) {
            typicalColorSwitch.visual_(this.onImage());
        } else {
            typicalColorSwitch.visual_(this.offImage());
        }
    }

    public IsrImageSearcher updateImageSearcher() {
        if (!StDialog.Confirm_((String)"Do you want to update?")) {
            return null;
        }
        this.imageFolder().updateImageObjects();
        this.imageBrowser().imageObjects_(this.imageObjects());
        return this;
    }

    public void windowClosing(WindowEvent e) {
        Window aWindow = e.getWindow();
        Point location = aWindow.getLocationOnScreen();
        Dimension size = aWindow.getSize();
        location = new Point(location.x + size.width, location.y);
        if (StDialog.Confirm_((String)"Really close?", (boolean)false, (Point)location)) {
            StApplicationModel[] models = new StApplicationModel[]{this.typicalColorModel(), this.averageGrayModel(), this.nineColorsModel(), this.iconAreaModel(), this.centerSpectraModel(), this.freehandImageModel(), this.cutOffModel(), this.imageBrowser()};
            int i = 0;
            while (i < models.length) {
                StApplicationModel model = models[i];
                Frame[] frames = model.builder().frames();
                int j = 0;
                while (j < frames.length) {
                    ((Component)frames[j]).setVisible(false);
                    ++j;
                }
                ++i;
            }
            super.windowClosing(e);
        }
    }

    protected String windowTitle() {
        return "Image Searcher";
    }
}

