/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.image.objects;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import sra.isr.geometry.basic.Isr2dPoint;
import sra.isr.image.objects.IsrImageFolder;
import sra.isr.image.support.IsrImageProcessor;
import sra.smalltalk.StAssociation;
import sra.smalltalk.StBlockClosure;
import sra.smalltalk.StColorValue;
import sra.smalltalk.StImage;
import sra.smalltalk.StObject;
import sra.smalltalk.SystemResourceSupport;

public class IsrImageObject
extends StObject
implements Serializable {
    protected String fileName;
    protected IsrImageFolder imageFolder;
    protected long modifiedDate;
    protected StImage iconImage;
    protected Rectangle iconArea;
    protected Color[] nineColors;
    protected Color averageColor;
    protected Color typicalColor;
    protected Isr2dPoint centerSpectra;
    protected StImage xSpectrum;
    protected StImage ySpectrum;
    protected StImage renderingImage;

    public File asFilename() {
        if (this.imageFolder() == null) {
            return new File(this.fileName());
        }
        return this.imageFolder().asFilenameWith_(this.fileName());
    }

    private Object assert_do_ensure_(StBlockClosure asserBlock, StBlockClosure doBlock, StBlockClosure ensureBlock) {
        return null;
    }

    public Color averageColor() {
        if (this.averageColor == null) {
            StImage image = this.iconImage();
            Rectangle area = this.iconArea();
            Color color = null;
            int red = 0;
            int green = 0;
            int blue = 0;
            int y = area.y;
            while (y < area.y + area.height) {
                int x = area.x;
                while (x < area.x + area.width) {
                    color = image.valueAtPoint_(new Point(x, y));
                    red += color.getRed();
                    green += color.getGreen();
                    blue += color.getBlue();
                    ++x;
                }
                ++y;
            }
            int areaSize = area.width * area.height;
            if (areaSize == 0) {
                color = Color.white;
            } else {
                red = Math.round((float)red / (float)areaSize);
                green = Math.round((float)green / (float)areaSize);
                blue = Math.round((float)blue / (float)areaSize);
                color = new Color(red, green, blue);
            }
            this.averageColor = color;
        }
        return this.averageColor;
    }

    public Color averageGray() {
        return StColorValue.Brightness_((double)StColorValue._GetBrightness((Color)this.averageColor()));
    }

    public StImage binaryImage() {
        StImage image = this.iconImage().convertToPalette_(IsrImageProcessor._WhiteBlackPalette());
        return image;
    }

    public Isr2dPoint centerSpectra() {
        if (this.centerSpectra == null) {
            Object[] xs = IsrImageProcessor.XSpectrum_(this.iconImage());
            if (this.xSpectrum == null) {
                this.xSpectrum = this.xSpectrum_height_(xs, this.iconImage().height());
            }
            Object[] ys = IsrImageProcessor.YSpectrum_(this.iconImage());
            if (this.ySpectrum == null) {
                this.ySpectrum = this.ySpectrum_width_(ys, this.iconImage().width());
            }
            double xTotal = 0.0;
            int i = 0;
            while (i < xs.length) {
                xTotal += ((Double)((StAssociation)xs[i]).value()).doubleValue();
                ++i;
            }
            double yTotal = 0.0;
            int j = 0;
            while (j < ys.length) {
                yTotal += ((Double)((StAssociation)ys[j]).value()).doubleValue();
                ++j;
            }
            double count = 0.0;
            double x = -1.0;
            int k = 0;
            while (k < xs.length) {
                if ((count += ((Double)((StAssociation)xs[k]).value()).doubleValue()) > xTotal * 0.5 && x == -1.0) {
                    x = ((Integer)((StAssociation)xs[k]).key()).doubleValue() / (double)xs.length;
                }
                ++k;
            }
            if (x == -1.0) {
                x = 0.5;
            }
            count = 0.0;
            double y = -1.0;
            int l = 0;
            while (l < xs.length) {
                if ((count += ((Double)((StAssociation)ys[l]).value()).doubleValue()) > yTotal * 0.5 && y == -1.0) {
                    y = ((Integer)((StAssociation)ys[l]).key()).doubleValue() / (double)ys.length;
                }
                ++l;
            }
            if (y == -1.0) {
                y = 0.5;
            }
            this.centerSpectra = new Isr2dPoint(x, y);
        }
        return this.centerSpectra;
    }

    public int defaultSize() {
        return IsrImageObject.DefaultSize();
    }

    public static int DefaultSize() {
        return 50;
    }

    public String fileName() {
        return this.fileName;
    }

    public static IsrImageObject FileName_imageFolder_(String aString, IsrImageFolder anImageFolder) {
        IsrImageObject self = new IsrImageObject();
        self.setFileName_imageFolder_(aString, anImageFolder);
        return self;
    }

    private void flushCaches() {
        this.iconImage = null;
        this.iconArea = null;
        this.nineColors = null;
        this.averageColor = null;
        this.typicalColor = null;
        this.centerSpectra = null;
        this.xSpectrum = null;
        this.ySpectrum = null;
        this.renderingImage = null;
    }

    public StImage grayImage() {
        return this.iconImage().convertToPalette_(IsrImageProcessor.GrayPalette256());
    }

    public Rectangle iconArea() {
        if (this.iconArea == null) {
            this.iconImage();
        }
        return this.iconArea;
    }

    public StImage iconImage() {
        if (this.iconImage == null) {
            Vector array = IsrImageProcessor.Icon3_size_(this.originalImage(), this.defaultSize());
            this.iconImage = ((StImage)array.firstElement()).convertToPalette_(IsrImageProcessor.ColorPalette256());
            this.iconArea = (Rectangle)array.lastElement();
            int[] bits = new int[this.defaultSize() * this.defaultSize()];
            int i = 0;
            while (i < bits.length) {
                bits[i] = 0xFFFFFF;
                ++i;
            }
            StImage shape = new StImage(this.defaultSize(), this.defaultSize(), bits);
            IsrImageProcessor.Fill_rectangle_color_(shape, this.iconArea, Color.black);
            this.iconImage = IsrImageProcessor._MakeImage_Shape_(this.iconImage, shape);
        }
        return this.iconImage;
    }

    public StImage imageAttributes() {
        StImage anImage = null;
        Graphics gc = null;
        Rectangle box = null;
        int size = this.defaultSize();
        Image image = SystemResourceSupport.createImage((int)(size * 4 + 5), (int)(size * 3 + 4));
        try {
            gc = image.getGraphics();
            gc.setColor(Color.gray);
            gc.fillRect(0, 0, size * 4 + 5, size * 3 + 4);
            box = this.iconImage().bounds();
            box.translate(size * 0 - box.x, size * 0 - box.y);
            this.iconImage().displayOn_at_(gc, new Point(box.x + 1, box.y + 1));
            box.translate(size * 1 - box.x, size * 0 - box.y);
            this.grayImage().displayOn_at_(gc, new Point(box.x + 2, box.y + 1));
            box.translate(size * 2 - box.x, size * 0 - box.y);
            this.ySpectrum().displayOn_at_(gc, new Point(box.x + 3, box.y + 1));
            box.translate(size * 3 - box.x, size * 0 - box.y);
            this.binaryImage().displayOn_at_(gc, new Point(box.x + 4, box.y + 1));
            box.translate(size * 0 - box.x, size * 1 - box.y);
            this.imageNineColors().displayOn_at_(gc, new Point(box.x + 1, box.y + 2));
            box.translate(size * 1 - box.x, size * 1 - box.y);
            this.xSpectrum().displayOn_at_(gc, new Point(box.x + 2, box.y + 2));
            box.translate(size * 2 - box.x, size * 1 - box.y);
            this.imageCenterSpectra().displayOn_at_(gc, new Point(box.x + 3, box.y + 2));
            box.translate(size * 3 - box.x, size * 1 - box.y);
            this.renderingImage().displayOn_at_(gc, new Point(box.x + 4, box.y + 2));
            box.translate(size * 0 - box.x, size * 2 - box.y);
            this.imageTypicalColor().displayOn_at_(gc, new Point(box.x + 1, box.y + 3));
            box.translate(size * 1 - box.x, size * 2 - box.y);
            this.imageTypicalGray().displayOn_at_(gc, new Point(box.x + 2, box.y + 3));
            box.translate(size * 2 - box.x, size * 2 - box.y);
            this.imageAverageColor().displayOn_at_(gc, new Point(box.x + 3, box.y + 3));
            box.translate(size * 3 - box.x, size * 2 - box.y);
            this.imageAverageGray().displayOn_at_(gc, new Point(box.x + 4, box.y + 3));
            anImage = new StImage(image);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            gc.dispose();
            image.flush();
            throw throwable;
        }
        Object var6_8 = null;
        gc.dispose();
        image.flush();
        return anImage;
    }

    public StImage imageAverageColor() {
        StImage image = new StImage(this.iconImage().width(), this.iconImage().height());
        IsrImageProcessor.Fill_rectangle_color_(image, image.bounds(), Color.white);
        IsrImageProcessor.Fill_rectangle_color_(image, this.iconArea(), this.averageColor());
        return image;
    }

    public StImage imageAverageGray() {
        StImage image = new StImage(this.iconImage().width(), this.iconImage().height());
        IsrImageProcessor.Fill_rectangle_color_(image, image.bounds(), Color.white);
        IsrImageProcessor.Fill_rectangle_color_(image, this.iconArea(), this.averageGray());
        return image;
    }

    public StImage imageCenterSpectra() {
        Rectangle box = new Rectangle(Math.round((float)this.centerSpectra().x() * (float)(this.iconImage().bounds().x + this.iconImage().bounds().width)), Math.round((float)this.centerSpectra().y() * (float)(this.iconImage().bounds().y + this.iconImage().bounds().height)), 0, 0);
        box = new Rectangle(box.x - 2, box.y - 2, box.width + 4, box.height + 4);
        StImage image = new StImage(this.iconImage().width(), this.iconImage().height());
        IsrImageProcessor.Fill_rectangle_color_(image, image.bounds(), Color.white);
        IsrImageProcessor.Fill_rectangle_color_(image, box, Color.black);
        box = new Rectangle(box.x + 1, box.y + 1, box.width - 2, box.height - 2);
        IsrImageProcessor.Fill_rectangle_color_(image, box, Color.white);
        return image;
    }

    public IsrImageFolder imageFolder() {
        return this.imageFolder;
    }

    public StImage imageNineColors() {
        StImage image = new StImage(this.iconImage().width(), this.iconImage().height());
        IsrImageProcessor.Fill_rectangle_color_(image, image.bounds(), Color.white);
        int i = 0;
        while (i < this.nineAreas().length) {
            Rectangle area = this.nineAreas()[i];
            Color color = this.nineColors()[i];
            IsrImageProcessor.Fill_rectangle_color_(image, area, color);
            ++i;
        }
        return image;
    }

    public StImage imageTracePolylines() {
        Graphics pixmap = null;
        StImage anImage = null;
        Object[] polylines = this.tracePolylines();
        Image image = SystemResourceSupport.createImage((int)this.iconImage().width(), (int)this.iconImage().height());
        try {
            pixmap = image.getGraphics();
            int i = 0;
            while (i < polylines.length) {
                Point[] points = (Point[])polylines[i];
                int[] xPoints = new int[points.length];
                int[] yPoints = new int[points.length];
                int j = 0;
                while (j < points.length) {
                    xPoints[j] = points[j].x;
                    yPoints[j] = points[j].y;
                    ++j;
                }
                pixmap.drawPolyline(xPoints, yPoints, xPoints.length);
                ++i;
            }
            anImage = new StImage(image);
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            pixmap.dispose();
            image.flush();
            throw throwable;
        }
        Object var5_12 = null;
        pixmap.dispose();
        image.flush();
        return anImage;
    }

    public StImage imageTypicalColor() {
        StImage image = new StImage(this.iconImage().width(), this.iconImage().height());
        IsrImageProcessor.Fill_rectangle_color_(image, image.bounds(), Color.white);
        IsrImageProcessor.Fill_rectangle_color_(image, this.iconArea(), this.typicalColor());
        return image;
    }

    public StImage imageTypicalGray() {
        StImage image = new StImage(this.iconImage().width(), this.iconImage().height());
        IsrImageProcessor.Fill_rectangle_color_(image, image.bounds(), Color.white);
        IsrImageProcessor.Fill_rectangle_color_(image, this.iconArea(), this.typicalGray());
        return image;
    }

    public void makeCaches() {
        this.iconImage();
        this.iconArea();
        this.nineColors();
        this.averageColor();
        this.typicalColor();
        this.centerSpectra();
        this.xSpectrum();
        this.ySpectrum();
        this.renderingImage();
    }

    public long modifiedDate() {
        return this.modifiedDate;
    }

    public Rectangle[] nineAreas() {
        Isr2dPoint size = new Isr2dPoint((double)this.iconArea().width / 3.0, (double)this.iconArea().height / 3.0);
        Point[] array = new Point[]{new Point(Math.round((float)size.x() * 0.0f), Math.round((float)size.y() * 0.0f)), new Point(Math.round((float)size.x() * 1.0f), Math.round((float)size.y() * 1.0f)), new Point(Math.round((float)size.x() * 2.0f), Math.round((float)size.y() * 2.0f)), new Point(Math.round((float)size.x() * 3.0f), Math.round((float)size.y() * 3.0f))};
        int index = 0;
        while (index < 4) {
            array[index] = new Point(Math.min(array[index].x, this.iconArea().width), Math.min(array[index].y, this.iconArea().height));
            ++index;
        }
        Rectangle[] collection = new Rectangle[9];
        int j = 0;
        while (j < array.length - 1) {
            int i = 0;
            while (i < array.length - 1) {
                Point origin = new Point(array[i].x, array[j].y);
                Point corner = new Point(array[i + 1].x, array[j + 1].y);
                Rectangle box = new Rectangle(origin.x, origin.y, corner.x - origin.x, corner.y - origin.y);
                box.translate(this.iconArea().x, this.iconArea().y);
                collection[j * 3 + i] = box;
                ++i;
            }
            ++j;
        }
        return collection;
    }

    public Color[] nineColors() {
        if (this.nineColors == null) {
            StImage figure = this.iconImage();
            Color[] collection = new Color[9];
            Rectangle[] nineAreas = this.nineAreas();
            int i = 0;
            while (i < nineAreas.length) {
                double value;
                StAssociation assoc;
                Rectangle area = nineAreas[i];
                StImage image = new StImage(area.width, area.height);
                if (image.bounds().width * image.bounds().height > 0) {
                    image.copy_from_in_rule_(image.bounds(), new Point(area.x, area.y), figure, 3);
                }
                Object[] histogram = IsrImageProcessor.ColorHistogram_(image);
                double max = 0.0;
                Color color = null;
                Color key = null;
                int j = 0;
                while (j < histogram.length) {
                    assoc = (StAssociation)histogram[j];
                    value = (Double)assoc.value();
                    key = (Color)assoc.key();
                    if (value > max && !StColorValue._IsGray((Color)key)) {
                        color = key;
                        max = value;
                    }
                    ++j;
                }
                if (color == null) {
                    max = 0.0;
                    color = null;
                    int k = 0;
                    while (k < histogram.length) {
                        assoc = (StAssociation)histogram[k];
                        value = (Double)assoc.value();
                        key = (Color)assoc.key();
                        if (value > max) {
                            color = key;
                            max = value;
                        }
                        ++k;
                    }
                }
                if (color == null) {
                    color = Color.white;
                }
                collection[i] = color;
                ++i;
            }
            this.nineColors = collection;
        }
        return this.nineColors;
    }

    public StImage originalImage() {
        Image image;
        StImage anImage = null;
        String string = this.asFilename().getAbsolutePath();
        if (string.toLowerCase().endsWith(".jpg")) {
            Frame frame = new Frame();
            Toolkit toolKit = frame.getToolkit();
            image = toolKit.getImage(string);
            MediaTracker mt = new MediaTracker(frame);
            mt.addImage(image, 0);
            try {
                mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("image load interrupted.");
                return null;
            }
            int status = mt.statusAll(false);
            if ((status & 2) != 0 || (status & 4) != 0) {
                System.err.println("could not load image.");
                return null;
            }
        } else {
            System.err.println("unknown image format");
            return null;
        }
        anImage = new StImage(image);
        image = null;
        return anImage;
    }

    public StImage renderingImage() {
        if (this.renderingImage == null) {
            this.renderingImage = this.iconImage()._convertToPalette_RenderedByErrorDiffusion(IsrImageProcessor._WhiteBlackPalette());
        }
        return this.renderingImage;
    }

    private IsrImageObject setFileName_imageFolder_(String aString, IsrImageFolder anImageFolder) {
        this.fileName = aString;
        this.imageFolder = anImageFolder;
        this.modifiedDate = this.asFilename().lastModified();
        return null;
    }

    public void setImageFolder_(IsrImageFolder anImageFolder) {
        this.imageFolder = anImageFolder;
    }

    public StImage shapeImage() {
        StImage image = IsrImageProcessor.Shape_(this.iconImage());
        return image;
    }

    public StImage thinImage() {
        StImage image = IsrImageProcessor.MakeThin_(this.iconImage());
        return image;
    }

    public Object[] tracePolylines() {
        Object[] collection = IsrImageProcessor.TraceBorder_(this.iconImage());
        Vector<Point[]> polylines = new Vector<Point[]>();
        int i = 0;
        while (i < collection.length) {
            Point[] polyline = (Point[])collection[i];
            if (polyline.length > 4) {
                polylines.addElement(polyline);
            }
            ++i;
        }
        Object[] array = new Object[polylines.size()];
        polylines.copyInto(array);
        return array;
    }

    public Color typicalColor() {
        if (this.typicalColor == null) {
            int red = 0;
            int green = 0;
            int blue = 0;
            Color[] nineColors = this.nineColors();
            int i = 0;
            while (i < nineColors.length) {
                Color color = nineColors[i];
                red += color.getRed();
                green += color.getGreen();
                blue += color.getBlue();
                ++i;
            }
            this.typicalColor = new Color(Math.round((float)red / 9.0f), Math.round((float)green / 9.0f), Math.round((float)blue / 9.0f));
        }
        return this.typicalColor;
    }

    public Color typicalGray() {
        return StColorValue.Brightness_((double)StColorValue._GetBrightness((Color)this.typicalColor()));
    }

    public StImage xSpectrum() {
        if (this.xSpectrum == null) {
            Object[] spectrum = IsrImageProcessor.XSpectrum_(this.iconImage());
            this.xSpectrum = this.xSpectrum_height_(spectrum, this.iconImage().height());
        }
        return this.xSpectrum;
    }

    private StImage xSpectrum_height_(Object[] spectrum, int height) {
        Graphics gc = null;
        StImage image = null;
        Image pixmap = SystemResourceSupport.createImage((int)spectrum.length, (int)height);
        try {
            gc = pixmap.getGraphics();
            int i = 0;
            while (i < spectrum.length) {
                StAssociation assoc = (StAssociation)spectrum[i];
                int x = (Integer)assoc.key();
                int value = Math.round(((Double)assoc.value()).floatValue() * (float)height);
                gc.setColor(Color.black);
                gc.fillRect(x, 0, 1, value);
                ++i;
            }
            image = new StImage(pixmap);
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            gc.dispose();
            pixmap.flush();
            throw throwable;
        }
        Object var6_12 = null;
        gc.dispose();
        pixmap.flush();
        return image;
    }

    public StImage ySpectrum() {
        if (this.ySpectrum == null) {
            Object[] spectrum = IsrImageProcessor.YSpectrum_(this.iconImage());
            this.ySpectrum = this.ySpectrum_width_(spectrum, this.iconImage().width());
        }
        return this.ySpectrum;
    }

    private StImage ySpectrum_width_(Object[] spectrum, int width) {
        Graphics gc = null;
        StImage image = null;
        Image pixmap = SystemResourceSupport.createImage((int)width, (int)spectrum.length);
        try {
            gc = pixmap.getGraphics();
            int i = 0;
            while (i < spectrum.length) {
                StAssociation assoc = (StAssociation)spectrum[i];
                int y = (Integer)assoc.key();
                int value = Math.round(((Double)assoc.value()).floatValue() * (float)width);
                gc.setColor(Color.black);
                gc.fillRect(0, y, value, 1);
                ++i;
            }
            image = new StImage(pixmap);
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            gc.dispose();
            pixmap.flush();
            throw throwable;
        }
        Object var6_12 = null;
        gc.dispose();
        pixmap.flush();
        return image;
    }
}

