/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.image.objects;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sra.isr.image.objects.IsrImageObject;
import sra.isr.interfaces.progress.IsrProgress;
import sra.smalltalk.SmalltalkException;
import sra.smalltalk.StAssociation;
import sra.smalltalk.StBlockClosure;
import sra.smalltalk.StDialog;
import sra.smalltalk.StInterval;
import sra.smalltalk.StObject;
import sra.smalltalk.StSortedCollection;
import sra.smalltalk.StValueHolder;

public class IsrImageFolder
extends StObject {
    protected String directoryName;
    protected IsrImageObject[] imageObjects;
    protected static String selection;

    public File asFilename() {
        return new File(this.directoryName());
    }

    public File asFilenameWith_(String aString) {
        try {
            StringWriter aWriter = new StringWriter();
            aWriter.write(this.directoryName());
            aWriter.write(File.separator);
            aWriter.write(aString);
            aWriter.flush();
            return new File(aWriter.toString());
        }
        catch (Exception e) {
            throw new SmalltalkException(e);
        }
    }

    private Object assert_do_ensure_(StBlockClosure asserBlock, StBlockClosure doBlock, StBlockClosure ensureBlock) {
        return null;
    }

    public String defaultCatalog() {
        return "JCatalog.idx";
    }

    public String directoryName() {
        return this.directoryName;
    }

    public static IsrImageFolder DirectoryName_(String aString) {
        IsrImageFolder self = new IsrImageFolder();
        self.setDirectoryName_(aString);
        return self;
    }

    public static String Dividers() {
        char[] data = new char[]{' ', '\t', '\n', '\f'};
        String string = new String(data);
        return string;
    }

    public void errorCanNotRead() {
        SmalltalkException.Error((String)"can't read the catalog");
    }

    public void errorCanNotWrite() {
        SmalltalkException.Error((String)"can't write the catalog");
    }

    public void flushImageObjects() {
        File catalog = new File(this.asFilename().toString(), this.defaultCatalog());
        if (catalog.exists()) {
            catalog.delete();
        }
        this.imageObjects = null;
    }

    public static IsrImageFolder FromUser() {
        String string = selection != null ? selection : "images";
        if ((string = StDialog.Request_((String)"Enter directory name of JPG images, then Ok", (String)string)) == null) {
            return null;
        }
        File filename = new File(string);
        if (!filename.exists()) {
            StDialog.Warn_((String)(String.valueOf(string) + " does not exist."));
            return null;
        }
        if (!filename.isDirectory()) {
            StDialog.Warn_((String)(String.valueOf(string) + " is not directory."));
            return null;
        }
        selection = string;
        IsrImageFolder imageFolder = IsrImageFolder.DirectoryName_(string);
        return imageFolder;
    }

    private boolean hasMagicNumber_stream_(byte[] aByteArray, InputStream aStream) throws Exception {
        byte[] aByte = new byte[aByteArray.length];
        if (aStream.read(aByte) != -1) {
            return new String(aByte).equals(new String(aByteArray));
        }
        return false;
    }

    public IsrImageObject[] imageObjects() {
        if (this.imageObjects == null) {
            this.updateImageObjects();
        }
        return this.imageObjects;
    }

    public boolean readHeader_(InputStream aStream) throws Exception {
        boolean result = this.hasMagicNumber_stream_("JCatalog".getBytes(), aStream);
        if (result) {
            return true;
        }
        this.errorCanNotRead();
        return false;
    }

    public Vector readImageObjects_(InputStream aStream) throws Exception {
        Vector collection = new Vector();
        try {
            IsrImageFolder self = this;
            InputStream stream = aStream;
            new IsrProgress().do_(new StBlockClosure(collection, self, stream){
                /* synthetic */ Vector val$collection;
                /* synthetic */ IsrImageFolder val$self;
                /* synthetic */ InputStream val$stream;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object value_(Object obj) {
                    ObjectInputStream inStream;
                    block11: {
                        block10: {
                            IsrProgress progress = (IsrProgress)((Object)obj);
                            progress.message_("reading catalog ... ");
                            inStream = null;
                            try {
                                try {
                                    inStream = new ObjectInputStream(this.val$stream);
                                    if (!this.val$self.readHeader_(inStream)) {
                                        Object var4_4 = null;
                                        break block10;
                                    }
                                    int size = inStream.readInt();
                                    int count = 1;
                                    int i = 0;
                                    while (i < size) {
                                        progress.value_((float)count / (float)size);
                                        IsrImageObject imageObject = (IsrImageObject)inStream.readObject();
                                        this.val$collection.addElement(imageObject);
                                        ++count;
                                        ++i;
                                    }
                                    break block11;
                                }
                                catch (Exception e) {
                                    SmalltalkException.Error((String)("reading error:" + e));
                                    break block11;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_5 = null;
                                try {
                                    if (inStream == null) throw throwable;
                                    inStream.close();
                                    inStream = null;
                                    throw throwable;
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                        }
                        try {}
                        catch (IOException iOException) {}
                        if (inStream == null) return null;
                        inStream.close();
                        return null;
                    }
                    Object var4_6 = null;
                    try {}
                    catch (IOException iOException) {
                        return null;
                    }
                    if (inStream == null) return null;
                    inStream.close();
                    return null;
                }
                {
                    this.val$collection = val$collection;
                    this.val$self = val$self;
                    this.val$stream = val$stream;
                }
            });
        }
        catch (Exception exception) {}
        return collection;
    }

    public static Vector Separate_dividers_(String separateCollection, String dividerCollection) {
        Vector<Integer> indexCollection = new Vector<Integer>();
        indexCollection.addElement(new Integer(0));
        int index = 1;
        int i = 0;
        while (i < separateCollection.length()) {
            char each = separateCollection.charAt(i);
            if (dividerCollection.indexOf(each) != -1) {
                indexCollection.addElement(new Integer(index));
            }
            ++index;
            ++i;
        }
        indexCollection.addElement(new Integer(separateCollection.length() + 1));
        Vector<StInterval> intervalCollection = new Vector<StInterval>();
        int i2 = 0;
        while (i2 < indexCollection.size() - 1) {
            int s = (Integer)indexCollection.elementAt(i2);
            int e = (Integer)indexCollection.elementAt(i2 + 1);
            intervalCollection.addElement(new StInterval((double)s, (double)(e - 1)));
            ++i2;
        }
        Vector<String> result = new Vector<String>();
        int i3 = 0;
        while (i3 < intervalCollection.size()) {
            StInterval interval = (StInterval)intervalCollection.elementAt(i3);
            if (interval.size() > 0) {
                result.addElement(separateCollection.substring((int)interval.first(), (int)interval.last()));
            }
            ++i3;
        }
        return result;
    }

    private IsrImageFolder setDirectoryName_(String aString) {
        File filename;
        String string = aString.toString();
        if (string.length() > 1 && string.charAt(string.length() - 1) == File.separatorChar) {
            string = string.substring(0, string.length() - 1);
        }
        if (!(filename = new File(string)).isDirectory()) {
            return null;
        }
        if (File.pathSeparator == ":" && !filename.isAbsolute() && string.charAt(0) != File.separatorChar) {
            string = String.valueOf(File.separator) + string;
        }
        this.directoryName = string;
        return this;
    }

    public static boolean StringMatch_and_(String string, String pattern) {
        String s1 = String.valueOf(string) + '\u0000';
        String s2 = String.valueOf(pattern) + '\u0000';
        return IsrImageFolder.StringMatch_sIndex_and_pIndex_(s1, 0, s2, 0);
    }

    public static boolean StringMatch_sIndex_and_pIndex_(String string, int sindex, String pattern, int pindex) {
        int si = sindex;
        int pi = pindex;
        char scc = string.charAt(si);
        ++si;
        char c = pattern.charAt(pi);
        ++pi;
        if (c == '[') {
            boolean ok = false;
            char lc = '\u00ff';
            c = pattern.charAt(pi);
            ++pi;
            while (c != '\u0000') {
                if (c == ']') {
                    if (ok) {
                        return IsrImageFolder.StringMatch_sIndex_and_pIndex_(string, si, pattern, pi);
                    }
                    return false;
                }
                if (c == '-') {
                    if (lc <= scc && scc <= pattern.charAt(pi)) {
                        ok = true;
                    }
                    ++pi;
                } else {
                    lc = c;
                    if (scc == c) {
                        ok = true;
                    }
                }
                c = pattern.charAt(pi);
                ++pi;
            }
        }
        if (c == '?') {
            if (scc != '\u0000') {
                return IsrImageFolder.StringMatch_sIndex_and_pIndex_(string, si, pattern, pi);
            }
            return false;
        }
        if (c == '*') {
            if (pattern.charAt(pi) == '\u0000') {
                return true;
            }
            --si;
            while (string.charAt(si) != '\u0000') {
                if (IsrImageFolder.StringMatch_sIndex_and_pIndex_(string, si, pattern, pi)) {
                    return true;
                }
                ++si;
            }
            return false;
        }
        if (c == '\u0000') {
            return scc == '\u0000';
        }
        if (c != scc) {
            return false;
        }
        if (scc != '\u0000') {
            return IsrImageFolder.StringMatch_sIndex_and_pIndex_(string, si, pattern, pi);
        }
        return false;
    }

    public IsrImageObject[] updateImageObjects() {
        this.updateImageObjectsAux();
        return this.imageObjects;
    }

    public IsrImageObject[] updateImageObjectsAux() {
        block35: {
            Vector<Serializable> vector2;
            String fileString;
            Hashtable<String, Vector<Serializable>> previous = null;
            Enumeration<Object> enumeration = null;
            IsrImageFolder self = this;
            String[] contents = this.asFilename().list();
            Vector<String> files = new Vector<String>(contents.length);
            int i = 0;
            while (i < contents.length) {
                String each = contents[i];
                if (each.toLowerCase().endsWith(".jpg")) {
                    files.addElement(each);
                }
                ++i;
            }
            Hashtable current = new Hashtable(files.size());
            Object[] array = new Object[files.size()];
            files.copyInto(array);
            int i2 = 0;
            while (i2 < array.length) {
                File filename = this.asFilenameWith_((String)array[i2]);
                long date = filename.lastModified();
                fileString = (String)array[i2];
                vector2 = new Vector<Serializable>(2);
                vector2.addElement(new Long(date));
                vector2.addElement(null);
                current.put(fileString, vector2);
                ++i2;
            }
            String catalogDir = String.valueOf(this.asFilename().toString()) + File.separator;
            File catalog = new File(catalogDir, this.defaultCatalog());
            if (catalog.exists()) {
                Vector readCollection = null;
                try {
                    FileInputStream inStream = null;
                    try {
                        try {
                            inStream = new FileInputStream(catalog);
                            readCollection = this.readImageObjects_(inStream);
                        }
                        catch (Exception exception) {}
                    }
                    catch (Throwable vector2) {
                        fileString = null;
                        try {
                            if (inStream != null) {
                                inStream.close();
                                inStream = null;
                            }
                        }
                        catch (IOException iOException) {}
                        throw vector2;
                    }
                    fileString = null;
                    try {
                        if (inStream != null) {
                            inStream.close();
                            inStream = null;
                        }
                    }
                    catch (IOException iOException) {}
                    if (readCollection.size() >= 1) {
                        previous = new Hashtable(readCollection.size());
                        enumeration = readCollection.elements();
                        while (enumeration.hasMoreElements()) {
                            IsrImageObject each = (IsrImageObject)enumeration.nextElement();
                            vector2 = new Vector(2);
                            vector2.addElement(new Long(each.modifiedDate()));
                            vector2.addElement(each);
                            previous.put(each.fileName(), vector2);
                        }
                    } else {
                        previous = new Hashtable();
                    }
                }
                catch (Exception exception) {
                    previous = new Hashtable();
                }
            } else {
                previous = new Hashtable<String, Vector<Serializable>>();
            }
            Hashtable<String, Vector> intersection = new Hashtable<String, Vector>();
            StValueHolder writing = new StValueHolder((Object)new Boolean(false));
            enumeration = previous.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Vector value = (Vector)previous.get(key);
                if (current.containsKey(key) && ((Vector)current.get(key)).firstElement().equals(value.firstElement())) {
                    intersection.put(key, value);
                    continue;
                }
                writing.value_((Object)new Boolean(true));
            }
            Vector collection = new Vector(current.size());
            StSortedCollection associations = new StSortedCollection(new StBlockClosure(){

                public Object value_value_(Object object1, Object object2) {
                    String key2;
                    String key1 = (String)((StAssociation)object1).key();
                    return new Boolean(key1.compareTo(key2 = (String)((StAssociation)object2).key()) <= 0);
                }
            });
            enumeration = current.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Vector value = (Vector)current.get(key);
                StAssociation assoc = new StAssociation((Object)key, (Object)value);
                associations.add_((Object)assoc);
            }
            int size = associations.size();
            new IsrProgress().do_(new StBlockClosure(self, intersection, writing, collection, associations, size){
                /* synthetic */ IsrImageFolder val$self;
                /* synthetic */ Hashtable val$intersection;
                /* synthetic */ StValueHolder val$writing;
                /* synthetic */ Vector val$collection;
                /* synthetic */ StSortedCollection val$associations;
                /* synthetic */ int val$size;

                public Object value_(Object obj) {
                    IsrProgress progress = (IsrProgress)((Object)obj);
                    IsrImageObject object = null;
                    int count = 1;
                    progress.message_("check catalog...");
                    Object[] array = this.val$associations._asArray();
                    int j = 0;
                    while (j < array.length) {
                        StAssociation assoc = (StAssociation)array[j];
                        if (this.val$intersection.containsKey((String)assoc.key())) {
                            object = (IsrImageObject)((Vector)this.val$intersection.get(assoc.key())).lastElement();
                            object.setImageFolder_(this.val$self);
                        } else {
                            object = IsrImageObject.FileName_imageFolder_((String)assoc.key(), this.val$self);
                            this.val$writing.value_((Object)new Boolean(true));
                        }
                        progress.message_("check catalog ... " + object.fileName());
                        object.makeCaches();
                        progress.value_((float)count / (float)this.val$size);
                        this.val$collection.addElement(object);
                        ++count;
                        ++j;
                    }
                    return null;
                }
                {
                    this.val$self = val$self;
                    this.val$intersection = val$intersection;
                    this.val$writing = val$writing;
                    this.val$collection = val$collection;
                    this.val$associations = val$associations;
                    this.val$size = val$size;
                }
            });
            Object[] images = new Object[collection.size()];
            collection.copyInto(images);
            this.imageObjects = new IsrImageObject[images.length];
            int i3 = 0;
            while (i3 < this.imageObjects.length) {
                this.imageObjects[i3] = (IsrImageObject)images[i3];
                ++i3;
            }
            if (!((Boolean)writing.value()).booleanValue()) break block35;
            FileOutputStream outStream = null;
            try {
                try {
                    outStream = new FileOutputStream(catalog);
                    this.writeImageObjects_(outStream);
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                Object var17_26 = null;
                try {
                    if (outStream != null) {
                        outStream.flush();
                        outStream.close();
                        outStream = null;
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            Object var17_27 = null;
            try {
                if (outStream != null) {
                    outStream.flush();
                    outStream.close();
                    outStream = null;
                }
            }
            catch (IOException iOException) {}
        }
        return this.imageObjects;
    }

    public void writeHeader_(OutputStream aStream) throws Exception {
        aStream.write("JCatalog".getBytes());
    }

    public void writeImageObjects_(OutputStream aStream) throws Exception {
        try {
            IsrImageFolder self = this;
            OutputStream stream = aStream;
            new IsrProgress().do_(new StBlockClosure(this, self, stream){
                /* synthetic */ IsrImageFolder this$0;
                /* synthetic */ IsrImageFolder val$self;
                /* synthetic */ OutputStream val$stream;

                public Object value_(Object obj) {
                    IsrProgress progress = (IsrProgress)((Object)obj);
                    progress.message_("writing catalog ... ");
                    ObjectOutputStream outStream = null;
                    try {
                        try {
                            outStream = new ObjectOutputStream(this.val$stream);
                            this.val$self.writeHeader_(outStream);
                            int size = this.this$0.imageObjects.length;
                            outStream.writeInt(size);
                            int count = 1;
                            int i = 0;
                            while (i < size) {
                                IsrImageObject each = this.val$self.imageObjects[i];
                                progress.value_((float)count / (float)size);
                                IsrImageObject clone = (IsrImageObject)each.copy();
                                clone.makeCaches();
                                clone.setImageFolder_(null);
                                outStream.writeObject(clone);
                                ++count;
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            SmalltalkException.Error((String)("writing error:" + e));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_11 = null;
                        try {
                            if (outStream != null) {
                                outStream.flush();
                                outStream.close();
                                outStream = null;
                            }
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    Object var4_12 = null;
                    try {
                        if (outStream != null) {
                            outStream.flush();
                            outStream.close();
                            outStream = null;
                        }
                    }
                    catch (Exception exception) {}
                    return null;
                }
                {
                    this.this$0 = this$0;
                    this.val$self = val$self;
                    this.val$stream = val$stream;
                }
            });
        }
        catch (Exception exception) {}
    }
}

