/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.image.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import sra.isr.image.browser.IsrImageBrowser;
import sra.isr.image.browser.IsrImageBrowserController;
import sra.isr.image.browser.IsrImageBrowserView;
import sra.isr.image.objects.IsrImageObject;
import sra.isr.image.support.IsrImageProcessor;
import sra.smalltalk.DependentEvent;
import sra.smalltalk.StBlockClosure;
import sra.smalltalk.StColorValue;
import sra.smalltalk.StImage;
import sra.smalltalk.StMenu;
import sra.smalltalk.StMenuModel;
import sra.smalltalk.StMenuViewForSwing;
import sra.smalltalk.StModel;
import sra.smalltalk.StValueHolder;
import sra.smalltalk.StViewJPanel;

public class IsrImageBrowserViewSwing
extends StViewJPanel
implements IsrImageBrowserView {
    protected IsrImageBrowserController controller;
    protected JPopupMenu popupMenu;
    protected Image offScreenImage;
    protected Graphics offScreenGraphics;
    protected Dimension offScreenSize;

    protected void buildComponent() {
        this.controller = this.defaultController();
        this.controller.view_(this);
    }

    public Point cellExtent() {
        int size = IsrImageObject.DefaultSize();
        return new Point(size + 2, size + 2);
    }

    public int columns() {
        int colunms = Math.max(this.displayExtent().width / this.cellExtent().x, 1);
        return colunms;
    }

    protected IsrImageBrowserController defaultController() {
        return new IsrImageBrowserController();
    }

    protected StModel defaultModel() {
        return new IsrImageBrowser();
    }

    public Dimension displayExtent() {
        JViewport viewport = (JViewport)((Component)((Object)this)).getParent();
        return viewport.getExtentSize();
    }

    public void displayImageAt_on_clip_(int anInteger, Graphics graphicsContext, Rectangle aRectangle) {
        StImage image = this.images()[anInteger].iconImage();
        Rectangle box = this.images()[anInteger].iconArea();
        Point offset = new Point(aRectangle.width / 2 - image.width() / 2, aRectangle.height / 2 - image.height() / 2);
        Point origin = new Point(aRectangle.x + offset.x, aRectangle.y + offset.y);
        MediaTracker mt = new MediaTracker((Component)((Object)this));
        mt.addImage(image.image(), 0);
        graphicsContext.drawImage(image.image(), origin.x, origin.y, (ImageObserver)((Object)this));
        box = new Rectangle(box.x + origin.x, box.y + origin.y, box.width - 1, box.height - 1);
        graphicsContext.setColor(Color.black);
        graphicsContext.drawRect(box.x, box.y, box.width, box.height);
        if (this.indexFlag()) {
            origin = new Point(aRectangle.x + 1, aRectangle.y + 1);
            String text = Integer.toString(anInteger);
            FontMetrics fontMetrics = graphicsContext.getFontMetrics();
            int height = fontMetrics.getAscent();
            origin.translate(0, height);
            graphicsContext.setColor(Color.white);
            Point[] points = IsrImageProcessor.EightPoints();
            int i = 0;
            while (i < points.length) {
                graphicsContext.drawString(text, origin.x + points[i].x, origin.y + points[i].y);
                ++i;
            }
            graphicsContext.setColor(Color.black);
            graphicsContext.drawString(text, origin.x, origin.y);
        }
    }

    public void displayOn_(Graphics aGraphics) {
        Dimension size = ((Component)((Object)this)).getSize();
        if (!size.equals(this.offScreenSize)) {
            this.offScreenImage = ((Component)((Object)this)).createImage(size.width, size.height);
            this.offScreenGraphics = this.offScreenImage.getGraphics();
            IsrImageBrowserViewSwing self = this;
            this.loop_(new StBlockClosure(self){
                /* synthetic */ IsrImageBrowserViewSwing val$self;

                public Object value_value_(Object obj1, Object obj2) {
                    Rectangle box = (Rectangle)obj1;
                    int index = (Integer)obj2;
                    this.val$self.displayOn_imageAt_clippingBox_(this.val$self.offScreenGraphics, index, box);
                    return null;
                }
                {
                    this.val$self = val$self;
                }
            });
            this.offScreenSize = size;
        }
        aGraphics.drawImage(this.offScreenImage, 0, 0, (ImageObserver)((Object)this));
    }

    public void displayOn_imageAt_clippingBox_(Graphics graphicsContext, int index, Rectangle box) {
        if (this.selectedIndexes().contains(new Integer(index))) {
            graphicsContext.setColor(Color.red);
            graphicsContext.fillRect(box.x, box.y, box.width, box.height);
        } else {
            graphicsContext.setColor(StColorValue.VeryLightGray);
            graphicsContext.fillRect(box.x, box.y, box.width, box.height);
        }
        if (index < this.imagesSize()) {
            this.displayImageAt_on_clip_(index, graphicsContext, box);
        }
    }

    protected void finalize() throws Throwable {
        if (this.offScreenGraphics != null) {
            this.offScreenGraphics.dispose();
            this.offScreenGraphics = null;
        }
        if (this.offScreenImage != null) {
            this.offScreenImage.flush();
            this.offScreenImage = null;
        }
    }

    public IsrImageBrowser getModel() {
        return (IsrImageBrowser)this.model();
    }

    public IsrImageObject[] images() {
        return this.getModel().imageObjects();
    }

    public int imagesSize() {
        return this.images().length;
    }

    public boolean indexFlag() {
        return this.getModel().indexFlag();
    }

    private Object loop_(StBlockClosure aBlock) {
        Rectangle cell = new Rectangle(0, 0, this.cellExtent().x, this.cellExtent().y);
        int index = 0;
        int row = 0;
        while (row < this.rows()) {
            int column = 0;
            while (column < this.columns()) {
                Object result = aBlock.value_value_((Object)cell, (Object)new Integer(index));
                if (result != null) {
                    return result;
                }
                cell.translate(cell.width, 0);
                ++index;
                ++column;
            }
            cell.translate(0 - cell.width * this.columns(), cell.height);
            ++row;
        }
        return null;
    }

    public Dimension preferredSize() {
        return new Dimension(this.columns() * this.cellExtent().x, this.rows() * this.cellExtent().y);
    }

    protected void rebuildComponent(StModel oldModel, StModel newModel) {
        StMenuModel menuModel = ((IsrImageBrowser)newModel).defaultMenu();
        if (menuModel != null) {
            StMenu editMenu = (StMenu)menuModel.getItem("ImageBrowserMenu");
            this.popupMenu = StMenuViewForSwing.CreateJPopupMenu((StMenu)editMenu);
        }
    }

    public int rows() {
        int columns = this.columns();
        int rows = this.imagesSize() / columns;
        if (this.imagesSize() % columns != 0) {
            ++rows;
        }
        return rows;
    }

    public Vector selectedIndexes() {
        return this.getModel().selectedIndexes();
    }

    public void setModel(IsrImageBrowser aModel) {
        this.model_((StModel)aModel);
    }

    public void showPopupMenu(Point aPoint) {
        if (this.popupMenu != null) {
            IsrImageBrowser browser = this.getModel();
            if (browser.selectedIndexes().size() == 0) {
                this.popupMenu.getComponent(2).setEnabled(false);
                this.popupMenu.getComponent(3).setEnabled(false);
            } else {
                this.popupMenu.getComponent(2).setEnabled(true);
                this.popupMenu.getComponent(3).setEnabled(true);
            }
            this.popupMenu.show((Component)((Object)this), aPoint.x, aPoint.y);
        }
    }

    public void update_(DependentEvent evt) {
        if (!((Component)((Object)this)).isShowing()) {
            return;
        }
        if (evt.getAspect() == StViewJPanel.$((String)"selectedIndexes")) {
            Vector indexCollection = (Vector)evt.getParameter();
            IsrImageBrowserViewSwing self = this;
            this.offScreenGraphics.clipRect(0, 0, ((Component)((Object)this)).getBounds().width, ((Component)((Object)this)).getBounds().height);
            this.loop_(new StBlockClosure(indexCollection, self){
                /* synthetic */ Vector val$indexCollection;
                /* synthetic */ IsrImageBrowserViewSwing val$self;

                public Object value_value_(Object obj1, Object obj2) {
                    Rectangle box = (Rectangle)obj1;
                    Integer index = (Integer)obj2;
                    if (this.val$indexCollection.contains(index)) {
                        this.val$self.displayOn_imageAt_clippingBox_(this.val$self.offScreenGraphics, index, box);
                    }
                    return null;
                }
                {
                    this.val$indexCollection = val$indexCollection;
                    this.val$self = val$self;
                }
            });
            ((JComponent)((Object)this)).getGraphics().drawImage(this.offScreenImage, 0, 0, (ImageObserver)((Object)this));
            return;
        }
        if (evt.getAspect() == StViewJPanel.$((String)"imageObjects")) {
            ((JViewport)((Component)((Object)this)).getParent()).setViewPosition(new Point(0, 0));
            this.offScreenSize = null;
            ((Component)((Object)this)).repaint();
            return;
        }
        this.offScreenSize = null;
        ((Component)((Object)this)).repaint();
    }

    public IsrImageObject whichImage_(Point aPoint) {
        int index = this.whichIndex_(aPoint);
        if (index == -1) {
            return null;
        }
        return this.images()[index];
    }

    public int whichIndex_(Point aPoint) {
        IsrImageBrowserViewSwing self = this;
        Point point = aPoint;
        Object result = this.loop_(new StBlockClosure(self, point){
            /* synthetic */ IsrImageBrowserViewSwing val$self;
            /* synthetic */ Point val$point;

            public Object value_value_(Object obj1, Object obj2) {
                Rectangle box = (Rectangle)obj1;
                int index = (Integer)obj2;
                if (box.contains(this.val$point)) {
                    if (index < this.val$self.imagesSize()) {
                        return new StValueHolder(index);
                    }
                    return new StValueHolder(-1);
                }
                return null;
            }
            {
                this.val$self = val$self;
                this.val$point = val$point;
            }
        });
        if (result != null) {
            return ((StValueHolder)result)._intValue();
        }
        return -1;
    }
}

