/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.image.browser;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import sra.isr.image.browser.IsrImageBrowser;
import sra.isr.image.browser.IsrImageBrowserView;
import sra.smalltalk.StController;
import sra.smalltalk.StObject;
import sra.smalltalk.StView;

public class IsrImageBrowserController
extends StController
implements MouseListener {
    protected void buildListener(StView newView) {
        Component aView = (Component)newView;
        aView.addMouseListener(this);
    }

    protected final IsrImageBrowser getModel() {
        return (IsrImageBrowser)this.model();
    }

    protected IsrImageBrowserView getView() {
        return (IsrImageBrowserView)this.view();
    }

    public void mouseClicked(MouseEvent event) {
        if (this.isMenuButtonPressed_(event)) {
            return;
        }
        if (event.getClickCount() == 1) {
            this.selectActivity_(event);
        } else if (event.getClickCount() == 2) {
            this.mouseDoubleClicked(event);
        }
    }

    public void mouseDoubleClicked(MouseEvent event) {
        if (event.isControlDown()) {
            if (event.isShiftDown()) {
                this.getModel().showNewImageAttributes();
            } else {
                this.getModel().showImageAttributes();
            }
        } else if (event.isShiftDown()) {
            this.getModel().showNewOriginalImages();
        } else {
            this.getModel().showOriginalImages();
        }
    }

    public void mousePressed(MouseEvent event) {
        if (event.isMetaDown()) {
            IsrImageBrowserView view = this.getView();
            view.showPopupMenu(event.getPoint());
        }
    }

    public void selectActivity_(MouseEvent event) {
        Point point;
        if (this.isMenuButtonPressed_(event)) {
            return;
        }
        IsrImageBrowserView view = this.getView();
        int index = view.whichIndex_(point = event.getPoint());
        if (index == -1) {
            return;
        }
        IsrImageBrowser browser = this.getModel();
        Vector oldSelection = (Vector)browser.selectedIndexes().clone();
        boolean bool = event.isShiftDown();
        if (bool) {
            if (browser.selectedIndexes().contains(new Integer(index))) {
                browser.removeSelectedIndex_(index);
            } else {
                browser.addSelectedIndex_(index);
            }
        } else if (!browser.selectedIndexes().contains(new Integer(index))) {
            browser.clearSelectedIndexes();
            browser.addSelectedIndex_(index);
        }
        Vector newSelection = browser.selectedIndexes();
        Vector xor = browser.xorIndexes_with_(newSelection, oldSelection);
        browser.changed_with_(StObject.$((String)"selectedIndexes"), xor);
    }
}

