/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.image.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import sra.isr.image.browser.IsrImageBrowserApplicationViewAwt;
import sra.isr.image.objects.IsrImageFolder;
import sra.isr.image.objects.IsrImageObject;
import sra.isr.interfaces.display.IsrDisplayModel;
import sra.smalltalk.StApplicationModel;
import sra.smalltalk.StBlockClosure;
import sra.smalltalk.StDialog;
import sra.smalltalk.StMenu;
import sra.smalltalk.StMenuItem;
import sra.smalltalk.StMenuModel;
import sra.smalltalk.StObject;
import sra.smalltalk.StSortedCollection;
import sra.smalltalk.StView;

public class IsrImageBrowser
extends StApplicationModel {
    protected IsrImageObject[] imageObjects;
    protected Vector selectedIndexes;
    protected boolean indexFlag;
    protected boolean slaveFlag;
    protected IsrDisplayModel displayModelForOriginal;
    protected IsrDisplayModel displayModelForAttributes;

    public void addSelectedIndex_(int anInteger) {
        Integer number = new Integer(anInteger);
        if (!this.selectedIndexes().contains(number)) {
            this.selectedIndexes.addElement(number);
        }
    }

    private Object assert_do_ensure_(StBlockClosure asserBlock, StBlockClosure doBlock, StBlockClosure ensureBlock) {
        return null;
    }

    public Vector clearSelectedIndexes() {
        this.selectedIndexes = new Vector();
        return this.selectedIndexes;
    }

    protected StMenuModel defaultMenu() {
        StMenuModel rootMenu = new StMenuModel();
        StMenu editMenu = new StMenu("ImageBrowserMenu");
        editMenu.add(this.createMenuItem("open", "openImageBrowser"));
        editMenu.addSeparator();
        editMenu.add(this.createMenuItem("original", "showOriginalImages"));
        editMenu.add(this.createMenuItem("attributes", "showImageAttributes"));
        editMenu.addSeparator();
        editMenu.add(this.createMenuItem("select all", "selectAll"));
        editMenu.add(this.createMenuItem("select indexes", "selectIndexes"));
        editMenu.add(this.createMenuItem("index on/off", "indexOnOff"));
        rootMenu.add((StMenuItem)editMenu);
        return rootMenu;
    }

    public StView defaultView() {
        if (StApplicationModel.GetDefaultViewMode() == 0) {
            return new IsrImageBrowserApplicationViewAwt();
        }
        return StApplicationModel.CreateView((String)"sra.isr.image.browser.IsrImageBrowserApplicationViewSwing");
    }

    public static IsrImageBrowser DirectoryName_(String aString) {
        return IsrImageBrowser.ImageFolder_(IsrImageFolder.DirectoryName_(aString));
    }

    public IsrDisplayModel displayModelForAttributes() {
        if (this.displayModelForAttributes == null) {
            this.displayModelForAttributes = IsrDisplayModel.Visual_("");
        }
        return this.displayModelForAttributes;
    }

    public IsrDisplayModel displayModelForOriginal() {
        if (this.displayModelForOriginal == null) {
            this.displayModelForOriginal = IsrDisplayModel.Visual_("");
        }
        return this.displayModelForOriginal;
    }

    public static IsrImageBrowser FromUser() {
        IsrImageFolder imageFolder = IsrImageFolder.FromUser();
        if (imageFolder == null) {
            return null;
        }
        IsrImageBrowser imageBrowser = IsrImageBrowser.ImageFolder_(imageFolder);
        return imageBrowser;
    }

    public static IsrImageBrowser ImageFolder_(IsrImageFolder imageFolder) {
        return IsrImageBrowser.ImageObjects_(imageFolder.imageObjects());
    }

    public IsrImageObject[] imageObjects() {
        return this.imageObjects;
    }

    public static IsrImageBrowser ImageObjects_(IsrImageObject[] collectionOfImageObjects) {
        IsrImageBrowser model = new IsrImageBrowser();
        model.imageObjects_(collectionOfImageObjects);
        return model;
    }

    public void imageObjects_(IsrImageObject[] collectionOfImageObjects) {
        if (this.imageObjects != collectionOfImageObjects) {
            this.setImageObjects_(collectionOfImageObjects);
            this.clearSelectedIndexes();
            this.changed_(StObject.$((String)"imageObjects"));
        }
    }

    public boolean indexFlag() {
        return this.indexFlag;
    }

    public void indexFlag_(boolean aBoolean) {
        this.indexFlag = aBoolean;
    }

    public void indexOnOff() {
        this.indexFlag_(!this.indexFlag());
        this.changed();
    }

    public void openImageBrowser() {
        IsrImageBrowser imageBrowser = IsrImageBrowser.FromUser();
        if (imageBrowser == null) {
            return;
        }
        imageBrowser.open();
    }

    public void removeSelectedIndex_(int anInteger) {
        Integer number = new Integer(anInteger);
        if (this.selectedIndexes().contains(number)) {
            this.selectedIndexes.removeElement(number);
        }
    }

    public void selectAll() {
        Vector oldIndexes = (Vector)this.selectedIndexes.clone();
        this.selectedIndexes_(new Vector());
        int index = 0;
        while (index < this.imageObjects().length) {
            this.selectedIndexes().addElement(new Integer(index));
            ++index;
        }
        Vector newIndexes = this.selectedIndexes();
        Vector xor = this.xorIndexes_with_(newIndexes, oldIndexes);
        this.changed_with_(StObject.$((String)"selectedIndexes"), xor);
    }

    public IsrImageObject[] selectedImages() {
        Vector<IsrImageObject> selectedImages = new Vector<IsrImageObject>();
        if (this.selectedIndexes().size() == 0) {
            return new IsrImageObject[0];
        }
        StBlockClosure sortBlock = new StBlockClosure(){

            public Object value_value_(Object obj1, Object obj2) {
                return new Boolean((Integer)obj1 <= (Integer)obj2);
            }
        };
        StSortedCollection sortedCollection = new StSortedCollection(sortBlock, this.selectedIndexes());
        Object[] collection = sortedCollection._asArray();
        int i = 0;
        while (i < collection.length) {
            selectedImages.addElement(this.imageObjects()[(Integer)collection[i]]);
            ++i;
        }
        IsrImageObject[] results = new IsrImageObject[selectedImages.size()];
        selectedImages.copyInto(results);
        return results;
    }

    public Vector selectedIndexes() {
        if (this.selectedIndexes == null) {
            this.clearSelectedIndexes();
        }
        return this.selectedIndexes;
    }

    public void selectedIndexes_(Vector indexes) {
        this.selectedIndexes = indexes;
    }

    public void selectIndexes() {
        String string = StDialog.Request_((String)"Enter indexes, then accept. Wild cards (*?[-]) are allowrd", (String)"");
        if (string == null || string.length() == 0) {
            return;
        }
        Vector tokens = IsrImageFolder.Separate_dividers_(string, IsrImageFolder.Dividers());
        Vector oldIndexes = (Vector)this.selectedIndexes.clone();
        Vector<Integer> indexes = new Vector<Integer>();
        int index = 0;
        while (index < this.imageObjects().length) {
            Enumeration enumeration = tokens.elements();
            while (enumeration.hasMoreElements()) {
                String token = (String)enumeration.nextElement();
                if (!IsrImageFolder.StringMatch_and_(String.valueOf(index), token)) continue;
                indexes.addElement(new Integer(index));
            }
            ++index;
        }
        this.selectedIndexes_(indexes);
        Vector newIndexes = this.selectedIndexes();
        Vector xor = this.xorIndexes_with_(newIndexes, oldIndexes);
        this.changed_with_(StObject.$((String)"selectedIndexes"), xor);
    }

    private void setImageObjects_(IsrImageObject[] collectionOfImageObjects) {
        this.imageObjects = collectionOfImageObjects;
    }

    public void showImageAttributes() {
        Frame window = null;
        IsrImageObject[] images = this.selectedImages();
        if (images.length == 0) {
            return;
        }
        IsrImageObject first = images[0];
        IsrDisplayModel model = this.displayModelForAttributes();
        String label = first.fileName().toString();
        Frame[] frames = model.builder().frames();
        int i = 0;
        while (i < frames.length) {
            model.visual_(first.imageAttributes().image());
            window = frames[i];
            window.setTitle(label);
            if (window.isShowing()) {
                window.toFront();
            } else {
                window.show();
            }
            ++i;
        }
        if (frames.length == 0) {
            model.visual_(first.imageAttributes().image());
            window = model.open();
            window.setTitle(label);
        }
        if (images.length > 1) {
            i = 1;
            while (i < images.length) {
                IsrImageObject each = images[i];
                label = each.fileName().toString();
                model.visual_(each.imageAttributes().image());
                window.setTitle(label);
                ++i;
            }
        }
    }

    public void showNewImageAttributes() {
        IsrImageObject[] images = this.selectedImages();
        if (images.length == 0) {
            return;
        }
        int i = 0;
        while (i < images.length) {
            IsrImageObject each = images[i];
            String label = each.fileName().toString();
            IsrDisplayModel.OpenVisual_label_(each.imageAttributes().image(), label);
            ++i;
        }
    }

    public void showNewOriginalImages() {
        IsrImageObject[] images = this.selectedImages();
        if (images.length == 0) {
            return;
        }
        int i = 0;
        while (i < images.length) {
            IsrImageObject each = images[i];
            String label = each.fileName().toString();
            IsrDisplayModel.OpenVisual_label_(each.originalImage().image(), label);
            ++i;
        }
    }

    public void showOriginalImages() {
        Frame window = null;
        IsrImageObject[] images = this.selectedImages();
        if (images.length == 0) {
            return;
        }
        IsrImageObject first = images[0];
        IsrDisplayModel model = this.displayModelForOriginal();
        String label = first.fileName().toString();
        Frame[] frames = model.builder().frames();
        int i = 0;
        while (i < frames.length) {
            model.visual_(first.originalImage().image());
            window = frames[i];
            window.setTitle(label);
            if (window.isShowing()) {
                window.toFront();
            } else {
                window.show();
            }
            ++i;
        }
        if (frames.length == 0) {
            model.visual_(first.originalImage().image());
            window = model.open();
            window.setTitle(label);
        }
        if (images.length > 1) {
            i = 1;
            while (i < images.length) {
                IsrImageObject each = images[i];
                label = each.fileName().toString();
                model.visual_(each.originalImage().image());
                window.setTitle(label);
                ++i;
            }
        }
    }

    public boolean slaveFlag() {
        return this.slaveFlag;
    }

    public void slaveFlag_(boolean aBoolean) {
        this.slaveFlag = aBoolean;
    }

    public void windowClosing(WindowEvent e) {
        if (this.slaveFlag()) {
            StApplicationModel[] models = new StApplicationModel[]{this.displayModelForOriginal(), this.displayModelForAttributes()};
            int i = 0;
            while (i < models.length) {
                StApplicationModel model = models[i];
                Frame[] frames = model.builder().frames();
                int j = 0;
                while (j < frames.length) {
                    ((Component)frames[j]).setVisible(false);
                    ++j;
                }
                ++i;
            }
            super.windowClosing(e);
        } else {
            Window aWindow = e.getWindow();
            Point location = aWindow.getLocationOnScreen();
            Dimension size = aWindow.getSize();
            location = new Point(location.x + size.width, location.y);
            if (StDialog.Confirm_((String)"Really close?", (boolean)false, (Point)location)) {
                StApplicationModel[] models = new StApplicationModel[]{this.displayModelForOriginal(), this.displayModelForAttributes()};
                int i = 0;
                while (i < models.length) {
                    StApplicationModel model = models[i];
                    Frame[] frames = model.builder().frames();
                    int j = 0;
                    while (j < frames.length) {
                        ((Component)frames[j]).setVisible(false);
                        ++j;
                    }
                    ++i;
                }
                super.windowClosing(e);
            }
        }
    }

    protected String windowTitle() {
        return "Image Browser";
    }

    public Vector xorIndexes_with_(Vector newCollection, Vector oldCollection) {
        Integer each;
        Vector<Integer> intersect = new Vector<Integer>();
        Enumeration enumeration = oldCollection.elements();
        while (enumeration.hasMoreElements()) {
            each = (Integer)enumeration.nextElement();
            if (!newCollection.contains(each)) continue;
            intersect.addElement(each);
        }
        enumeration = newCollection.elements();
        while (enumeration.hasMoreElements()) {
            each = (Integer)enumeration.nextElement();
            oldCollection.addElement(each);
        }
        Vector<Integer> xor = new Vector<Integer>();
        enumeration = oldCollection.elements();
        while (enumeration.hasMoreElements()) {
            each = (Integer)enumeration.nextElement();
            if (intersect.contains(each)) continue;
            xor.addElement(each);
        }
        return xor;
    }
}

