/*
 * Decompiled with CFR 0.152.
 */
package sra.isr.geometry.basic;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import sra.isr.geometry.basic.IsrPoint;

public class Isr2dPoint
extends IsrPoint
implements Serializable {
    protected double x;
    protected double y;

    public Isr2dPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public IsrPoint abs() {
        return new Isr2dPoint(Math.abs(this.x), Math.abs(this.y));
    }

    public double[] asArray() {
        return new double[]{this.x, this.y};
    }

    public double distance_(Isr2dPoint aPoint) {
        return this.minus_(aPoint).rho();
    }

    public Isr2dPoint dividedBy_(double delta) {
        return new Isr2dPoint(this.x / delta, this.y / delta);
    }

    public Isr2dPoint dividedBy_(Isr2dPoint aPoint) {
        return new Isr2dPoint(this.x / aPoint.x, this.y / aPoint.y);
    }

    public double dotProduct_(Isr2dPoint aPoint) {
        Isr2dPoint newPoint = this.multipliedBy_(aPoint);
        return newPoint.x + newPoint.y;
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof Isr2dPoint)) {
            return false;
        }
        Isr2dPoint aPoint = (Isr2dPoint)anObject;
        return this.x == aPoint.x && this.y == aPoint.y;
    }

    public static Isr2dPoint FromArray_(double[] anArray) {
        return new Isr2dPoint(anArray[0], anArray[1]);
    }

    public static Isr2dPoint FromPoint_(Isr2dPoint aPoint) {
        return new Isr2dPoint(aPoint.x, aPoint.y);
    }

    public int generality() {
        return 200;
    }

    public int hashCode() {
        long bitsX = Double.doubleToLongBits(this.x);
        int xHash = (int)(bitsX ^ bitsX >> 32);
        long bitsY = Double.doubleToLongBits(this.y);
        int yHash = (int)(bitsY ^ bitsY >> 32);
        return xHash >> 2 | yHash;
    }

    public double innerProduct_(Isr2dPoint aPoint) {
        return this.dotProduct_(aPoint);
    }

    public boolean is2d() {
        return true;
    }

    public boolean isLessThan_(Isr2dPoint aPoint) {
        return this.x < aPoint.x && this.y < aPoint.y;
    }

    public boolean isLessThanOrEqualTo_(Isr2dPoint aPoint) {
        return this.x <= aPoint.x && this.y <= aPoint.y;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public Isr2dPoint length_(double aNumber) {
        double length = this.length();
        if (length <= 1.0E-12) {
            return this;
        }
        return this.multipliedBy_(aNumber / length);
    }

    public Isr2dPoint max_(Isr2dPoint aPoint) {
        return new Isr2dPoint(Math.max(this.x, aPoint.x), Math.max(this.y, aPoint.y));
    }

    public Isr2dPoint min_(Isr2dPoint aPoint) {
        return new Isr2dPoint(Math.min(this.x, aPoint.x), Math.min(this.y, aPoint.y));
    }

    public Isr2dPoint minus_(double delta) {
        return new Isr2dPoint(this.x - delta, this.y - delta);
    }

    public Isr2dPoint minus_(Isr2dPoint aPoint) {
        return new Isr2dPoint(this.x - aPoint.x, this.y - aPoint.y);
    }

    public Isr2dPoint multipliedBy_(double delta) {
        return new Isr2dPoint(this.x * delta, this.y * delta);
    }

    public Isr2dPoint multipliedBy_(Isr2dPoint aPoint) {
        return new Isr2dPoint(this.x * aPoint.x, this.y * aPoint.y);
    }

    public Isr2dPoint negated() {
        return Isr2dPoint.Zero().minus_(this);
    }

    public Isr2dPoint plus_(double delta) {
        return new Isr2dPoint(this.x + delta, this.y + delta);
    }

    public Isr2dPoint plus_(Isr2dPoint aPoint) {
        return new Isr2dPoint(this.x + aPoint.x, this.y + aPoint.y);
    }

    public void printOn_(Writer aWriter) throws IOException {
        aWriter.write("(");
        aWriter.write(String.valueOf(this.x));
        aWriter.write(" , ");
        aWriter.write(String.valueOf(this.y));
        aWriter.write(")");
    }

    public double product_(Isr2dPoint aPoint) {
        return this.x * aPoint.y - this.y * aPoint.x;
    }

    public double rho() {
        return Math.sqrt(this.dotProduct_(this));
    }

    public static Isr2dPoint Rho_theta_(double rho, double theta) {
        return new Isr2dPoint(rho * Math.cos(theta), rho * Math.sin(theta));
    }

    public Isr2dPoint rounded() {
        return new Isr2dPoint(Math.round(this.x), Math.round(this.y));
    }

    public Isr2dPoint truncated() {
        double newX = this.x >= 0.0 ? Math.ceil(this.x) : Math.floor(this.x);
        double newY = this.y >= 0.0 ? Math.ceil(this.y) : Math.floor(this.y);
        return new Isr2dPoint(newX, newY);
    }

    public Isr2dPoint unitVector() {
        return this.length_(1.0);
    }

    public static Isr2dPoint Unity() {
        return new Isr2dPoint(1.0, 1.0);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public static Isr2dPoint Zero() {
        return new Isr2dPoint(0.0, 0.0);
    }
}

