/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.IPDialog;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IconSquare;
import com.equitysoft.icon.LibButton;
import com.equitysoft.icon.Palette;
import com.equitysoft.icon.Parser;
import com.equitysoft.icon.SysProps;
import com.equitysoft.icon.XPMname;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class XPMList
extends IPDialog
implements ActionListener,
ListSelectionListener {
    String APPLY = "Apply";
    String CANCEL = "Cancel";
    DefaultListModel vals = new DefaultListModel();
    JTextField tf;
    static JList list;
    StringBuffer sb;

    XPMList() {
        super("Choose from XPM colors");
        this.jp.setLayout(new BorderLayout());
        if (!this.setUp()) {
            return;
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "RGB value"));
        this.tf = new JTextField(25);
        this.tf.setHorizontalAlignment(0);
        this.tf.setFont(SysProps.MSG_FONT);
        jPanel.add(this.tf);
        this.tf.setEditable(false);
        this.jp.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 3, 10, 3), BorderFactory.createLoweredBevelBorder()));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(150, 250));
        list = new JList();
        list.addListSelectionListener(this);
        list.setSelectionMode(0);
        list.setModel(this.vals);
        list.setCellRenderer(new CRenderer());
        jScrollPane.getViewport().setView(list);
        jPanel2.add((Component)jScrollPane, "Center");
        this.jp.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        LibButton libButton = new LibButton(this.APPLY);
        jPanel3.add(libButton);
        libButton.addActionListener(this);
        libButton = new LibButton(this.CANCEL);
        jPanel3.add(libButton);
        libButton.addActionListener(this);
        this.jp.add((Component)jPanel3, "South");
        this.finishOff();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.closeDialog();
        if (actionEvent.getActionCommand() == this.APPLY) {
            int n = list.getSelectedIndex();
            if (n < 0) {
                return;
            }
            XPMname xPMname = (XPMname)list.getSelectedValue();
            Palette.setCurrent(xPMname.col.getRGB());
        }
    }

    boolean setUp() {
        String string;
        String string2 = IPUtils.getFileAsString("images/unique.text");
        if (string2 == null) {
            return false;
        }
        Parser.init(string2.length());
        while ((string = Parser.nextToken(string2)) != null) {
            Color color = new Color(Integer.parseInt(string), Integer.parseInt(Parser.nextToken(string2)), Integer.parseInt(Parser.nextToken(string2)));
            this.vals.addElement(new XPMname(color, Parser.nextLineEnd(string2)));
        }
        return true;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.sb == null) {
            this.sb = new StringBuffer(20);
        } else {
            this.sb.setLength(0);
        }
        XPMname xPMname = (XPMname)list.getSelectedValue();
        if (xPMname == null) {
            this.tf.setText(null);
        } else {
            this.sb.append(' ').append("R: ").append(xPMname.col.getRed()).append("  G: ").append(xPMname.col.getGreen());
            this.sb.append("  B: ").append(xPMname.col.getBlue());
            this.tf.setText(this.sb.toString());
        }
    }

    class CRenderer
    extends JLabel
    implements ListCellRenderer {
        public CRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(Color.darkGray);
                this.setForeground(Color.cyan);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            XPMname xPMname = (XPMname)object;
            this.setHorizontalTextPosition(4);
            this.setIcon(new IconSquare(xPMname.col));
            this.setText(xPMname.name);
            return this;
        }
    }
}

