/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Bar;
import com.equitysoft.icon.CurveOptions;
import com.equitysoft.icon.Dummy;
import com.equitysoft.icon.FileManager;
import com.equitysoft.icon.FloodOptions;
import com.equitysoft.icon.FontBox;
import com.equitysoft.icon.IPMsg;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.ImageEffect;
import com.equitysoft.icon.LogoPanel;
import com.equitysoft.icon.MBar;
import com.equitysoft.icon.PopupOptions;
import com.equitysoft.icon.Status;
import com.equitysoft.icon.SwingToolButton;
import com.equitysoft.icon.SysProps;
import com.equitysoft.icon.TypeBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.DataBufferInt;

class ToolBar
extends Container
implements ActionListener {
    static Dimension DIM = new Dimension(32, 32);
    String NEW = "new_lg.gif";
    String OPEN = "open_lg.gif";
    String SAVE = "save_lg.gif";
    String FLOOD = "flood.gif";
    String FONT = "font.gif";
    String TEXT = "text.gif";
    String UNDO = "undo.gif";
    String CIRCLE = "circle.gif";
    String ELLIPSE = "ellipse.gif";
    String BOX = "box.gif";
    String TRIANGLE = "triangle.gif";
    String POLYGON = "polygon.gif";
    String LINE = "line.gif";
    String CURVES = "curves.gif";
    String EFFECT = "effect.gif";
    String COLORS = "colors.gif";
    static PopupOptions puo;
    static CurveOptions co;
    FloodOptions fo;

    ToolBar() {
        this.setBackground(Color.lightGray);
        this.setLayout(new FlowLayout(0, 1, 0));
        this.addButton(this.NEW, "Begin new image", DIM);
        this.addButton(this.OPEN, "Open existing image file", DIM);
        this.addButton(this.SAVE, "Save image to a file", DIM);
        this.addButton(this.UNDO, "Undo last change to image", DIM);
        this.addButton(this.TEXT, "Create text", DIM);
        this.addButton(this.FONT, "Change text font", DIM);
        this.addButton(this.FLOOD, "Flood-fill", DIM);
        this.addButton(this.LINE, "Draw a line", DIM);
        this.addButton(this.CIRCLE, "Draw a circle", DIM);
        this.addButton(this.ELLIPSE, "Draw an ellipse", DIM);
        this.addButton(this.BOX, "Draw a box", DIM);
        this.addButton(this.TRIANGLE, "Draw a triangle", DIM);
        this.addButton(this.POLYGON, "Draw a polygon", DIM);
        this.addButton(this.CURVES, "Draw a curve", DIM);
        this.addButton(this.EFFECT, "Apply filter effect", DIM);
        this.addButton(this.COLORS, "Count the colors", new Dimension(32, 32));
        this.add(new Dummy(new Dimension(1, 1), false));
        if (SysProps.spin == 0) {
            this.add(new LogoPanel());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        TypeBox.hideIt();
        PopupOptions.hideIt();
        if (Status.action != 12) {
            Status.clear();
        }
        if (string == this.NEW) {
            IPUtils.newIcon();
        } else if (string == this.OPEN) {
            FileManager.openFile();
        } else if (string == this.SAVE) {
            MBar.save();
        } else if (string == this.FLOOD) {
            if (co == null) {
                this.fo = new FloodOptions();
                this.add(this.fo);
            }
            Component component = (Component)actionEvent.getSource();
            Point point = component.getLocation();
            Dimension dimension = component.getSize();
            this.fo.show(this, point.x, point.y + dimension.height);
        } else if (string == this.UNDO) {
            IconPainter.undo();
        } else if (string == this.TEXT) {
            Bar.initTextAdd();
        } else if (string == this.FONT) {
            new FontBox();
        } else if (string == this.LINE) {
            Status.set(PopupOptions.DRAG_MSG, 8);
        } else if (string == this.CIRCLE) {
            this.showPopup(actionEvent, PopupOptions.CIRCLE);
        } else if (string == this.BOX) {
            this.showPopup(actionEvent, PopupOptions.BOX);
        } else if (string == this.ELLIPSE) {
            this.showPopup(actionEvent, PopupOptions.ELLIPSE);
        } else if (string == this.TRIANGLE) {
            this.showPopup(actionEvent, PopupOptions.TRIANGLE);
        } else if (string == this.POLYGON) {
            this.showPopup(actionEvent, PopupOptions.POLYGON);
        } else if (string == this.CURVES) {
            if (co == null) {
                co = new CurveOptions();
                this.add(co);
            }
            Component component = (Component)actionEvent.getSource();
            Point point = component.getLocation();
            Dimension dimension = component.getSize();
            co.show(this, point.x, point.y + dimension.height);
        } else if (string == this.EFFECT) {
            new ImageEffect();
        } else if (string == this.COLORS) {
            int[] nArray = ((DataBufferInt)IconPainter.curr.getRaster().getDataBuffer()).getData();
            int n = nArray.length;
            int[] nArray2 = new int[256];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                block38: {
                    int n5 = nArray[n4];
                    n3 = 0;
                    while (n3 < n2) {
                        if (nArray2[n3] != n5) {
                            ++n3;
                            continue;
                        }
                        break block38;
                    }
                    if (n2 == 256) {
                        new IPMsg("There are more than 256 colors in the image");
                        return;
                    }
                    nArray2[n2] = n5;
                    ++n2;
                }
                ++n4;
            }
            new IPMsg("The total number of colors in the image is " + n2);
        }
    }

    void addButton(String string, String string2, Dimension dimension) {
        Image image = IPUtils.getSystemImage(string);
        this.add(new SwingToolButton(image, string2, dimension, this, string));
    }

    void showPopup(ActionEvent actionEvent, String string) {
        if (puo == null) {
            puo = new PopupOptions();
            this.add(puo);
        }
        Component component = (Component)actionEvent.getSource();
        Point point = component.getLocation();
        Dimension dimension = component.getSize();
        puo.showOptions(this, point.x, point.y + dimension.height, string);
    }
}

