/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JButton;

public class SwingColorButton
extends JButton {
    Dimension prefdim;
    boolean up;
    String name;
    BufferedImage bi;

    public SwingColorButton(ActionListener actionListener, Dimension dimension) {
        this(actionListener, dimension, null);
    }

    public SwingColorButton(ActionListener actionListener, Dimension dimension, String string) {
        this.enableEvents(16L);
        this.prefdim = dimension;
        this.setPreferredSize(dimension);
        this.addActionListener(actionListener);
        this.setBorderPainted(false);
        this.name = string;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.prefdim.width, this.prefdim.height);
        if (this.bi != null) {
            graphics.drawImage(this.bi, 0, 0, this.prefdim.width, this.prefdim.height, null);
        }
        graphics.setColor(Color.lightGray);
        graphics.draw3DRect(0, 0, this.prefdim.width - 1, this.prefdim.height - 1, this.up);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 504: {
                this.up = true;
                this.repaint();
                break;
            }
            case 505: {
                this.up = false;
                this.repaint();
                break;
            }
            case 501: {
                this.up = false;
                this.repaint();
                break;
            }
            case 502: {
                this.up = true;
                this.repaint();
                if (this.contains(mouseEvent.getX(), mouseEvent.getY())) break;
                return;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void setBackground(Color color) {
        String string = this.name == null ? "R:" + color.getRed() + " G:" + color.getGreen() + " B:" + color.getBlue() : String.valueOf(this.name) + "  R:" + color.getRed() + " G:" + color.getGreen() + " B:" + color.getBlue();
        this.setToolTipText(string);
        super.setBackground(color);
    }

    void setImage(BufferedImage bufferedImage) {
        this.bi = bufferedImage;
        if (bufferedImage == null) {
            this.setBackground(this.getBackground());
        } else {
            this.setToolTipText("Click to restore original color");
        }
    }
}

