/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.CrissCross;
import com.equitysoft.icon.FileFinder;
import com.equitysoft.icon.FileManager;
import com.equitysoft.icon.IPLib;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.Status;
import com.equitysoft.icon.SysProps;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.util.Vector;
import javax.swing.JMenu;

class ShapeMenu
extends JMenu
implements ActionListener {
    static File SHAPE_DIR;
    String DEFINE = "Define & save a polygon shape";
    String UO = "Outlined";
    String UF = "Filled";
    String UFO = "Filled & outlined";
    String SO = "Scaled & outlined";
    String SF = "Scaled & filled";
    String SFO = "Scaled, filled & outlined";

    ShapeMenu() {
        super("  Shape  ");
        this.setMnemonic(65);
        this.add(IPUtils.getMI(this.DEFINE, this, 68));
        JMenu jMenu = new JMenu("Select and draw unscaled shape");
        this.add(jMenu);
        jMenu.setMnemonic(85);
        jMenu.add(IPUtils.getMI(this.UO, this, 79));
        jMenu.add(IPUtils.getMI(this.UF, this, 70));
        jMenu.add(IPUtils.getMI(this.UFO, this, 73));
        jMenu = new JMenu("Select and draw scaled shape");
        this.add(jMenu);
        jMenu.setMnemonic(83);
        jMenu.add(IPUtils.getMI(this.SO, this, 79));
        jMenu.add(IPUtils.getMI(this.SF, this, 70));
        jMenu.add(IPUtils.getMI(this.SFO, this, 73));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object;
        String string = actionEvent.getActionCommand();
        if (string == this.DEFINE) {
            Status.set("Click on the corners of the polygon, double click to save", 34);
            return;
        }
        ShapeMenu.checkDir();
        String[] stringArray = new String[]{".ips"};
        File file = FileFinder.ask(SHAPE_DIR, "Choose the shape to draw", 1, "Shape file", stringArray, 1);
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            new IPZap("Unable to read file");
            return;
        }
        Vector<Point> vector = new Vector<Point>(10);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            object = new DataInputStream(new FileInputStream(file));
            n4 = ((DataInputStream)object).readInt();
            n3 = ((DataInputStream)object).readInt();
            n2 = ((DataInputStream)object).readInt();
            n = 0;
            while (n < n2) {
                vector.addElement(new Point(((DataInputStream)object).readInt(), ((DataInputStream)object).readInt()));
                ++n;
            }
            ((FilterInputStream)object).close();
        }
        catch (Exception exception) {
            new IPZap("Unable to load the shape polygon");
        }
        if (actionEvent.getActionCommand().startsWith("Scaled")) {
            n = IconPainter.cols;
            int n5 = IconPainter.rows;
            int n6 = 0;
            while (n6 < n2) {
                object = (Point)vector.elementAt(n6);
                ((Point)object).x = ((Point)object).x * n / n3;
                ((Point)object).y = ((Point)object).y * n5 / n4;
                ++n6;
            }
        }
        if (string == this.UO || string == this.SO) {
            IPLib.fill = 0;
        } else if (string == this.UF || string == this.SF) {
            IPLib.fill = 1;
        } else if (string == this.UFO || string == this.SFO) {
            IPLib.fill = 2;
        }
        IconPainter.startAdd();
        IPLib.drawMPLine(vector);
        CrissCross.points.clear();
        CrissCross.handle.endPaint();
    }

    static void checkDir() {
        if (SHAPE_DIR == null && !(SHAPE_DIR = new File(SysProps.CURR_DIR, "shapes")).exists()) {
            SHAPE_DIR.mkdir();
        }
    }

    static void saveShape(Vector vector) {
        ShapeMenu.checkDir();
        String[] stringArray = new String[]{".ips"};
        File file = FileFinder.ask(SHAPE_DIR, "Specify the shape name", 2, "Name of shape file", stringArray, 1);
        if (file == null) {
            return;
        }
        file = FileManager.checkExtension(file, 16);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            dataOutputStream.writeInt(IconPainter.rows);
            dataOutputStream.writeInt(IconPainter.cols);
            int n = vector.size();
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                Point point = (Point)vector.elementAt(n2);
                dataOutputStream.writeInt(point.x);
                dataOutputStream.writeInt(point.y);
                ++n2;
            }
            dataOutputStream.close();
        }
        catch (Exception exception) {
            new IPZap("Unable to save the shape polygon");
        }
    }
}

