/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.FileFinder;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.InfoBar;
import com.equitysoft.icon.ShadeBar;
import com.equitysoft.icon.Status;
import com.equitysoft.icon.SwingColorButton;
import com.equitysoft.icon.SysProps;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

class Palette
extends Container
implements ActionListener {
    static int currcolor;
    static int targcol;
    static final Dimension DIM;
    static final int NUM = 44;
    static final int HALF = 22;
    static SwingColorButton[] boxes;
    static JFileChooser fc;
    static String IPP;
    static Palette handle;
    static boolean usetexture;
    static BufferedImage texture;

    static {
        targcol = Color.red.getRGB();
        DIM = new Dimension(18, 18);
        boxes = new SwingColorButton[44];
        IPP = "IPP";
        handle = new Palette();
    }

    Palette() {
        this.setLayout(new GridLayout(2, 1));
        Container container = new Container();
        container.setLayout(new FlowLayout(0, 1, 1));
        SwingColorButton swingColorButton = null;
        int n = 0;
        while (n < 22) {
            swingColorButton = new SwingColorButton(this, DIM);
            container.add(swingColorButton);
            Palette.boxes[n] = swingColorButton;
            ++n;
        }
        this.add(container);
        container = new Container();
        container.setLayout(new FlowLayout(0, 1, 1));
        int n2 = 43;
        while (n2 >= 22) {
            swingColorButton = new SwingColorButton(this, DIM);
            container.add(swingColorButton);
            Palette.boxes[n2] = swingColorButton;
            --n2;
        }
        this.add(container);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SwingColorButton swingColorButton = (SwingColorButton)actionEvent.getSource();
        switch (Status.action) {
            case 1: {
                ((JComponent)swingColorButton).setBackground(new Color(currcolor));
                break;
            }
            case 2: {
                targcol = swingColorButton.getBackground().getRGB();
                InfoBar.set();
                break;
            }
            case 3: {
                ((JComponent)swingColorButton).setBackground(new Color(targcol));
                break;
            }
            case 13: {
                IconPainter.resetBack(swingColorButton.getBackground());
                break;
            }
            default: {
                Palette.setCurrent(swingColorButton.getBackground().getRGB());
            }
        }
        Status.clear();
    }

    static void load() {
        String[] stringArray = new String[]{".pal"};
        File file = FileFinder.ask(SysProps.getPaletteDir(), "Loading palette file", 1, "Palette to load", stringArray, 1);
        if (file == null) {
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            if (!dataInputStream.readUTF().equals(IPP)) {
                new IPZap("This file is not a valid palette file.");
                dataInputStream.close();
                return;
            }
            int n = 0;
            while (n < 44) {
                ((JComponent)boxes[n]).setBackground(new Color(dataInputStream.readInt()));
                ++n;
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            new IPZap("Unable to load palette - possibly a 16 color palette");
            return;
        }
    }

    static void save() {
        int n;
        String[] stringArray = new String[]{".pal"};
        File file = FileFinder.ask(SysProps.getPaletteDir(), "Choose a name for the palette file", 2, "Palette file", stringArray, 1);
        if (file == null) {
            return;
        }
        String string = file.getName();
        int n2 = string.lastIndexOf(46);
        file = n2 == (n = string.length() - 1) ? new File(file.getParent(), String.valueOf(string) + "pal") : (n2 == -1 ? new File(file.getParent(), String.valueOf(string) + ".pal") : new File(file.getParent(), String.valueOf(string.substring(0, n2)) + ".pal"));
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            dataOutputStream.writeUTF(IPP);
            int n3 = 0;
            while (n3 < 44) {
                dataOutputStream.writeInt(boxes[n3].getBackground().getRGB());
                ++n3;
            }
            dataOutputStream.close();
        }
        catch (Exception exception) {
            new IPZap("Unable to load palette");
            return;
        }
    }

    static void setColors() {
        Color[] colorArray = new Color[]{Color.white, new Color(255, 204, 255), new Color(204, 255, 204), new Color(204, 204, 255), Color.pink, new Color(255, 120, 120), Color.red, new Color(210, 0, 0), Color.red.darker(), new Color(150, 0, 0), new Color(255, 170, 255), new Color(255, 100, 255), Color.magenta, new Color(200, 0, 200), new Color(255, 204, 102), Color.orange, new Color(204, 153, 0), new Color(255, 255, 130), Color.yellow, new Color(220, 220, 0), Color.yellow.darker(), new Color(153, 153, 0), new Color(153, 255, 153), Color.green, new Color(0, 200, 0), Color.green.darker(), new Color(0, 130, 0), new Color(153, 255, 255), Color.cyan, new Color(0, 200, 200), new Color(0, 175, 175), new Color(153, 153, 255), new Color(102, 102, 255), Color.blue, Color.blue.darker(), new Color(0, 0, 150), new Color(0, 0, 100), new Color(210, 210, 210), Color.lightGray, new Color(140, 140, 140), new Color(100, 100, 100), Color.darkGray, new Color(32, 32, 32), Color.black};
        int n = 0;
        while (n < 22) {
            ((JComponent)boxes[n]).setBackground(colorArray[n]);
            ++n;
        }
        int n2 = 22;
        while (n2 < 44) {
            ((JComponent)boxes[n2]).setBackground(colorArray[n2]);
            ++n2;
        }
    }

    static void setCurrent(int n) {
        usetexture = false;
        InfoBar.setImage(null);
        InfoBar.lastcurr = 0;
        currcolor = n;
        ShadeBar.handle.repaint();
        InfoBar.set();
    }

    static void setGrayScale() {
        float f = 5.8086557f;
        int n = 0;
        while (n < 44) {
            int n2 = 255 - Math.round((float)n * f);
            ((JComponent)boxes[n]).setBackground(new Color(n2, n2, n2));
            ++n;
        }
        ((JComponent)boxes[43]).setBackground(Color.black);
    }

    static void setTexture(BufferedImage bufferedImage) {
        texture = bufferedImage;
        usetexture = true;
        InfoBar.setImage(bufferedImage);
    }

    static void useOriginal() {
        Palette.setCurrent(currcolor);
    }
}

