/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Adjuster;
import com.equitysoft.icon.Bar;
import com.equitysoft.icon.FontBox;
import com.equitysoft.icon.OBRenderer;
import com.equitysoft.icon.PlusMinus;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JComboBox;
import javax.swing.JLabel;

class OptionsBox
extends JComboBox
implements Adjuster {
    static final int DIREC_IDX = 0;
    static final int FSIZE_IDX = 1;
    static final int TRANS_IDX = 2;
    static final int ALIAS_IDX = 3;
    static final int STROKE_IDX = 4;
    static final int JOIN_IDX = 5;
    static final int END_IDX = 6;
    static final int DASH_IDX = 7;
    static final int SHADOW_IDX = 8;
    static final int OFFSET_IDX = 9;
    static final int NORTH = 1;
    static final int NORTHEAST = 2;
    static final int EAST = 3;
    static final int SOUTHEAST = 4;
    static final int SOUTH = 5;
    static final int SOUTHWEST = 6;
    static final int WEST = 7;
    static final int NORTHWEST = 8;
    static OptionsBox handle;
    static int shadow;
    static String[] SHADOW_TXT;
    static int offset;
    static String OFFSET_TXT;
    static int antialias;
    static int filldirec;
    static String[] ALIAS_TXT;
    static String[] DIRECTIONS;
    static int fsize;
    static String FSIZE_TXT;
    static String TRANS;
    static String STROKE;
    static Dimension DIM;
    static int LAST;
    static int stroke;
    static float transparency;
    static int dash;
    static String DASH_TXT;
    static String NODASH_TXT;
    static int join;
    static int[] joins;
    static String[] JOIN_TXT;
    static int end;
    static int[] ends;
    static String[] ENDS_TXT;

    static {
        shadow = 0;
        SHADOW_TXT = new String[]{" No shadow", " North shadow", " NorthEast shadow", " East shadow", " SouthEast shadow", " South shadow", " SouthWest shadow", " West shadow", " NorthWest shadow"};
        offset = 1;
        OFFSET_TXT = " Shadow offset ";
        ALIAS_TXT = new String[]{" Antialias On", " Antialias Off"};
        DIRECTIONS = new String[]{" No fill gradient", " Fill to North", " Fill to NorthEast", " Fill to East", " Fill to SouthEast", " Fill to South", " Fill to SouthWest", " Fill to West", " Fill to NorthWest"};
        fsize = 10;
        FSIZE_TXT = " Font size ";
        TRANS = " Transparency ";
        STROKE = " Line width ";
        stroke = 1;
        transparency = 1.0f;
        dash = 0;
        DASH_TXT = " Dash interval ";
        NODASH_TXT = " No dash in lines";
        join = 0;
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        joins = nArray;
        JOIN_TXT = new String[]{" Miter join lines", " Round join lines", " Bevel join lines"};
        end = 0;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 2;
        ends = nArray2;
        ENDS_TXT = new String[]{" Butt end lines", " Round end lines", " Square end lines"};
    }

    OptionsBox() {
        handle = this;
        JLabel jLabel = new JLabel(String.valueOf(TRANS) + "-0.75");
        DIM = jLabel.getPreferredSize();
        this.setRenderer(new OBRenderer());
        OptionsBox.reset();
    }

    public void adjust(PlusMinus plusMinus, int n) {
        int n2 = this.getSelectedIndex();
        String string = null;
        switch (n2) {
            case 0: {
                if ((filldirec += n) == DIRECTIONS.length) {
                    filldirec = 0;
                } else if (filldirec < 0) {
                    filldirec = DIRECTIONS.length - 1;
                }
                string = DIRECTIONS[filldirec];
                break;
            }
            case 1: {
                if ((fsize += n) < 3) {
                    fsize = 3;
                    return;
                }
                string = String.valueOf(FSIZE_TXT) + fsize;
                Bar.drawText();
                break;
            }
            case 2: {
                int n3 = Math.round(transparency * 10.0f);
                if ((n3 += n) < 1) {
                    n3 = 1;
                } else if (n3 == 11) {
                    n3 = 10;
                }
                transparency = n3;
                string = String.valueOf(TRANS) + (transparency /= 10.0f);
                break;
            }
            case 4: {
                if ((stroke += n) == 0) {
                    stroke = 1;
                    return;
                }
                string = String.valueOf(STROKE) + stroke;
                break;
            }
            case 5: {
                if ((join += n) == joins.length) {
                    join = 0;
                } else if (join < 0) {
                    join = joins.length - 1;
                }
                string = JOIN_TXT[join];
                break;
            }
            case 6: {
                if ((end += n) == ends.length) {
                    end = 0;
                } else if (end < 0) {
                    end = ends.length - 1;
                }
                string = ENDS_TXT[end];
                break;
            }
            case 7: {
                if ((dash += n) < 0) {
                    dash = 0;
                    return;
                }
                string = dash == 0 ? NODASH_TXT : String.valueOf(DASH_TXT) + dash;
                break;
            }
            case 3: {
                if ((antialias += n) == 2) {
                    antialias = 0;
                } else if (antialias < 0) {
                    antialias = 1;
                }
                string = ALIAS_TXT[antialias];
                break;
            }
            case 8: {
                if ((shadow += n) == SHADOW_TXT.length) {
                    shadow = 0;
                } else if (shadow < 0) {
                    shadow = SHADOW_TXT.length - 1;
                }
                string = SHADOW_TXT[shadow];
                break;
            }
            case 9: {
                if ((offset += n) == 0) {
                    offset = 1;
                }
                string = String.valueOf(OFFSET_TXT) + offset;
                break;
            }
        }
        this.removeItemAt(n2);
        if (n2 != LAST) {
            this.insertItemAt(string, n2);
        } else {
            this.addItem(string);
        }
        this.setSelectedIndex(n2);
        this.repaint();
    }

    static BasicStroke getBasicStroke() {
        if (dash == 0) {
            return new BasicStroke(stroke, end, join);
        }
        float[] fArray = new float[]{dash, dash};
        return new BasicStroke(stroke, end, join, 10.0f, fArray, 0.0f);
    }

    static Font getCurrentFont() {
        Font font = FontBox.getCurrFont();
        return new Font(font.getName(), font.getStyle(), fsize);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    static void reset() {
        handle.addItem(DIRECTIONS[filldirec]);
        handle.addItem(String.valueOf(FSIZE_TXT) + fsize);
        handle.addItem(String.valueOf(TRANS) + transparency);
        handle.addItem(ALIAS_TXT[antialias]);
        handle.addItem(String.valueOf(STROKE) + stroke);
        handle.addItem(JOIN_TXT[join]);
        handle.addItem(ENDS_TXT[end]);
        handle.addItem(dash == 0 ? NODASH_TXT : String.valueOf(DASH_TXT) + dash);
        handle.addItem(SHADOW_TXT[shadow]);
        handle.addItem(String.valueOf(OFFSET_TXT) + offset);
        LAST = handle.getItemCount() - 1;
    }

    static int transx(int n) {
        switch (shadow) {
            case 2: 
            case 3: 
            case 4: {
                return n + offset;
            }
            case 6: 
            case 7: 
            case 8: {
                return n - offset;
            }
        }
        return n;
    }

    static int transy(int n) {
        switch (shadow) {
            case 1: 
            case 2: 
            case 8: {
                return n - offset;
            }
            case 4: 
            case 5: 
            case 6: {
                return n + offset;
            }
        }
        return n;
    }
}

