/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Bar;
import com.equitysoft.icon.IPDialog;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.JSOLabel;
import com.equitysoft.icon.LibButton;
import com.equitysoft.icon.RBMI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

class OpenFileDialog
extends IPDialog
implements ItemListener,
ActionListener {
    static final int CENTER = 0;
    static final int SCALE = 1;
    static final int GRID = 2;
    static String CONTINUE = "Continue";
    static String CANCEL = "Cancel";
    int wid;
    int hgt;
    boolean ignore;
    int state;
    Image img;
    File f;

    OpenFileDialog(Image image, File file) {
        super("Image size mismatch dialog");
        this.img = image;
        this.f = file;
        this.wid = image.getWidth(null);
        this.hgt = image.getHeight(null);
        this.jp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 3, 10, 3), BorderFactory.createEtchedBorder()));
        JSOLabel jSOLabel = new JSOLabel("There is a mismatch between the current size and the new image. ");
        jPanel.add(jSOLabel);
        jSOLabel.setForeground(Color.black);
        jSOLabel = new JSOLabel("The current size is " + IconPainter.cols + " columns by " + IconPainter.rows + " rows");
        jPanel.add(jSOLabel);
        jSOLabel.setForeground(Color.black);
        jSOLabel = new JSOLabel("The image to be opened is " + this.wid + " columns by " + this.hgt + " rows");
        jPanel.add(jSOLabel);
        jSOLabel.setForeground(Color.black);
        this.jp.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 3, 10, 3), BorderFactory.createEtchedBorder()));
        ButtonGroup buttonGroup = new ButtonGroup();
        RBMI rBMI = new RBMI(2, "Change current size to fit image");
        jPanel2.add(rBMI);
        rBMI.addItemListener(this);
        rBMI.setSelected(true);
        buttonGroup.add(rBMI);
        rBMI = new RBMI(1, "Scale image to fit current size");
        jPanel2.add(rBMI);
        rBMI.addItemListener(this);
        buttonGroup.add(rBMI);
        rBMI = new RBMI(0, "Draw unscaled image centered over current size");
        jPanel2.add(rBMI);
        rBMI.addItemListener(this);
        buttonGroup.add(rBMI);
        this.jp.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 3, 10, 3), BorderFactory.createEtchedBorder()));
        LibButton libButton = new LibButton(CONTINUE);
        jPanel3.add(libButton);
        libButton.addActionListener(this);
        libButton = new LibButton(CANCEL);
        jPanel3.add(libButton);
        libButton.addActionListener(this);
        this.jp.add((Component)jPanel3, "South");
        this.finishOff();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == CONTINUE) {
            switch (this.state) {
                case 0: {
                    Graphics2D graphics2D = IconPainter.curr.createGraphics();
                    this.wid = (IconPainter.cols - this.wid) / 2;
                    this.hgt = (IconPainter.rows - this.hgt) / 2;
                    graphics2D.drawImage(this.img, this.wid, this.hgt, null);
                    Bar.setFile(this.f);
                    break;
                }
                case 1: {
                    Graphics2D graphics2D = IconPainter.curr.createGraphics();
                    graphics2D.drawImage(this.img, 0, 0, IconPainter.cols, IconPainter.rows, null);
                    Bar.setFile(this.f);
                    break;
                }
                case 2: {
                    if (IconPainter.sqdim != 1 && (this.wid * IconPainter.sqdim > IconPainter.screendim.width || this.hgt * IconPainter.sqdim > IconPainter.screendim.height)) {
                        this.closeDialog();
                        new IPZap("The grid size will be too big, change the square size and retry");
                        return;
                    }
                    IconPainter.init(this.wid, this.hgt);
                    Graphics2D graphics2D = IconPainter.curr.createGraphics();
                    graphics2D.drawImage(this.img, 0, 0, null);
                    Bar.setFile(this.f);
                    break;
                }
            }
            IconPainter.startAdd();
            IconPainter.refreshAll();
        }
        this.closeDialog();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        RBMI rBMI = (RBMI)itemEvent.getSource();
        if (!rBMI.isSelected()) {
            return;
        }
        if (this.ignore) {
            this.ignore = false;
            return;
        }
        if (rBMI.pos != this.state) {
            this.state = rBMI.pos;
        }
    }
}

