/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.ACreator;
import com.equitysoft.icon.AUtils;
import com.equitysoft.icon.AniImage;
import com.equitysoft.icon.Anih;
import com.equitysoft.icon.Bar;
import com.equitysoft.icon.DefineRate;
import com.equitysoft.icon.DefineSeq;
import com.equitysoft.icon.FileManager;
import com.equitysoft.icon.FileUtils;
import com.equitysoft.icon.IPDialog;
import com.equitysoft.icon.IPQ;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.LibButton;
import com.equitysoft.icon.RecentFiles;
import com.equitysoft.icon.StripDialog;
import com.equitysoft.icon.SysProps;
import com.equitysoft.icon.ValueAdjuster;
import com.equitysoft.icon.ValueBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class OpenA
extends IPDialog
implements ActionListener {
    static int editnum;
    static OpenA handle;
    String SAVE = "Save";
    String CLOSE = "Close";
    String STRIP = "Create strip...";
    String EMPTY = " Empty";
    String DEFINE = "Define";
    String CLEAR = "Clear  ";
    Anih curr;
    AniImage ani;
    ABox currbox;
    JScrollPane scroll;
    JPanel spread;
    JPanel anipanel;
    static boolean changed;
    ValueBox blits;
    DefaultListModel ratevals;
    DefaultListModel seqvals;
    JTextField name;
    JTextField artist;

    OpenA(Anih anih) {
        super("");
        handle = this;
        this.curr = anih;
        this.resetTitle();
        this.jp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new EditPanel(), "North");
        this.spread = new JPanel();
        this.spread.setLayout(new FlowLayout(1, 0, 0));
        this.scroll = new JScrollPane();
        this.scroll.setBorder(BorderFactory.createLoweredBevelBorder());
        this.scroll.getViewport().add(this.spread);
        jPanel.add((Component)this.scroll, "Center");
        int n = anih.num;
        int n2 = 0;
        while (n2 < n) {
            this.spread.add(new ABox(anih.imgs[n2], n2));
            ++n2;
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Internal data"));
        jPanel2.add(new JLabel("Title"));
        this.name = new JTextField(20);
        jPanel2.add(this.name);
        this.name.setFont(SysProps.MSG_FONT);
        if (anih.name != null) {
            this.name.setText(anih.name);
        }
        jPanel2.add(new JLabel("  Artist"));
        this.artist = new JTextField(20);
        jPanel2.add(this.artist);
        this.artist.setFont(SysProps.MSG_FONT);
        if (anih.artist != null) {
            this.artist.setText(anih.artist);
        }
        jPanel.add((Component)jPanel2, "South");
        this.jp.add((Component)jPanel, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(new Hotspot());
        jPanel3.add(new Seq());
        this.anipanel = new JPanel();
        this.anipanel.setLayout(new GridLayout(1, 1));
        this.ani = new AniImage(anih);
        this.anipanel.add(this.ani);
        this.anipanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createLoweredBevelBorder()));
        jPanel3.add(this.anipanel);
        jPanel3.add(new Rates());
        jPanel3.add(new Vals());
        this.jp.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
        LibButton libButton = new LibButton(this.STRIP);
        jPanel4.add(libButton);
        libButton.addActionListener(this);
        libButton = new LibButton(this.SAVE);
        jPanel4.add(libButton);
        libButton.addActionListener(this);
        libButton = new LibButton(this.CLOSE);
        jPanel4.add(libButton);
        libButton.addActionListener(this);
        this.jp.add((Component)jPanel4, "South");
        this.loadSeq();
        this.loadRate();
        this.finishOff();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.CLOSE) {
            this.closeWindow();
        } else if (string == this.STRIP) {
            BufferedImage bufferedImage = new BufferedImage(this.curr.wid * this.curr.num, this.curr.hgt, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            int n = 0;
            int n2 = 0;
            while (n2 < this.curr.num) {
                graphics2D.drawImage((Image)this.curr.imgs[n2], n, 0, null);
                n += this.curr.wid;
                ++n2;
            }
            new StripDialog(bufferedImage);
        } else if (string == this.SAVE && this.saveIt()) {
            this.closeDialog();
        }
    }

    void closeWindow() {
        if (changed && !IPQ.ask("The file has been changed, close without saving?", "Close", "Cancel")) {
            return;
        }
        this.ani.halt();
        changed = false;
        this.closeDialog();
        if (FileManager.currfile != null && FileManager.currfile.compareTo(this.curr.file) == 0) {
            IPUtils.newIcon();
        }
    }

    void deleteFrame(ABox aBox) {
        this.stopAni();
        changed = true;
        int n = aBox.num;
        int n2 = this.curr.num--;
        BufferedImage[] bufferedImageArray = new BufferedImage[this.curr.num];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            bufferedImageArray[n3] = this.curr.imgs[n3];
            ++n3;
            ++n4;
        }
        ++n3;
        while (n3 < n2) {
            bufferedImageArray[n4] = this.curr.imgs[n3];
            ++n3;
            ++n4;
        }
        this.curr.imgs = bufferedImageArray;
        this.currbox = null;
        this.spread.removeAll();
        n3 = 0;
        while (n3 < this.curr.num) {
            this.spread.add(new ABox(bufferedImageArray[n3], n3));
            ++n3;
        }
        this.spread.validate();
        if (this.curr.rate != null) {
            int[] nArray = new int[this.curr.num];
            n3 = 0;
            n4 = 0;
            while (n3 < n) {
                nArray[n3] = this.curr.rate[n3];
                ++n3;
                ++n4;
            }
            ++n3;
            while (n3 < n2) {
                nArray[n4] = this.curr.rate[n3];
                ++n3;
                ++n4;
            }
            this.curr.rate = nArray;
        }
        if (this.curr.seq != null) {
            int n5 = this.curr.seq.length;
            int[] nArray = new int[n5];
            n4 = 0;
            n3 = 0;
            while (n3 < n5) {
                if (this.curr.seq[n3] != n) {
                    nArray[n4] = this.curr.seq[n3];
                    if (nArray[n4] > n) {
                        int n6 = n4;
                        nArray[n6] = nArray[n6] - 1;
                    }
                    ++n4;
                }
                ++n3;
            }
            if (n4 == 0) {
                this.curr.seq = null;
            } else {
                int[] nArray2 = new int[n4];
                n3 = 0;
                while (n3 < n4) {
                    nArray2[n3] = nArray[n3];
                    ++n3;
                }
                this.curr.seq = nArray2;
            }
            this.curr.blits = this.curr.seq.length;
            this.loadSeq();
        } else {
            this.curr.blits = this.curr.num;
        }
        this.blits.set(this.curr.num);
        this.startAni();
        this.repaint();
    }

    void loadRate() {
        this.ratevals.removeAllElements();
        if (this.curr.rate == null) {
            this.ratevals.addElement(this.EMPTY);
            return;
        }
        int n = this.curr.rate.length;
        int n2 = 0;
        while (n2 < n) {
            this.ratevals.addElement(" No." + (n2 + 1) + ": " + String.valueOf(this.curr.rate[n2]));
            ++n2;
        }
    }

    void loadSeq() {
        this.seqvals.removeAllElements();
        if (this.curr.seq == null) {
            this.seqvals.addElement(this.EMPTY);
            return;
        }
        int n = this.curr.seq.length;
        int n2 = 0;
        while (n2 < n) {
            this.seqvals.addElement(" No: " + String.valueOf(this.curr.seq[n2] + 1));
            ++n2;
        }
    }

    void resetTitle() {
        if (this.currbox == null) {
            this.setTitle(" " + this.curr.num + " frames in '" + this.curr.file.getName() + "'");
        } else {
            this.setTitle(" Frame " + (this.currbox.num + 1) + " selected from '" + this.curr.file.getName() + "'");
        }
    }

    static void saveImage() {
        if (FileManager.currfile != null) {
            Object object;
            Anih anih = AUtils.tryOpen(FileManager.currfile);
            if (anih == null) {
                new IPZap("Error opening the ANI file");
                return;
            }
            if (anih.wid != IconPainter.cols || anih.hgt != IconPainter.rows) {
                new IPZap("Image size mismatch");
                return;
            }
            changed = true;
            if (editnum > -1) {
                object = anih.imgs[editnum].createGraphics();
                ((Graphics)object).drawImage(IconPainter.curr, 0, 0, null);
            } else {
                int n = anih.num++;
                BufferedImage[] bufferedImageArray = new BufferedImage[anih.num];
                int n2 = 0;
                while (n2 < n) {
                    bufferedImageArray[n2] = anih.imgs[n2];
                    ++n2;
                }
                bufferedImageArray[n] = new BufferedImage(anih.wid, anih.hgt, 1);
                Graphics2D graphics2D = bufferedImageArray[n].createGraphics();
                graphics2D.drawImage((Image)IconPainter.curr, 0, 0, null);
                anih.imgs = bufferedImageArray;
                if (anih.rate != null) {
                    int[] nArray = new int[anih.num];
                    int n3 = 0;
                    while (n3 < n) {
                        nArray[n3] = anih.rate[n3];
                        ++n3;
                    }
                    nArray[n] = anih.rate[0];
                    anih.rate = nArray;
                }
            }
            object = new OpenA(anih);
            changed = true;
        }
    }

    boolean saveIt() {
        if (this.curr.rate != null && this.curr.rate.length != this.curr.num) {
            new IPZap("The number of rate values must match the number of frames - clear or define the rate list");
            return false;
        }
        String string = this.name.getText();
        if (string.equals("")) {
            this.curr.name = null;
        } else {
            this.curr.name = string;
            this.curr.artist = this.artist.getText();
        }
        try {
            File file = File.createTempFile("IPF#", "tmp");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ACreator.asave(fileOutputStream, this.curr);
            fileOutputStream.close();
            if (this.curr.file.exists()) {
                this.curr.file.delete();
            }
            file.renameTo(this.curr.file);
        }
        catch (IOException iOException) {
            new IPZap("Error writing ANI file");
            return false;
        }
        changed = false;
        RecentFiles.addFile(this.curr.file);
        return true;
    }

    void startAni() {
        this.ani = new AniImage(this.curr);
        this.anipanel.add(this.ani);
        this.anipanel.validate();
    }

    void stopAni() {
        this.anipanel.removeAll();
        this.ani.halt();
        this.ani = null;
    }

    void tempTitle(int n) {
        this.setTitle(" Frame " + (n + 1) + " of " + this.curr.num + " in '" + this.curr.file.getName() + "'");
    }

    class EditPanel
    extends JPanel
    implements ActionListener {
        String EDIT = "Edit frame";
        String DELETE = "Delete frame";
        String ADD = "Add frame";

        EditPanel() {
            this.setLayout(new FlowLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
            LibButton libButton = new LibButton(this.ADD);
            this.add(libButton);
            libButton.addActionListener(this);
            libButton = new LibButton(this.EDIT);
            this.add(libButton);
            libButton.addActionListener(this);
            libButton = new LibButton(this.DELETE);
            this.add(libButton);
            libButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == this.ADD) {
                if (changed && !OpenA.this.saveIt()) {
                    return;
                }
                OpenA.this.closeDialog();
                editnum = -1;
                FileManager.filetype = 11;
                Bar.setFile(OpenA.this.curr.file);
                if (OpenA.this.curr.wid != IconPainter.cols || OpenA.this.curr.hgt != IconPainter.rows) {
                    IconPainter.init(OpenA.this.curr.wid, OpenA.this.curr.hgt);
                }
            } else if (string == this.EDIT) {
                if (changed && !OpenA.this.saveIt()) {
                    return;
                }
                if (OpenA.this.currbox == null) {
                    new IPZap("First click on the frame to select it");
                    return;
                }
                OpenA.this.closeDialog();
                FileManager.filetype = 11;
                editnum = OpenA.this.currbox.num;
                FileUtils.displayIt(OpenA.this.curr.file, OpenA.this.curr.imgs[OpenA.this.currbox.num]);
                FileManager.filetype = 11;
                editnum = OpenA.this.currbox.num;
            } else if (string == this.DELETE) {
                if (OpenA.this.currbox == null) {
                    new IPZap("First click on the frame to delete");
                } else if (OpenA.this.curr.num == 1) {
                    new IPZap("There has to be at least frame in the animation");
                } else {
                    OpenA.this.deleteFrame(OpenA.this.currbox);
                }
            }
        }
    }

    class Vals
    extends JPanel
    implements ValueAdjuster {
        ValueBox rate;

        Vals() {
            this.setLayout(new BorderLayout());
            this.rate = new ValueBox("Frame delay (jiffies)", OpenA.this.curr.jiffies, 1, 1000, this);
            this.add((Component)this.rate, "North");
            OpenA.this.blits = new ValueBox("Blits", OpenA.this.curr.blits, 1, 1000, this);
            this.add((Component)OpenA.this.blits, "South");
        }

        public void setValue(ValueBox valueBox, int n) {
            changed = true;
            if (valueBox == this.rate) {
                OpenA.this.curr.jiffies = n;
            } else {
                OpenA.this.curr.blits = n;
            }
        }
    }

    class Hotspot
    extends JPanel
    implements ValueAdjuster {
        ValueBox xspot;
        ValueBox yspot;

        Hotspot() {
            this.setLayout(new BorderLayout());
            this.xspot = new ValueBox("X hotspot", OpenA.this.curr.xspot, 0, OpenA.this.curr.wid - 1, this);
            this.add((Component)this.xspot, "North");
            this.yspot = new ValueBox("Y hotspot", OpenA.this.curr.yspot, 0, OpenA.this.curr.hgt - 1, this);
            this.add((Component)this.yspot, "South");
        }

        public void setValue(ValueBox valueBox, int n) {
            changed = true;
            if (valueBox == this.xspot) {
                OpenA.this.curr.xspot = n;
            } else {
                OpenA.this.curr.yspot = n;
            }
        }
    }

    class Rates
    extends JPanel
    implements ActionListener {
        Rates() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Delays (jiffies)"));
            JScrollPane jScrollPane = new JScrollPane();
            OpenA.this.ratevals = new DefaultListModel();
            JList jList = new JList();
            jList.setFont(SysProps.MSG_FONT);
            jScrollPane.setPreferredSize(new Dimension(80, 100));
            jList.setSelectionMode(0);
            jList.setModel(OpenA.this.ratevals);
            jScrollPane.getViewport().setView(jList);
            this.add((Component)jScrollPane, "North");
            LibButton libButton = new LibButton(OpenA.this.CLEAR);
            this.add((Component)libButton, "Center");
            libButton.addActionListener(this);
            libButton = new LibButton(OpenA.this.DEFINE);
            this.add((Component)libButton, "South");
            libButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == OpenA.this.CLEAR) {
                if (OpenA.this.curr.rate == null) {
                    return;
                }
                if (OpenA.this.curr.jiffies == 0) {
                    OpenA.this.curr.jiffies = OpenA.this.curr.rate[0];
                }
                changed = true;
                OpenA.this.curr.rate = null;
                OpenA.this.loadRate();
            } else {
                int[] nArray = DefineRate.getRate(OpenA.this.curr);
                if (nArray != null) {
                    OpenA.this.stopAni();
                    changed = true;
                    OpenA.this.curr.rate = nArray;
                    OpenA.this.loadRate();
                    OpenA.this.startAni();
                }
            }
        }
    }

    class Seq
    extends JPanel
    implements ActionListener {
        Seq() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sequence"));
            JScrollPane jScrollPane = new JScrollPane();
            OpenA.this.seqvals = new DefaultListModel();
            JList jList = new JList();
            jList.setFont(SysProps.MSG_FONT);
            jScrollPane.setPreferredSize(new Dimension(80, 100));
            jList.setSelectionMode(0);
            jList.setModel(OpenA.this.seqvals);
            jScrollPane.getViewport().setView(jList);
            this.add((Component)jScrollPane, "North");
            LibButton libButton = new LibButton(OpenA.this.CLEAR);
            this.add((Component)libButton, "Center");
            libButton.addActionListener(this);
            libButton = new LibButton(OpenA.this.DEFINE);
            this.add((Component)libButton, "South");
            libButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == OpenA.this.CLEAR) {
                if (OpenA.this.curr.seq != null) {
                    changed = true;
                    OpenA.this.curr.seq = null;
                    OpenA.this.loadSeq();
                }
            } else {
                int[] nArray = DefineSeq.getSeq(OpenA.this.curr);
                if (nArray != null) {
                    OpenA.this.stopAni();
                    OpenA.this.curr.blits = nArray.length;
                    OpenA.this.blits.set(OpenA.this.curr.blits);
                    changed = true;
                    OpenA.this.curr.seq = nArray;
                    OpenA.this.loadSeq();
                    OpenA.this.startAni();
                }
            }
        }
    }

    class ABox
    extends JPanel {
        BufferedImage bi;
        boolean entered;
        boolean pressed;
        int num;

        ABox(BufferedImage bufferedImage, int n) {
            this.enableEvents(16L);
            this.bi = bufferedImage;
            this.num = n;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.bi.getWidth() + 6, this.bi.getHeight() + 6);
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getPreferredSize();
            int n = dimension.width - 3;
            int n2 = dimension.height - 3;
            if (this.entered) {
                if (OpenA.this.currbox != this) {
                    graphics2D.setColor(Color.green);
                } else {
                    graphics2D.setColor(Color.orange);
                }
                graphics2D.fillRect(0, 0, dimension.width, 3);
                graphics2D.fillRect(n, 0, 3, dimension.height);
                graphics2D.fillRect(0, n2, dimension.width, 3);
                graphics2D.fillRect(0, 0, 3, dimension.height);
                if (OpenA.this.currbox != this) {
                    graphics2D.setColor(Color.red);
                } else {
                    graphics2D.setColor(Color.blue);
                }
                int n3 = 0;
                while (n3 < dimension.width) {
                    graphics2D.fillRect(n3, 0, 4, 3);
                    graphics2D.fillRect(n3, n2, 4, 3);
                    n3 += 8;
                }
                n3 = 0;
                while (n3 < dimension.height) {
                    graphics2D.fillRect(0, n3, 3, 4);
                    graphics2D.fillRect(n, n3, 3, 4);
                    n3 += 8;
                }
            } else {
                graphics2D.setColor(this.getParent().getBackground());
                graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            }
            graphics2D.drawImage((Image)this.bi, 3, 3, null);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 504: {
                    if (OpenA.this.currbox == this) {
                        return;
                    }
                    OpenA.this.tempTitle(this.num);
                    this.entered = true;
                    this.repaint();
                    break;
                }
                case 505: {
                    if (OpenA.this.currbox == this) {
                        return;
                    }
                    OpenA.this.resetTitle();
                    this.entered = false;
                    this.repaint();
                    break;
                }
                case 501: {
                    if (OpenA.this.currbox != this) {
                        ABox aBox = null;
                        if (OpenA.this.currbox != null) {
                            aBox = OpenA.this.currbox;
                        }
                        OpenA.this.currbox = this;
                        if (aBox != null) {
                            aBox.entered = false;
                            aBox.repaint();
                        }
                        this.repaint();
                        OpenA.this.resetTitle();
                        break;
                    }
                    this.entered = false;
                    OpenA.this.currbox = null;
                    this.repaint();
                    OpenA.this.tempTitle(this.num);
                }
            }
        }
    }
}

