/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.FileUtils;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IconPainter;
import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.PNGDecodeParam;
import com.sun.media.jai.codec.PNGEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

class JAIMethods {
    JAIMethods() {
    }

    static BufferedImage getAnyImage(File file, Color color) {
        BufferedImage bufferedImage = null;
        try {
            FileSeekableStream fileSeekableStream = new FileSeekableStream(file);
            String[] stringArray = ImageCodec.getDecoderNames((SeekableStream)fileSeekableStream);
            ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)stringArray[0], (SeekableStream)fileSeekableStream, null);
            RenderedImage renderedImage = imageDecoder.decodeAsRenderedImage();
            int n = renderedImage.getWidth();
            int n2 = renderedImage.getHeight();
            bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n, n2);
            if (FileUtils.atrans == null) {
                FileUtils.atrans = new AffineTransform();
            }
            graphics2D.drawRenderedImage(renderedImage, FileUtils.atrans);
        }
        catch (Exception exception) {
            return null;
        }
        return bufferedImage;
    }

    static BufferedImage getPNG(File file, Color color, boolean bl) {
        BufferedImage bufferedImage = null;
        try {
            PNGDecodeParam pNGDecodeParam = new PNGDecodeParam();
            pNGDecodeParam.setGenerateEncodeParam(true);
            ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)"png", (InputStream)new FileInputStream(file), (ImageDecodeParam)pNGDecodeParam);
            RenderedImage renderedImage = imageDecoder.decodeAsRenderedImage();
            int n = renderedImage.getWidth();
            int n2 = renderedImage.getHeight();
            PNGEncodeParam pNGEncodeParam = pNGDecodeParam.getEncodeParam();
            if (pNGEncodeParam.isTransparencySet()) {
                FileUtils.type = 5;
            }
            bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n, n2);
            if (FileUtils.atrans == null) {
                FileUtils.atrans = new AffineTransform();
            }
            graphics2D.drawRenderedImage(renderedImage, FileUtils.atrans);
        }
        catch (Exception exception) {
            new IPZap("Unable to load image");
            return null;
        }
        return bufferedImage;
    }

    static boolean savePNG(File file, BufferedImage bufferedImage, int n) {
        try {
            Object object;
            PNGEncodeParam.RGB rGB = null;
            if (n == 5) {
                object = new int[]{IconPainter.backcol.getRed(), IconPainter.backcol.getGreen(), IconPainter.backcol.getBlue()};
                rGB = new PNGEncodeParam.RGB();
                rGB.setTransparentRGB(object);
            }
            object = ImageCodec.createImageEncoder((String)"PNG", (OutputStream)new FileOutputStream(file), rGB);
            object.encode((RenderedImage)bufferedImage);
        }
        catch (Exception exception) {
            new IPZap("Unable to write the PNG file to disk.");
            return false;
        }
        return true;
    }

    static boolean saveTiff(File file, BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 5);
        IPUtils.copy(bufferedImage, bufferedImage2);
        TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
        try {
            ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"tiff", (OutputStream)new FileOutputStream(file), (ImageEncodeParam)tIFFEncodeParam);
            imageEncoder.encode((RenderedImage)bufferedImage2);
        }
        catch (Exception exception) {
            new IPZap("Error writing the file to disk.");
            return false;
        }
        return true;
    }
}

