/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.ColorMenu;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.Palette;
import com.equitysoft.icon.ShadeBar;
import com.equitysoft.icon.SwingColorButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

class InfoBar
extends JPanel
implements ActionListener {
    static String CURRENT = "Current:";
    static String TEXTURE = "Texture:";
    static JLabel curlab;
    static SwingColorButton back;
    static SwingColorButton curr;
    static SwingColorButton second;
    static int lastcurr;

    InfoBar() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBackground(Color.lightGray);
        this.setLayout(new FlowLayout(1, 3, 1));
        curlab = new JLabel(CURRENT);
        this.add(curlab);
        Dimension dimension = new Dimension(20, 20);
        curr = new SwingColorButton(this, dimension);
        this.add(curr);
        this.add(new JLabel("  Back:"));
        back = new SwingColorButton(this, dimension);
        this.add(back);
        this.add(new JLabel("  Second:"));
        second = new SwingColorButton(this, dimension);
        this.add(second);
        lastcurr = 0;
        InfoBar.set();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SwingColorButton swingColorButton = (SwingColorButton)actionEvent.getSource();
        if (swingColorButton == curr) {
            if (Palette.usetexture) {
                Palette.useOriginal();
                return;
            }
            if (ShadeBar.used && lastcurr != 0) {
                Palette.setCurrent(lastcurr);
                lastcurr = 0;
                ShadeBar.used = false;
            } else if (Palette.currcolor == back.getBackground().getRGB() || Palette.currcolor == second.getBackground().getRGB()) {
                if (lastcurr != 0) {
                    Palette.setCurrent(lastcurr);
                    lastcurr = 0;
                }
            } else {
                ColorMenu.setCurrent();
            }
        } else {
            if (Palette.currcolor != back.getBackground().getRGB() && Palette.currcolor != second.getBackground().getRGB()) {
                lastcurr = Palette.currcolor;
            }
            Palette.currcolor = swingColorButton.getBackground().getRGB();
            InfoBar.set();
        }
    }

    static void set() {
        curr.setBackground(new Color(Palette.currcolor));
        curr.repaint();
        back.setBackground(IconPainter.backcol);
        back.repaint();
        second.setBackground(new Color(Palette.targcol));
        second.repaint();
    }

    static void setImage(BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            curlab.setText(TEXTURE);
        } else if (InfoBar.curr.bi != null) {
            curlab.setText(CURRENT);
        }
        curr.setImage(bufferedImage);
    }

    static void swap() {
        int n = Palette.currcolor;
        Palette.currcolor = Palette.targcol;
        Palette.targcol = n;
        InfoBar.set();
    }
}

