/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Bar;
import com.equitysoft.icon.FileUtils;
import com.equitysoft.icon.FullImage;
import com.equitysoft.icon.IPDialog;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.ImageLook;
import com.equitysoft.icon.ImgThumb;
import com.equitysoft.icon.LibButton;
import com.equitysoft.icon.SysProps;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ImageOpener
extends IPDialog
implements ActionListener,
ListSelectionListener,
ComponentListener,
Runnable,
MouseListener {
    static Dimension PIXDIM = new Dimension(50, 50);
    static Color ALTCOL = new Color(153, 153, 255);
    static File HOME_DIR;
    static final int GAP = 2;
    Dimension SQ = new Dimension(26, 26);
    Dimension DIM = new Dimension(200, 20);
    static Dimension origdim;
    static File[] disks;
    static JList list;
    static DefaultListModel vals;
    JComboBox lookin;
    static File currdir;
    static ImageIcon diricon;
    static ImageIcon docicon;
    static ImageIcon diskicon;
    LibButton goup;
    LibButton gohome;
    LibButton select;
    LibButton full;
    LibButton cancel;
    static JTabbedPane jtp;
    static ImageLook il;
    Thread runner;
    boolean ignore;
    boolean ignoreselect;
    boolean ignorehide;
    static Image dirimg;
    static Image diskimg;
    static JPanel pix;
    static JPanel outer;
    static int dirnum;
    static int currnum;
    static ImageOpener handle;
    static boolean canrun;
    static JTextField fn;
    static File currfile;
    static String[] suffix;
    static int slen;

    ImageOpener(File file, String string, String string2, String[] stringArray, int n) {
        super(" " + string);
        suffix = stringArray;
        slen = n;
        HOME_DIR = file;
        if (dirimg == null) {
            dirimg = IPUtils.getSystemImage("dir.gif");
            diricon = new ImageIcon(dirimg);
            docicon = new ImageIcon(IPUtils.getSystemImage("doc.gif"));
            diskimg = IPUtils.getSystemImage("disk.gif");
            diskicon = new ImageIcon(diskimg);
        }
        this.jp.setLayout(new BorderLayout());
        this.select = new LibButton("Select");
        Container container = new Container();
        container.setLayout(new FlowLayout(0, 8, 5));
        container.add(new JLabel("Look in:"));
        this.lookin = new JComboBox();
        container.add(this.lookin);
        this.lookin.setRenderer(new LCRenderer());
        this.addRoots();
        this.goup = new LibButton(null, "updir.gif");
        container.add(this.goup);
        this.goup.addActionListener(this);
        this.goup.setPreferredSize(this.SQ);
        this.goup.setToolTipText("Go up a directory level");
        this.gohome = new LibButton(null, "home.gif");
        container.add(this.gohome);
        this.gohome.addActionListener(this);
        this.gohome.setPreferredSize(this.SQ);
        this.gohome.setToolTipText("Go back to the starting directory");
        this.full = new LibButton(null, "crisscross.gif");
        container.add(this.full);
        this.full.addActionListener(this);
        this.full.setPreferredSize(this.SQ);
        this.full.setToolTipText("Show image at full size");
        this.jp.add((Component)container, "North");
        jtp = new JTabbedPane();
        jtp.setFont(SysProps.MSG_FONT);
        this.jp.add((Component)jtp, "Center");
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        vals = new DefaultListModel();
        list = new JList();
        list.addMouseListener(this);
        list.setCellRenderer(new FFRenderer(list));
        list.setModel(vals);
        jScrollPane.getViewport().setView(list);
        jPanel.add((Component)jScrollPane, "Center");
        il = new ImageLook(100, 300);
        jPanel.add((Component)il, "East");
        jtp.addTab("   List   ", jPanel);
        jtp.setIconAt(0, new ImageIcon(IPUtils.getSystemImage("lines.gif")));
        this.lookin.addActionListener(this);
        list.addListSelectionListener(this);
        outer = new JPanel(false);
        outer.setLayout(new BorderLayout());
        jtp.addTab("   Images   ", outer);
        outer.addComponentListener(this);
        jtp.setIconAt(1, new ImageIcon(IPUtils.getSystemImage("blocks.gif")));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string2));
        fn = new JTextField(25);
        jPanel3.add(fn);
        fn.setFont(SysProps.MSG_FONT);
        jPanel2.add(jPanel3);
        fn.setEditable(false);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        this.select = new LibButton("Open  ");
        jPanel4.add((Component)this.select, "North");
        this.select.addActionListener(this);
        this.select.setEnabled(false);
        this.cancel = new LibButton("Cancel");
        jPanel4.add((Component)this.cancel, "South");
        this.cancel.addActionListener(this);
        jPanel2.add(jPanel4);
        this.jp.add((Component)jPanel2, "South");
        this.setDir(file);
        currdir = file;
        this.setUpDir();
        this.finishOff();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        canrun = false;
        if (object instanceof JComboBox) {
            if (!this.ignore) {
                File file = (File)this.lookin.getSelectedItem();
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    new IPZap("The device '" + file.getAbsolutePath() + "' is not accessible.");
                    this.ignore = true;
                    this.lookin.setSelectedItem(currdir);
                    this.ignore = false;
                    return;
                }
                this.removeLookin(file);
                this.setDir(file);
            }
        } else if (object instanceof LibButton) {
            LibButton libButton = (LibButton)object;
            if (libButton == this.goup) {
                if (this.getDepth(currdir) == 0) {
                    return;
                }
                ImageOpener.clearPix();
                File file = currdir.getParentFile();
                this.setDir(file);
                this.removeLookin(file);
            } else if (libButton == this.gohome) {
                ImageOpener.clearPix();
                this.setDir(HOME_DIR);
                Vector<File> vector = new Vector<File>();
                int n = this.lookin.getItemCount();
                int n2 = 0;
                while (n2 < n) {
                    File file = (File)this.lookin.getItemAt(n2);
                    if (this.getDepth(file) > 0) {
                        vector.addElement(file);
                    }
                    ++n2;
                }
                n = vector.size();
                this.ignore = true;
                int n3 = 0;
                while (n3 < n) {
                    this.lookin.removeItem(vector.elementAt(n3));
                    ++n3;
                }
                this.ignore = false;
                this.setUpDir();
            } else if (libButton == this.cancel) {
                currfile = null;
                this.closeDialog();
            } else if (libButton == this.select) {
                this.closeDialog();
            } else if (libButton == this.full) {
                new FullImage(currfile);
            }
        }
    }

    void addRoots() {
        disks = File.listRoots();
        int n = disks.length;
        this.ignore = true;
        int n2 = 0;
        while (n2 < n) {
            this.lookin.addItem(disks[n2]);
            ++n2;
        }
        this.ignore = false;
    }

    static File ask(File file, String string, String string2, String[] stringArray, int n) {
        new ImageOpener(file, string, string2, stringArray, n);
        return currfile;
    }

    static void clearPix() {
        if (!outer.isVisible()) {
            return;
        }
        jtp.setSelectedIndex(0);
        outer.removeAll();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        if (this.ignorehide) {
            this.ignorehide = false;
            return;
        }
        canrun = false;
        Component[] componentArray = pix.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Pix pix = (Pix)componentArray[n2];
            pix.flush();
            ++n2;
        }
        il.view(null);
        outer.removeAll();
        Bar.handle.validate();
        list.clearSelection();
        this.off();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.setImages();
    }

    static int deselectAll() {
        Component[] componentArray = pix.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Pix pix = (Pix)componentArray[n3];
            if (pix.selected) {
                ++n2;
                pix.selected = false;
            }
            ++n3;
        }
        return n2;
    }

    static void fileBubbleSort(File[] fileArray, int n) {
        int n2 = n - 1;
        boolean bl = false;
        while (true) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 + 1;
                if (fileArray[n3].getName().compareToIgnoreCase(fileArray[n4].getName()) > 0) {
                    File file = fileArray[n4];
                    fileArray[n4] = fileArray[n3];
                    fileArray[n3] = file;
                    bl = true;
                }
                ++n3;
            }
            if (!bl) break;
            bl = false;
            --n2;
        }
    }

    int getDepth(File file) {
        int n = 0;
        while ((file = file.getParentFile()) != null) {
            ++n;
        }
        return n;
    }

    static ImgThumb getThumbImage(File file, Dimension dimension, boolean bl) {
        int n;
        int n2;
        Image image = FileUtils.getImage(file, true, il.getBackground());
        if (image == null) {
            return null;
        }
        ImgThumb imgThumb = new ImgThumb();
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        imgThumb.origw = n3;
        imgThumb.origh = n4;
        int n5 = dimension.width;
        int n6 = dimension.height;
        if (n3 <= n5 && n4 <= n6) {
            imgThumb.img = image;
            imgThumb.xpos = (n5 - n3) / 2;
            imgThumb.ypos = (n6 - n4) / 2;
            return imgThumb;
        }
        float f = n3;
        float f2 = n4;
        float f3 = f / f2;
        if (n3 > n5) {
            n2 = n5;
            n = (int)((float)n2 / f3);
            if (n > n6) {
                n = n6;
                n2 = (int)(f3 * (float)n);
            }
        } else if (n4 > n6) {
            n = n6;
            n2 = (int)(f3 * (float)n);
            if (n2 > n5) {
                n2 = n5;
                n = (int)((float)n2 / f3);
            }
        } else {
            n2 = n3;
            n = n4;
        }
        imgThumb.nw = n2;
        imgThumb.nh = n;
        imgThumb.xpos = (n5 - n2) / 2;
        imgThumb.ypos = (n6 - n) / 2;
        if (bl) {
            BufferedImage bufferedImage = new BufferedImage(n2, n, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, n2, n, null);
            imgThumb.bi = bufferedImage;
        } else {
            Image image2 = Bar.handle.createImage(n2, n);
            Graphics graphics = image2.getGraphics();
            graphics.drawImage(image, 0, 0, n2, n, null);
            graphics.dispose();
            imgThumb.img = image2;
        }
        image.flush();
        return imgThumb;
    }

    static boolean hasSelection() {
        Component[] componentArray = pix.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Pix pix = (Pix)componentArray[n2];
            if (pix.selected) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isDisk(File file) {
        int n = disks.length;
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            if (file.equals(disks[n2])) break;
            ++n2;
        }
        return n2 < n;
    }

    void lastCall() {
        canrun = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        int n = list.locationToIndex(mouseEvent.getPoint());
        if (n < 0) {
            return;
        }
        File file = (File)vals.getElementAt(n);
        if (!file.isDirectory()) {
            currfile = file;
            this.closeDialog();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void off() {
        this.select.setEnabled(false);
        fn.setText("");
        this.full.setEnabled(false);
        currfile = null;
    }

    void on(File file) {
        this.select.setEnabled(true);
        fn.setText(file.getName());
        this.full.setEnabled(true);
        currfile = file;
    }

    void removeLookin(File file) {
        boolean bl = false;
        if (this.isDisk(file)) {
            bl = true;
        }
        Vector<File> vector = new Vector<File>();
        int n = this.lookin.getItemCount();
        String string = file.getAbsolutePath();
        int n2 = 0;
        while (n2 < n) {
            File file2 = (File)this.lookin.getItemAt(n2);
            String string2 = file2.getAbsolutePath();
            if (!bl) {
                if (string2.startsWith(string) && !string2.equals(string)) {
                    vector.addElement(file2);
                }
            } else if (!this.isDisk(file2)) {
                vector.addElement(file2);
            }
            ++n2;
        }
        n = vector.size();
        this.ignore = true;
        int n3 = 0;
        while (n3 < n) {
            this.lookin.removeItem(vector.elementAt(n3));
            ++n3;
        }
        this.ignore = false;
    }

    public void run() {
        int n;
        if (origdim == null) {
            origdim = outer.getSize();
        }
        pix = new JPanel(false);
        pix.setLayout(null);
        int n2 = ImageOpener.origdim.width - 18;
        int n3 = n2 / (ImageOpener.PIXDIM.width + 2);
        if (n3 * (ImageOpener.PIXDIM.width + 2) + 2 > n2) {
            --n3;
        }
        if ((n = currnum / n3) * n3 < currnum) {
            ++n;
        }
        Dimension dimension = new Dimension(ImageOpener.origdim.width - 10, n * (ImageOpener.PIXDIM.height + 2) + 2);
        pix.setSize(dimension);
        pix.setPreferredSize(dimension);
        pix.setMaximumSize(dimension);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(pix);
        outer.add((Component)jScrollPane, "Center");
        outer.validate();
        int n4 = 2;
        int n5 = 2;
        int n6 = 1;
        int n7 = vals.size();
        int n8 = 0;
        while (n8 < n7) {
            if (!canrun) {
                outer.removeAll();
                return;
            }
            File file = (File)vals.elementAt(n8);
            if (!file.isDirectory()) {
                Pix pix = new Pix(file, list.isSelectedIndex(n8));
                ImageOpener.pix.add(pix);
                pix.setBounds(n5, n4, ImageOpener.PIXDIM.width, ImageOpener.PIXDIM.height);
                if (++n6 > n3) {
                    n4 = n4 + ImageOpener.PIXDIM.height + 2;
                    n5 = 2;
                    n6 = 1;
                } else {
                    n5 = n5 + ImageOpener.PIXDIM.width + 2;
                }
            }
            ++n8;
        }
        canrun = false;
        list.clearSelection();
    }

    void setDir(File file) {
        File file2;
        if (this.getDepth(file) == 0) {
            this.goup.setEnabled(false);
        } else {
            this.goup.setEnabled(true);
        }
        vals.removeAllElements();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = fileArray.length;
        File[] fileArray2 = new File[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            file2 = fileArray[n3];
            if (file2.isDirectory()) {
                fileArray2[n2] = file2;
                ++n2;
            }
            ++n3;
        }
        ImageOpener.fileBubbleSort(fileArray2, n2);
        int n4 = 0;
        while (n4 < n2) {
            vals.addElement(fileArray2[n4]);
            ++n4;
        }
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            file2 = fileArray[n6];
            if (!file2.isDirectory()) {
                String string = file2.getName();
                int n7 = string.length() - 4;
                n5 = 0;
                while (n5 < slen) {
                    if (string.regionMatches(true, n7, suffix[n5], 0, 4)) break;
                    ++n5;
                }
                if (n5 < slen) {
                    fileArray2[n2] = file2;
                    ++n2;
                }
            }
            ++n6;
        }
        ImageOpener.fileBubbleSort(fileArray2, n2);
        int n8 = 0;
        while (n8 < n2) {
            vals.addElement(fileArray2[n8]);
            ++n8;
        }
        jtp.setEnabledAt(1, n2 > 0);
        il.view(null);
        currnum = n2;
        currdir = file;
        this.off();
        jtp.setSelectedIndex(0);
        canrun = false;
    }

    void setImages() {
        canrun = true;
        new Thread(this).start();
    }

    void setUpDir() {
        File file;
        this.ignore = true;
        int n = this.lookin.getItemCount();
        String string = currdir.getAbsolutePath();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            file = (File)this.lookin.getItemAt(n2);
            if (string.startsWith(file.getAbsolutePath())) break;
            ++n2;
        }
        int n3 = this.getDepth(currdir);
        if (n3 == 0) {
            this.lookin.setSelectedIndex(n2);
            this.ignore = false;
            return;
        }
        if (n2 == n) {
            new IPZap("A storage device is missing - unable to load the 'Lookin' directories.");
            return;
        }
        ++n2;
        file = currdir;
        while (true) {
            if (n2 == n) {
                this.lookin.addItem(file);
            } else {
                this.lookin.insertItemAt(file, n2);
            }
            file = file.getParentFile();
            if (file.getParentFile() == null) break;
            n = -1;
        }
        this.lookin.setSelectedItem(currdir);
        this.ignore = false;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (this.ignoreselect) {
            return;
        }
        if (list.getSelectedIndex() < 0) {
            return;
        }
        int[] nArray = list.getSelectedIndices();
        int n2 = nArray[(n = nArray.length) - 1];
        File file = (File)vals.getElementAt(n2);
        if (file.isDirectory()) {
            File file2;
            this.setDir(file);
            int n3 = this.lookin.getItemCount();
            String string = file.getAbsolutePath();
            int n4 = 0;
            n4 = 0;
            while (n4 < n3) {
                file2 = (File)this.lookin.getItemAt(n4);
                if (string.startsWith(file2.getAbsolutePath())) break;
                ++n4;
            }
            if (n4 == n3 - 1) {
                this.lookin.addItem(file);
                this.lookin.setSelectedIndex(n3);
            } else {
                int n5 = 0;
                n5 = n4;
                while (n5 < n3) {
                    file2 = (File)this.lookin.getItemAt(n5);
                    if (!string.startsWith(file2.getAbsolutePath())) break;
                    ++n5;
                }
                this.lookin.insertItemAt(file, n5);
                this.ignore = true;
                this.lookin.setSelectedItem(file);
                this.ignore = false;
            }
            this.select.setEnabled(false);
        } else {
            il.view(file);
            if (il.hasImage()) {
                this.on(file);
            } else {
                this.off();
            }
        }
    }

    class Pix
    extends JComponent {
        ImgThumb it;
        boolean loaded;
        boolean entered;
        boolean selected;
        File f;

        Pix(File file, boolean bl) {
            this.selected = bl;
            this.f = file;
            this.it = ImageOpener.getThumbImage(file, PIXDIM, false);
            this.enableEvents(16L);
        }

        void flush() {
            if (this.it != null) {
                this.it.flush();
            }
        }

        public Dimension getPreferredSize() {
            return PIXDIM;
        }

        public void paintComponent(Graphics graphics) {
            block7: {
                block6: {
                    if (!this.loaded) {
                        if (this.it == null || this.it.img == null) {
                            return;
                        }
                        this.setToolTipText(String.valueOf(this.f.getName()) + "  " + this.it.origw + "x" + this.it.origh + "  " + IPUtils.asK(this.f.length()));
                        this.loaded = true;
                    }
                    graphics.drawImage(this.it.img, this.it.xpos, this.it.ypos, this);
                    if (!this.selected) break block6;
                    int n = ImageOpener.PIXDIM.width - 4;
                    int n2 = ImageOpener.PIXDIM.height - 4;
                    graphics.setColor(Color.yellow);
                    graphics.fillRect(0, 0, ImageOpener.PIXDIM.width, 4);
                    graphics.fillRect(n, 0, 4, ImageOpener.PIXDIM.height);
                    graphics.fillRect(0, n2, ImageOpener.PIXDIM.width, 4);
                    graphics.fillRect(0, 0, 4, ImageOpener.PIXDIM.height);
                    graphics.setColor(Color.red);
                    int n3 = 0;
                    while (n3 < ImageOpener.PIXDIM.width) {
                        graphics.fillRect(n3, 0, 4, 4);
                        graphics.fillRect(n3, n2, 4, 4);
                        n3 += 8;
                    }
                    n3 = 0;
                    while (n3 < ImageOpener.PIXDIM.height) {
                        graphics.fillRect(0, n3, 4, 4);
                        graphics.fillRect(n, n3, 4, 4);
                        n3 += 8;
                    }
                    break block7;
                }
                if (!this.entered) break block7;
                int n = ImageOpener.PIXDIM.width - 4;
                int n4 = ImageOpener.PIXDIM.height - 4;
                graphics.setColor(Color.orange);
                graphics.fillRect(0, 0, ImageOpener.PIXDIM.width, 4);
                graphics.fillRect(n, 0, 4, ImageOpener.PIXDIM.height);
                graphics.fillRect(0, n4, ImageOpener.PIXDIM.width, 4);
                graphics.fillRect(0, 0, 4, ImageOpener.PIXDIM.height);
                graphics.setColor(Color.blue);
                int n5 = 0;
                while (n5 < ImageOpener.PIXDIM.width) {
                    graphics.fillRect(n5, 0, 4, 4);
                    graphics.fillRect(n5, n4, 4, 4);
                    n5 += 8;
                }
                n5 = 0;
                while (n5 < ImageOpener.PIXDIM.height) {
                    graphics.fillRect(0, n5, 4, 4);
                    graphics.fillRect(n, n5, 4, 4);
                    n5 += 8;
                }
            }
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 504: {
                    this.entered = true;
                    this.repaint();
                    break;
                }
                case 505: {
                    this.entered = false;
                    this.repaint();
                    break;
                }
                case 502: {
                    if (!this.contains(mouseEvent.getX(), mouseEvent.getY())) break;
                    if (this.selected) {
                        currfile = this.f;
                        ImageOpener.this.closeDialog();
                        return;
                    }
                    ImageOpener.deselectAll();
                    this.selected = true;
                    currfile = this.f;
                    ImageOpener.this.on(this.f);
                    pix.repaint();
                    break;
                }
            }
            super.processMouseEvent(mouseEvent);
        }
    }

    class LCRenderer
    extends Component
    implements ListCellRenderer {
        boolean isdisk;
        Color back;
        String txt;
        int indent;
        boolean selected;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            if (ImageOpener.this.getDepth(file) > 0) {
                this.isdisk = false;
                this.txt = file.getName();
            } else {
                this.isdisk = true;
                this.txt = file.getAbsolutePath();
            }
            this.indent = n < 0 ? 0 : 1 + ImageOpener.this.getDepth(file) * 8;
            this.selected = bl;
            return this;
        }

        public Dimension getPreferredSize() {
            return ImageOpener.this.DIM;
        }

        public void paint(Graphics graphics) {
            if (this.back == null) {
                this.back = this.getParent().getBackground();
            }
            graphics.setColor(this.selected ? ALTCOL : this.back);
            graphics.fillRect(0, 0, ImageOpener.this.DIM.width + 30, ImageOpener.this.DIM.height);
            if (this.isdisk) {
                graphics.drawImage(diskimg, this.indent, 2, null);
            } else {
                graphics.drawImage(dirimg, this.indent, 2, null);
            }
            graphics.setFont(SysProps.MSG_FONT);
            graphics.setColor(Color.black);
            graphics.drawString(this.txt, this.indent + 21, 15);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    class FFRenderer
    extends DefaultListCellRenderer {
        FFRenderer(JList jList) {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            if (file.isDirectory()) {
                this.setIcon(diricon);
            } else {
                this.setIcon(docicon);
            }
            return super.getListCellRendererComponent((JList<?>)jList, file.getName(), n, bl, bl2);
        }
    }
}

