/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Adjuster;
import com.equitysoft.icon.BackPanel;
import com.equitysoft.icon.CrissCross;
import com.equitysoft.icon.CustomConvolve;
import com.equitysoft.icon.EffectUtils;
import com.equitysoft.icon.IPDialog;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.LibButton;
import com.equitysoft.icon.PlusMinus;
import com.equitysoft.icon.SysProps;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class ImageEffect
extends IPDialog
implements ActionListener,
Adjuster {
    String BACK = "Repaint background";
    String EFFECT = " Effect";
    String UNDO = " Undo";
    String APPLY = " Apply";
    String GRAY = "Gray out";
    String FUZZ = "Fuzz";
    String BUTTON = "Button";
    String DETECTION = "Edge detection";
    String INVERT = "Invert";
    String SHARPEN = "Sharpen";
    String BRIGHTEN = "Brighten";
    String BLUR = "Blur";
    String DARKEN = "Darken";
    String CUSTOM = "Custom Convolve";
    String CANCEL = "Cancel";
    String CHECK = "Checkered";
    Dimension pdim;
    static Font MSG_FONT = new Font("SansSerif", 1, 12);
    CenterPanel center;
    JPanel north;
    BufferedImage orig;
    BufferedImage curr;
    BufferedImage tmp;
    BufferedImage undobi;
    int wid;
    int hgt;
    static ImageEffect handle;
    String curreffect;
    int currval;
    boolean undone;
    EffectPopup popup;
    JTextField txt;
    PlusMinus pm;
    LibButton effect;
    int buttonwid;

    ImageEffect() {
        super("Image effects.");
        JComponent jComponent;
        handle = this;
        this.wid = IconPainter.curr.getWidth();
        this.hgt = IconPainter.curr.getHeight();
        this.orig = new BufferedImage(this.wid, this.hgt, 1);
        IPUtils.copy(IconPainter.curr, this.orig);
        this.tmp = new BufferedImage(this.wid, this.hgt, 1);
        this.curr = new BufferedImage(this.wid, this.hgt, 1);
        IPUtils.copy(this.orig, this.curr);
        this.pdim = new Dimension(this.wid, this.hgt);
        this.jp.setLayout(new BorderLayout());
        this.north = new JPanel();
        this.north.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
        this.effect = new LibButton(this.EFFECT, "effect.gif");
        this.north.add(this.effect);
        this.effect.addActionListener(this);
        this.pm = new PlusMinus(this);
        this.north.add(this.pm);
        ((JComponent)this.pm).setEnabled(false);
        this.txt = new JTextField(10);
        this.txt.setFont(SysProps.MSG_FONT);
        this.txt.setEditable(false);
        this.north.add(this.txt);
        this.txt.setEnabled(false);
        this.txt.setBackground(Color.lightGray);
        LibButton libButton = new LibButton(this.UNDO);
        this.north.add(libButton);
        libButton.addActionListener(this);
        this.jp.add((Component)this.north, "North");
        this.center = new CenterPanel();
        if (this.wid > 250 || this.hgt > 200) {
            jComponent = new JScrollPane();
            jComponent.setBorder(BorderFactory.createLoweredBevelBorder());
            ((JScrollPane)jComponent).getViewport().add(this.center);
            this.jp.add((Component)jComponent, "Center");
        } else {
            jComponent = new JPanel();
            jComponent.setBackground(BackPanel.framecol);
            GridBagLayout gridBagLayout = new GridBagLayout();
            jComponent.setLayout(gridBagLayout);
            jComponent.add(this.center);
            gridBagLayout.setConstraints(jComponent, new GridBagConstraints());
            this.jp.add((Component)jComponent, "Center");
        }
        jComponent = new JPanel();
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
        libButton = new LibButton(this.APPLY);
        jComponent.add(libButton);
        libButton.addActionListener(this);
        libButton = new LibButton(this.CANCEL);
        jComponent.add(libButton);
        libButton.addActionListener(this);
        this.jp.add((Component)jComponent, "South");
        this.pack();
        if (this.getSize().height < 350) {
            ((Component)this).setSize(this.getSize().width, 350);
        }
        this.calcPos();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.EFFECT) {
            if (this.popup == null) {
                this.popup = new EffectPopup();
                this.jp.add(this.popup);
            }
            this.popup.show(this.jp, this.effect.getLocation().x, this.effect.getLocation().y + this.effect.getSize().height);
        } else if (string == this.UNDO) {
            this.resetCaption();
            if (this.undone) {
                this.undone = false;
                IPUtils.copy(this.undobi, this.curr);
            } else {
                this.undone = true;
                if (this.undobi == null) {
                    this.undobi = new BufferedImage(this.wid, this.hgt, 1);
                }
                IPUtils.copy(this.curr, this.undobi);
                IPUtils.copy(this.orig, this.curr);
            }
            this.repaint();
        } else if (string == this.CANCEL) {
            this.closeDialog();
        } else if (string == this.APPLY) {
            IconPainter.startAdd();
            Graphics2D graphics2D = IconPainter.curr.createGraphics();
            CrissCross.setClip(graphics2D);
            graphics2D.drawImage((Image)this.curr, 0, 0, null);
            IconPainter.refreshAll();
            this.closeDialog();
        }
    }

    public void adjust(PlusMinus plusMinus, int n) {
        if (this.curreffect.startsWith(this.BRIGHTEN)) {
            int n2 = n + this.currval;
            if (n2 < 0 || n2 > 100) {
                return;
            }
            this.currval = n2;
            this.txt.setText(" Brightness +" + n2 + " %");
            EffectUtils.brighten(this.orig, this.curr, this.currval, this.curreffect);
        } else if (this.curreffect.startsWith(this.DARKEN)) {
            int n3 = this.currval - n;
            if (n3 < 0 || n3 > 100) {
                return;
            }
            this.currval = n3;
            this.txt.setText(" Darkness -" + n3 + " %");
            EffectUtils.darken(this.orig, this.curr, this.currval, this.curreffect);
        } else if (this.curreffect.startsWith(this.FUZZ)) {
            int n4 = this.currval + n;
            if (n4 < 1 || n4 > 20) {
                return;
            }
            this.currval = n4;
            this.txt.setText(" Fuzz level " + n4);
            EffectUtils.fuzz(this.orig, this.curr, this.currval);
        } else if (this.curreffect.startsWith(this.BUTTON)) {
            int n5 = this.currval + n;
            if (n5 < 1 || n5 > Math.min(this.curr.getHeight(), this.curr.getWidth()) / 2) {
                return;
            }
            this.currval = n5;
            this.buttonwid = n5;
            this.txt.setText(" Border pixels " + n5);
            EffectUtils.buttonize(this.orig, this.curr, this.currval, this.curreffect);
        } else if (this.curreffect.endsWith("check")) {
            int n6 = this.currval + n;
            if (n6 < 1) {
                return;
            }
            this.currval = n6;
            this.txt.setText(" Border " + n6 + " pixels");
            EffectUtils.check(this.orig, this.curr, this.currval, this.curreffect);
        }
        this.repaint();
    }

    static void applyConvolve(Kernel kernel, boolean bl) {
        IPUtils.copy(ImageEffect.handle.curr, ImageEffect.handle.tmp);
        ConvolveOp convolveOp = bl ? new ConvolveOp(kernel, 0, null) : new ConvolveOp(kernel);
        convolveOp.filter(ImageEffect.handle.tmp, ImageEffect.handle.curr);
        handle.repaint();
        ImageEffect.handle.center.repaint();
    }

    void resetCaption() {
        this.txt.setText("");
        this.txt.setBackground(Color.lightGray);
        this.txt.setEnabled(false);
        ((JComponent)this.pm).setEnabled(false);
        this.currval = 0;
    }

    void setAdjust(String string) {
        this.txt.setBackground(Color.white);
        this.curreffect = string;
        ((JComponent)this.pm).setEnabled(true);
        this.txt.setEnabled(true);
        this.adjust(this.pm, 0);
    }

    void startModify() {
        this.undone = false;
        IPUtils.copy(this.curr, this.orig);
    }

    class EffectPopup
    extends JPopupMenu
    implements ActionListener {
        EffectPopup() {
            JMenuItem jMenuItem = new JMenuItem(ImageEffect.this.BACK);
            this.add(jMenuItem);
            jMenuItem.addActionListener(this);
            this.addSeparator();
            JMenu jMenu = new JMenu("Pattern");
            this.add(jMenu);
            JMenu jMenu2 = new JMenu("Buttonize");
            jMenu.add(jMenu2);
            jMenuItem = new JMenuItem("Button up");
            jMenu2.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Button down");
            jMenu2.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenu2 = new JMenu(ImageEffect.this.CHECK);
            jMenu.add(jMenu2);
            jMenuItem = new JMenuItem("Uniform check");
            jMenu2.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Random check");
            jMenu2.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenu = new JMenu(ImageEffect.this.INVERT);
            this.add(jMenu);
            jMenuItem = new JMenuItem("Invert all colors");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Invert Red");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Invert Green");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Invert Blue");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenu = new JMenu(ImageEffect.this.BLUR);
            this.add(jMenu);
            jMenuItem = new JMenuItem("Low blur");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Medium blur");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("High blur");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenu = new JMenu(ImageEffect.this.SHARPEN);
            this.add(jMenu);
            jMenuItem = new JMenuItem("Low sharpen");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Medium sharpen");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("High sharpen");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenu = new JMenu(ImageEffect.this.DETECTION);
            this.add(jMenu);
            jMenuItem = new JMenuItem("Low detection");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Medium detection");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("High detection");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenu = new JMenu("Miscellaneous");
            this.add(jMenu);
            jMenuItem = new JMenuItem(ImageEffect.this.GRAY);
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem(ImageEffect.this.FUZZ);
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            this.addSeparator();
            jMenu = new JMenu(ImageEffect.this.BRIGHTEN);
            this.add(jMenu);
            jMenuItem = new JMenuItem("Brighten all colors");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Brighten red");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Brighten green");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Brighten blue");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenu = new JMenu(ImageEffect.this.DARKEN);
            this.add(jMenu);
            jMenuItem = new JMenuItem("Darken all colors");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Darken red");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Darken green");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Darken blue");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            this.addSeparator();
            jMenu = new JMenu(ImageEffect.this.CUSTOM);
            this.add(jMenu);
            jMenuItem = new JMenuItem("3x3 grid");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("5x5 grid");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            ImageEffect.this.startModify();
            ImageEffect.this.resetCaption();
            if (string == ImageEffect.this.BACK) {
                EffectUtils.refreshBack(ImageEffect.this.curr);
            } else if (string == ImageEffect.this.GRAY) {
                EffectUtils.grayout(ImageEffect.this.curr);
            } else if (string.startsWith(ImageEffect.this.BUTTON)) {
                ImageEffect.this.pm.setInc(1);
                if (ImageEffect.this.curreffect == null || !ImageEffect.this.curreffect.startsWith(ImageEffect.this.BUTTON)) {
                    ImageEffect.this.currval = (int)((double)Math.min(ImageEffect.this.curr.getHeight(), ImageEffect.this.curr.getWidth()) * 0.15);
                } else if (ImageEffect.this.curreffect != null) {
                    ImageEffect.this.currval = ImageEffect.this.buttonwid;
                }
                ImageEffect.this.setAdjust(string);
            } else if (string == ImageEffect.this.FUZZ) {
                ImageEffect.this.pm.setInc(1);
                ImageEffect.this.currval = 1;
                ImageEffect.this.setAdjust(string);
            } else if (string.endsWith("check")) {
                ImageEffect.this.pm.setInc(1);
                ImageEffect.this.currval = 8;
                ImageEffect.this.setAdjust(string);
            } else if (string.startsWith("Brighten")) {
                ImageEffect.this.pm.setInc(10);
                ImageEffect.this.currval = 50;
                ImageEffect.this.setAdjust(string);
            } else if (string.startsWith("Darken")) {
                ImageEffect.this.pm.setInc(10);
                ImageEffect.this.currval = 50;
                ImageEffect.this.setAdjust(string);
            } else if (string.endsWith("detection")) {
                EffectUtils.edge(string);
            } else if (string.endsWith("blur")) {
                EffectUtils.blur(string);
            } else if (string.endsWith("sharpen")) {
                EffectUtils.sharpen(string);
            } else if (string.startsWith("Invert")) {
                EffectUtils.invert(string, ImageEffect.this.curr);
            } else if (string.endsWith("grid")) {
                new CustomConvolve(string);
            }
            handle.repaint();
        }
    }

    class CenterPanel
    extends JPanel {
        CenterPanel() {
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return ImageEffect.this.pdim;
        }

        public void paintComponent(Graphics graphics) {
            graphics.drawImage(ImageEffect.this.curr, 0, 0, null);
        }
    }
}

