/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Bar;
import com.equitysoft.icon.CrissCross;
import com.equitysoft.icon.DisplayMenu;
import com.equitysoft.icon.EditMenu;
import com.equitysoft.icon.FileManager;
import com.equitysoft.icon.FontBox;
import com.equitysoft.icon.Grid;
import com.equitysoft.icon.IPLib;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.InfoBar;
import com.equitysoft.icon.Palette;
import com.equitysoft.icon.Pic;
import com.equitysoft.icon.RecentFiles;
import com.equitysoft.icon.Splash;
import com.equitysoft.icon.SquareMenu;
import com.equitysoft.icon.Status;
import com.equitysoft.icon.SysProps;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class IconPainter {
    static String SYS_ICON = "blue_logo_sm.gif";
    static int SEP = 1;
    static BufferedImage orig;
    static BufferedImage curr;
    static BufferedImage transimg;
    static BufferedImage undo;
    static int rows;
    static int cols;
    static int sqdim;
    static int back;
    static Color backcol;
    static Color backtrans;
    static Dimension screendim;
    static Pic pic;
    static Bar bar;
    static Grid grid;
    static boolean undone;
    static Closer closer;

    public IconPainter() {
        IPUtils.cls = this.getClass();
        screendim = Toolkit.getDefaultToolkit().getScreenSize();
        Splash splash = null;
        FileManager.a675 = true;
        SysProps.setDirs();
        closer = new Closer();
        if (!SysProps.exists()) {
            IconPainter.initAll();
        } else if (!SysProps.setProps()) {
            IconPainter.initAll();
        } else {
            if (SysProps.splash == 0) {
                splash = new Splash(screendim);
            }
            bar = new Bar();
            SysProps.setDelayedProps();
            grid = new Grid();
            ((Component)bar).setLocation(SysProps.getBarLoc());
            ((Component)bar).setVisible(true);
            ((Component)grid).setLocation(SysProps.getGridLoc());
            ((Component)grid).setSize(SysProps.getGridSize());
            ((Component)grid).setVisible(true);
            if (sqdim > 1) {
                pic = new Pic();
                ((Component)pic).setLocation(SysProps.getPicLoc());
                ((Component)pic).setVisible(true);
            }
            SysProps.endLoad();
            RecentFiles.load();
        }
        SquareMenu.setSquare();
        FileManager.a675 = false;
        if (!FileManager.a675) {
            SysProps.a9();
        }
        Bar.setUntitled();
        if (splash != null) {
            ((Component)splash).setVisible(false);
        }
        IPUtils.checkPackages();
        Bar.handle.requestFocus();
    }

    static void clearTransImg() {
        int[] nArray = ((DataBufferInt)transimg.getRaster().getDataBuffer()).getData();
        int n = nArray.length;
        int n2 = backtrans.getRGB();
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = n2;
            ++n3;
        }
    }

    static void cloneAdd() {
        IPUtils.copy(curr, orig);
    }

    static void createUndoBuffer() {
        if (undo == null) {
            undo = new BufferedImage(cols, rows, 4);
        }
    }

    static void init(int n, int n2) {
        EditMenu.off();
        BufferedImage bufferedImage = null;
        int n3 = 0;
        int n4 = 0;
        transimg = null;
        undo = null;
        if (orig != null) {
            bufferedImage = curr;
            n3 = cols;
            n4 = rows;
        }
        rows = n2;
        cols = n;
        curr = new BufferedImage(n, n2, 1);
        orig = new BufferedImage(n, n2, 1);
        transimg = new BufferedImage(cols, rows, 2);
        IconPainter.clearTransImg();
        IPUtils.clearAll();
        if (bufferedImage != null) {
            Graphics2D graphics2D = curr.createGraphics();
            if (DisplayMenu.resize.getState() == 0) {
                graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
            } else {
                int n5 = bufferedImage.getWidth();
                int n6 = bufferedImage.getHeight();
                graphics2D.drawImage((Image)bufferedImage, (n - n5) / 2, (n2 - n6) / 2, null);
            }
            IPUtils.copy(curr, orig);
        }
        if (bufferedImage != null) {
            IconPainter.layoutGrid();
        }
        Bar.setUntitled();
    }

    static void initAll() {
        FontBox.fname = "SansSerif";
        bar = new Bar();
        IconPainter.setBackColor(Color.lightGray);
        Palette.setColors();
        FileManager.chooserdir = SysProps.MYICONS_DIR;
        SysProps.setLandF(0);
        sqdim = 10;
        SquareMenu.handle.setState(2);
        IconPainter.init(32, 32);
        grid = new Grid();
        ((Component)bar).setLocation(10, 0);
        ((Component)bar).setVisible(true);
        ((Component)grid).setLocation(IconPainter.bar.getLocation().x, IconPainter.bar.getLocation().y + IconPainter.bar.getSize().height + SEP);
        ((Component)grid).setVisible(true);
        pic = new Pic();
        ((Component)pic).setLocation(IconPainter.grid.getLocation().x + IconPainter.grid.getSize().width + SEP, IconPainter.grid.getLocation().y);
        Palette.setCurrent(Color.blue.getRGB());
        ((Component)pic).setVisible(true);
        RecentFiles.load();
    }

    static void layoutGrid() {
        CrissCross.reset();
        Point point = grid.getLocation();
        grid.pack();
        grid.repaint();
        if (point.y + IconPainter.grid.getSize().height > IconPainter.screendim.height) {
            ((Component)grid).setSize(IconPainter.grid.getSize().width, IconPainter.screendim.height - point.y);
        }
        if (point.x + IconPainter.grid.getSize().width > IconPainter.screendim.width) {
            ((Component)grid).setSize(IconPainter.screendim.width - point.x, IconPainter.grid.getSize().height);
        }
        grid.invalidate();
        grid.validate();
        grid.repaint();
        if (sqdim > 1) {
            Pic.ii.invalidate();
            pic.pack();
            if (!pic.isVisible()) {
                ((Component)pic).setVisible(true);
            }
            if (point.x + IconPainter.grid.getSize().width + IconPainter.pic.getSize().width > IconPainter.screendim.width) {
                ((Component)pic).setLocation(0, point.y);
            } else {
                ((Component)pic).setLocation(IconPainter.grid.getLocation().x + IconPainter.grid.getSize().width + SEP, IconPainter.grid.getLocation().y);
            }
            pic.repaint();
        }
        Grid.setOrig();
    }

    public static void main(String[] stringArray) {
        new IconPainter();
    }

    static void refreshAll() {
        if (sqdim > 1) {
            pic.repaint();
        }
        grid.repaint();
    }

    static void resetBack(Color color) {
        IPLib.shadowcolor = null;
        int n = back;
        IconPainter.setBackColor(color);
        int n2 = 0;
        while (n2 < rows) {
            int n3 = 0;
            while (n3 < cols) {
                if (curr.getRGB(n3, n2) == n) {
                    curr.setRGB(n3, n2, back);
                }
                ++n3;
            }
            ++n2;
        }
        CrissCross.lines = IPUtils.darken(color);
        grid.repaint();
        if (sqdim > 1) {
            pic.repaint();
        }
        InfoBar.set();
    }

    static void setBackColor(Color color) {
        back = color.getRGB();
        backcol = color;
        backtrans = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
    }

    static void startAdd() {
        IPLib.resetParams();
        IconPainter.clearTransImg();
        undone = false;
        IPUtils.copy(curr, orig);
    }

    static void undo() {
        Status.clear();
        if (!undone) {
            undone = true;
            IconPainter.createUndoBuffer();
            IPUtils.copy(curr, undo);
            IPUtils.copy(orig, curr);
        } else {
            undone = false;
            IPUtils.copy(undo, curr);
        }
        IconPainter.refreshAll();
    }

    class Closer
    extends WindowAdapter {
        Closer() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            SysProps.writeProps();
        }
    }
}

