/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.FileManager;
import com.equitysoft.icon.IData;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IUtils;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.MSUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class ISave {
    static int ONLY = 1;
    static int ONLY_OFFSET = 22;
    static int BUF_LEN = 512;
    static BufferedImage img;
    static int iwidth;
    static int iheight;
    static int xhot;
    static int yhot;
    static boolean saveas;
    static int istobe;

    ISave() {
    }

    static boolean appendSave(File file, IData[] iDataArray) {
        int n = iDataArray.length;
        long l = iDataArray[0].offset;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += iDataArray[n3].size;
            ++n3;
        }
        try {
            File file2 = File.createTempFile("IPF#", "tmp");
            file2.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            ISave.saveIDir(fileOutputStream, iDataArray.length + 1);
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.skip(6L);
            int n4 = n * 16;
            int n5 = 0;
            while (n5 < n) {
                iDataArray[n5].offset += 16;
                ISave.writeEntry(fileOutputStream, iDataArray[n5]);
                fileInputStream.skip(16L);
                ++n5;
            }
            ISave.saveEntry(fileOutputStream, n2 + 6 + (n4 += 16));
            byte[] byArray = new byte[BUF_LEN];
            ISave.copy(byArray, fileInputStream, fileOutputStream, n2);
            fileInputStream.close();
            ISave.saveIt(fileOutputStream);
            fileOutputStream.close();
            file.delete();
            file2.renameTo(file);
        }
        catch (IOException iOException) {
            new IPZap("Error appending icon : " + iOException.getMessage());
            return false;
        }
        return true;
    }

    static void copy(byte[] byArray, FileInputStream fileInputStream, FileOutputStream fileOutputStream, int n) throws IOException {
        int n2;
        if (n == 0) {
            return;
        }
        int n3 = byArray.length;
        for (n2 = n; n2 > n3; n2 -= n3) {
            fileInputStream.read(byArray);
            fileOutputStream.write(byArray);
        }
        fileInputStream.read(byArray, 0, n2);
        fileOutputStream.write(byArray, 0, n2);
    }

    static boolean firstSave(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (!ISave.saveIDir(fileOutputStream, 1)) {
                fileOutputStream.close();
                return false;
            }
            if (!ISave.saveEntry(fileOutputStream, ONLY_OFFSET)) {
                fileOutputStream.close();
                return false;
            }
            if (!ISave.saveIt(fileOutputStream)) {
                fileOutputStream.close();
                return false;
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static int getDataSize() {
        switch (iheight) {
            case 16: {
                return 1384;
            }
            case 24: {
                return 1736;
            }
            case 32: {
                return 2216;
            }
            case 48: {
                return 3752;
            }
            case 64: {
                return 5672;
            }
        }
        return 0;
    }

    static int getOr(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 128;
                break;
            }
            case 1: {
                n2 = 64;
                break;
            }
            case 2: {
                n2 = 32;
                break;
            }
            case 3: {
                n2 = 16;
                break;
            }
            case 4: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 4;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 1;
                break;
            }
        }
        return n2;
    }

    static boolean go(File file, int n) {
        istobe = n;
        img = IconPainter.curr;
        iwidth = img.getWidth();
        iheight = img.getHeight();
        if (ISave.getDataSize() == 0 || iwidth != iheight) {
            new IPZap("ICO images must be 16,24,32,48 or 64 pixels square.");
            return false;
        }
        if (!file.exists()) {
            return ISave.firstSave(file);
        }
        IData[] iDataArray = IUtils.getDirs(file);
        int n2 = iDataArray.length;
        if (n2 == 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (ISave.isSimilar(iDataArray[n3], img)) break;
            ++n3;
        }
        if (n3 == n2) {
            return ISave.appendSave(file, iDataArray);
        }
        if (n2 == 1) {
            return ISave.firstSave(file);
        }
        return ISave.replaceSave(file, n3, iDataArray);
    }

    static boolean isSimilar(IData iData, BufferedImage bufferedImage) {
        return iData.wid == bufferedImage.getWidth() && iData.hgt == bufferedImage.getHeight();
    }

    static boolean replaceSave(File file, int n, IData[] iDataArray) {
        try {
            File file2 = File.createTempFile("IPF#", "tmp");
            file2.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[BUF_LEN];
            ISave.copy(byArray, fileInputStream, fileOutputStream, 6);
            int n2 = iDataArray.length;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                ISave.copy(byArray, fileInputStream, fileOutputStream, 16);
                n3 += iDataArray[n4].size;
                ++n4;
            }
            fileInputStream.skip(16L);
            int n5 = ISave.getDataSize() - iDataArray[n].size;
            ISave.saveEntry(fileOutputStream, iDataArray[n].offset);
            int n6 = 0;
            int n7 = n + 1;
            while (n7 < n2) {
                iDataArray[n7].offset += n5;
                ISave.writeEntry(fileOutputStream, iDataArray[n7]);
                n6 += iDataArray[n7].size;
                fileInputStream.skip(16L);
                ++n7;
            }
            ISave.copy(byArray, fileInputStream, fileOutputStream, n3);
            ISave.saveIt(fileOutputStream);
            fileInputStream.skip(iDataArray[n].size);
            ISave.copy(byArray, fileInputStream, fileOutputStream, n6);
            fileInputStream.close();
            fileOutputStream.close();
            file.delete();
            file2.renameTo(file);
        }
        catch (IOException iOException) {
            new IPZap("Error replacing icon : " + iOException.getMessage());
            return false;
        }
        return true;
    }

    static boolean saveEntry(FileOutputStream fileOutputStream, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = 8;
        if (istobe == 10) {
            n5 = yhot;
            n4 = xhot;
        }
        try {
            fileOutputStream.write(iwidth);
            fileOutputStream.write(iheight);
            fileOutputStream.write(n2);
            fileOutputStream.write(n3);
            fileOutputStream.write(MSUtils.intToWord(n4));
            fileOutputStream.write(MSUtils.intToWord(n5));
            fileOutputStream.write(MSUtils.intToDWord(ISave.getDataSize()));
            fileOutputStream.write(MSUtils.intToDWord(n));
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static boolean saveIDir(FileOutputStream fileOutputStream, int n) {
        try {
            int n2 = 0;
            int n3 = 1;
            if (istobe == 10) {
                n3 = 2;
            }
            int n4 = n;
            fileOutputStream.write(MSUtils.intToWord(n2));
            fileOutputStream.write(MSUtils.intToWord(n3));
            fileOutputStream.write(MSUtils.intToWord(n4));
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static boolean saveIt(FileOutputStream fileOutputStream) {
        int n;
        int n2 = 40;
        int n3 = 1;
        int n4 = 8;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = IconPainter.back;
        int n12 = iheight * iwidth;
        int[] nArray = new int[256];
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        nArray[0] = 0;
        ++n13;
        byte[] byArray = new byte[n12];
        int n18 = 0;
        if (iwidth == 16) {
            n18 = 64;
        } else if (iwidth == 24) {
            n18 = 96;
        } else if (iwidth == 32) {
            n18 = 128;
        } else if (iwidth == 48) {
            n18 = 384;
        } else if (iwidth == 64) {
            n18 = 512;
        }
        byte[] byArray2 = new byte[n18];
        int n19 = iheight - 1;
        while (n19 >= 0) {
            n = 0;
            while (n < iwidth) {
                int n20 = img.getRGB(n, n19);
                if (n20 == n11) {
                    int n21 = byArray2[n15] | ISave.getOr(n16);
                    byArray2[n15] = (byte)n21;
                }
                if (++n16 == 8) {
                    n16 = 0;
                    ++n15;
                    switch (iheight) {
                        case 16: {
                            if (++n17 != 2) break;
                            n17 = 0;
                            ++n15;
                            ++n15;
                            break;
                        }
                        case 24: {
                            if (++n17 != 3) break;
                            n17 = 0;
                            ++n15;
                            break;
                        }
                        case 48: {
                            if (++n17 != 6) break;
                            n17 = 0;
                            ++n15;
                            ++n15;
                            break;
                        }
                    }
                }
                if (n20 == n11) {
                    byArray[n14] = 0;
                    ++n14;
                } else {
                    int n22 = 0;
                    while (n22 < n13) {
                        if (nArray[n22] == n20) {
                            byArray[n14] = (byte)(n22 & 0xFF);
                            break;
                        }
                        ++n22;
                    }
                    if (n22 == n13) {
                        if (n13 == 256) {
                            new IPZap("Too many colors for an icon");
                            return false;
                        }
                        nArray[n13] = n20;
                        byArray[n14] = (byte)(n13 & 0xFF);
                        ++n13;
                    }
                    ++n14;
                }
                ++n;
            }
            --n19;
        }
        int n23 = iwidth + iheight;
        try {
            fileOutputStream.write(MSUtils.intToDWord(n2));
            fileOutputStream.write(MSUtils.intToDWord(iwidth));
            fileOutputStream.write(MSUtils.intToDWord(n23));
            fileOutputStream.write(MSUtils.intToWord(n3));
            fileOutputStream.write(MSUtils.intToWord(n4));
            fileOutputStream.write(MSUtils.intToDWord(n5));
            fileOutputStream.write(MSUtils.intToDWord(n6));
            fileOutputStream.write(MSUtils.intToDWord(n7));
            fileOutputStream.write(MSUtils.intToDWord(n8));
            fileOutputStream.write(MSUtils.intToDWord(n9));
            fileOutputStream.write(MSUtils.intToDWord(n10));
            n = 0;
            while (n < 256) {
                fileOutputStream.write(MSUtils.intToDWord(nArray[n]));
                ++n;
            }
            fileOutputStream.write(byArray, 0, n12);
            fileOutputStream.write(byArray2, 0, n18);
        }
        catch (Exception exception) {
            new IPZap("Error writing file : " + exception.getMessage());
            return false;
        }
        return true;
    }

    static void setSpot(int n, int n2) {
        FileManager.filetype = 10;
        xhot = n;
        yhot = n2;
        FileManager.saveFile(saveas);
    }

    static void writeEntry(FileOutputStream fileOutputStream, IData iData) throws IOException {
        int n = 0;
        fileOutputStream.write(iData.wid);
        fileOutputStream.write(iData.hgt);
        fileOutputStream.write(iData.colors);
        fileOutputStream.write(n);
        fileOutputStream.write(MSUtils.intToWord(iData.xspot));
        fileOutputStream.write(MSUtils.intToWord(iData.yspot));
        fileOutputStream.write(MSUtils.intToDWord(iData.size));
        fileOutputStream.write(MSUtils.intToDWord(iData.offset));
    }
}

