/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Bar;
import com.equitysoft.icon.EditMenu;
import com.equitysoft.icon.FileManager;
import com.equitysoft.icon.Grid;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.Status;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.NumberFormat;
import javax.swing.JMenuItem;

class IPUtils {
    static String EMPTY = "";
    static MediaTracker tracker;
    static Class cls;
    static final int BUFSIZE = 512;
    static byte[] buf;
    static ByteArrayOutputStream baos;
    static NumberFormat nf;
    static StringBuffer sb;

    static {
        nf = NumberFormat.getInstance();
        sb = new StringBuffer(10);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumFractionDigits(1);
    }

    IPUtils() {
    }

    static String asK(long l) {
        sb.setLength(0);
        if (l < 103L) {
            sb.append(l);
            if (l == 1L) {
                sb.append("byte");
            } else {
                sb.append("bytes");
            }
            return sb.toString();
        }
        if (l < 0x100000L) {
            sb.append(nf.format((float)l / 1024.0f)).append("K");
            return sb.toString();
        }
        float f = (float)l / 1048576.0f;
        sb.append(nf.format(f)).append("MB");
        return sb.toString();
    }

    static void checkPackages() {
        if (IPUtils.isAvailable("com.sun.media.jai.codec.BMPEncodeParam")) {
            FileManager.havejai = true;
        }
        if (IPUtils.isAvailable("quicktime.qd.QDRect")) {
            FileManager.haveqt = true;
        }
    }

    static void clearAll() {
        Graphics2D graphics2D = IconPainter.curr.createGraphics();
        graphics2D.setColor(IconPainter.backcol);
        graphics2D.fillRect(0, 0, IconPainter.cols, IconPainter.rows);
        graphics2D = IconPainter.orig.createGraphics();
        graphics2D.setColor(IconPainter.backcol);
        graphics2D.fillRect(0, 0, IconPainter.cols, IconPainter.rows);
        IconPainter.clearTransImg();
    }

    static void completeClear() {
        IPUtils.clearAll();
        IconPainter.undo = null;
        IconPainter.undone = false;
    }

    static void copy(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
    }

    static Color darken(Color color) {
        Color color2 = null;
        int n = 0;
        if (color.getRed() < 100) {
            ++n;
        }
        if (color.getGreen() < 100) {
            ++n;
        }
        if (color.getBlue() < 100) {
            ++n;
        }
        if (n > 1) {
            int n2;
            int n3;
            int n4 = (255 - color.getRed()) / 3 + color.getRed();
            if (n4 > 255) {
                n4 = 255;
            }
            if ((n3 = (255 - color.getGreen()) / 3 + color.getGreen()) > 255) {
                n3 = 255;
            }
            if ((n2 = (255 - color.getBlue()) / 3 + color.getBlue()) > 255) {
                n2 = 255;
            }
            color2 = new Color(n4, n3, n2);
        } else {
            color2 = new Color((int)((double)color.getRed() * 0.8), (int)((double)color.getGreen() * 0.8), (int)((double)color.getBlue() * 0.8));
        }
        return color2;
    }

    static void defrost() {
        Bar.handle.setEnabled(true);
        Grid.handle.setEnabled(true);
    }

    static void freeze() {
        Bar.handle.setEnabled(false);
        Grid.handle.setEnabled(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getAnyFileAsString(File file) {
        if (baos == null) {
            buf = new byte[512];
            baos = new ByteArrayOutputStream();
        } else {
            baos.reset();
        }
        byte[] byArray = buf;
        ByteArrayOutputStream byteArrayOutputStream = baos;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (fileInputStream == null) {
                return null;
            }
            while (true) {
                int n;
                if ((n = fileInputStream.read(byArray, 0, 512)) <= 0) {
                    fileInputStream.close();
                    return byteArrayOutputStream.toString();
                }
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getFileAsString(String string) {
        if (baos == null) {
            buf = new byte[512];
            baos = new ByteArrayOutputStream();
        } else {
            baos.reset();
        }
        byte[] byArray = buf;
        ByteArrayOutputStream byteArrayOutputStream = baos;
        try {
            InputStream inputStream = cls.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            while (true) {
                int n;
                if ((n = inputStream.read(byArray, 0, 512)) <= 0) {
                    inputStream.close();
                    return byteArrayOutputStream.toString();
                }
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    static URL getIPURL(String string) {
        URL uRL = cls.getResource("images/" + string);
        if (uRL == null) {
            return null;
        }
        return uRL;
    }

    static Image getImage(File file) {
        return IPUtils.loadImage(Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath()));
    }

    static JMenuItem getMI(String string, ActionListener actionListener) {
        return IPUtils.getMI(string, actionListener, -1);
    }

    static JMenuItem getMI(String string, ActionListener actionListener, int n) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        if (n > 0) {
            jMenuItem.setMnemonic(n);
        }
        return jMenuItem;
    }

    static Image getSystemImage(String string) {
        return IPUtils.loadImage(Toolkit.getDefaultToolkit().getImage(IPUtils.getIPURL(string)));
    }

    static boolean isAvailable(String string) {
        try {
            Class<?> clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    static Image loadImage(Image image) {
        try {
            if (tracker == null) {
                tracker = new MediaTracker(Bar.handle);
            }
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (Exception exception) {
            return null;
        }
        if (image.getWidth(null) <= 0) {
            return null;
        }
        return image;
    }

    static void newIcon() {
        Status.clear();
        Bar.setUntitled();
        IPUtils.completeClear();
        IconPainter.startAdd();
        EditMenu.off();
        IconPainter.refreshAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void writeFileAsString(File file, String string) {
        if (baos == null) {
            buf = new byte[512];
            baos = new ByteArrayOutputStream();
        } else {
            baos.reset();
        }
        byte[] byArray = buf;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (fileOutputStream == null) {
                return;
            }
            while (true) {
                int n;
                if ((n = byteArrayInputStream.read(byArray, 0, 512)) <= 0) {
                    fileOutputStream.close();
                    return;
                }
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            new IPZap("Error occured writing file");
            return;
        }
    }
}

