/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Bar;
import com.equitysoft.icon.CrissCross;
import com.equitysoft.icon.DisplayMenu;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.OptionsBox;
import com.equitysoft.icon.Palette;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import java.util.Vector;

class IPLib {
    static final int OUTLINE = 0;
    static final int FILL = 1;
    static final int OUTLINE_FILL = 2;
    static final int LOW = 0;
    static final int MEDIUM = 1;
    static final int HIGH = 2;
    static int origcol;
    static int currcolor;
    static int gccnt;
    static int total;
    static BufferedImage curr;
    static BufferedImage transimg;
    static Rectangle fillrec;
    static Color shadowcolor;
    static int xshift;
    static int yshift;
    static int fill;
    static double rotation;

    IPLib() {
    }

    static void blur(int n) {
        Kernel kernel;
        float f;
        BufferedImage bufferedImage = new BufferedImage(IconPainter.cols, IconPainter.rows, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)IconPainter.transimg, 0, 0, null);
        IconPainter.clearTransImg();
        if (n == 0) {
            f = 0.2f;
            float[] fArray = new float[9];
            fArray[1] = f;
            fArray[4] = f;
            fArray[5] = f;
            fArray[6] = f;
            fArray[8] = f;
            kernel = new Kernel(3, 3, fArray);
        } else if (n == 1) {
            f = 0.11111111f;
            float[] fArray = new float[9];
            int n2 = 0;
            while (n2 < 9) {
                fArray[n2] = f;
                ++n2;
            }
            kernel = new Kernel(3, 3, fArray);
        } else {
            f = 0.04f;
            float[] fArray = new float[25];
            int n3 = 0;
            while (n3 < 25) {
                fArray[n3] = f;
                ++n3;
            }
            kernel = new Kernel(5, 5, fArray);
        }
        ConvolveOp convolveOp = new ConvolveOp(kernel, 0, null);
        convolveOp.filter(bufferedImage, IconPainter.transimg);
    }

    static void doFlood(int n, int n2) {
        if (++total == 10000) {
            return;
        }
        if (++gccnt == 300) {
            gccnt = 0;
            System.gc();
        }
        curr.setRGB(n, n2, currcolor);
        transimg.setRGB(n, n2, currcolor);
        if (n > 0 && curr.getRGB(n - 1, n2) == origcol) {
            IPLib.doFlood(n - 1, n2);
        }
        if (n < IconPainter.cols - 1 && curr.getRGB(n + 1, n2) == origcol) {
            IPLib.doFlood(n + 1, n2);
        }
        if (n2 > 0 && curr.getRGB(n, n2 - 1) == origcol) {
            IPLib.doFlood(n, n2 - 1);
        }
        if (n2 < IconPainter.rows - 1 && curr.getRGB(n, n2 + 1) == origcol) {
            IPLib.doFlood(n, n2 + 1);
        }
    }

    static void drawBoxShadow(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        if (OptionsBox.shadow == 0) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        graphics2D.setColor(IPLib.getShadow());
        int n5 = OptionsBox.transx(n);
        int n6 = OptionsBox.transy(n2);
        if (bl) {
            graphics2D.fill(new Rectangle(n5, n6, n3, n4));
        } else {
            graphics2D.draw(new Rectangle(n5, n6, n3, n4));
        }
        IPLib.blur(bl ? 2 : 0);
        graphics2D.setPaint(paint);
    }

    static void drawCurve(int n, int n2) {
        int n3 = IconPainter.sqdim;
        Point2D[] point2DArray = CrissCross.controls;
        int n4 = 0;
        while (n4 < n2) {
            Point point = point2DArray[n4];
            point.x /= n3;
            point.y /= n3;
            ++n4;
        }
        Graphics2D graphics2D = IPLib.getContext();
        if (n == 32) {
            if (OptionsBox.filldirec != 0) {
                Object object;
                if (DisplayMenu.fillhow.getState() != 0) {
                    object = new int[n2];
                    int[] nArray = new int[n2];
                    int n5 = 0;
                    while (n5 < n2) {
                        object[n5] = ((Point)point2DArray[n5]).x;
                        nArray[n5] = ((Point)point2DArray[n5]).y;
                        ++n5;
                    }
                    Polygon polygon = new Polygon((int[])object, nArray, n2);
                    fillrec = polygon.getBounds();
                }
                CrissCross.quadcurve.setCurve(point2DArray, 0);
                graphics2D.draw(CrissCross.quadcurve);
                IPLib.setGradientPaint(graphics2D, true);
                if (OptionsBox.shadow != 0) {
                    object = graphics2D.getPaint();
                    IPLib.drawCurveShadow(graphics2D, (Point[])point2DArray, n2, n);
                    CrissCross.quadcurve.setCurve(point2DArray, 0);
                    graphics2D.setPaint((Paint)object);
                }
                graphics2D.draw(CrissCross.quadcurve);
            } else {
                if (OptionsBox.shadow != 0) {
                    IPLib.drawCurveShadow(graphics2D, (Point[])point2DArray, n2, n);
                    graphics2D.setColor(new Color(Palette.currcolor));
                }
                CrissCross.quadcurve.setCurve(point2DArray, 0);
                graphics2D.draw(CrissCross.quadcurve);
            }
        } else if (OptionsBox.filldirec != 0) {
            Object object;
            if (DisplayMenu.fillhow.getState() != 0) {
                object = new int[n2];
                int[] nArray = new int[n2];
                int n6 = 0;
                while (n6 < n2) {
                    object[n6] = ((Point)point2DArray[n6]).x;
                    nArray[n6] = ((Point)point2DArray[n6]).y;
                    ++n6;
                }
                Polygon polygon = new Polygon((int[])object, nArray, n2);
                fillrec = polygon.getBounds();
            }
            CrissCross.cubiccurve.setCurve(point2DArray, 0);
            graphics2D.draw(CrissCross.cubiccurve);
            IPLib.setGradientPaint(graphics2D, true);
            if (OptionsBox.shadow != 0) {
                object = graphics2D.getPaint();
                IPLib.drawCurveShadow(graphics2D, (Point[])point2DArray, n2, n);
                CrissCross.cubiccurve.setCurve(point2DArray, 0);
                graphics2D.setPaint((Paint)object);
            }
            graphics2D.draw(CrissCross.cubiccurve);
        } else {
            if (OptionsBox.shadow != 0) {
                IPLib.drawCurveShadow(graphics2D, (Point[])point2DArray, n2, n);
                graphics2D.setColor(new Color(Palette.currcolor));
            }
            CrissCross.cubiccurve.setCurve(point2DArray, 0);
            graphics2D.draw(CrissCross.cubiccurve);
        }
    }

    static void drawCurveShadow(Graphics2D graphics2D, Point[] pointArray, int n, int n2) {
        graphics2D.setColor(IPLib.getShadow());
        Point2D[] point2DArray = new Point[n];
        int n3 = 0;
        while (n3 < n) {
            point2DArray[n3] = new Point(OptionsBox.transx(pointArray[n3].x), OptionsBox.transy(pointArray[n3].y));
            ++n3;
        }
        if (n2 == 32) {
            CrissCross.quadcurve.setCurve(point2DArray, 0);
            graphics2D.draw(CrissCross.quadcurve);
        } else {
            CrissCross.cubiccurve.setCurve(point2DArray, 0);
            graphics2D.draw(CrissCross.cubiccurve);
        }
        IPLib.blur(0);
    }

    static void drawEllipseShadow(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        if (OptionsBox.shadow == 0) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        graphics2D.setColor(IPLib.getShadow());
        int n5 = OptionsBox.transx(n);
        int n6 = OptionsBox.transy(n2);
        Ellipse2D.Float float_ = new Ellipse2D.Float(n5, n6, n3, n4);
        if (bl) {
            graphics2D.fill(float_);
        } else {
            graphics2D.draw(float_);
        }
        IPLib.blur(bl ? 2 : 0);
        graphics2D.setPaint(paint);
    }

    static void drawMPLine(Vector vector) {
        int n = vector.size();
        if (n < 2) {
            return;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            Point point = (Point)vector.elementAt(n2);
            nArray[n2] = point.x;
            nArray2[n2] = point.y;
            ++n2;
        }
        Polygon polygon = new Polygon(nArray, nArray2, n);
        if (DisplayMenu.fillhow.getState() != 0) {
            fillrec = polygon.getBounds();
        }
        Graphics2D graphics2D = IPLib.getContext();
        if (fill == 1 || fill == 2) {
            if (OptionsBox.filldirec != 0) {
                graphics2D.fillPolygon(polygon);
                graphics2D.drawPolygon(polygon);
                IPLib.setGradientPaint(graphics2D, true);
                IPLib.drawPolyShadow(graphics2D, nArray, nArray2, n, true);
                graphics2D.fillPolygon(polygon);
                graphics2D.drawPolygon(polygon);
            } else {
                IPLib.drawPolyShadow(graphics2D, nArray, nArray2, n, true);
                graphics2D.fillPolygon(polygon);
                graphics2D.drawPolygon(polygon);
            }
            if (fill == 2) {
                graphics2D.setColor(new Color(Palette.targcol));
                graphics2D.drawPolygon(polygon);
            }
        } else if (fill == 0) {
            if (OptionsBox.filldirec != 0) {
                graphics2D.drawPolyline(nArray, nArray2, n);
                IPLib.setGradientPaint(graphics2D, true);
                IPLib.drawPolyShadow(graphics2D, nArray, nArray2, n, false);
                graphics2D.drawPolyline(nArray, nArray2, n);
            } else {
                IPLib.drawPolyShadow(graphics2D, nArray, nArray2, n, false);
                graphics2D.drawPolyline(nArray, nArray2, n);
            }
        }
    }

    static void drawPoly(int[] nArray, int[] nArray2) {
        Polygon polygon = new Polygon(nArray, nArray2, nArray.length);
        if (DisplayMenu.fillhow.getState() != 0) {
            fillrec = polygon.getBounds();
        }
        Graphics2D graphics2D = IPLib.getContext();
        if (fill == 1 || fill == 2) {
            if (OptionsBox.filldirec != 0) {
                graphics2D.fillPolygon(polygon);
                graphics2D.drawPolygon(polygon);
                IPLib.setGradientPaint(graphics2D, true);
                IPLib.drawPolyShadow2(graphics2D, nArray, nArray2, nArray.length, true);
                graphics2D.fillPolygon(polygon);
                graphics2D.drawPolygon(polygon);
            } else {
                IPLib.drawPolyShadow2(graphics2D, nArray, nArray2, nArray.length, true);
                graphics2D.fillPolygon(polygon);
                graphics2D.drawPolygon(polygon);
            }
            if (fill == 2) {
                graphics2D.setColor(new Color(Palette.targcol));
                graphics2D.drawPolygon(polygon);
            }
        } else if (fill == 0) {
            if (OptionsBox.filldirec != 0) {
                graphics2D.drawPolygon(polygon);
                IPLib.setGradientPaint(graphics2D, true);
                IPLib.drawPolyShadow2(graphics2D, nArray, nArray2, nArray.length, false);
                graphics2D.drawPolygon(polygon);
            } else {
                IPLib.drawPolyShadow2(graphics2D, nArray, nArray2, nArray.length, false);
                graphics2D.drawPolygon(polygon);
            }
        }
    }

    static void drawPolyShadow(Graphics2D graphics2D, int[] nArray, int[] nArray2, int n, boolean bl) {
        if (OptionsBox.shadow == 0) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        graphics2D.setColor(IPLib.getShadow());
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = OptionsBox.transx(nArray[n2]);
            nArray4[n2] = OptionsBox.transy(nArray2[n2]);
            ++n2;
        }
        if (bl) {
            graphics2D.fillPolygon(nArray3, nArray4, n);
        }
        graphics2D.drawPolyline(nArray3, nArray4, n);
        IPLib.blur(bl ? 2 : 0);
        graphics2D.setPaint(paint);
    }

    static void drawPolyShadow2(Graphics2D graphics2D, int[] nArray, int[] nArray2, int n, boolean bl) {
        if (OptionsBox.shadow == 0) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        graphics2D.setColor(IPLib.getShadow());
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = OptionsBox.transx(nArray[n2]);
            nArray4[n2] = OptionsBox.transy(nArray2[n2]);
            ++n2;
        }
        if (bl) {
            graphics2D.fillPolygon(nArray3, nArray4, n);
        } else {
            graphics2D.drawPolygon(nArray3, nArray4, n);
        }
        IPLib.blur(bl ? 2 : 0);
        graphics2D.setPaint(paint);
    }

    static void drawShape(int n, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = IPLib.getContext();
        switch (n5) {
            case 8: {
                if (DisplayMenu.fillhow.getState() != 0) {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    if (n < n3) {
                        n9 = n;
                        n8 = n3;
                    } else {
                        n9 = n3;
                        n8 = n;
                    }
                    if (n2 < n4) {
                        n7 = n2;
                        n6 = n4;
                    } else {
                        n7 = n4;
                        n6 = n2;
                    }
                    fillrec = new Rectangle(n9, n7, n8 - n9, n6 - n7);
                }
                if (OptionsBox.filldirec != 0) {
                    graphics2D.drawLine(n, n2, n3, n4);
                    IPLib.setGradientPaint(graphics2D, true);
                    if (OptionsBox.shadow != 0) {
                        Paint paint = graphics2D.getPaint();
                        graphics2D.setColor(IPLib.getShadow());
                        graphics2D.drawLine(OptionsBox.transx(n), OptionsBox.transy(n2), OptionsBox.transx(n3), OptionsBox.transy(n4));
                        IPLib.blur(0);
                        graphics2D.setPaint(paint);
                    }
                    graphics2D.drawLine(n, n2, n3, n4);
                    break;
                }
                if (OptionsBox.shadow != 0) {
                    graphics2D.setColor(IPLib.getShadow());
                    graphics2D.drawLine(OptionsBox.transx(n), OptionsBox.transy(n2), OptionsBox.transx(n3), OptionsBox.transy(n4));
                    IPLib.blur(0);
                    graphics2D.setColor(new Color(Palette.currcolor));
                }
                graphics2D.drawLine(n, n2, n3, n4);
                break;
            }
            case 7: {
                if (DisplayMenu.fillhow.getState() != 0) {
                    fillrec = new Rectangle(n, n2, n3 + 1, n4 + 1);
                }
                if (fill == 1 || fill == 2) {
                    if (OptionsBox.filldirec != 0) {
                        graphics2D.fill(new Rectangle(n, n2, n3 + 1, n4 + 1));
                        IPLib.setGradientPaint(graphics2D, true);
                        IPLib.drawBoxShadow(graphics2D, n, n2, n3 + 1, n4 + 1, true);
                        graphics2D.fill(new Rectangle(n, n2, n3 + 1, n4 + 1));
                    } else {
                        IPLib.drawBoxShadow(graphics2D, n, n2, n3 + 1, n4 + 1, true);
                        graphics2D.fill(new Rectangle(n, n2, n3 + 1, n4 + 1));
                    }
                    if (fill != 2) break;
                    graphics2D.setColor(new Color(Palette.targcol));
                    graphics2D.draw(new Rectangle(n, n2, n3, n4));
                    break;
                }
                if (fill != 0) break;
                if (OptionsBox.filldirec != 0) {
                    graphics2D.draw(new Rectangle(n, n2, n3, n4));
                    IPLib.setGradientPaint(graphics2D, true);
                    IPLib.drawBoxShadow(graphics2D, n, n2, n3, n4, false);
                    graphics2D.draw(new Rectangle(n, n2, n3, n4));
                    break;
                }
                IPLib.drawBoxShadow(graphics2D, n, n2, n3, n4, false);
                graphics2D.draw(new Rectangle(n, n2, n3, n4));
                break;
            }
            default: {
                if (DisplayMenu.fillhow.getState() != 0) {
                    fillrec = new Rectangle(n, n2, n3 + 1, n4 + 1);
                }
                if (fill == 1 || fill == 2) {
                    Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3 + 1, n4 + 1);
                    if (OptionsBox.filldirec != 0) {
                        graphics2D.fill(float_);
                        IPLib.setGradientPaint(graphics2D, true);
                        IPLib.drawEllipseShadow(graphics2D, n, n2, n3 + 1, n4 + 1, true);
                        graphics2D.fill(float_);
                    } else {
                        IPLib.drawEllipseShadow(graphics2D, n, n2, n3 + 1, n4 + 1, true);
                        graphics2D.fill(float_);
                    }
                    if (fill != 2) break;
                    float_ = new Ellipse2D.Float(n, n2, n3, n4);
                    graphics2D.setColor(new Color(Palette.targcol));
                    graphics2D.draw(float_);
                    break;
                }
                if (fill != 0) break;
                Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
                if (OptionsBox.filldirec != 0) {
                    graphics2D.draw(float_);
                    IPLib.setGradientPaint(graphics2D, true);
                    IPLib.drawEllipseShadow(graphics2D, n, n2, n3, n4, false);
                    graphics2D.draw(float_);
                    break;
                }
                IPLib.drawEllipseShadow(graphics2D, n, n2, n3, n4, false);
                graphics2D.draw(float_);
            }
        }
    }

    static void fillWithGradient() {
        if (OptionsBox.filldirec == 0) {
            return;
        }
        int n = IconPainter.cols;
        int n2 = IconPainter.rows;
        int n3 = IconPainter.backtrans.getRGB();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        IPLib.setGradientPaint(graphics2D, false);
        graphics2D.fillRect(0, 0, n, n2);
        BufferedImage bufferedImage2 = IconPainter.transimg;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                if (bufferedImage2.getRGB(n5, n4) != n3) {
                    bufferedImage2.setRGB(n5, n4, bufferedImage.getRGB(n5, n4));
                }
                ++n5;
            }
            ++n4;
        }
    }

    static boolean floodFill(int n, int n2, int n3) {
        curr = IconPainter.curr;
        transimg = IconPainter.transimg;
        origcol = n;
        currcolor = Palette.currcolor;
        System.gc();
        gccnt = 0;
        IPLib.doFlood(n2, n3);
        if (total >= 10000) {
            IPUtils.copy(IconPainter.orig, curr);
            new IPZap("The bounded fill memory limit has been exceeded - use saturation instead.");
            return false;
        }
        return true;
    }

    static Graphics2D getContext() {
        Graphics2D graphics2D = IconPainter.transimg.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, OptionsBox.antialias == 0 ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setColor(new Color(Palette.currcolor));
        graphics2D.setStroke(OptionsBox.getBasicStroke());
        return graphics2D;
    }

    static Color getShadow() {
        if (shadowcolor == null) {
            shadowcolor = CrissCross.lines;
        }
        return shadowcolor;
    }

    static void paintTransImg() {
        Graphics2D graphics2D = IconPainter.curr.createGraphics();
        graphics2D.drawImage((Image)IconPainter.orig, 0, 0, null);
        CrissCross.setClip(graphics2D);
        if (xshift != 0 || yshift != 0) {
            graphics2D.translate(xshift, yshift);
        }
        if (rotation != 0.0) {
            graphics2D.rotate(rotation, (double)IconPainter.cols / 2.0, (double)IconPainter.rows / 2.0);
        }
        if (OptionsBox.transparency < 1.0f) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, OptionsBox.transparency));
        }
        graphics2D.drawImage((Image)IconPainter.transimg, 0, 0, null);
        IconPainter.refreshAll();
    }

    static void resetParams() {
        xshift = 0;
        yshift = 0;
        rotation = 0.0;
        Bar.text = Bar.EMPTY;
    }

    static void saturate(int n) {
        int[] nArray = ((DataBufferInt)IconPainter.curr.getRaster().getDataBuffer()).getData();
        int n2 = nArray.length;
        int[] nArray2 = ((DataBufferInt)IconPainter.transimg.getRaster().getDataBuffer()).getData();
        int n3 = Palette.currcolor;
        int n4 = 0;
        while (n4 < n2) {
            if (nArray[n4] == n) {
                nArray[n4] = n3;
                nArray2[n4] = n3;
            }
            ++n4;
        }
    }

    static void setGradientPaint(Graphics2D graphics2D, boolean bl) {
        if (Palette.usetexture) {
            TexturePaint texturePaint = new TexturePaint(Palette.texture, new Rectangle(0, 0, Palette.texture.getWidth(), Palette.texture.getHeight()));
            graphics2D.setPaint(texturePaint);
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = OptionsBox.filldirec;
        if (DisplayMenu.fillhow.getState() == 0) {
            int n6 = IconPainter.cols;
            int n7 = IconPainter.rows;
            int n8 = IconPainter.backtrans.getRGB();
            int n9 = n6 - 1;
            int n10 = 0;
            int n11 = n7 - 1;
            int n12 = 0;
            int n13 = Integer.MIN_VALUE;
            int n14 = Integer.MAX_VALUE;
            BufferedImage bufferedImage = IconPainter.transimg;
            int n15 = 0;
            while (n15 < n7) {
                int n16 = 0;
                while (n16 < n6) {
                    if (bufferedImage.getRGB(n16, n15) != n8) {
                        switch (n5) {
                            case 1: 
                            case 5: {
                                if (n15 < n11) {
                                    n11 = n15;
                                }
                                if (n15 <= n12) break;
                                n12 = n15;
                                break;
                            }
                            case 3: 
                            case 7: {
                                if (n16 < n9) {
                                    n9 = n16;
                                }
                                if (n16 <= n10) break;
                                n10 = n16;
                                break;
                            }
                            case 2: 
                            case 6: {
                                int n17 = n16 + n7 - n15;
                                if (n17 < n14) {
                                    n14 = n17;
                                    n9 = n16;
                                    n11 = n15;
                                }
                                if (n17 <= n13) break;
                                n13 = n17;
                                n10 = n16;
                                n12 = n15;
                                break;
                            }
                            case 4: 
                            case 8: {
                                int n17 = n7 - n15 - n16;
                                if (n17 > n13) {
                                    n13 = n17;
                                    n9 = n16;
                                    n11 = n15;
                                }
                                if (n17 >= n14) break;
                                n14 = n17;
                                n10 = n16;
                                n12 = n15;
                                break;
                            }
                        }
                    }
                    ++n16;
                }
                ++n15;
            }
            switch (n5) {
                case 1: {
                    n4 = n11;
                    n2 = n12;
                    break;
                }
                case 5: {
                    n2 = n11;
                    n4 = n12;
                    break;
                }
                case 7: {
                    n3 = n9;
                    n = n10;
                    break;
                }
                case 3: {
                    n = n9;
                    n3 = n10;
                    break;
                }
                case 2: {
                    n = n9;
                    n2 = n11;
                    n3 = (n11 + n9 - n12 + n10) / 2;
                    n4 = n11 + n9 - n3;
                    break;
                }
                case 6: {
                    n3 = n9;
                    n4 = n11;
                    n = (n11 + n9 - n12 + n10) / 2;
                    n2 = n11 + n9 - n;
                    break;
                }
                case 4: {
                    n = n9;
                    n2 = n11;
                    n3 = (n10 + n12 + n9 - n11) / 2;
                    n4 = n3 + n11 - n9;
                    break;
                }
                case 8: {
                    n3 = n9;
                    n4 = n11;
                    n = (n10 + n12 + n9 - n11) / 2;
                    n2 = n + n11 - n9;
                    break;
                }
            }
            if (bl) {
                graphics2D.setBackground(IconPainter.backtrans);
                graphics2D.clearRect(0, 0, n6, n7);
            }
        } else if (fillrec != null) {
            switch (n5) {
                case 1: {
                    n3 = n = IPLib.fillrec.x;
                    n2 = IPLib.fillrec.y + IPLib.fillrec.height;
                    n4 = IPLib.fillrec.y;
                    break;
                }
                case 5: {
                    n3 = n = IPLib.fillrec.x;
                    n2 = IPLib.fillrec.y;
                    n4 = IPLib.fillrec.y + IPLib.fillrec.height;
                    break;
                }
                case 7: {
                    n = IPLib.fillrec.x + IPLib.fillrec.width;
                    n3 = IPLib.fillrec.x;
                    n4 = n2 = IPLib.fillrec.y;
                    break;
                }
                case 3: {
                    n = IPLib.fillrec.x;
                    n3 = IPLib.fillrec.x + IPLib.fillrec.width;
                    n4 = n2 = IPLib.fillrec.y;
                    break;
                }
                case 2: {
                    n = IPLib.fillrec.x;
                    n2 = IPLib.fillrec.x + IPLib.fillrec.height;
                    n3 = IPLib.fillrec.x + IPLib.fillrec.width;
                    n4 = IPLib.fillrec.y;
                    break;
                }
                case 6: {
                    n = IPLib.fillrec.x + IPLib.fillrec.width;
                    n2 = IPLib.fillrec.y;
                    n3 = IPLib.fillrec.x;
                    n4 = IPLib.fillrec.y + IPLib.fillrec.height;
                    break;
                }
                case 4: {
                    n = IPLib.fillrec.x;
                    n2 = IPLib.fillrec.y;
                    n3 = IPLib.fillrec.x + IPLib.fillrec.width;
                    n4 = IPLib.fillrec.y + IPLib.fillrec.height;
                    break;
                }
                case 8: {
                    n = IPLib.fillrec.x + IPLib.fillrec.width;
                    n2 = IPLib.fillrec.y + IPLib.fillrec.height;
                    n3 = IPLib.fillrec.x;
                    n4 = IPLib.fillrec.y;
                    break;
                }
            }
        }
        GradientPaint gradientPaint = new GradientPaint(n, n2, new Color(Palette.currcolor), n3, n4, new Color(Palette.targcol));
        graphics2D.setPaint(gradientPaint);
    }
}

