/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.FileManager;
import com.equitysoft.icon.FileUtils;
import com.equitysoft.icon.IData;
import com.equitysoft.icon.IPDialog;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IUtils;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.LibButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class IBox
extends IPDialog
implements ActionListener {
    static File f;
    static IBox handle;

    IBox(File file) {
        super("");
        f = file;
        handle = this;
        this.resetTitle();
        IData[] iDataArray = IUtils.extract(file, IconPainter.backcol);
        if (iDataArray.length == 0) {
            new IPZap("Unable to extract any images from the file");
            return;
        }
        if (iDataArray.length == 1) {
            FileManager.filetype = 9;
            FileUtils.displayIt(file, iDataArray[0].img);
            return;
        }
        this.jp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        jScrollPane.getViewport().add(jPanel);
        this.jp.add((Component)jScrollPane, "Center");
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        int n = 0;
        while (n < iDataArray.length) {
            jPanel.add(new IButton(iDataArray[n]));
            ++n;
        }
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder()));
        JLabel jLabel = new JLabel("Select the image to edit by clicking on it.");
        jPanel.add(jLabel);
        jLabel.setForeground(Color.black);
        LibButton libButton = new LibButton("Cancel");
        jPanel.add(libButton);
        libButton.addActionListener(this);
        this.jp.add((Component)jPanel, "South");
        this.finishOff();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.closeDialog();
    }

    void resetTitle() {
        this.setTitle(" Contents of file '" + f.getName() + "'");
    }

    class IButton
    extends JPanel {
        IData id;
        boolean entered;
        boolean pressed;
        int iw;
        int ih;

        IButton(IData iData) {
            this.enableEvents(16L);
            this.id = iData;
            this.iw = iData.img.getWidth();
            this.ih = iData.img.getHeight();
        }

        void apply() {
            FileManager.filetype = 9;
            FileUtils.displayIt(f, this.id.img);
            IBox.this.closeDialog();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.iw + 6, this.ih + 6);
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getPreferredSize();
            int n = dimension.width - 3;
            int n2 = dimension.height - 3;
            if (this.entered) {
                graphics2D.setColor(Color.green);
                graphics2D.fillRect(0, 0, dimension.width, 3);
                graphics2D.fillRect(n, 0, 3, dimension.height);
                graphics2D.fillRect(0, n2, dimension.width, 3);
                graphics2D.fillRect(0, 0, 3, dimension.height);
                graphics2D.setColor(Color.red);
                int n3 = 0;
                while (n3 < dimension.width) {
                    graphics2D.fillRect(n3, 0, 4, 3);
                    graphics2D.fillRect(n3, n2, 4, 3);
                    n3 += 8;
                }
                n3 = 0;
                while (n3 < dimension.height) {
                    graphics2D.fillRect(0, n3, 3, 4);
                    graphics2D.fillRect(n, n3, 3, 4);
                    n3 += 8;
                }
            } else {
                graphics2D.setColor(this.getParent().getBackground());
                graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            }
            graphics2D.drawImage((Image)this.id.img, 3, 3, null);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 504: {
                    IBox.this.setTitle(" Columns: " + this.iw + "  Rows: " + this.ih);
                    this.entered = true;
                    this.repaint();
                    break;
                }
                case 505: {
                    IBox.this.resetTitle();
                    this.entered = false;
                    this.repaint();
                    break;
                }
                case 502: {
                    this.apply();
                    break;
                }
                case 501: {
                    this.pressed = true;
                    this.repaint();
                }
            }
        }
    }
}

