/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.AUtils;
import com.equitysoft.icon.BMUtils;
import com.equitysoft.icon.Bar;
import com.equitysoft.icon.FastA;
import com.equitysoft.icon.FileManager;
import com.equitysoft.icon.IBox;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IUtils;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.JAIMethods;
import com.equitysoft.icon.MSUtils;
import com.equitysoft.icon.QTMethods;
import com.equitysoft.icon.XBMUtils;
import com.equitysoft.icon.XPMUtils;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

class FileUtils {
    static String UNRECOG = "The file is not a recognised image type";
    static AffineTransform atrans;
    static int type;

    FileUtils() {
    }

    static void displayIt(File file, BufferedImage bufferedImage) {
        if (bufferedImage.getWidth() != IconPainter.cols || bufferedImage.getHeight() != IconPainter.rows) {
            IconPainter.init(bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        Bar.setFile(file);
        Graphics2D graphics2D = IconPainter.curr.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        IconPainter.startAdd();
        IconPainter.refreshAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Image getImage(File file, boolean bl, Color color) {
        int n;
        Object object;
        Image image = null;
        int n2 = 10;
        type = -1;
        byte[] byArray = new byte[n2];
        try {
            object = new FileInputStream(file);
            n = ((FileInputStream)object).read(byArray, 0, n2);
            ((FileInputStream)object).close();
            if (n < n2) {
                return null;
            }
        }
        catch (Exception exception) {
            if (bl) return null;
            new IPZap("Unable to read the file '" + file.getName() + "'");
            return null;
        }
        object = file.getName();
        if (byArray[0] == 66 && byArray[1] == 77) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                fileInputStream.skip(28L);
                fileInputStream.read(byArray, 0, 2);
                fileInputStream.close();
            }
            catch (Exception exception) {
                return null;
            }
            n = MSUtils.wordToInt(byArray, 0);
            if (n == 8) {
                type = 7;
            } else {
                if (n != 24) {
                    if (bl) return null;
                    new IPZap("The file is not an 8 or 24 bit BMP file.");
                    return null;
                }
                type = 8;
            }
        } else if (byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 56) {
            if (byArray[4] == 55) {
                type = 1;
            } else {
                if (byArray[4] != 57) return null;
                type = 2;
            }
        } else if (byArray[4] == 0 && byArray[5] == 16 && byArray[6] == 74 && byArray[7] == 70 && byArray[8] == 73 && byArray[9] == 70) {
            type = 0;
        } else if (byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71 && byArray[4] == 13 && byArray[5] == 10 && byArray[6] == 26 && byArray[7] == 10) {
            type = 4;
        } else if (MSUtils.wordToInt(byArray, 2) == 1 && (file.getName().endsWith(".ico") || ((String)object).endsWith(".ICO"))) {
            if (!bl) {
                new IBox(file);
                return null;
            }
            type = 9;
        } else if (MSUtils.wordToInt(byArray, 2) == 2 && (file.getName().endsWith(".cur") || ((String)object).endsWith(".CUR"))) {
            if (!bl) {
                new IBox(file);
                return null;
            }
            type = 10;
        } else if (byArray[0] == 82 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 70 && (((String)object).endsWith(".ani") || ((String)object).endsWith(".ANI"))) {
            if (!bl) {
                AUtils.getA(file);
                return null;
            }
            type = 11;
        } else if (byArray[0] == 47 && byArray[1] == 42 && (((String)object).endsWith(".xpm") || ((String)object).endsWith(".XPM") || ((String)object).endsWith(".pm"))) {
            type = 14;
        } else if (byArray[0] == 35 && byArray[1] == 100 && byArray[2] == 101 && (((String)object).endsWith(".xbm") || ((String)object).endsWith(".XBM") || ((String)object).endsWith(".bm"))) {
            type = 13;
        } else if (((String)object).endsWith(".tif") || ((String)object).endsWith(".tiff")) {
            type = 17;
        } else {
            if (!((String)object).endsWith(".pct") && !((String)object).endsWith(".PCT")) {
                if (bl) return null;
                new IPZap(UNRECOG);
                return null;
            }
            type = 12;
        }
        switch (type) {
            case 1: 
            case 2: {
                image = IPUtils.getImage(file);
                break;
            }
            case 0: {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)fileInputStream);
                    image = jPEGImageDecoder.decodeAsBufferedImage();
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    image = null;
                }
                break;
            }
            case 7: 
            case 8: {
                image = BMUtils.load(file);
                break;
            }
            case 9: 
            case 10: {
                image = IUtils.getImage(file, color);
                break;
            }
            case 11: {
                image = FastA.getImage(file, color);
                break;
            }
            case 4: {
                image = JAIMethods.getPNG(file, color, bl);
                break;
            }
            case 17: {
                image = JAIMethods.getAnyImage(file, color);
                break;
            }
            case 12: {
                image = QTMethods.getImageWithQT4J(file, color);
                break;
            }
            case 13: {
                image = XBMUtils.getImage(file, color, bl);
                break;
            }
            case 14: {
                image = XPMUtils.getImage(file, color);
                if (XPMUtils.hotx <= -1) break;
                type = 15;
                break;
            }
            default: {
                image = null;
            }
        }
        if (image == null) {
            if (bl) return image;
            new IPZap("Unable to load the file '" + file.getName() + "' as an image");
            return image;
        }
        if (bl) return image;
        if (type == 12) return image;
        FileManager.filetype = type;
        return image;
    }
}

